/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.reloc;

import db.BinaryCodedField;
import db.BinaryField;
import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.IntField;
import db.RecordIterator;
import db.Schema;
import db.StringField;
import ghidra.program.database.map.AddressMap;
import ghidra.program.database.reloc.RelocationDBAdapterNoTable;
import ghidra.program.database.reloc.RelocationDBAdapterV1;
import ghidra.program.database.reloc.RelocationDBAdapterV2;
import ghidra.program.database.reloc.RelocationDBAdapterV3;
import ghidra.program.database.reloc.RelocationDBAdapterV4;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

abstract class RelocationDBAdapter {
    static final int TYPE_COL = 0;
    static final int VALU_COL = 1;
    static final int BYTES_COL = 2;
    static final int SYMBOL_NAME_COL = 3;
    static final String TABLE_NAME = "Relocations";
    static final Schema SCHEMA = new Schema(4, "Address", new Field[]{IntField.INSTANCE, BinaryField.INSTANCE, BinaryField.INSTANCE, StringField.INSTANCE}, new String[]{"Type", "Values", "Bytes", "Symbol Name"});

    RelocationDBAdapter() {
    }

    static RelocationDBAdapter getAdapter(DBHandle dbHandle, int openMode, AddressMap addrMap, TaskMonitor monitor) throws VersionException, IOException {
        if (openMode == 0) {
            return new RelocationDBAdapterV4(dbHandle, addrMap, true);
        }
        try {
            RelocationDBAdapterV4 adapter = new RelocationDBAdapterV4(dbHandle, addrMap, false);
            if (addrMap.isUpgraded()) {
                throw new VersionException(true);
            }
            return adapter;
        }
        catch (VersionException e) {
            if (!e.isUpgradable() || openMode == 1) {
                throw e;
            }
            RelocationDBAdapter adapter = RelocationDBAdapter.findReadOnlyAdapter(dbHandle, addrMap);
            if (openMode == 3) {
                adapter = RelocationDBAdapter.upgrade(dbHandle, addrMap, adapter, monitor);
            }
            return adapter;
        }
    }

    private static RelocationDBAdapter findReadOnlyAdapter(DBHandle handle, AddressMap addrMap) throws IOException {
        try {
            return new RelocationDBAdapterV3(handle, addrMap, false);
        }
        catch (VersionException versionException) {
            try {
                return new RelocationDBAdapterV2(handle, addrMap);
            }
            catch (VersionException versionException2) {
                try {
                    return new RelocationDBAdapterV1(handle, addrMap);
                }
                catch (VersionException versionException3) {
                    return new RelocationDBAdapterNoTable();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static RelocationDBAdapter upgrade(DBHandle dbHandle, AddressMap addrMap, RelocationDBAdapter oldAdapter, TaskMonitor monitor) throws VersionException, IOException {
        AddressMap oldAddrMap = addrMap.getOldAddressMap();
        try (DBHandle tmpHandle = new DBHandle();){
            BinaryCodedField values;
            tmpHandle.startTransaction();
            RelocationDBAdapterV4 tmpAdapter = new RelocationDBAdapterV4(tmpHandle, addrMap, true);
            RecordIterator iter = oldAdapter.iterator();
            while (iter.hasNext()) {
                DBRecord rec = iter.next();
                Address addr = oldAddrMap.decodeAddress(rec.getKey());
                values = new BinaryCodedField((BinaryField)rec.getFieldValue(1));
                ((RelocationDBAdapter)tmpAdapter).add(addrMap.getKey(addr, true), rec.getIntValue(0), values.getLongArray(), null, null);
            }
            dbHandle.deleteTable(TABLE_NAME);
            RelocationDBAdapterV4 newAdapter = new RelocationDBAdapterV4(dbHandle, addrMap, true);
            iter = ((RelocationDBAdapter)tmpAdapter).iterator();
            while (iter.hasNext()) {
                DBRecord rec = iter.next();
                values = new BinaryCodedField((BinaryField)rec.getFieldValue(1));
                ((RelocationDBAdapter)newAdapter).add(rec.getKey(), rec.getIntValue(0), values.getLongArray(), null, null);
            }
            RelocationDBAdapterV4 relocationDBAdapterV4 = newAdapter;
            return relocationDBAdapterV4;
        }
    }

    abstract void add(long var1, int var3, long[] var4, byte[] var5, String var6) throws IOException;

    abstract void remove(long var1) throws IOException;

    abstract DBRecord get(long var1) throws IOException;

    abstract RecordIterator iterator() throws IOException;

    abstract RecordIterator iterator(AddressSetView var1) throws IOException;

    abstract RecordIterator iterator(Address var1) throws IOException;

    abstract int getVersion();

    abstract int getRecordCount();

    abstract DBRecord adaptRecord(DBRecord var1);

    class RecordIteratorAdapter
    implements RecordIterator {
        RecordIterator it;

        RecordIteratorAdapter(RecordIterator it) {
            this.it = it;
        }

        public boolean delete() throws IOException {
            return this.it.delete();
        }

        public boolean hasNext() throws IOException {
            return this.it.hasNext();
        }

        public boolean hasPrevious() throws IOException {
            return this.it.hasPrevious();
        }

        public DBRecord next() throws IOException {
            DBRecord rec = this.it.next();
            return RelocationDBAdapter.this.adaptRecord(rec);
        }

        public DBRecord previous() throws IOException {
            DBRecord rec = this.it.previous();
            return RelocationDBAdapter.this.adaptRecord(rec);
        }
    }
}

