/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.data;

import db.BinaryField;
import db.DBFieldIterator;
import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.LongField;
import db.RecordIterator;
import db.Schema;
import db.StringField;
import db.Table;
import ghidra.program.database.data.InstanceSettingsDBAdapter;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

class InstanceSettingsDBAdapterV0
extends InstanceSettingsDBAdapter {
    static final int V0_INST_ADDR_COL = 0;
    static final int V0_INST_NAME_COL = 1;
    static final int V0_INST_LONG_VALUE_COL = 2;
    static final int V0_INST_STRING_VALUE_COL = 3;
    static final int V0_INST_BYTE_VALUE_COL = 4;
    static final Schema V0_INSTANCE_SCHEMA = new Schema(0, "Settings ID", new Field[]{LongField.INSTANCE, StringField.INSTANCE, LongField.INSTANCE, StringField.INSTANCE, BinaryField.INSTANCE}, new String[]{"Address", "Settings Name", "Long Value", "String Value", "Byte Value"});
    private Table instanceTable;

    InstanceSettingsDBAdapterV0(DBHandle handle, boolean create) throws VersionException, IOException {
        if (create) {
            this.instanceTable = handle.createTable("Instance Settings", V0_INSTANCE_SCHEMA, new int[]{0});
        } else {
            this.instanceTable = handle.getTable("Instance Settings");
            if (this.instanceTable == null) {
                throw new VersionException("Missing Table: Instance Settings");
            }
            if (this.instanceTable.getSchema().getVersion() != 0) {
                throw new VersionException("Expected version 0 for table Instance Settings but got " + this.instanceTable.getSchema().getVersion());
            }
        }
    }

    @Override
    public DBRecord createInstanceRecord(long addr, String name, String strValue, long longValue, byte[] byteValue) throws IOException {
        DBRecord record = V0_INSTANCE_SCHEMA.createRecord(this.instanceTable.getKey());
        record.setLongValue(0, addr);
        record.setString(1, name);
        record.setString(3, strValue);
        record.setLongValue(2, longValue);
        record.setBinaryData(4, byteValue);
        this.instanceTable.putRecord(record);
        return record;
    }

    @Override
    public Field[] getInstanceKeys(long addr) throws IOException {
        return this.instanceTable.findRecords((Field)new LongField(addr), 0);
    }

    @Override
    public boolean removeInstanceRecord(long settingsID) throws IOException {
        return this.instanceTable.deleteRecord(settingsID);
    }

    @Override
    public DBRecord getInstanceRecord(long settingsID) throws IOException {
        return this.instanceTable.getRecord(settingsID);
    }

    @Override
    public void updateInstanceRecord(DBRecord record) throws IOException {
        this.instanceTable.putRecord(record);
    }

    @Override
    public RecordIterator getRecords(long start, long end) throws IOException {
        return this.instanceTable.indexIterator(0, (Field)new LongField(start), (Field)new LongField(end), true);
    }

    @Override
    RecordIterator getRecords() throws IOException {
        return this.instanceTable.iterator();
    }

    @Override
    int getRecordCount() {
        return this.instanceTable.getRecordCount();
    }

    @Override
    void delete(long start, long end, TaskMonitor monitor) throws CancelledException, IOException {
        DBFieldIterator it = this.instanceTable.indexKeyIterator(0, (Field)new LongField(start), (Field)new LongField(end), true);
        while (it.hasNext()) {
            if (monitor.isCancelled()) {
                throw new CancelledException();
            }
            this.instanceTable.deleteRecord(it.next());
        }
    }
}

