/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.data;

import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.IntField;
import db.LongField;
import db.RecordIterator;
import db.Schema;
import db.StringField;
import db.Table;
import ghidra.program.database.data.DataTypeManagerDB;
import ghidra.program.database.data.FunctionParameterAdapter;
import ghidra.util.exception.VersionException;
import java.io.IOException;

class FunctionParameterAdapterV1
extends FunctionParameterAdapter {
    static final int VERSION = 1;
    static final int V1_PARAMETER_PARENT_ID_COL = 0;
    static final int V1_PARAMETER_DT_ID_COL = 1;
    static final int V1_PARAMETER_NAME_COL = 2;
    static final int V1_PARAMETER_COMMENT_COL = 3;
    static final int V1_PARAMETER_ORDINAL_COL = 4;
    static final int V1_PARAMETER_DT_LENGTH_COL = 5;
    static final Schema V1_PARAMETER_SCHEMA = new Schema(1, "Parameter ID", new Field[]{LongField.INSTANCE, LongField.INSTANCE, StringField.INSTANCE, StringField.INSTANCE, IntField.INSTANCE, IntField.INSTANCE}, new String[]{"Parent ID", "Data Type ID", "Name", "Comment", "Ordinal", "Data Type Length"});
    private Table table;

    public FunctionParameterAdapterV1(DBHandle handle, boolean create) throws VersionException, IOException {
        if (create) {
            this.table = handle.createTable("Function Parameters", V1_PARAMETER_SCHEMA, new int[]{0});
        } else {
            this.table = handle.getTable("Function Parameters");
            if (this.table == null) {
                throw new VersionException(true);
            }
            int version = this.table.getSchema().getVersion();
            if (version != 1) {
                String msg = "Expected version 1 for table Function Parameters but got " + this.table.getSchema().getVersion();
                if (version < 1) {
                    throw new VersionException(msg, 1, true);
                }
                throw new VersionException(msg, 2, false);
            }
        }
    }

    @Override
    public DBRecord createRecord(long dataTypeID, long parentID, int ordinal, String name, String comment, int dtLength) throws IOException {
        long tableKey = this.table.getKey();
        long key = DataTypeManagerDB.createKey(7, tableKey);
        DBRecord record = V1_PARAMETER_SCHEMA.createRecord(key);
        record.setLongValue(0, parentID);
        record.setLongValue(1, dataTypeID);
        record.setString(2, name);
        record.setString(3, comment);
        record.setIntValue(4, ordinal);
        record.setIntValue(5, dtLength);
        this.table.putRecord(record);
        return record;
    }

    @Override
    public DBRecord getRecord(long parameterID) throws IOException {
        return this.table.getRecord(parameterID);
    }

    @Override
    protected RecordIterator getRecords() throws IOException {
        return this.table.iterator();
    }

    @Override
    public void updateRecord(DBRecord record) throws IOException {
        this.table.putRecord(record);
    }

    @Override
    public boolean removeRecord(long parameterID) throws IOException {
        return this.table.deleteRecord(parameterID);
    }

    @Override
    protected void deleteTable(DBHandle handle) throws IOException {
        handle.deleteTable("Function Parameters");
    }

    @Override
    public Field[] getParameterIdsInFunctionDef(long functionDefID) throws IOException {
        return this.table.findRecords((Field)new LongField(functionDefID), 0);
    }
}

