/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.code;

import db.DBRecord;
import db.RecordIterator;
import ghidra.program.database.code.CodeManager;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.DataIterator;
import java.io.IOException;

public class DataRecordIterator
implements DataIterator {
    private CodeManager codeMgr;
    private RecordIterator it;
    private Data nextData;
    private boolean forward;

    public DataRecordIterator(CodeManager codeMgr, RecordIterator it, boolean forward) {
        this.codeMgr = codeMgr;
        this.it = it;
        this.forward = forward;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasNext() {
        if (this.nextData == null) {
            this.findNext();
        }
        return this.nextData != null;
    }

    @Override
    public Data next() {
        if (this.hasNext()) {
            Data ret = this.nextData;
            this.nextData = null;
            return ret;
        }
        return null;
    }

    private void findNext() {
        try {
            while (this.nextData == null && (this.forward ? this.it.hasNext() : this.it.hasPrevious())) {
                DBRecord record = this.forward ? this.it.next() : this.it.previous();
                this.nextData = this.codeMgr.getDataDB(record);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

