/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.code;

import db.DBHandle;
import db.DBRecord;
import db.RecordIterator;
import db.util.ErrorHandler;
import ghidra.program.database.DBObjectCache;
import ghidra.program.database.ManagerDB;
import ghidra.program.database.ProgramDB;
import ghidra.program.database.code.CodeUnitDB;
import ghidra.program.database.code.CodeUnitKeyIterator;
import ghidra.program.database.code.CodeUnitRecordIterator;
import ghidra.program.database.code.CommentHistoryAdapter;
import ghidra.program.database.code.CommentTypeFilterAddressIterator;
import ghidra.program.database.code.CommentTypeFilterIterator;
import ghidra.program.database.code.CommentsDBAdapter;
import ghidra.program.database.code.DataDB;
import ghidra.program.database.code.DataDBAdapter;
import ghidra.program.database.code.DataFilteredCodeUnitIterator;
import ghidra.program.database.code.DataKeyIterator;
import ghidra.program.database.code.DataRecordIterator;
import ghidra.program.database.code.EmptyCodeUnitIterator;
import ghidra.program.database.code.InstDBAdapter;
import ghidra.program.database.code.InstructionDB;
import ghidra.program.database.code.InstructionRecordIterator;
import ghidra.program.database.code.PrototypeManager;
import ghidra.program.database.code.StringDiff;
import ghidra.program.database.code.StringDiffUtils;
import ghidra.program.database.data.DataTypeManagerDB;
import ghidra.program.database.map.AddressKeyAddressIterator;
import ghidra.program.database.map.AddressKeyIterator;
import ghidra.program.database.map.AddressMap;
import ghidra.program.database.properties.IntPropertyMapDB;
import ghidra.program.database.properties.LongPropertyMapDB;
import ghidra.program.database.properties.PropertyMapDB;
import ghidra.program.database.properties.VoidPropertyMapDB;
import ghidra.program.database.symbol.SymbolManager;
import ghidra.program.disassemble.Disassembler;
import ghidra.program.disassemble.DisassemblerMessageListener;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.EmptyAddressIterator;
import ghidra.program.model.address.SegmentedAddress;
import ghidra.program.model.data.Array;
import ghidra.program.model.data.BitFieldDataType;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DefaultDataType;
import ghidra.program.model.data.Dynamic;
import ghidra.program.model.data.DynamicDataType;
import ghidra.program.model.data.FactoryDataType;
import ghidra.program.model.data.FunctionDefinition;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.lang.InstructionBlock;
import ghidra.program.model.lang.InstructionError;
import ghidra.program.model.lang.InstructionPrototype;
import ghidra.program.model.lang.InstructionSet;
import ghidra.program.model.lang.ProcessorContextView;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.CodeUnitIterator;
import ghidra.program.model.listing.CommentHistory;
import ghidra.program.model.listing.ContextChangeException;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.DataIterator;
import ghidra.program.model.listing.FlowOverride;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.InstructionIterator;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramContext;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.mem.MemoryBufferImpl;
import ghidra.program.model.symbol.EquateTable;
import ghidra.program.model.symbol.ExternalLocation;
import ghidra.program.model.symbol.FlowType;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.RefTypeFactory;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.program.model.util.PropertyMap;
import ghidra.program.model.util.PropertyMapManager;
import ghidra.util.Lock;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.NoValueException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import ghidra.util.task.TaskMonitorAdapter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;

public class CodeManager
implements ErrorHandler,
ManagerDB {
    private DBHandle dbHandle;
    private AddressMap addrMap;
    private CommentsDBAdapter commentAdapter;
    private DataDBAdapter dataAdapter;
    private InstDBAdapter instAdapter;
    private CommentHistoryAdapter historyAdapter;
    private ProgramDB program;
    private PrototypeManager protoMgr;
    private DBObjectCache<CodeUnitDB> cache;
    private DataTypeManagerDB dataManager;
    private EquateTable equateTable;
    private SymbolManager symbolTable;
    private ProgramContext contextMgr;
    private ReferenceManager refManager;
    private PropertyMapManager propertyMapMgr;
    private VoidPropertyMapDB compositeMgr;
    private IntPropertyMapDB lengthMgr;
    private boolean contextLockingEnabled = false;
    private boolean creatingInstruction = false;
    private volatile boolean redisassemblyMode = false;
    Lock lock;
    static final int DATA_OP_INDEX = 0;
    private static final int MAX_SEGMENT_LIMIT = 2;
    private HashMap<Long, Byte> redisassmblyFlags;

    public CodeManager(DBHandle handle, AddressMap addrMap, int openMode, Lock lock, TaskMonitor monitor) throws VersionException, CancelledException, IOException {
        this.dbHandle = handle;
        this.addrMap = addrMap;
        this.lock = lock;
        this.initializeAdapters(openMode, monitor);
        this.cache = new DBObjectCache(1000);
        this.protoMgr = new PrototypeManager(handle, addrMap, openMode, monitor);
        this.compositeMgr = new VoidPropertyMapDB(this.dbHandle, openMode, this, null, addrMap, "Composites", monitor);
        this.lengthMgr = new IntPropertyMapDB(this.dbHandle, openMode, this, null, addrMap, "Lengths", monitor);
        this.checkOldFallThroughMaps(handle, openMode, monitor);
    }

    private void checkOldFallThroughMaps(DBHandle handle, int openMode, TaskMonitor monitor) throws VersionException, CancelledException, IOException {
        if (openMode != 1) {
            return;
        }
        LongPropertyMapDB oldFallThroughs = new LongPropertyMapDB(this.dbHandle, openMode, this, null, this.addrMap, "FallThroughs", monitor);
        LongPropertyMapDB oldFallFroms = new LongPropertyMapDB(this.dbHandle, openMode, this, null, this.addrMap, "FallFroms", monitor);
        if (oldFallThroughs.getSize() != 0 || oldFallFroms.getSize() != 0) {
            throw new VersionException(true);
        }
    }

    private void upgradeOldFallThroughMaps(TaskMonitor monitor) throws CancelledException, IOException {
        try {
            ReferenceManager refMgr = this.program.getReferenceManager();
            LongPropertyMapDB oldFallFroms = new LongPropertyMapDB(this.dbHandle, 3, this, null, this.addrMap, "FallFroms", monitor);
            LongPropertyMapDB oldFallThroughs = new LongPropertyMapDB(this.dbHandle, 3, this, null, this.addrMap, "FallThroughs", monitor);
            int cnt = oldFallThroughs.getSize();
            if (cnt != 0) {
                monitor.setMessage("Upgrade Fallthrough Overrides...");
                monitor.initialize((long)cnt);
                cnt = 0;
                AddressIterator addrIter = oldFallThroughs.getPropertyIterator();
                while (addrIter.hasNext()) {
                    monitor.checkCanceled();
                    Address addr = addrIter.next();
                    try {
                        long offset = oldFallThroughs.getLong(addr);
                        Address toAddr = addr.getNewAddress(offset);
                        refMgr.addMemoryReference(addr, toAddr, RefType.FALL_THROUGH, SourceType.USER_DEFINED, -1);
                    }
                    catch (NoValueException noValueException) {
                        // empty catch block
                    }
                    monitor.setProgress((long)(++cnt));
                }
            }
            oldFallThroughs.delete();
            oldFallFroms.delete();
        }
        catch (VersionException e) {
            throw new IOException(e.getMessage());
        }
    }

    private void initializeAdapters(int openMode, TaskMonitor monitor) throws VersionException, CancelledException, IOException {
        VersionException versionExc = null;
        try {
            this.instAdapter = InstDBAdapter.getAdapter(this.dbHandle, openMode, this.addrMap, monitor);
        }
        catch (VersionException e) {
            versionExc = e.combine(versionExc);
        }
        try {
            this.dataAdapter = DataDBAdapter.getAdapter(this.dbHandle, openMode, this.addrMap, monitor);
        }
        catch (VersionException e) {
            versionExc = e.combine(versionExc);
        }
        try {
            this.commentAdapter = CommentsDBAdapter.getAdapter(this.dbHandle, openMode, this.addrMap, monitor);
        }
        catch (VersionException e) {
            versionExc = e.combine(versionExc);
        }
        try {
            this.historyAdapter = CommentHistoryAdapter.getAdapter(this.dbHandle, openMode, this.addrMap, monitor);
        }
        catch (VersionException e) {
            versionExc = e.combine(versionExc);
        }
        if (versionExc != null) {
            throw versionExc;
        }
    }

    @Override
    public void setProgram(ProgramDB program) {
        this.program = program;
        this.equateTable = program.getEquateTable();
        this.symbolTable = (SymbolManager)program.getSymbolTable();
        this.contextMgr = program.getProgramContext();
        this.refManager = program.getReferenceManager();
        this.propertyMapMgr = program.getUsrPropertyManager();
        this.dataManager = program.getDataTypeManager();
        this.protoMgr.setProgram(program);
    }

    @Override
    public void programReady(int openMode, int currentRevision, TaskMonitor monitor) throws IOException, CancelledException {
        if (openMode == 3) {
            this.upgradeOldFallThroughMaps(monitor);
        }
    }

    public void activateContextLocking() {
        if (this.program.getProgramContext().getBaseContextRegister() != null) {
            this.contextLockingEnabled = true;
        }
    }

    public void dbError(IOException e) {
        this.program.dbError(e);
    }

    private CodeUnit startInstructionRange(Address firstInstrStart) throws IOException {
        DataDB prevData;
        DBRecord rec;
        InstructionDB prevInst;
        DBRecord rec2;
        InstructionDB inst = null;
        RecordIterator recIt = this.instAdapter.getRecords(firstInstrStart, true);
        if (recIt.hasNext()) {
            rec2 = recIt.next();
            inst = this.getInstructionDB(rec2);
            recIt.previous();
        }
        if (recIt.hasPrevious() && (prevInst = this.getInstructionDB(rec2 = recIt.previous())).getMaxAddress().compareTo(firstInstrStart) >= 0) {
            return prevInst;
        }
        DataDB data = null;
        recIt = this.dataAdapter.getRecords(firstInstrStart, true);
        if (recIt.hasNext()) {
            rec = recIt.next();
            data = this.getDataDB(rec);
            recIt.previous();
        }
        if (recIt.hasPrevious() && (prevData = this.getDataDB(rec = recIt.previous())).getMaxAddress().compareTo(firstInstrStart) >= 0) {
            return prevData;
        }
        if (data == null) {
            return inst;
        }
        if (inst == null) {
            return data;
        }
        return inst.getMinAddress().compareTo(data.getMinAddress()) < 0 ? inst : data;
    }

    private void checkInstructionSet(InstructionSet instructionSet, HashSet<Address> skipDelaySlots) throws IOException, CancelledException {
        CodeUnit nextCu = null;
        Address nextAddrInRange = null;
        boolean findNextCodeUnit = true;
        for (InstructionBlock block : instructionSet) {
            Address errorAddr = null;
            InstructionError conflict = block.getInstructionConflict();
            if (conflict != null && (errorAddr = conflict.getInstructionAddress()) == null || block.isEmpty()) continue;
            Address blockStart = block.getStartAddress();
            if (findNextCodeUnit || !blockStart.equals(nextAddrInRange)) {
                nextCu = this.startInstructionRange(blockStart);
                findNextCodeUnit = false;
            }
            Address flowFrom = block.getFlowFromAddress();
            for (Instruction protoInstr : block) {
                Address startAddr = protoInstr.getMinAddress();
                if (nextCu != null) {
                    int c = nextCu.getMinAddress().compareTo(startAddr);
                    boolean isInstruction = nextCu instanceof Instruction;
                    if (c == 0 && isInstruction) {
                        Instruction inst = (Instruction)nextCu;
                        if (protoInstr.isInDelaySlot() != inst.isInDelaySlot() && inst.getLength() == protoInstr.getLength()) {
                            if (protoInstr.isInDelaySlot()) {
                                this.clearCodeUnits(inst.getMinAddress(), inst.getMinAddress(), false, TaskMonitorAdapter.DUMMY_MONITOR);
                            } else {
                                skipDelaySlots.add(startAddr);
                            }
                            try {
                                nextCu = this.startInstructionRange(inst.getMaxAddress().addNoWrap(1L));
                            }
                            catch (AddressOverflowException e) {
                                nextCu = null;
                            }
                            continue;
                        }
                        if (!protoInstr.getPrototype().equals(inst.getPrototype())) {
                            InstructionError.dumpInstructionDifference(protoInstr, inst);
                            block.setInconsistentPrototypeConflict(startAddr, flowFrom);
                        } else {
                            block.setInstructionError(InstructionError.InstructionErrorType.DUPLICATE, startAddr, startAddr, flowFrom, null);
                        }
                        findNextCodeUnit = true;
                        break;
                    }
                    c = nextCu.getMinAddress().compareTo(protoInstr.getMaxAddress());
                    if (c <= 0) {
                        block.setCodeUnitConflict(nextCu.getMinAddress(), startAddr, flowFrom, isInstruction, isInstruction);
                        findNextCodeUnit = true;
                        break;
                    }
                }
                if (errorAddr != null && errorAddr.compareTo(startAddr) <= 0) break;
                flowFrom = startAddr;
            }
            nextAddrInRange = block.getMaxAddress().next();
        }
    }

    public AddressSetView addInstructions(InstructionSet instructionSet, boolean overwrite) {
        AddressSet set = new AddressSet();
        this.lock.acquire();
        this.creatingInstruction = true;
        try {
            HashSet<Address> skipDelaySlots = new HashSet<Address>();
            if (overwrite) {
                for (AddressRange range : instructionSet.getAddressSet()) {
                    this.clearCodeUnits(range.getMinAddress(), range.getMaxAddress(), false, TaskMonitorAdapter.DUMMY_MONITOR);
                }
            } else {
                this.checkInstructionSet(instructionSet, skipDelaySlots);
            }
            for (InstructionBlock block : instructionSet) {
                InstructionError conflict = block.getInstructionConflict();
                Address errorAddr = null;
                CodeUnit conflictCodeUnit = null;
                if (conflict != null) {
                    errorAddr = conflict.getInstructionAddress();
                    if (errorAddr == null) continue;
                    if (conflict.getInstructionErrorType().isConflict && (conflictCodeUnit = this.getCodeUnitAt(conflict.getConflictAddress())) instanceof Data && !((Data)conflictCodeUnit).isDefined()) {
                        conflictCodeUnit = null;
                    }
                }
                int count = 0;
                CodeUnit lastInstruction = null;
                Iterator<Instruction> instructionIterator = block.iterator();
                Stack<Instruction> delaySlotStack = null;
                while (delaySlotStack != null || instructionIterator.hasNext()) {
                    boolean deferDS;
                    Instruction protoInstr;
                    if (delaySlotStack != null) {
                        protoInstr = (Instruction)delaySlotStack.pop();
                        deferDS = false;
                        if (delaySlotStack.isEmpty()) {
                            delaySlotStack = null;
                        }
                    } else {
                        protoInstr = instructionIterator.next();
                        deferDS = true;
                    }
                    InstructionPrototype prototype = protoInstr.getPrototype();
                    Address startAddr = protoInstr.getMinAddress();
                    Address endAddr = protoInstr.getMaxAddress();
                    if (prototype.hasDelaySlots()) {
                        try {
                            endAddr = startAddr.addNoWrap(prototype.getFallThroughOffset(protoInstr.getInstructionContext())).previous();
                        }
                        catch (AddressOverflowException e) {
                            break;
                        }
                    }
                    if (conflictCodeUnit != null && endAddr.compareTo(errorAddr) >= 0 && startAddr.compareTo(conflictCodeUnit.getMaxAddress()) <= 0) {
                        if (errorAddr.compareTo(protoInstr.getMaxAddress()) <= 0) break;
                        Address flowFromAddr = lastInstruction != null ? lastInstruction.getAddress() : block.getFlowFromAddress();
                        block.setCodeUnitConflict(conflict.getConflictAddress(), startAddr, flowFromAddr, conflict.isInstructionConflict(), false);
                        break;
                    }
                    if (!skipDelaySlots.contains(startAddr)) {
                        FlowOverride flowOverride;
                        if (!this.program.getMemory().contains(startAddr, endAddr)) {
                            block.setInstructionError(InstructionError.InstructionErrorType.MEMORY, startAddr, startAddr, null, "Not enough bytes available for instruction");
                            break;
                        }
                        if (deferDS && prototype.hasDelaySlots()) {
                            Instruction dsProtoInstr;
                            if (delaySlotStack != null) {
                                throw new AssertException();
                            }
                            delaySlotStack = new Stack<Instruction>();
                            delaySlotStack.push(protoInstr);
                            int dsCount = protoInstr.getDelaySlotDepth();
                            while (dsCount-- != 0 && instructionIterator.hasNext() && (dsProtoInstr = instructionIterator.next()).isInDelaySlot() && !skipDelaySlots.contains(dsProtoInstr.getAddress())) {
                                delaySlotStack.push(dsProtoInstr);
                            }
                            continue;
                        }
                        lastInstruction = this.addInstruction(startAddr, endAddr, prototype, protoInstr, protoInstr);
                        ++count;
                        if (protoInstr.isFallThroughOverridden()) {
                            lastInstruction.setFallThrough(protoInstr.getFallThrough());
                        }
                        if ((flowOverride = protoInstr.getFlowOverride()) != FlowOverride.NONE) {
                            lastInstruction.setFlowOverride(flowOverride);
                        }
                    }
                    if (errorAddr == null || conflictCodeUnit != null || errorAddr.compareTo(startAddr) > 0) continue;
                    break;
                }
                block.setInstructionsAddedCount(count);
                if (lastInstruction == null) continue;
                Address maxAddr = lastInstruction.getMaxAddress();
                InstructionPrototype prototype = lastInstruction.getPrototype();
                if (prototype.hasDelaySlots()) {
                    try {
                        maxAddr = lastInstruction.getAddress().addNoWrap(prototype.getFallThroughOffset(lastInstruction.getInstructionContext())).previous();
                    }
                    catch (AddressOverflowException addressOverflowException) {
                        // empty catch block
                    }
                }
                set.addRange(block.getStartAddress(), maxAddr);
                this.program.setChanged(30, block.getStartAddress(), maxAddr, null, null);
            }
        }
        catch (IOException e) {
            this.program.dbError(e);
        }
        catch (CancelledException e) {
            throw new AssertException();
        }
        finally {
            this.creatingInstruction = false;
            this.lock.release();
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Instruction createCodeUnit(Address address, InstructionPrototype prototype, MemBuffer memBuf, ProcessorContextView context) throws CodeUnitInsertionException {
        this.lock.acquire();
        this.creatingInstruction = true;
        try {
            Address endAddr = address.addNoWrap(prototype.getLength() - 1);
            this.checkValidAddressRange(address, endAddr);
            InstructionDB inst = this.addInstruction(address, endAddr, prototype, memBuf, context);
            this.program.setChanged(30, address, endAddr, null, inst);
            InstructionDB instructionDB = inst;
            return instructionDB;
        }
        catch (AddressOverflowException e) {
            throw new CodeUnitInsertionException("Code unit would extend beyond Address space");
        }
        catch (IOException e) {
            this.program.dbError(e);
        }
        finally {
            this.creatingInstruction = false;
            this.lock.release();
        }
        return null;
    }

    private InstructionDB addInstruction(Address address, Address endAddr, InstructionPrototype prototype, MemBuffer memBuf, ProcessorContextView context) throws IOException {
        int protoID = this.protoMgr.getID(prototype, memBuf, context);
        prototype = this.protoMgr.getPrototype(protoID);
        Register contextReg = this.contextMgr.getBaseContextRegister();
        if (contextReg != Register.NO_CONTEXT) {
            try {
                RegisterValue contextValue = context.getRegisterValue(contextReg);
                Address start = address;
                if (SystemUtilities.isEqual((Object)contextValue, (Object)this.contextMgr.getDefaultValue(contextReg, start))) {
                    this.contextMgr.setValue(contextReg, start, endAddr, null);
                } else {
                    RegisterValue ctx = contextValue;
                    if (this.contextMgr.hasNonFlowingContext() && !start.equals(endAddr)) {
                        this.contextMgr.setRegisterValue(start, start, ctx);
                        ctx = this.contextMgr.getFlowValue(ctx);
                        start = start.next();
                    }
                    this.contextMgr.setRegisterValue(start, endAddr, ctx);
                }
            }
            catch (ContextChangeException e) {
                throw new AssertException(e.getMessage());
            }
        }
        long addr = this.addrMap.getKey(address, true);
        byte flags = 0;
        if (this.redisassemblyMode) {
            Byte byteFlags = this.redisassmblyFlags.get(addr);
            flags = byteFlags == null ? (byte)0 : byteFlags;
        }
        this.instAdapter.createInstruction(addr, protoID, flags);
        this.cache.delete(this.addrMap.getKeyRanges(address, endAddr, false));
        InstructionDB inst = new InstructionDB(this, this.cache, address, addr, prototype, flags);
        this.addReferencesForInstruction(inst);
        return inst;
    }

    RegisterValue getOriginalPrototypeContext(InstructionPrototype prototype, Register baseContextReg) throws NoValueException {
        return this.protoMgr.getOriginalPrototypeContext(prototype, baseContextReg);
    }

    CommentsDBAdapter getCommentAdapter() {
        return this.commentAdapter;
    }

    @Override
    public void deleteAddressRange(Address start, Address end, TaskMonitor monitor) throws CancelledException {
        CodeUnit cu = this.getCodeUnitContaining(start);
        if (cu != null) {
            start = cu.getMinAddress();
        }
        start = this.adjustStartForDelaySlot(start);
        end = this.adjustEndForDelaySlot(end);
        this.deleteAddressRange(start, end, false, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteAddressRange(Address start, Address end, boolean keepComments, TaskMonitor monitor) throws CancelledException {
        this.lock.acquire();
        boolean success = false;
        try {
            this.compositeMgr.removeRange(start, end);
            monitor.checkCanceled();
            this.instAdapter.deleteRecords(start, end);
            monitor.checkCanceled();
            this.dataAdapter.deleteRecords(start, end);
            monitor.checkCanceled();
            this.lengthMgr.removeRange(start, end);
            monitor.checkCanceled();
            if (!keepComments) {
                this.commentAdapter.deleteRecords(start, end);
                monitor.checkCanceled();
                this.historyAdapter.deleteRecords(start, end);
                monitor.checkCanceled();
            }
            this.cache.delete(this.addrMap.getKeyRanges(start, end, false));
            success = true;
        }
        catch (IOException e) {
            this.program.dbError(e);
        }
        finally {
            if (!success) {
                this.cache.invalidate();
            }
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveAddressRange(Address fromAddr, Address toAddr, long length, TaskMonitor monitor) throws CancelledException {
        this.lock.acquire();
        try {
            Address start = fromAddr;
            Address newStart = toAddr;
            Address newEnd = newStart.add(length - 1L);
            monitor.setMessage("Moving code...");
            try {
                this.moveDefinedCodeUnits(start, newStart, length, monitor);
                this.invalidateCache(true);
                this.addMovedInstructionReferences(newStart, newEnd, monitor);
                this.addMovedDataReferences(newStart, newEnd, monitor);
            }
            catch (IOException e) {
                this.program.dbError(e);
            }
            this.invalidateCache(true);
        }
        finally {
            this.lock.release();
        }
    }

    public CodeUnit getCodeUnitAt(Address address) {
        long addr = this.addrMap.getKey(address, false);
        if (address.isExternalAddress()) {
            Symbol externalSymbol = this.program.getSymbolTable().getPrimarySymbol(address);
            if (externalSymbol == null) {
                return this.getUndefinedDataDB(address, addr);
            }
            ExternalLocation externalLocation = this.program.getExternalManager().getExternalLocation(externalSymbol);
            DataType dataType = externalLocation.getDataType();
            if (dataType == null || dataType == DataType.DEFAULT) {
                return this.getUndefinedDataDB(address, addr);
            }
            DataDB dataDB = new DataDB(this, null, addr, address, addr, dataType);
            return dataDB;
        }
        return this.getCodeUnitAt(addr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CodeUnit getCodeUnitAt(long addr) {
        if (addr == -1L) {
            return null;
        }
        this.lock.acquire();
        try {
            CodeUnitDB cu = this.cache.get(addr);
            if (cu != null) {
                CodeUnitDB codeUnitDB = cu;
                return codeUnitDB;
            }
            InstructionDB inst = this.getInstructionDB(addr);
            if (inst != null) {
                InstructionDB instructionDB = inst;
                return instructionDB;
            }
            DataDB data = this.getDataDB(addr);
            if (data != null) {
                DataDB dataDB = data;
                return dataDB;
            }
            Data data2 = this.getUndefinedAt(this.addrMap.decodeAddress(addr), addr);
            return data2;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CodeUnit getCodeUnitAfter(Address addr) {
        this.lock.acquire();
        try {
            CodeUnit cu = this.getCodeUnitContaining(addr);
            if (cu != null) {
                addr = cu.getMaxAddress();
            }
            Memory mem = this.program.getMemory();
            AddressIterator it = mem.getAddresses(addr, true);
            if (mem.contains(addr)) {
                it.next();
            }
            if (it.hasNext()) {
                addr = it.next();
                CodeUnit codeUnit = this.getCodeUnitAt(addr);
                return codeUnit;
            }
        }
        finally {
            this.lock.release();
        }
        return null;
    }

    public Iterator<String> getUserDefinedProperties() {
        return this.propertyMapMgr.propertyManagers();
    }

    public void removeUserDefinedProperty(String propertyName) {
        this.propertyMapMgr.removePropertyMap(propertyName);
    }

    public PropertyMap getPropertyMap(String propertyName) {
        return this.propertyMapMgr.getPropertyMap(propertyName);
    }

    private CodeUnit getDefinedBefore(Address address) throws IOException {
        Address instAddr;
        DBRecord dataRec = this.dataAdapter.getRecordBefore(address);
        DBRecord instRec = this.instAdapter.getRecordBefore(address);
        if (dataRec == null && instRec == null) {
            return null;
        }
        if (dataRec == null) {
            return this.getInstructionDB(instRec);
        }
        if (instRec == null) {
            return this.getDataDB(dataRec);
        }
        Address dataAddr = this.addrMap.decodeAddress(dataRec.getKey());
        if (dataAddr.compareTo(instAddr = this.addrMap.decodeAddress(instRec.getKey())) > 0) {
            return this.getDataDB(dataRec);
        }
        return this.getInstructionDB(instRec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CodeUnit getCodeUnitBefore(Address address) {
        this.lock.acquire();
        try {
            AddressIterator it = this.program.getMemory().getAddresses(address, false);
            Address addr = null;
            if (it.hasNext() && (addr = it.next()).equals(address)) {
                Address address2 = addr = it.hasNext() ? it.next() : null;
            }
            if (addr == null) {
                CodeUnit codeUnit = null;
                return codeUnit;
            }
            CodeUnit cu = this.getDefinedBefore(address);
            if (cu != null && cu.contains(addr)) {
                CodeUnit codeUnit = cu;
                return codeUnit;
            }
            DataDB dataDB = this.getUndefinedDataDB(addr, this.addrMap.getKey(addr, false));
            return dataDB;
        }
        catch (IOException e) {
            this.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public CodeUnit getCodeUnitContaining(Address address) {
        block18: {
            DataDB dataDB;
            DataType dataType;
            long addr;
            block20: {
                Symbol externalSymbol;
                block19: {
                    block17: {
                        Object dataAddr;
                        block16: {
                            CodeUnitDB cuSecond;
                            block15: {
                                Address instAddr;
                                block14: {
                                    this.lock.acquire();
                                    CodeUnit cu = this.getCodeUnitAt(address);
                                    if (cu == null) break block14;
                                    CodeUnit codeUnit = cu;
                                    this.lock.release();
                                    return codeUnit;
                                }
                                DBRecord dataRec = this.dataAdapter.getRecordBefore(address);
                                DBRecord instRec = this.instAdapter.getRecordBefore(address);
                                CodeUnitDB cuFirst = null;
                                cuSecond = null;
                                if (instRec != null) {
                                    cuFirst = this.getInstructionDB(instRec);
                                }
                                if (dataRec != null) {
                                    cuSecond = this.getDataDB(dataRec);
                                }
                                if (dataRec != null && instRec != null && (dataAddr = this.addrMap.decodeAddress(dataRec.getKey())).compareTo(instAddr = this.addrMap.decodeAddress(instRec.getKey())) > 0) {
                                    InstructionDB tmp = cuFirst;
                                    cuFirst = cuSecond;
                                    cuSecond = tmp;
                                }
                                if (cuFirst == null || !cuFirst.contains(address)) break block15;
                                dataAddr = cuFirst;
                                this.lock.release();
                                return dataAddr;
                            }
                            if (cuSecond == null || !cuSecond.contains(address)) break block16;
                            dataAddr = cuSecond;
                            this.lock.release();
                            return dataAddr;
                        }
                        if (!this.program.getMemory().contains(address)) break block17;
                        dataAddr = this.getUndefinedAt(address);
                        this.lock.release();
                        return dataAddr;
                    }
                    if (!address.isExternalAddress()) break block18;
                    addr = this.addrMap.getKey(address, false);
                    externalSymbol = this.program.getSymbolTable().getPrimarySymbol(address);
                    if (externalSymbol != null) break block19;
                    DataDB dataDB2 = this.getUndefinedDataDB(address, addr);
                    this.lock.release();
                    return dataDB2;
                }
                ExternalLocation externalLocation = this.program.getExternalManager().getExternalLocation(externalSymbol);
                dataType = externalLocation.getDataType();
                if (dataType != null && dataType != DataType.DEFAULT) break block20;
                DataDB dataDB3 = this.getUndefinedDataDB(address, addr);
                this.lock.release();
                return dataDB3;
            }
            DataDB dataDB4 = dataDB = new DataDB(this, null, addr, address, addr, dataType);
            this.lock.release();
            return dataDB4;
        }
        try {
            block21: {
                break block21;
                catch (IOException e) {
                    this.dbError(e);
                }
            }
            CodeUnit codeUnit = null;
            return codeUnit;
        }
        finally {
            this.lock.release();
        }
    }

    public CodeUnitIterator getCodeUnitIterator(String property, Address address, boolean forward) {
        Address end;
        if (this.program.getMemory().isEmpty()) {
            return new EmptyCodeUnitIterator();
        }
        if (address == null) {
            address = this.program.getMinAddress();
        }
        Address start = forward ? address : this.program.getMinAddress();
        Address address2 = end = forward ? this.program.getMaxAddress() : address;
        if (property.equals("COMMENT__GHIDRA_")) {
            try {
                AddressKeyIterator iter = this.commentAdapter.getKeys(start, end, forward);
                return new CodeUnitKeyIterator(this, iter, forward);
            }
            catch (IOException e) {
                this.program.dbError(e);
            }
        } else if (property.equals("INSTRUCTION__GHIDRA_")) {
            try {
                AddressKeyIterator iter = this.instAdapter.getKeys(start, end, forward);
                return new CodeUnitKeyIterator(this, iter, forward);
            }
            catch (IOException e) {
                this.program.dbError(e);
            }
        } else if (property.equals("DEFINED_DATA__GHIDRA_")) {
            try {
                AddressKeyIterator iter = this.dataAdapter.getKeys(start, end, forward);
                return new CodeUnitKeyIterator(this, iter, forward);
            }
            catch (IOException e) {
                this.program.dbError(e);
            }
        } else {
            PropertyMapDB pm = (PropertyMapDB)this.propertyMapMgr.getPropertyMap(property);
            if (pm != null) {
                try {
                    AddressKeyIterator iter = pm.getAddressKeyIterator(start, end, forward);
                    return new CodeUnitKeyIterator(this, iter, forward);
                }
                catch (IOException e) {
                    this.program.dbError(e);
                }
            }
        }
        return new EmptyCodeUnitIterator();
    }

    public CodeUnitIterator getCodeUnitIterator(String property, AddressSetView addrSetView, boolean forward) {
        PropertyMapDB pm;
        if (addrSetView == null) {
            addrSetView = this.program.getMemory();
        } else if (addrSetView.isEmpty()) {
            return CodeUnitIterator.EMPTY_ITERATOR;
        }
        if (property.equals("COMMENT__GHIDRA_")) {
            try {
                AddressKeyIterator iter = this.commentAdapter.getKeys(addrSetView, forward);
                return new CodeUnitKeyIterator(this, iter, forward);
            }
            catch (IOException e) {
                this.program.dbError(e);
            }
        }
        if (property.equals("INSTRUCTION__GHIDRA_")) {
            try {
                AddressKeyIterator iter = this.instAdapter.getKeys(addrSetView, forward);
                return new CodeUnitKeyIterator(this, iter, forward);
            }
            catch (IOException e) {
                this.program.dbError(e);
            }
        }
        if (property.equals("DEFINED_DATA__GHIDRA_")) {
            try {
                AddressKeyIterator iter = this.dataAdapter.getKeys(addrSetView, forward);
                return new CodeUnitKeyIterator(this, iter, forward);
            }
            catch (IOException e) {
                this.program.dbError(e);
            }
        }
        if ((pm = (PropertyMapDB)this.propertyMapMgr.getPropertyMap(property)) != null) {
            try {
                AddressKeyIterator iter = pm.getAddressKeyIterator(addrSetView, forward);
                return new CodeUnitKeyIterator(this, iter, forward);
            }
            catch (IOException e) {
                this.program.dbError(e);
            }
        }
        return new EmptyCodeUnitIterator();
    }

    public CodeUnitIterator getCommentCodeUnitIterator(int commentType, AddressSetView set) {
        CodeUnitIterator it = this.getCodeUnitIterator("COMMENT__GHIDRA_", set, true);
        return new CommentTypeFilterIterator(it, commentType);
    }

    public AddressIterator getCommentAddressIterator(int commentType, AddressSetView set, boolean forward) {
        if (set != null && set.isEmpty()) {
            return AddressIterator.EMPTY_ITERATOR;
        }
        try {
            AddressKeyIterator keyIter = this.commentAdapter.getKeys(set, forward);
            AddressKeyAddressIterator addrIter = new AddressKeyAddressIterator(keyIter, forward, this.addrMap, (ErrorHandler)this.program);
            return new CommentTypeFilterAddressIterator(this.program, addrIter, commentType);
        }
        catch (IOException e) {
            this.program.dbError(e);
            return new EmptyAddressIterator();
        }
    }

    public AddressIterator getCommentAddressIterator(AddressSetView addrSet, boolean forward) {
        if (addrSet != null && addrSet.isEmpty()) {
            return AddressIterator.EMPTY_ITERATOR;
        }
        try {
            AddressKeyIterator keyIter = this.commentAdapter.getKeys(addrSet, forward);
            return new AddressKeyAddressIterator(keyIter, forward, this.addrMap, (ErrorHandler)this.program);
        }
        catch (IOException e) {
            this.program.dbError(e);
            return new EmptyAddressIterator();
        }
    }

    public Instruction getInstructionAt(Address address) {
        return this.getInstructionAt(this.addrMap.getKey(address, false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InstructionDB getInstructionAt(long addr) {
        if (addr == -1L) {
            return null;
        }
        this.lock.acquire();
        try {
            CodeUnitDB cu = this.cache.get(addr);
            if (cu == null) {
                InstructionDB instructionDB = this.getInstructionDB(addr);
                return instructionDB;
            }
            if (cu instanceof InstructionDB) {
                InstructionDB instructionDB = (InstructionDB)cu;
                return instructionDB;
            }
        }
        catch (IOException e) {
            this.program.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return null;
    }

    public Data getDefinedDataAt(Address address) {
        return this.getDefinedDataAt(this.addrMap.getKey(address, false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Data getDefinedDataAt(long addr) {
        if (addr == -1L) {
            return null;
        }
        this.lock.acquire();
        try {
            CodeUnit cu = this.cache.get(addr);
            if (cu == null) {
                DBRecord rec = this.dataAdapter.getRecord(addr);
                DataDB dataDB = this.getDataDB(rec);
                return dataDB;
            }
            if (cu instanceof Data && ((Data)cu).isDefined()) {
                DataDB dataDB = (DataDB)cu;
                return dataDB;
            }
        }
        catch (IOException e) {
            this.program.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Instruction getInstructionBefore(Address addr) {
        this.lock.acquire();
        try {
            DBRecord rec = this.instAdapter.getRecordBefore(addr);
            InstructionDB instructionDB = this.getInstructionDB(rec);
            return instructionDB;
        }
        catch (IOException e) {
            this.program.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Instruction getInstructionAfter(Address addr) {
        this.lock.acquire();
        try {
            DBRecord rec = this.instAdapter.getRecordAfter(addr);
            InstructionDB instructionDB = this.getInstructionDB(rec);
            return instructionDB;
        }
        catch (IOException e) {
            this.program.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Instruction getInstructionContaining(Address address) {
        this.lock.acquire();
        try {
            Instruction instr = this.getInstructionAt(address);
            if (instr != null) {
                Instruction instruction = instr;
                return instruction;
            }
            instr = this.getInstructionBefore(address);
            if (instr != null && instr.contains(address)) {
                Instruction instruction = instr;
                return instruction;
            }
            Instruction instruction = null;
            return instruction;
        }
        finally {
            this.lock.release();
        }
    }

    public Data getDataAt(Address address) {
        return this.getDataAt(address, this.addrMap.getKey(address, false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Data getDataAt(Address address, long addr) {
        if (addr == -1L) {
            return this.getUndefinedDataDB(address, addr);
        }
        this.lock.acquire();
        try {
            DataDB data = this.getDataDB(addr);
            if (data != null) {
                DataDB dataDB = data;
                return dataDB;
            }
            Data data2 = this.getUndefinedAt(address, addr);
            return data2;
        }
        catch (IOException e) {
            this.program.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return null;
    }

    public Data getDataBefore(Address addr) {
        CodeUnitIterator it = this.getCodeUnits(addr, false);
        CodeUnit cu = it.next();
        if (cu != null && !cu.getMinAddress().equals(addr) && cu instanceof Data) {
            return (Data)cu;
        }
        while (it.hasNext()) {
            cu = it.next();
            if (!(cu instanceof Data)) continue;
            return (Data)cu;
        }
        return null;
    }

    public Data getDataAfter(Address addr) {
        CodeUnitIterator it = this.getCodeUnits(addr, true);
        if (this.getCodeUnitAt(addr) != null) {
            it.next();
        }
        while (it.hasNext()) {
            CodeUnit cu = it.next();
            if (!(cu instanceof Data)) continue;
            return (Data)cu;
        }
        return null;
    }

    public Data getDataContaining(Address addr) {
        CodeUnit cu = this.getCodeUnitContaining(addr);
        if (cu instanceof Data) {
            return (Data)cu;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Data getDefinedDataAfter(Address addr) {
        this.lock.acquire();
        try {
            DBRecord rec = this.dataAdapter.getRecordAfter(addr);
            DataDB dataDB = this.getDataDB(rec);
            return dataDB;
        }
        catch (IOException e) {
            this.program.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Data getDefinedDataBefore(Address addr) {
        this.lock.acquire();
        try {
            DBRecord rec = this.dataAdapter.getRecordBefore(addr);
            DataDB dataDB = this.getDataDB(rec);
            return dataDB;
        }
        catch (IOException e) {
            this.program.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Data getDefinedDataContaining(Address addr) {
        this.lock.acquire();
        try {
            Data data = this.getDefinedDataAt(addr);
            if (data != null) {
                Data data2 = data;
                return data2;
            }
            data = this.getDefinedDataBefore(addr);
            if (data != null && data.contains(addr)) {
                Data data3 = data;
                return data3;
            }
            Data data4 = null;
            return data4;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AddressSetView getUndefinedRanges(AddressSetView set, boolean initializedMemoryOnly, TaskMonitor monitor) throws CancelledException {
        this.lock.acquire();
        try {
            AddressSet searchSet;
            if (monitor == null) {
                monitor = TaskMonitorAdapter.DUMMY_MONITOR;
            }
            Memory mem = this.program.getMemory();
            if (set == null) {
                searchSet = new AddressSet(initializedMemoryOnly ? mem.getLoadedAndInitializedAddressSet() : mem);
            } else {
                if (set.isEmpty()) {
                    AddressSetView addressSetView = set;
                    return addressSetView;
                }
                searchSet = new AddressSet(set);
                searchSet = searchSet.intersect(initializedMemoryOnly ? mem.getLoadedAndInitializedAddressSet() : mem);
            }
            AddressSet resultSet = new AddressSet();
            block12: for (AddressRange range : searchSet.getAddressRanges()) {
                monitor.checkCanceled();
                Address start = range.getMinAddress();
                Address rangeMax = range.getMaxAddress();
                if (start.getAddressSpace().getMinAddress().compareTo(start) < 0) {
                    try {
                        Instruction instr = this.getInstructionBefore(start);
                        if (instr != null && instr.contains(start)) {
                            start = instr.getMaxAddress().addNoWrap(1L);
                            if (start.compareTo(rangeMax) > 0) {
                            }
                        } else {
                            Data data = this.getDefinedDataBefore(start);
                            if (data != null && data.contains(start) && (start = data.getMaxAddress().addNoWrap(1L)).compareTo(rangeMax) > 0) {
                            }
                        }
                    }
                    catch (AddressOverflowException e) {}
                    continue;
                }
                RecordIterator instIter = this.instAdapter.getRecords(start, rangeMax, true);
                RecordIterator dataIter = this.dataAdapter.getRecords(start, rangeMax, true);
                Address nextInstAddr = null;
                Address nextDataAddr = null;
                Address nextInstEndAddr = null;
                Address nextDataEndAddr = null;
                while (true) {
                    if (nextInstAddr == null && instIter.hasNext()) {
                        int len;
                        DBRecord nextInstRec = instIter.next();
                        nextInstEndAddr = nextInstAddr = this.addrMap.decodeAddress(nextInstRec.getKey());
                        int protoID = nextInstRec.getIntValue(0);
                        InstructionPrototype proto = this.protoMgr.getPrototype(protoID);
                        int n = len = proto != null ? proto.getLength() : nextInstAddr.getAddressSpace().getAddressableUnitSize();
                        if (len > 1) {
                            try {
                                nextInstEndAddr = nextInstAddr.addNoWrap(len - 1);
                            }
                            catch (AddressOverflowException e) {
                                nextInstEndAddr = rangeMax;
                            }
                        }
                    }
                    if (nextDataAddr == null && dataIter.hasNext()) {
                        DBRecord nextDataRec = dataIter.next();
                        nextDataEndAddr = nextDataAddr = this.addrMap.decodeAddress(nextDataRec.getKey());
                        DataDB data = this.getDataDB(nextDataRec);
                        int len = data.getLength();
                        if (len > 1) {
                            try {
                                nextDataEndAddr = nextDataAddr.addNoWrap(len - 1);
                            }
                            catch (AddressOverflowException e) {
                                nextDataEndAddr = rangeMax;
                            }
                        }
                    }
                    if (nextInstAddr == null && nextDataAddr == null) {
                        if (start.compareTo(rangeMax) > 0) continue block12;
                        resultSet.addRange(start, rangeMax);
                        continue block12;
                    }
                    Address nextDefinedAddr = nextInstAddr;
                    Address nextDefinedEndAddr = nextInstEndAddr;
                    if (nextInstAddr == null) {
                        nextDefinedAddr = nextDataAddr;
                        nextDefinedEndAddr = nextDataEndAddr;
                    }
                    if (nextInstAddr != null && nextDataAddr != null && nextInstAddr.compareTo(nextDataAddr) > 0) {
                        nextDefinedAddr = nextDataAddr;
                        nextDefinedEndAddr = nextDataEndAddr;
                        nextDataAddr = null;
                    } else if (nextDefinedAddr == nextInstAddr) {
                        nextInstAddr = null;
                    } else {
                        nextDataAddr = null;
                    }
                    if (start.compareTo(nextDefinedAddr) < 0) {
                        resultSet.addRange(start, nextDefinedAddr.subtract(1L));
                    }
                    if (nextDefinedEndAddr.compareTo(rangeMax) >= 0) continue block12;
                    start = nextDefinedEndAddr.add(1L);
                }
            }
            AddressSet addressSet = resultSet;
            return addressSet;
        }
        catch (IOException e) {
            this.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return null;
    }

    public Data getUndefinedAt(Address address) {
        return this.getUndefinedAt(address, this.addrMap.getKey(address, false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Data getUndefinedAt(Address address, long addr) {
        if (addr != -1L) {
            this.lock.acquire();
            try {
                Instruction inst = this.getInstructionContaining(address);
                if (inst != null) {
                    Data data = null;
                    return data;
                }
                Data data = this.getDefinedDataContaining(address);
                if (data != null) {
                    Data data2 = null;
                    return data2;
                }
                if (this.program.getMemory().contains(address)) {
                    DataDB dataDB = this.getUndefinedDataDB(address, addr);
                    return dataDB;
                }
            }
            finally {
                this.lock.release();
            }
        }
        if (address.isExternalAddress()) {
            Symbol externalSymbol = this.program.getSymbolTable().getPrimarySymbol(address);
            if (externalSymbol == null) {
                return this.getUndefinedDataDB(address, addr);
            }
            ExternalLocation externalLocation = this.program.getExternalManager().getExternalLocation(externalSymbol);
            DataType dataType = externalLocation.getDataType();
            if (dataType == null || dataType == DataType.DEFAULT) {
                return this.getUndefinedDataDB(address, addr);
            }
            DataDB dataDB = new DataDB(this, null, addr, address, addr, dataType);
            return dataDB;
        }
        return null;
    }

    public Data getFirstUndefinedDataAfter(Address addr, TaskMonitor monitor) {
        if (!addr.isMemoryAddress() || addr.equals(addr.getAddressSpace().getMaxAddress())) {
            return null;
        }
        Memory mem = this.program.getMemory();
        AddressSet set = mem.intersectRange(addr.next(), addr.getAddressSpace().getMaxAddress());
        int i = 0;
        CodeUnitIterator it = this.getCodeUnits(set, true);
        while (it.hasNext()) {
            CodeUnit cu = it.next();
            if (cu instanceof Data && !((Data)cu).isDefined()) {
                return (Data)cu;
            }
            if (++i % 1000 != 0) continue;
            monitor.setMessage("Searching address " + cu.getMinAddress());
        }
        return null;
    }

    public Data getFirstUndefinedData(AddressSetView set, TaskMonitor monitor) {
        if (set.isEmpty()) {
            return null;
        }
        Memory mem = this.program.getMemory();
        set = mem.intersect(set);
        if (set.isEmpty()) {
            return null;
        }
        int i = 0;
        CodeUnitIterator it = this.getCodeUnits(set, true);
        while (it.hasNext()) {
            CodeUnit cu = it.next();
            if (cu instanceof Data && !((Data)cu).isDefined()) {
                return (Data)cu;
            }
            if (++i % 1000 != 0) continue;
            monitor.setMessage("Searching address " + cu.getMinAddress());
        }
        return null;
    }

    public Data getFirstUndefinedDataBefore(Address addr, TaskMonitor monitor) {
        if (!addr.isMemoryAddress() || addr.getOffset() == 0L) {
            return null;
        }
        Memory mem = this.program.getMemory();
        AddressSet set = mem.intersectRange(addr.getAddressSpace().getMinAddress(), addr.previous());
        int i = 0;
        CodeUnitIterator it = this.getCodeUnits(set, false);
        while (it.hasNext()) {
            CodeUnit cu = it.next();
            if (cu instanceof Data && !((Data)cu).isDefined()) {
                return (Data)cu;
            }
            if (++i % 1000 != 0) continue;
            monitor.setMessage("Searching address " + cu.getMinAddress());
        }
        return null;
    }

    private void checkValidAddressRange(Address startAddr, Address endAddr) throws CodeUnitInsertionException, IOException {
        DataDB data;
        InstructionDB inst;
        DBRecord rec;
        if (!this.program.getMemory().contains(startAddr, endAddr)) {
            long length = endAddr.subtract(startAddr) + 1L;
            throw new CodeUnitInsertionException("Insufficent memory at address " + startAddr + " (length: " + length + " bytes)");
        }
        RecordIterator recIt = this.instAdapter.getRecords(startAddr, true);
        if (recIt.hasNext()) {
            rec = recIt.next();
            inst = this.getInstructionDB(rec);
            if (inst.getMinAddress().compareTo(endAddr) <= 0) {
                throw new CodeUnitInsertionException("Conflicting instruction exists at address " + inst.getMinAddress() + " to " + inst.getMaxAddress());
            }
            recIt.previous();
        }
        if (recIt.hasPrevious() && (inst = this.getInstructionDB(rec = recIt.previous())).getMaxAddress().compareTo(startAddr) >= 0) {
            throw new CodeUnitInsertionException("Conflicting instruction exists at address " + inst.getMinAddress() + " to " + inst.getMaxAddress());
        }
        recIt = this.dataAdapter.getRecords(startAddr, true);
        if (recIt.hasNext()) {
            rec = recIt.next();
            data = this.getDataDB(rec);
            if (data.getMinAddress().compareTo(endAddr) <= 0) {
                throw new CodeUnitInsertionException("Conflicting data exists at address " + data.getMinAddress() + " to " + data.getMaxAddress());
            }
            recIt.previous();
        }
        if (recIt.hasPrevious() && (data = this.getDataDB(rec = recIt.previous())).getMaxAddress().compareTo(startAddr) >= 0) {
            throw new CodeUnitInsertionException("Conflicting data exists at address " + data.getMinAddress() + " to " + data.getMaxAddress());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Data createCodeUnit(Address addr, DataType dataType, int length) throws CodeUnitInsertionException {
        this.lock.acquire();
        DataDB data = null;
        try {
            MemBuffer memBuffer;
            if (dataType instanceof BitFieldDataType) {
                throw new CodeUnitInsertionException("Bitfields not supported for Data");
            }
            DataType originalDataType = dataType;
            if (dataType instanceof FactoryDataType) {
                MemoryBufferImpl memBuffer2 = new MemoryBufferImpl(this.program.getMemory(), addr);
                dataType = ((FactoryDataType)dataType).getDataType(memBuffer2);
                length = -1;
            }
            if (dataType == null) {
                throw new CodeUnitInsertionException("Failed to resolve data type");
            }
            dataType = dataType.clone(this.dataManager);
            boolean isFunctionDef = dataType instanceof FunctionDefinition;
            if (dataType instanceof TypeDef) {
                isFunctionDef = ((TypeDef)dataType).getBaseDataType() instanceof FunctionDefinition;
            }
            if (isFunctionDef) {
                dataType = new PointerDataType(dataType, dataType.getDataTypeManager());
                length = dataType.getLength();
            } else if (dataType instanceof Dynamic) {
                MemoryBlock block;
                if (!(length > 0 && ((Dynamic)dataType).canSpecifyLength() || (block = this.program.getMemory().getBlock(addr)) != null && block.isInitialized())) {
                    throw new CodeUnitInsertionException(originalDataType.getName() + " may only be applied on initialized memory (" + addr + ")");
                }
                Dynamic dynamicDataType = (Dynamic)dataType;
                memBuffer = new MemoryBufferImpl(this.program.getMemory(), addr);
                length = dynamicDataType.getLength(memBuffer, length);
            } else {
                length = dataType.getLength();
            }
            if (length < 0) {
                throw new CodeUnitInsertionException("Failed to resolve data length for " + originalDataType.getName());
            }
            if (length == 0) {
                throw new CodeUnitInsertionException("Zero-length data not allowed " + originalDataType.getName());
            }
            Address endAddr = addr.addNoWrap(length - 1);
            this.checkValidAddressRange(addr, endAddr);
            if (dataType == DataType.DEFAULT) {
                memBuffer = this.getUndefinedDataDB(addr, this.addrMap.getKey(addr, false));
                return memBuffer;
            }
            DBRecord record = this.dataAdapter.createData(addr, this.dataManager.getResolvedID(dataType));
            DataType baseDt = dataType;
            if (baseDt instanceof TypeDef) {
                baseDt = ((TypeDef)baseDt).getBaseDataType();
            }
            if (dataType.getLength() < 1) {
                this.lengthMgr.add(addr, length);
            }
            this.cache.delete(this.addrMap.getKeyRanges(addr, endAddr, false));
            data = this.getDataDB(record);
            baseDt = data.getBaseDataType();
            if (dataType instanceof Composite || dataType instanceof Array || dataType instanceof Dynamic) {
                this.compositeMgr.add(addr);
                this.program.setChanged(33, addr, endAddr, null, null);
            }
            this.program.setChanged(30, addr, endAddr, null, data);
            this.addDataReferences(data, new ArrayList<Address>());
        }
        catch (AddressOverflowException e) {
            throw new CodeUnitInsertionException("Code unit would extend beyond Address space");
        }
        catch (IOException e) {
            this.program.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return data;
    }

    public void updateDataReferences(Data data) {
        this.lock.acquire();
        try {
            this.refManager.removeAllReferencesFrom(data.getMinAddress(), data.getMinAddress());
            this.addDataReferences(data, new ArrayList<Address>());
        }
        finally {
            this.lock.release();
        }
    }

    private void addDataReferences(Data data, List<Address> longSegmentAddressList) {
        Memory mem = this.program.getMemory();
        MemoryBlock block = mem.getBlock(data.getAddress());
        if (block == null || !block.isInitialized()) {
            return;
        }
        DataType dt = data.getBaseDataType();
        if (Address.class.equals(dt.getValueClass(null))) {
            Object obj = data.getValue();
            if (obj instanceof Address) {
                this.createReference(data, (Address)obj, longSegmentAddressList);
            }
            return;
        }
        if (!this.containsAddressComponents(dt)) {
            return;
        }
        int numComponents = data.getNumComponents();
        for (int i = 0; i < numComponents; ++i) {
            Data dataElement = data.getComponent(i);
            this.addDataReferences(dataElement, longSegmentAddressList);
        }
    }

    private boolean containsAddressComponents(DataType dt) {
        while (dt instanceof Array || dt instanceof TypeDef) {
            if (dt instanceof TypeDef) {
                dt = ((TypeDef)dt).getBaseDataType();
            }
            if (!(dt instanceof Array)) continue;
            dt = ((Array)dt).getDataType();
        }
        if (dt instanceof DynamicDataType || Address.class.equals(dt.getValueClass(null))) {
            return true;
        }
        if (dt instanceof Structure) {
            Structure structDt = (Structure)dt;
            for (DataTypeComponent component : structDt.getDefinedComponents()) {
                if (!this.containsAddressComponents(component.getDataType())) continue;
                return true;
            }
        }
        return false;
    }

    private void createReference(Data data, Address toAddr, List<Address> longSegmentAddressList) {
        if (toAddr == null || !toAddr.isLoadedMemoryAddress()) {
            return;
        }
        long offset = toAddr.getOffset();
        if (offset == 0L || offset == toAddr.getAddressSpace().getMaxAddress().getOffset()) {
            return;
        }
        if (toAddr.getAddressSpace().getSize() > 32 && this.exceedsLimitOn64BitAddressSegments(longSegmentAddressList, toAddr)) {
            return;
        }
        this.addDataReference(data.getMinAddress(), toAddr, true);
    }

    private boolean exceedsLimitOn64BitAddressSegments(List<Address> longSegmentAddressList, Address toAddr) {
        long maskedOffset = toAddr.getOffset() & 0xFFFFFFFF00000000L;
        for (Address address : longSegmentAddressList) {
            long offset = address.getOffset();
            if ((offset & 0xFFFFFFFF00000000L) != maskedOffset) continue;
            return false;
        }
        if (longSegmentAddressList.size() < 2) {
            longSegmentAddressList.add(toAddr);
            return false;
        }
        return true;
    }

    private boolean addDataReference(Address fromAddr, Address toAddr, boolean isPrimary) {
        Reference ref = this.refManager.addMemoryReference(fromAddr, toAddr, RefType.DATA, SourceType.DEFAULT, 0);
        if (!isPrimary) {
            this.refManager.setPrimary(ref, isPrimary);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearComments(Address start, Address end) {
        this.lock.acquire();
        try {
            try {
                this.addCommentHistoryRecords(start, end);
            }
            catch (IOException e) {
                this.program.dbError(e);
            }
            this.cache.invalidate();
            try {
                boolean commentRemoved = this.commentAdapter.deleteRecords(start, end);
                if (commentRemoved) {
                    this.program.setChanged(31, start, end, null, null);
                }
            }
            catch (IOException e) {
                this.program.dbError(e);
            }
        }
        finally {
            this.lock.release();
        }
    }

    public void clearProperties(Address start, Address end, TaskMonitor monitor) throws CancelledException {
        this.propertyMapMgr.removeAll(start, end, monitor);
    }

    private Address adjustStartForDelaySlot(Address addr) {
        Instruction instr;
        CodeUnit cu = this.getCodeUnitContaining(addr);
        if (cu == null) {
            return addr;
        }
        if (cu instanceof Instruction && (instr = (Instruction)cu).isInDelaySlot()) {
            try {
                Address previousAddr = instr.getMinAddress().subtractNoWrap(1L);
                return this.adjustStartForDelaySlot(previousAddr);
            }
            catch (AddressOverflowException addressOverflowException) {
                // empty catch block
            }
        }
        return cu.getMinAddress();
    }

    private Address adjustEndForDelaySlot(Address addr) {
        CodeUnit cu = this.getCodeUnitContaining(addr);
        if (cu == null) {
            return addr;
        }
        if (cu instanceof Instruction) {
            boolean followDelay;
            Instruction instr = (Instruction)cu;
            boolean bl = followDelay = instr.getPrototype().hasDelaySlots() || instr.isInDelaySlot();
            while (followDelay) {
                cu = instr;
                try {
                    Address nextAddr = instr.getMaxAddress().addNoWrap(1L);
                    CodeUnit nextCu = this.getCodeUnitContaining(nextAddr);
                    if (!(nextCu instanceof Instruction)) break;
                    instr = (Instruction)nextCu;
                    followDelay = instr.isInDelaySlot();
                }
                catch (AddressOverflowException e) {
                    break;
                }
            }
        }
        return cu.getMaxAddress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCodeUnits(Address start, Address end, boolean clearContext, TaskMonitor monitor) throws CancelledException {
        this.lock.acquire();
        try {
            CodeUnit cu = this.getCodeUnitContaining(start);
            if (cu != null) {
                start = cu.getMinAddress();
            }
            start = this.adjustStartForDelaySlot(start);
            end = this.adjustEndForDelaySlot(end);
            this.refManager.removeAllReferencesFrom(start, end);
            this.equateTable.deleteAddressRange(start, end, monitor);
            this.dataManager.deleteAddressRange(start, end, monitor);
            this.deleteAddressRange(start, end, true, monitor);
            if (clearContext && this.contextMgr.getBaseContextRegister() != null) {
                try {
                    this.contextMgr.remove(start, end, this.contextMgr.getBaseContextRegister());
                }
                catch (ContextChangeException e) {
                    throw new AssertException((Throwable)((Object)e));
                }
            }
            this.program.setChanged(31, start, end, cu, null);
        }
        finally {
            this.lock.release();
        }
    }

    public void clearAll(boolean clearContext, TaskMonitor monitor) {
        Address minAddr = this.program.getMinAddress();
        Address maxAddr = this.program.getMaxAddress();
        try {
            this.clearCodeUnits(minAddr, maxAddr, clearContext, monitor);
        }
        catch (CancelledException cancelledException) {
            // empty catch block
        }
    }

    public int getNumInstructions() {
        try {
            return this.instAdapter.getRecordCount();
        }
        catch (IOException e) {
            this.program.dbError(e);
            return 0;
        }
    }

    public int getNumDefinedData() {
        try {
            return this.dataAdapter.getRecordCount();
        }
        catch (IOException e) {
            this.program.dbError(e);
            return 0;
        }
    }

    public DataIterator getCompositeData(Address start, boolean forward) {
        try {
            return new DataKeyIterator(this, this.addrMap, this.compositeMgr.getAddressKeyIterator(start, forward));
        }
        catch (IOException e) {
            this.program.dbError(e);
            return null;
        }
    }

    public DataIterator getCompositeData(AddressSetView addrSet, boolean forward) {
        try {
            return new DataKeyIterator(this, this.addrMap, this.compositeMgr.getAddressKeyIterator(addrSet, forward));
        }
        catch (IOException e) {
            this.program.dbError(e);
            return null;
        }
    }

    public CodeUnitIterator getCodeUnits(Address start, boolean forward) {
        AddressSet bounds;
        Memory mem = this.program.getMemory();
        if (forward) {
            Address max = mem.getMaxAddress();
            if (start.compareTo(max) > 0) {
                return new EmptyCodeUnitIterator();
            }
            bounds = this.program.getAddressFactory().getAddressSet(start, max);
        } else {
            Address min = mem.getMinAddress();
            if (start.compareTo(min) < 0) {
                return new EmptyCodeUnitIterator();
            }
            bounds = this.program.getAddressFactory().getAddressSet(min, start);
        }
        AddressSet set = mem.intersect(bounds);
        if (set.isEmpty()) {
            return CodeUnitIterator.EMPTY_ITERATOR;
        }
        return new CodeUnitRecordIterator(this, this.getInstructions(start, forward), this.getDefinedData(start, forward), mem.intersect(bounds), forward);
    }

    public CodeUnitIterator getCodeUnits(AddressSetView set, boolean forward) {
        if (set.isEmpty()) {
            return CodeUnitIterator.EMPTY_ITERATOR;
        }
        return new CodeUnitRecordIterator(this, this.getInstructions(set, forward), this.getDefinedData(set, forward), set, forward);
    }

    public InstructionIterator getInstructions(Address address, boolean forward) {
        try {
            RecordIterator recIt = this.instAdapter.getRecords(address, forward);
            return new InstructionRecordIterator(this, recIt, forward);
        }
        catch (IOException e) {
            this.program.dbError(e);
            return null;
        }
    }

    public DataIterator getDefinedData(Address address, boolean forward) {
        try {
            RecordIterator recIt = this.dataAdapter.getRecords(address, forward);
            return new DataRecordIterator(this, recIt, forward);
        }
        catch (IOException e) {
            this.program.dbError(e);
            return null;
        }
    }

    public InstructionIterator getInstructions(AddressSetView set, boolean forward) {
        try {
            RecordIterator recIt = this.instAdapter.getRecords(set, forward);
            return new InstructionRecordIterator(this, recIt, forward);
        }
        catch (IOException e) {
            this.program.dbError(e);
            return null;
        }
    }

    public DataIterator getData(Address start, boolean forward) {
        return new DataFilteredCodeUnitIterator(this.getCodeUnits(start, forward));
    }

    public DataIterator getData(AddressSetView addrSet, boolean forward) {
        return new DataFilteredCodeUnitIterator(this.getCodeUnits(addrSet, forward));
    }

    public DataIterator getDefinedData(AddressSetView addrSet, boolean forward) {
        try {
            return new DataRecordIterator(this, this.dataAdapter.getRecords(addrSet, forward), forward);
        }
        catch (IOException e) {
            this.program.dbError(e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkContextWrite(Address start, Address end) throws ContextChangeException {
        this.lock.acquire();
        try {
            if (!start.getAddressSpace().equals(end.getAddressSpace())) {
                throw new IllegalArgumentException();
            }
            if (!this.contextLockingEnabled || this.creatingInstruction || !this.program.getMemory().contains(start, end)) {
                return;
            }
            boolean fail = false;
            if (this.getInstructionContaining(start) != null) {
                fail = true;
            } else {
                Address addr;
                AddressRangeImpl range = new AddressRangeImpl(start, end);
                Instruction inst = this.getInstructionAfter(start);
                if (inst != null && range.contains(addr = inst.getMinAddress())) {
                    fail = true;
                }
            }
            if (fail) {
                throw new ContextChangeException("Context register change conflicts with one or more instructions");
            }
        }
        finally {
            this.lock.release();
        }
    }

    public boolean isUndefined(Address start, Address end) {
        Address addr;
        Address addr2;
        if (!start.getAddressSpace().equals(end.getAddressSpace())) {
            return false;
        }
        if (!this.program.getMemory().contains(start, end)) {
            return false;
        }
        if (this.getInstructionContaining(start) != null) {
            return false;
        }
        if (this.getDefinedDataContaining(start) != null) {
            return false;
        }
        AddressRangeImpl range = new AddressRangeImpl(start, end);
        Instruction inst = this.getInstructionAfter(start);
        if (inst != null && range.contains(addr2 = inst.getMinAddress())) {
            return false;
        }
        Data data = this.getDefinedDataAfter(start);
        return data == null || !range.contains(addr = data.getMinAddress());
    }

    protected boolean isUndefined(Address address, long addr) {
        if (this.program.getMemory().contains(address)) {
            try {
                DBRecord rec = this.dataAdapter.getRecord(addr);
                if (rec == null) {
                    rec = this.instAdapter.getRecord(addr);
                }
                if (rec != null) {
                    return false;
                }
                CodeUnit cu = this.getDefinedBefore(address);
                if (cu == null) {
                    return true;
                }
                return cu.getMaxAddress().compareTo(address) < 0;
            }
            catch (IOException e) {
                this.program.dbError(e);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearData(long[] dataTypeIDs, TaskMonitor monitor) throws CancelledException {
        this.lock.acquire();
        try {
            ArrayList<Address> addrs = new ArrayList<Address>();
            RecordIterator it = this.dataAdapter.getRecords();
            block5: while (it.hasNext()) {
                monitor.checkCanceled();
                DBRecord rec = it.next();
                long id = rec.getLongValue(0);
                for (long dataTypeID : dataTypeIDs) {
                    if (id != dataTypeID) continue;
                    addrs.add(this.addrMap.decodeAddress(rec.getKey()));
                    continue block5;
                }
            }
            for (Address addr : addrs) {
                monitor.checkCanceled();
                this.clearCodeUnits(addr, addr, false, monitor);
            }
        }
        catch (IOException e) {
            this.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    Program getProgram() {
        return this.program;
    }

    SymbolTable getSymbolTable() {
        return this.symbolTable;
    }

    Listing getListing() {
        return this.program.getListing();
    }

    PropertyMapManager getPropertyMapManager() {
        return this.propertyMapMgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InstructionDB getInstructionDB(DBRecord rec) {
        this.lock.acquire();
        try {
            if (rec != null) {
                InstructionDB inst = (InstructionDB)this.cache.get(rec);
                if (inst != null) {
                    InstructionDB instructionDB = inst;
                    return instructionDB;
                }
                long addr = rec.getKey();
                Address address = this.addrMap.decodeAddress(addr);
                int protoID = rec.getIntValue(0);
                byte flags = rec.getByteValue(1);
                InstructionPrototype proto = this.protoMgr.getPrototype(protoID);
                InstructionDB instructionDB = inst = new InstructionDB(this, this.cache, address, addr, proto, flags);
                return instructionDB;
            }
            InstructionDB instructionDB = null;
            return instructionDB;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DataDB getDataDB(DBRecord rec) {
        this.lock.acquire();
        try {
            if (rec != null) {
                DataDB data = (DataDB)this.cache.get(rec);
                if (data != null) {
                    DataDB dataDB = data;
                    return dataDB;
                }
                long addr = rec.getKey();
                Address address = this.addrMap.decodeAddress(addr);
                long datatypeID = rec.getLongValue(0);
                DataType dt = this.dataManager.getDataType(datatypeID);
                DataDB dataDB = data = new DataDB(this, this.cache, addr, address, addr, dt);
                return dataDB;
            }
            DataDB dataDB = null;
            return dataDB;
        }
        finally {
            this.lock.release();
        }
    }

    DataDBAdapter getDataAdapter() {
        return this.dataAdapter;
    }

    InstDBAdapter getInstructionAdapter() {
        return this.instAdapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Address getDefinedAddressAfter(Address address) {
        this.lock.acquire();
        try {
            Address instAddr;
            DBRecord dataRec = null;
            DBRecord instRec = null;
            try {
                dataRec = this.dataAdapter.getRecordAfter(address);
                instRec = this.instAdapter.getRecordAfter(address);
            }
            catch (IOException e) {
                this.program.dbError(e);
                Address address2 = null;
                this.lock.release();
                return address2;
            }
            if (dataRec == null && instRec == null) {
                Address e = null;
                return e;
            }
            if (dataRec == null) {
                Address e = this.addrMap.decodeAddress(instRec.getKey());
                return e;
            }
            if (instRec == null) {
                Address e = this.addrMap.decodeAddress(dataRec.getKey());
                return e;
            }
            Address dataAddr = this.addrMap.decodeAddress(dataRec.getKey());
            if (dataAddr.compareTo(instAddr = this.addrMap.decodeAddress(instRec.getKey())) < 0) {
                Address address3 = dataAddr;
                return address3;
            }
            Address address4 = instAddr;
            return address4;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveDefinedCodeUnits(Address startAddr, Address newStartAddr, long length, TaskMonitor monitor) throws IOException, CancelledException {
        this.lock.acquire();
        try {
            Address endAddr = startAddr.add(length - 1L);
            this.compositeMgr.moveRange(startAddr, endAddr, newStartAddr);
            monitor.checkCanceled();
            this.lengthMgr.moveRange(startAddr, endAddr, newStartAddr);
            monitor.checkCanceled();
            this.instAdapter.moveAddressRange(startAddr, newStartAddr, length, monitor);
            this.dataAdapter.moveAddressRange(startAddr, newStartAddr, length, monitor);
            this.commentAdapter.moveAddressRange(startAddr, newStartAddr, length, monitor);
        }
        finally {
            this.lock.release();
        }
    }

    private void addMovedInstructionReferences(Address start, Address end, TaskMonitor monitor) throws IOException, CancelledException {
        RecordIterator iter = this.instAdapter.getRecords(start, end, true);
        while (iter.hasNext()) {
            monitor.checkCanceled();
            InstructionDB inst = this.getInstructionDB(iter.next());
            this.addReferencesForInstruction(inst);
        }
    }

    private void addMovedDataReferences(Address start, Address end, TaskMonitor monitor) throws IOException, CancelledException {
        RecordIterator iter = this.dataAdapter.getRecords(start, end, true);
        while (iter.hasNext()) {
            monitor.checkCanceled();
            DBRecord rec = iter.next();
            DataDB data = this.getDataDB(rec);
            this.addDataReferences(data, new ArrayList<Address>());
        }
    }

    private void addReferencesForInstruction(InstructionDB inst) {
        ArrayList<Reference> oldRefList = null;
        if (this.redisassemblyMode) {
            for (Reference ref : this.refManager.getReferencesFrom(inst.getMinAddress())) {
                if (ref.getSource() != SourceType.DEFAULT || !ref.isMemoryReference()) continue;
                if (oldRefList == null) {
                    oldRefList = new ArrayList<Reference>();
                }
                oldRefList.add(ref);
            }
        }
        InstructionPrototype prototype = inst.getPrototype();
        Address[] flowAddrs = prototype.getFlows(inst);
        int remainingAddrs = flowAddrs.length;
        int opCount = prototype.getNumOperands();
        for (int opIndex = 0; opIndex < opCount; ++opIndex) {
            RefType refType;
            Address refAddr;
            int refCnt = 0;
            Reference operandPrimaryRef = null;
            ArrayList<Object> opList = prototype.getOpRepresentationList(opIndex, inst);
            for (Object obj : opList) {
                if (!(obj instanceof Address)) continue;
                Address refAddr2 = (Address)obj;
                ++refCnt;
                RefType refType2 = this.getOperandMemoryReferenceType(inst, opIndex, flowAddrs, refAddr2);
                if (refType2 == null) continue;
                operandPrimaryRef = this.addDefaultMemoryReferenceIfMissing(inst, opIndex, refAddr2, refType2, oldRefList, operandPrimaryRef);
                --remainingAddrs;
            }
            if (refCnt == 0 && remainingAddrs > 0 && (refAddr = prototype.getAddress(opIndex, inst)) != null && (refType = this.getOperandMemoryReferenceType(inst, opIndex, flowAddrs, refAddr)) != null) {
                operandPrimaryRef = this.addDefaultMemoryReferenceIfMissing(inst, opIndex, refAddr, refType, oldRefList, operandPrimaryRef);
                --remainingAddrs;
            }
            if (operandPrimaryRef == null || operandPrimaryRef.isPrimary()) continue;
            this.refManager.setPrimary(operandPrimaryRef, true);
        }
        Reference mnemonicPrimaryRef = null;
        for (Address flowAddr : flowAddrs) {
            boolean isFallthrough;
            if (flowAddr == null || !flowAddr.isMemoryAddress()) continue;
            FlowType flowType = RefTypeFactory.getDefaultFlowType(inst, flowAddr, false);
            if (flowType == null) {
                flowType = RefType.INVALID;
            }
            boolean bl = isFallthrough = flowType.isJump() && flowAddr.equals(inst.getMaxAddress().next());
            if (isFallthrough) continue;
            mnemonicPrimaryRef = this.addDefaultMemoryReferenceIfMissing(inst, -1, flowAddr, flowType, oldRefList, mnemonicPrimaryRef);
        }
        if (mnemonicPrimaryRef != null && !mnemonicPrimaryRef.isPrimary()) {
            this.refManager.setPrimary(mnemonicPrimaryRef, true);
        }
        if (oldRefList != null && !oldRefList.isEmpty()) {
            for (Reference ref : oldRefList) {
                this.refManager.delete(ref);
            }
        }
    }

    private Reference addDefaultMemoryReferenceIfMissing(Instruction inst, int opIndex, Address refAddr, RefType refType, List<Reference> oldRefList, Reference operandPrimaryRef) {
        Reference ref = this.removeOldReference(oldRefList, refAddr, opIndex, refType);
        if (ref == null) {
            ref = this.refManager.addMemoryReference(inst.getMinAddress(), refAddr, refType, SourceType.DEFAULT, opIndex);
            if (operandPrimaryRef == null) {
                operandPrimaryRef = ref;
            }
        } else if (ref.isPrimary()) {
            operandPrimaryRef = ref;
        }
        return operandPrimaryRef;
    }

    private Reference removeOldReference(List<Reference> oldRefList, Address toAddr, int opIndex, RefType refType) {
        if (oldRefList == null) {
            return null;
        }
        Iterator<Reference> iterator = oldRefList.iterator();
        while (iterator.hasNext()) {
            Reference ref = iterator.next();
            if (opIndex != ref.getOperandIndex() || !toAddr.equals(ref.getToAddress())) continue;
            iterator.remove();
            if (refType != ref.getReferenceType()) break;
            return ref;
        }
        return null;
    }

    private RefType getOperandMemoryReferenceType(InstructionDB inst, int opIndex, Address[] flowAddrs, Address refAddr) {
        if (this.program.getRegister(refAddr) != null) {
            return null;
        }
        RefType refType = RefTypeFactory.getDefaultMemoryRefType(inst, opIndex, refAddr, true);
        if (refType.isFlow()) {
            for (int j = 0; j < flowAddrs.length; ++j) {
                if (!refAddr.equals(flowAddrs[j])) continue;
                flowAddrs[j] = null;
                return refType;
            }
            if (refType != RefType.INDIRECTION) {
                refType = RefType.DATA;
            }
        }
        return refType;
    }

    public ReferenceManager getReferenceMgr() {
        return this.refManager;
    }

    AddressMap getAddressMap() {
        return this.addrMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getLength(Address addr) {
        this.lock.acquire();
        try {
            int n = this.lengthMgr.getInt(addr);
            return n;
        }
        catch (NoValueException e) {
            int n = -1;
            return n;
        }
        finally {
            this.lock.release();
        }
    }

    private InstructionDB getInstructionDB(long addr) throws IOException {
        DBRecord rec = this.instAdapter.getRecord(addr);
        return this.getInstructionDB(rec);
    }

    protected DBRecord getInstructionRecord(long addr) {
        try {
            return this.instAdapter.getRecord(addr);
        }
        catch (IOException e) {
            this.program.dbError(e);
            return null;
        }
    }

    DataType getDataType(long addr) {
        try {
            return this.getDataType(this.dataAdapter.getRecord(addr));
        }
        catch (IOException e) {
            this.program.dbError(e);
            return null;
        }
    }

    DataType getDataType(DBRecord dataRecord) {
        if (dataRecord != null) {
            long datatypeID = dataRecord.getLongValue(0);
            DataType dt = this.dataManager.getDataType(datatypeID);
            return dt;
        }
        return null;
    }

    private DataDB getDataDB(long addr) throws IOException {
        return this.getDataDB(this.dataAdapter.getRecord(addr));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataDB getUndefinedDataDB(Address address, long addr) {
        if (addr == -1L) {
            return null;
        }
        this.lock.acquire();
        try {
            CodeUnit cu = this.cache.get(addr);
            if (cu == null) {
                DataDB data;
                if (address instanceof SegmentedAddress) {
                    address = this.normalize((SegmentedAddress)address, this.program.getMemory());
                }
                DataDB dataDB = data = new DataDB(this, this.cache, addr, address, addr, DefaultDataType.dataType);
                return dataDB;
            }
            if (cu instanceof Data && !((Data)cu).isDefined()) {
                DataDB dataDB = (DataDB)cu;
                return dataDB;
            }
            DataDB dataDB = null;
            return dataDB;
        }
        finally {
            this.lock.release();
        }
    }

    private Address normalize(SegmentedAddress addr, Memory memory) {
        if (memory == null) {
            return addr;
        }
        MemoryBlock block = memory.getBlock(addr);
        if (block == null) {
            return addr;
        }
        SegmentedAddress start = (SegmentedAddress)block.getStart();
        return addr.normalize(start.getSegment());
    }

    @Override
    public void invalidateCache(boolean all) {
        this.lock.acquire();
        try {
            this.cache.invalidate();
            this.lengthMgr.invalidateCache();
            this.compositeMgr.invalidateCache();
            this.protoMgr.clearCache();
        }
        finally {
            this.lock.release();
        }
    }

    public void invalidateCodeUnitCache() {
        this.cache.invalidate();
    }

    public void memoryChanged(Address addr, Address end) {
        this.lock.acquire();
        try {
            this.cache.invalidate();
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fallThroughChanged(Address fromAddr, Reference newFallThroughRef) {
        this.lock.acquire();
        try {
            InstructionDB instr = this.getInstructionAt(this.addrMap.getKey(fromAddr, false));
            if (instr != null) {
                instr.fallThroughChanged(newFallThroughRef);
            }
        }
        finally {
            this.lock.release();
        }
    }

    void setFlags(long addr, byte flags) {
        try {
            this.instAdapter.updateFlags(addr, flags);
        }
        catch (IOException e) {
            this.program.dbError(e);
        }
    }

    public String getComment(int commentType, Address address) {
        try {
            long addr = this.addrMap.getKey(address, false);
            DBRecord commentRec = this.getCommentAdapter().getRecord(addr);
            if (commentRec != null) {
                return commentRec.getString(commentType);
            }
        }
        catch (IOException e) {
            this.dbError(e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setComment(Address address, int commentType, String comment) {
        CodeUnit cu = this.getCodeUnitAt(address);
        if (cu != null) {
            cu.setComment(commentType, comment);
            return;
        }
        this.lock.acquire();
        try {
            long addr = this.addrMap.getKey(address, true);
            DBRecord commentRec = this.getCommentAdapter().getRecord(addr);
            if (commentRec == null) {
                if (comment == null) {
                    return;
                }
                commentRec = this.getCommentAdapter().createRecord(addr, commentType, comment);
                this.sendNotification(address, commentType, null, comment);
                return;
            }
            String oldValue = commentRec.getString(commentType);
            commentRec.setString(commentType, comment);
            this.sendNotification(address, commentType, oldValue, comment);
            for (int i = 0; i < 5; ++i) {
                if (commentRec.getString(i) == null) continue;
                this.getCommentAdapter().updateRecord(commentRec);
                return;
            }
            this.getCommentAdapter().deleteRecord(commentRec.getKey());
        }
        catch (IOException e) {
            this.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    void sendNotification(Address address, int commentType, String oldValue, String newValue) {
        int eventType;
        switch (commentType) {
            case 3: {
                eventType = 95;
                break;
            }
            case 1: {
                eventType = 91;
                break;
            }
            case 2: {
                eventType = 92;
                break;
            }
            case 4: {
                eventType = 96;
                break;
            }
            default: {
                eventType = 90;
            }
        }
        this.createCommentHistoryRecord(address, commentType, oldValue, newValue);
        this.program.setChanged(eventType, address, address, oldValue, newValue);
    }

    void createCommentHistoryRecord(Address address, int commentType, String oldComment, String newComment) {
        if (oldComment == null) {
            oldComment = "";
        }
        if (newComment == null) {
            newComment = "";
        }
        StringDiff[] diffs = StringDiffUtils.getLineDiffs(newComment, oldComment);
        long date = System.currentTimeMillis();
        long addr = this.addrMap.getKey(address, true);
        try {
            for (StringDiff diff : diffs) {
                this.historyAdapter.createRecord(addr, (byte)commentType, diff.start, diff.end, diff.text, date);
            }
        }
        catch (IOException e) {
            this.dbError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommentHistory[] getCommentHistory(Address addr, int commentType) {
        this.lock.acquire();
        try {
            List<DBRecord> allRecords = this.getHistoryRecords(addr, commentType);
            ArrayList<CommentHistory> results = new ArrayList<CommentHistory>();
            String comment = this.getComment(addr, commentType);
            while (!allRecords.isEmpty()) {
                DBRecord rec = allRecords.get(allRecords.size() - 1);
                long date = rec.getLongValue(6);
                List<DBRecord> records = this.subListByDate(allRecords, date);
                ArrayList<StringDiff> diffs = new ArrayList<StringDiff>(records.size());
                String user = null;
                for (DBRecord r : records) {
                    user = r.getString(5);
                    int pos1 = r.getIntValue(2);
                    int pos2 = r.getIntValue(3);
                    String data = r.getString(4);
                    diffs.add(StringDiff.restore(data, pos1, pos2));
                }
                results.add(new CommentHistory(addr, commentType, user, comment, new Date(date)));
                comment = StringDiffUtils.applyDiffs(comment, diffs);
                records.clear();
            }
            CommentHistory[] h = new CommentHistory[results.size()];
            CommentHistory[] commentHistoryArray = results.toArray(h);
            return commentHistoryArray;
        }
        catch (IOException e) {
            this.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return new CommentHistory[0];
    }

    private List<DBRecord> getHistoryRecords(Address addr, int commentType) throws IOException {
        RecordIterator it = this.historyAdapter.getRecordsByAddress(addr);
        ArrayList<DBRecord> list = new ArrayList<DBRecord>();
        while (it.hasNext()) {
            DBRecord rec = it.next();
            if (rec.getByteValue(1) != commentType) continue;
            list.add(rec);
        }
        return list;
    }

    private List<DBRecord> subListByDate(List<DBRecord> records, long date) {
        for (int i = records.size() - 1; i >= 0; --i) {
            DBRecord rec = records.get(i);
            if (date == rec.getLongValue(6)) continue;
            return records.subList(i + 1, records.size());
        }
        return records.subList(0, records.size());
    }

    private String getComment(Address addr, int commentType) throws IOException {
        DBRecord record = this.commentAdapter.getRecord(this.addrMap.getKey(addr, false));
        if (record != null) {
            return record.getString(commentType);
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceDataTypes(long oldDataTypeID, long newDataTypeID) {
        this.lock.acquire();
        try {
            RecordIterator it = this.dataAdapter.getRecords();
            while (it.hasNext()) {
                DBRecord rec = it.next();
                long id = rec.getLongValue(0);
                if (id != oldDataTypeID) continue;
                rec.setLongValue(0, newDataTypeID);
                this.dataAdapter.putRecord(rec);
                Address addr = this.addrMap.decodeAddress(rec.getKey());
                this.program.setChanged(35, addr, addr, null, null);
            }
        }
        catch (IOException e) {
            this.dbError(e);
        }
        finally {
            this.cache.invalidate();
            this.lock.release();
        }
    }

    private void addCommentHistoryRecords(Address start, Address end) throws IOException {
        RecordIterator iter = this.commentAdapter.getRecords(start, end, true);
        while (iter.hasNext()) {
            DBRecord rec = iter.next();
            this.addCommentHistoryRecord(rec, 1);
            this.addCommentHistoryRecord(rec, 2);
            this.addCommentHistoryRecord(rec, 0);
            this.addCommentHistoryRecord(rec, 3);
            this.addCommentHistoryRecord(rec, 4);
        }
    }

    private void addCommentHistoryRecord(DBRecord commentRec, int commentType) {
        String comment = commentRec.getString(commentType);
        if (comment != null) {
            this.createCommentHistoryRecord(this.addrMap.decodeAddress(commentRec.getKey()), commentType, comment, "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reDisassembleAllInstructions(TaskMonitor monitor) throws IOException, CancelledException {
        this.redisassemblyMode = true;
        try {
            if (this.lock.getOwner() != Thread.currentThread()) {
                throw new IllegalStateException("Must be invoked by lock owner");
            }
            Disassembler.clearUnimplementedPcodeWarnings(this.program, null, monitor);
            Disassembler.clearBadInstructionErrors(this.program, null, monitor);
            int maxCount = this.instAdapter.getRecordCount();
            monitor.initialize((long)maxCount);
            monitor.setMessage("Preparing for Re-Disassembly...");
            this.redisassmblyFlags = new HashMap();
            HashMap<Integer, Integer> protoLengthCache = new HashMap<Integer, Integer>();
            AddressSet codeSet = new AddressSet();
            Address minAddr = null;
            Address maxAddr = null;
            int count = 0;
            RecordIterator recIter = this.instAdapter.getRecords();
            while (recIter.hasNext()) {
                DBRecord rec = recIter.next();
                Address addr = this.addrMap.decodeAddress(rec.getKey());
                if (minAddr == null) {
                    minAddr = addr;
                } else {
                    Address nextAddr = null;
                    try {
                        nextAddr = maxAddr.add(1L);
                    }
                    catch (AddressOutOfBoundsException addressOutOfBoundsException) {
                        // empty catch block
                    }
                    if (nextAddr == null || !addr.equals(nextAddr)) {
                        codeSet.addRange(minAddr, maxAddr);
                        minAddr = addr;
                    }
                }
                int protoId = rec.getIntValue(0);
                Integer len = (Integer)protoLengthCache.get(protoId);
                if (len == null) {
                    len = this.protoMgr.getOriginalPrototypeLength(protoId);
                    if (len <= 0) {
                        len = 1;
                    }
                    protoLengthCache.put(protoId, len);
                }
                maxAddr = addr;
                try {
                    maxAddr = addr.add(len - 1);
                }
                catch (AddressOutOfBoundsException addressOutOfBoundsException) {
                    // empty catch block
                }
                byte flags = rec.getByteValue(1);
                if (flags != 0) {
                    this.redisassmblyFlags.put(rec.getKey(), flags);
                }
                if (++count % 1000 != 0) continue;
                monitor.checkCanceled();
                monitor.setProgress((long)count);
            }
            if (minAddr != null) {
                codeSet.addRange(minAddr, maxAddr);
            }
            monitor.setMessage("Clearing Old Instructions...");
            monitor.initialize(0L);
            this.instAdapter.deleteAll();
            this.cache.invalidate();
            this.protoMgr.setLanguage(this.program.getLanguage());
            monitor.setMessage("Performing Re-Disassembly...");
            Disassembler d = Disassembler.getDisassembler(this.program, monitor, new DisassemblerMessageListener(){

                @Override
                public void disassembleMessageReported(String msg) {
                    Msg.warn((Object)this, (Object)msg);
                }
            });
            d.disassemble(codeSet, (AddressSetView)codeSet, true);
        }
        finally {
            this.redisassemblyMode = false;
            this.redisassmblyFlags = null;
        }
    }

    InstructionPrototype getInstructionPrototype(int protoID) {
        return this.protoMgr.getPrototype(protoID);
    }
}

