/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcodeCPort.slghsymbol;

import ghidra.pcodeCPort.address.Address;
import ghidra.pcodeCPort.context.FixedHandle;
import ghidra.pcodeCPort.context.ParserWalker;
import ghidra.pcodeCPort.semantics.ConstTpl;
import ghidra.pcodeCPort.semantics.VarnodeTpl;
import ghidra.pcodeCPort.slghpatexpress.PatternExpression;
import ghidra.pcodeCPort.slghsymbol.SpecificSymbol;
import ghidra.pcodeCPort.slghsymbol.symbol_type;
import ghidra.pcodeCPort.space.AddrSpace;
import ghidra.sleigh.grammar.Location;
import java.io.PrintStream;

public class FlowDestSymbol
extends SpecificSymbol {
    private AddrSpace const_space;

    public FlowDestSymbol(Location location, String nm, AddrSpace cspc) {
        super(location, nm);
        this.const_space = cspc;
    }

    @Override
    public PatternExpression getPatternExpression() {
        return null;
    }

    @Override
    public symbol_type getType() {
        return symbol_type.start_symbol;
    }

    @Override
    public void getFixedHandle(FixedHandle hand, ParserWalker walker) {
        Address refAddr = walker.getFlowDestAddr();
        hand.space = this.const_space;
        hand.offset_space = null;
        hand.offset_offset = refAddr.getOffset();
        hand.size = refAddr.getAddrSize();
    }

    @Override
    public VarnodeTpl getVarnode() {
        ConstTpl spc = new ConstTpl(this.const_space);
        ConstTpl off = new ConstTpl(ConstTpl.const_type.j_flowdest);
        ConstTpl sz_zero = new ConstTpl();
        return new VarnodeTpl(this.location, spc, off, sz_zero);
    }

    @Override
    public void print(PrintStream s, ParserWalker pos) {
        long val = pos.getFlowDestAddr().getOffset();
        s.append("0x");
        s.print(Long.toHexString(val));
    }
}

