/*
 * Decompiled with CFR 0.152.
 */
package org.snpsift.testCases;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.List;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.snpeff.util.Gpr;
import org.snpeff.vcf.VcfEffect;
import org.snpeff.vcf.VcfEntry;
import org.snpeff.vcf.VcfGenotype;
import org.snpeff.vcf.VcfLof;
import org.snpsift.SnpSift;
import org.snpsift.SnpSiftCmdFilter;

public class TestCasesFilter
extends TestCase {
    public static boolean verbose = false;
    public static final int STDOUT_BUFFER_SIZE = 0xA00000;

    List<VcfEntry> snpSiftFilter(String[] args) {
        SnpSift snpSift = new SnpSift(args);
        SnpSiftCmdFilter snpSiftFilter = (SnpSiftCmdFilter)snpSift.cmd();
        return snpSiftFilter.run(true);
    }

    public void test_01() {
        Gpr.debug("Test");
        double minQ = 50.0;
        SnpSiftCmdFilter snpsiftFilter = new SnpSiftCmdFilter();
        String expression = "QUAL >= " + minQ;
        List<VcfEntry> list2 = snpsiftFilter.filter("test/test01.vcf", expression, true);
        if (verbose) {
            System.out.println("Expression: '" + expression + "'");
        }
        Assert.assertNotNull(list2);
        Assert.assertTrue(list2.size() > 0);
        for (VcfEntry vcfEntry : list2) {
            if (verbose) {
                System.out.println("\t" + vcfEntry);
            }
            Assert.assertTrue(vcfEntry.getQuality() >= minQ);
        }
    }

    public void test_02() {
        Gpr.debug("Test");
        SnpSiftCmdFilter snpsiftFilter = new SnpSiftCmdFilter();
        String expression = "(CHROM = '19')";
        List<VcfEntry> list2 = snpsiftFilter.filter("test/test01.vcf", expression, true);
        if (verbose) {
            System.out.println("Expression: '" + expression + "'");
        }
        Assert.assertNotNull(list2);
        Assert.assertTrue(list2.size() > 0);
        for (VcfEntry vcfEntry : list2) {
            if (verbose) {
                System.out.println("\t" + vcfEntry);
            }
            Assert.assertTrue(vcfEntry.getChromosomeName().equals("19"));
        }
    }

    public void test_03() {
        Gpr.debug("Test");
        int minPos = 20175;
        SnpSiftCmdFilter snpsiftFilter = new SnpSiftCmdFilter();
        String expression = "(POS > " + minPos + ")";
        List<VcfEntry> list2 = snpsiftFilter.filter("test/test01.vcf", expression, true);
        if (verbose) {
            System.out.println("Expression: '" + expression + "'");
        }
        Assert.assertNotNull(list2);
        Assert.assertTrue(list2.size() > 0);
        for (VcfEntry vcfEntry : list2) {
            if (verbose) {
                System.out.println("\t" + vcfEntry.getStart() + "\t" + vcfEntry);
            }
            Assert.assertTrue(vcfEntry.getStart() > minPos - 1);
        }
    }

    public void test_04() {
        Gpr.debug("Test");
        int minPos = 20175;
        SnpSiftCmdFilter snpsiftFilter = new SnpSiftCmdFilter();
        String expression = "(POS >= " + minPos + ")";
        List<VcfEntry> list2 = snpsiftFilter.filter("test/test01.vcf", expression, true);
        if (verbose) {
            System.out.println("Expression: '" + expression + "'");
        }
        Assert.assertNotNull(list2);
        Assert.assertTrue(list2.size() > 0);
        for (VcfEntry vcfEntry : list2) {
            if (verbose) {
                System.out.println("\t" + vcfEntry.getStart() + "\t" + vcfEntry);
            }
            Assert.assertTrue(vcfEntry.getStart() >= 20174);
        }
    }

    public void test_05() {
        Gpr.debug("Test");
        int maxPos = 20175;
        SnpSiftCmdFilter snpsiftFilter = new SnpSiftCmdFilter();
        String expression = "(POS < " + maxPos + ")";
        List<VcfEntry> list2 = snpsiftFilter.filter("test/test01.vcf", expression, true);
        if (verbose) {
            System.out.println("Expression: '" + expression + "'");
        }
        Assert.assertNotNull(list2);
        Assert.assertTrue(list2.size() > 0);
        for (VcfEntry vcfEntry : list2) {
            if (verbose) {
                System.out.println("\t" + vcfEntry);
            }
            Assert.assertTrue(vcfEntry.getStart() < maxPos - 1);
        }
    }

    public void test_06() {
        Gpr.debug("Test");
        int maxPos = 20175;
        SnpSiftCmdFilter snpsiftFilter = new SnpSiftCmdFilter();
        String expression = "(POS <= " + maxPos + ")";
        List<VcfEntry> list2 = snpsiftFilter.filter("test/test01.vcf", expression, true);
        if (verbose) {
            System.out.println("Expression: '" + expression + "'");
        }
        Assert.assertNotNull(list2);
        Assert.assertTrue(list2.size() > 0);
        for (VcfEntry vcfEntry : list2) {
            if (verbose) {
                System.out.println("\t" + vcfEntry);
            }
            Assert.assertTrue(vcfEntry.getStart() <= maxPos - 1);
        }
    }

    public void test_07() {
        Gpr.debug("Test");
        int minPos = 20175;
        int maxPos = 35549;
        SnpSiftCmdFilter snpsiftFilter = new SnpSiftCmdFilter();
        String expression = "(POS >= " + minPos + ") & (POS <= " + maxPos + ")";
        List<VcfEntry> list2 = snpsiftFilter.filter("test/test01.vcf", expression, true);
        if (verbose) {
            System.out.println("Expression: '" + expression + "'");
        }
        Assert.assertNotNull(list2);
        Assert.assertTrue(list2.size() > 0);
        for (VcfEntry vcfEntry : list2) {
            if (verbose) {
                System.out.println("\t" + vcfEntry);
            }
            Assert.assertTrue(vcfEntry.getStart() >= minPos - 1);
            Assert.assertTrue(vcfEntry.getStart() <= maxPos - 1);
        }
    }

    public void test_08() {
        Gpr.debug("Test");
        int minPos = 20175;
        int maxPos = 35549;
        SnpSiftCmdFilter snpsiftFilter = new SnpSiftCmdFilter();
        String expression = "(POS >= " + minPos + ") | (POS <= " + maxPos + ")";
        List<VcfEntry> list2 = snpsiftFilter.filter("test/test01.vcf", expression, true);
        if (verbose) {
            System.out.println("Expression: '" + expression + "'");
        }
        Assert.assertNotNull(list2);
        Assert.assertTrue(list2.size() > 0);
        for (VcfEntry vcfEntry : list2) {
            if (verbose) {
                System.out.println("\t" + vcfEntry);
            }
            Assert.assertTrue(vcfEntry.getStart() >= minPos - 1 || vcfEntry.getStart() <= maxPos - 1);
        }
    }

    public void test_09() {
        Gpr.debug("Test");
        SnpSiftCmdFilter snpsiftFilter = new SnpSiftCmdFilter();
        String expression = "( CHROM =~ 'NT_' )";
        List<VcfEntry> list2 = snpsiftFilter.filter("test/test01.vcf", expression, true);
        if (verbose) {
            System.out.println("Expression: '" + expression + "'");
        }
        Assert.assertNotNull(list2);
        Assert.assertTrue(list2.size() > 0);
        for (VcfEntry vcfEntry : list2) {
            if (verbose) {
                System.out.println("\t" + vcfEntry);
            }
            Assert.assertTrue(vcfEntry.getChromosomeName().startsWith("NT_"));
        }
    }

    public void test_10() {
        Gpr.debug("Test");
        SnpSiftCmdFilter snpsiftFilter = new SnpSiftCmdFilter();
        String expression = "( REF = 'C' ) & ( ALT = 'T') ";
        List<VcfEntry> list2 = snpsiftFilter.filter("test/test01.vcf", expression, true);
        if (verbose) {
            System.out.println("Expression: '" + expression + "'");
        }
        Assert.assertNotNull(list2);
        Assert.assertTrue(list2.size() > 0);
        for (VcfEntry vcfEntry : list2) {
            if (verbose) {
                System.out.println("\t" + vcfEntry);
            }
            Assert.assertTrue(vcfEntry.getRef().equals("C"));
            Assert.assertTrue(vcfEntry.getAltsStr().equals("T"));
        }
    }

    public void test_11() {
        Gpr.debug("Test");
        SnpSiftCmdFilter snpsiftFilter = new SnpSiftCmdFilter();
        String expression = "( DP >= 5 ) ";
        List<VcfEntry> list2 = snpsiftFilter.filter("test/test01.vcf", expression, true);
        if (verbose) {
            System.out.println("Expression: '" + expression + "'");
        }
        Assert.assertNotNull(list2);
        Assert.assertTrue(list2.size() > 0);
        for (VcfEntry vcfEntry : list2) {
            if (verbose) {
                System.out.println("\t" + vcfEntry);
            }
            Assert.assertTrue(Gpr.parseIntSafe(vcfEntry.getInfo("DP")) >= 5);
        }
    }

    public void test_12() {
        Gpr.debug("Test");
        SnpSiftCmdFilter snpsiftFilter = new SnpSiftCmdFilter();
        String expression = "( exists INDEL ) ";
        snpsiftFilter.setVerbose(verbose);
        List<VcfEntry> list2 = snpsiftFilter.filter("test/test01.vcf", expression, true);
        if (verbose) {
            System.out.println("Expression: '" + expression + "'");
        }
        Assert.assertNotNull(list2);
        Assert.assertEquals(182, list2.size());
        for (VcfEntry vcfEntry : list2) {
            if (verbose) {
                System.out.println("\t" + vcfEntry);
            }
            Assert.assertNotNull(vcfEntry.getInfo("INDEL"));
        }
    }

    public void test_13() {
        Gpr.debug("Test");
        SnpSiftCmdFilter snpsiftFilter = new SnpSiftCmdFilter();
        String expression = "( exists INDEL ) ";
        List<VcfEntry> list2 = snpsiftFilter.filter("test/test01.vcf", expression, true);
        if (verbose) {
            System.out.println("Expression: '" + expression + "'");
        }
        Assert.assertNotNull(list2);
        Assert.assertTrue(list2.size() > 0);
        for (VcfEntry vcfEntry : list2) {
            if (verbose) {
                System.out.println("\t" + vcfEntry);
            }
            Assert.assertNotNull(vcfEntry.getInfo("INDEL"));
        }
    }

    public void test_14() {
        Gpr.debug("Test");
        SnpSiftCmdFilter snpsiftFilter = new SnpSiftCmdFilter();
        String expression = "( GEN[0].PL[1] > 100 ) ";
        List<VcfEntry> list2 = snpsiftFilter.filter("test/test01.vcf", expression, true);
        if (verbose) {
            System.out.println("Expression: '" + expression + "'");
        }
        Assert.assertNotNull(list2);
        Assert.assertTrue(list2.size() > 0);
        int count2 = 0;
        for (VcfEntry vcfEntry : list2) {
            VcfGenotype vcfGenotype;
            String pl;
            String plSub;
            int plSubInt;
            if (verbose) {
                System.out.println("\t" + vcfEntry);
            }
            Assert.assertTrue((plSubInt = Gpr.parseIntSafe(plSub = (pl = (vcfGenotype = vcfEntry.getVcfGenotype(0)).get("PL")).split(",")[1])) > 10);
            ++count2;
        }
        Assert.assertTrue(count2 == 24);
    }

    public void test_15() {
        Gpr.debug("Test");
        SnpSiftCmdFilter snpsiftFilter = new SnpSiftCmdFilter();
        String expression = "( GEN[0].GT = '1/1' ) ";
        List<VcfEntry> list2 = snpsiftFilter.filter("test/test01.vcf", expression, true);
        if (verbose) {
            System.out.println("Expression: '" + expression + "'");
        }
        Assert.assertNotNull(list2);
        Assert.assertTrue(list2.size() > 0);
        for (VcfEntry vcfEntry : list2) {
            if (verbose) {
                System.out.println("\t" + vcfEntry);
            }
            VcfGenotype vcfGenotype = vcfEntry.getVcfGenotype(0);
            String gt = vcfGenotype.get("GT");
            Assert.assertEquals("1/1", gt);
        }
    }

    public void test_16() {
        Gpr.debug("Test");
        SnpSiftCmdFilter snpsiftFilter = new SnpSiftCmdFilter();
        String expression = "( isHom ( GEN[0] ) ) ";
        List<VcfEntry> list2 = snpsiftFilter.filter("test/test02.vcf", expression, true);
        if (verbose) {
            System.out.println("Expression: '" + expression + "'");
        }
        Assert.assertNotNull(list2);
        Assert.assertTrue(list2.size() > 0);
        int count2 = 0;
        for (VcfEntry vcfEntry : list2) {
            if (verbose) {
                System.out.println("\t" + vcfEntry);
            }
            VcfGenotype vcfGenotype = vcfEntry.getVcfGenotype(0);
            Assert.assertTrue(vcfGenotype.isHomozygous());
            ++count2;
        }
        Assert.assertEquals(821, count2);
    }

    public void test_17() {
        Gpr.debug("Test");
        SnpSiftCmdFilter snpsiftFilter = new SnpSiftCmdFilter();
        String expression = "( isHet ( GEN[0] ) ) ";
        List<VcfEntry> list2 = snpsiftFilter.filter("test/test02.vcf", expression, true);
        if (verbose) {
            System.out.println("Expression: '" + expression + "'");
        }
        Assert.assertNotNull(list2);
        Assert.assertTrue(list2.size() > 0);
        for (VcfEntry vcfEntry : list2) {
            if (verbose) {
                System.out.println("\t" + vcfEntry);
            }
            VcfGenotype vcfGenotype = vcfEntry.getVcfGenotype(0);
            Assert.assertTrue(vcfGenotype.isHeterozygous());
        }
    }

    public void test_18() {
        Gpr.debug("Test");
        SnpSiftCmdFilter snpsiftFilter = new SnpSiftCmdFilter();
        String expression = "( isRef ( GEN[0] ) ) ";
        List<VcfEntry> list2 = snpsiftFilter.filter("test/test02.vcf", expression, true);
        if (verbose) {
            System.out.println("Expression: '" + expression + "'");
        }
        Assert.assertNotNull(list2);
        Assert.assertTrue(list2.size() > 0);
        for (VcfEntry vcfEntry : list2) {
            VcfGenotype vcfGenotype;
            if (verbose) {
                System.out.println("\t" + vcfEntry);
            }
            Assert.assertTrue(!(vcfGenotype = vcfEntry.getVcfGenotype(0)).isVariant());
        }
    }

    public void test_19() {
        Gpr.debug("Test");
        SnpSiftCmdFilter snpsiftFilter = new SnpSiftCmdFilter();
        String expression = "( isVariant ( GEN[0] ) ) ";
        List<VcfEntry> list2 = snpsiftFilter.filter("test/test02.vcf", expression, true);
        if (verbose) {
            System.out.println("Expression: '" + expression + "'");
        }
        Assert.assertNotNull(list2);
        Assert.assertTrue(list2.size() > 0);
        for (VcfEntry vcfEntry : list2) {
            if (verbose) {
                System.out.println("\t" + vcfEntry);
            }
            VcfGenotype vcfGenotype = vcfEntry.getVcfGenotype(0);
            Assert.assertTrue(vcfGenotype.isVariant());
        }
    }

    public void test_20() {
        Gpr.debug("Test");
        SnpSiftCmdFilter snpsiftFilter = new SnpSiftCmdFilter();
        String expression = "isVariant ( GEN[0] ) & isHom( GEN[0] ) ";
        List<VcfEntry> list2 = snpsiftFilter.filter("test/test02.vcf", expression, true);
        if (verbose) {
            System.out.println("Expression: '" + expression + "'");
        }
        Assert.assertNotNull(list2);
        Assert.assertTrue(list2.size() > 0);
        for (VcfEntry vcfEntry : list2) {
            if (verbose) {
                System.out.println("\t" + vcfEntry);
            }
            VcfGenotype vcfGenotype = vcfEntry.getVcfGenotype(0);
            String gt = vcfGenotype.get("GT");
            Assert.assertEquals("1|1", gt);
        }
    }

    public void test_21() {
        Gpr.debug("Test");
        SnpSiftCmdFilter snpsiftFilter = new SnpSiftCmdFilter();
        String expression = "isVariant ( GEN[1] ) & isHom( GEN[1] ) & isRef( GEN[2] )";
        List<VcfEntry> list2 = snpsiftFilter.filter("test/test02.vcf", expression, true);
        if (verbose) {
            System.out.println("Expression: '" + expression + "'");
        }
        Assert.assertNotNull(list2);
        Assert.assertTrue(list2.size() > 0);
        for (VcfEntry vcfEntry : list2) {
            if (verbose) {
                System.out.println("\t" + vcfEntry);
            }
            String gt = vcfEntry.getVcfGenotype(1).get("GT");
            Assert.assertEquals("1|1", gt);
            gt = vcfEntry.getVcfGenotype(2).get("GT");
            Assert.assertEquals("0|0", gt);
        }
    }

    public void test_22() {
        Gpr.debug("Test");
        SnpSiftCmdFilter snpsiftFilter = new SnpSiftCmdFilter();
        snpsiftFilter.addSet("test/set_rs_test01.txt");
        snpsiftFilter.addSet("test/set_rs_test02.txt");
        String expression = "ID in SET[1]";
        List<VcfEntry> list2 = snpsiftFilter.filter("test/test02.vcf", expression, true);
        if (verbose) {
            System.out.println("Expression: '" + expression + "'");
        }
        Assert.assertNotNull(list2);
        for (VcfEntry vcfEntry : list2) {
            String id;
            if (verbose) {
                System.out.println("\t" + vcfEntry);
            }
            Assert.assertTrue((id = vcfEntry.getId()).equals("rs58108140") || id.equals("rs71262674") || id.equals("rs71262673"));
        }
        Assert.assertEquals(3, list2.size());
    }

    public void test_22_3() {
        Gpr.debug("Test");
        SnpSiftCmdFilter snpsiftFilter = new SnpSiftCmdFilter();
        snpsiftFilter.addSet("test/set_rs_test01.txt");
        snpsiftFilter.addSet("test/set_rs_test02.txt");
        snpsiftFilter.addSet("test/set_rs_test03.txt");
        String expression = "ID in SET[2]";
        List<VcfEntry> list2 = snpsiftFilter.filter("test/test02.vcf", expression, true);
        if (verbose) {
            System.out.println("Expression: '" + expression + "'");
        }
        Assert.assertNotNull(list2);
        for (VcfEntry vcfEntry : list2) {
            if (!verbose) continue;
            System.out.println("\t" + vcfEntry);
        }
        Assert.assertEquals(67, list2.size());
    }

    public void test_23() {
        Gpr.debug("Test");
        SnpSiftCmdFilter snpsiftFilter = new SnpSiftCmdFilter();
        String expression = "GEN[*].GT = '1|1'";
        List<VcfEntry> list2 = snpsiftFilter.filter("test/test02.vcf", expression, true);
        if (verbose) {
            System.out.println("Expression: '" + expression + "'");
        }
        for (VcfEntry vcfEntry : list2) {
            if (verbose) {
                System.out.println("\t" + vcfEntry);
            }
            boolean any = false;
            for (VcfGenotype gen : vcfEntry) {
                any |= gen.getGenotype()[0] == 1 && gen.getGenotype()[1] == 1;
            }
            Assert.assertEquals(true, any);
        }
        Assert.assertEquals(147, list2.size());
    }

    public void test_24() {
        Gpr.debug("Test");
        SnpSiftCmdFilter snpsiftFilter = new SnpSiftCmdFilter();
        String expression = "GEN[0].AP[*] > 0.8";
        List<VcfEntry> list2 = snpsiftFilter.filter("test/test02.vcf", expression, true);
        if (verbose) {
            System.out.println("Expression: '" + expression + "'");
        }
        for (VcfEntry vcfEntry : list2) {
            if (verbose) {
                System.out.println("\t" + vcfEntry);
            }
            boolean any = false;
            String ap = vcfEntry.getVcfGenotypes().get(0).get("AP");
            for (String a : ap.split(",")) {
                any |= Gpr.parseDoubleSafe(a) > 0.8;
            }
            Assert.assertEquals(true, any);
        }
    }

    public void test_25() {
        Gpr.debug("Test");
        SnpSiftCmdFilter snpsiftFilter = new SnpSiftCmdFilter();
        String expression = "GEN[*].AP[*] > 0.95";
        List<VcfEntry> list2 = snpsiftFilter.filter("test/test02.vcf", expression, true);
        if (verbose) {
            System.out.println("Expression: '" + expression + "'");
        }
        for (VcfEntry vcfEntry : list2) {
            if (verbose) {
                System.out.println("\t" + vcfEntry);
            }
            boolean any = false;
            for (VcfGenotype gen : vcfEntry) {
                String ap = gen.get("AP");
                for (String a : ap.split(",")) {
                    any |= Gpr.parseDoubleSafe(a) > 0.95;
                }
            }
            Assert.assertEquals(true, any);
        }
    }

    public void test_26() {
        Gpr.debug("Test");
        SnpSiftCmdFilter snpsiftFilter = new SnpSiftCmdFilter();
        String expression = "EFF[0].EFFECT = 'SYNONYMOUS_CODING'";
        List<VcfEntry> list2 = snpsiftFilter.filter("test/test03.vcf", expression, true);
        if (verbose) {
            System.out.println("Expression: '" + expression + "'");
        }
        for (VcfEntry vcfEntry : list2) {
            if (verbose) {
                System.out.println("\t" + vcfEntry);
            }
            String eff = vcfEntry.getInfo("EFF").split("\\(")[0];
            Assert.assertEquals(eff, "SYNONYMOUS_CODING");
        }
        Assert.assertEquals(2, list2.size());
    }

    public void test_26_ann() {
        Gpr.debug("Test");
        SnpSiftCmdFilter snpsiftFilter = new SnpSiftCmdFilter();
        String expression = "ANN[0].EFFECT = 'synonymous_variant'";
        List<VcfEntry> list2 = snpsiftFilter.filter("test/test03.ann.vcf", expression, true);
        int count2 = 0;
        if (verbose) {
            System.out.println("Expression: '" + expression + "'");
        }
        for (VcfEntry vcfEntry : list2) {
            if (verbose) {
                System.out.println("\t" + vcfEntry);
            }
            String eff = vcfEntry.getInfo("ANN").split("\\|")[1];
            Assert.assertEquals("synonymous_variant", eff);
            ++count2;
        }
        Assert.assertEquals(3, count2);
    }

    public void test_27() {
        Gpr.debug("Test");
        SnpSiftCmdFilter snpsiftFilter = new SnpSiftCmdFilter();
        String expression = "EFF[*].EFFECT = 'SYNONYMOUS_CODING'";
        List<VcfEntry> list2 = snpsiftFilter.filter("test/test03.vcf", expression, true);
        if (verbose) {
            System.out.println("Expression: '" + expression + "'");
        }
        for (VcfEntry vcfEntry : list2) {
            if (verbose) {
                System.out.println("\t" + vcfEntry);
            }
            boolean any = false;
            String effStr = vcfEntry.getInfo("EFF");
            for (String eff : effStr.split(",")) {
                String e = eff.split("\\(")[0];
                any |= e.equals("SYNONYMOUS_CODING");
            }
            Assert.assertEquals(true, any);
        }
        Assert.assertEquals(4, list2.size());
    }

    public void test_27_ann() {
        Gpr.debug("Test");
        SnpSiftCmdFilter snpsiftFilter = new SnpSiftCmdFilter();
        String expression = "ANN[*].EFFECT = 'synonymous_variant'";
        List<VcfEntry> list2 = snpsiftFilter.filter("test/test03.ann.vcf", expression, true);
        if (verbose) {
            System.out.println("Expression: '" + expression + "'");
        }
        int count2 = 0;
        for (VcfEntry vcfEntry : list2) {
            if (verbose) {
                System.out.println("\t" + vcfEntry);
            }
            String effStr = vcfEntry.getInfo("ANN");
            boolean any = false;
            for (String eff : effStr.split(",")) {
                String e = eff.split("\\|")[1];
                if (!e.equals("synonymous_variant")) continue;
                ++count2;
                any = true;
            }
            Assert.assertEquals(true, any);
        }
        Assert.assertEquals(3, count2);
    }

    public void test_27_ann2() {
        Gpr.debug("Test");
        SnpSiftCmdFilter snpsiftFilter = new SnpSiftCmdFilter();
        String expression = "ANN[*].EFFECT = 'missense_variant'";
        List<VcfEntry> list2 = snpsiftFilter.filter("test/test03.ann.vcf", expression, true);
        if (verbose) {
            System.out.println("Expression: '" + expression + "'");
        }
        int count2 = 0;
        for (VcfEntry vcfEntry : list2) {
            if (verbose) {
                System.out.println("\t" + vcfEntry);
            }
            String effStr = vcfEntry.getInfo("ANN");
            boolean any = false;
            for (String eff : effStr.split(",")) {
                String e = eff.split("\\|")[1];
                if (!e.equals("missense_variant")) continue;
                ++count2;
                any = true;
            }
            Assert.assertEquals(true, any);
        }
        Assert.assertEquals(6, count2);
    }

    public void test_28() {
        Gpr.debug("Test");
        SnpSiftCmdFilter snpsiftFilter = new SnpSiftCmdFilter();
        String expression = "( countHom() = 3 ) ";
        List<VcfEntry> list2 = snpsiftFilter.filter("test/test02.vcf", expression, true);
        if (verbose) {
            System.out.println("Expression: '" + expression + "'");
        }
        Assert.assertNotNull(list2);
        for (VcfEntry vcfEntry : list2) {
            if (verbose) {
                System.out.println("\t" + vcfEntry);
            }
            int count2 = 0;
            for (VcfGenotype gen : vcfEntry) {
                if (!gen.isHomozygous()) continue;
                ++count2;
            }
            Assert.assertTrue(count2 == 3);
        }
        Assert.assertEquals(105, list2.size());
    }

    public void test_29() {
        Gpr.debug("Test");
        SnpSiftCmdFilter snpsiftFilter = new SnpSiftCmdFilter();
        String expression = "( countHet() = 3 ) ";
        List<VcfEntry> list2 = snpsiftFilter.filter("test/test02.vcf", expression, true);
        if (verbose) {
            System.out.println("Expression: '" + expression + "'");
        }
        Assert.assertNotNull(list2);
        Assert.assertTrue(list2.size() > 0);
        for (VcfEntry vcfEntry : list2) {
            if (verbose) {
                System.out.println("\t" + vcfEntry);
            }
            int count2 = 0;
            for (VcfGenotype gen : vcfEntry) {
                if (!gen.isHeterozygous()) continue;
                ++count2;
            }
            Assert.assertTrue(count2 == 3);
        }
    }

    public void test_30() {
        Gpr.debug("Test");
        SnpSiftCmdFilter snpsiftFilter = new SnpSiftCmdFilter();
        String expression = "( countRef() = 3 ) ";
        List<VcfEntry> list2 = snpsiftFilter.filter("test/test02.vcf", expression, true);
        if (verbose) {
            System.out.println("Expression: '" + expression + "'");
        }
        Assert.assertNotNull(list2);
        Assert.assertTrue(list2.size() > 0);
        for (VcfEntry vcfEntry : list2) {
            if (verbose) {
                System.out.println("\t" + vcfEntry);
            }
            int count2 = 0;
            for (VcfGenotype gen : vcfEntry) {
                if (gen.isVariant()) continue;
                ++count2;
            }
            Assert.assertEquals(3, count2);
        }
        Assert.assertEquals(84, list2.size());
    }

    public void test_31() {
        Gpr.debug("Test");
        SnpSiftCmdFilter snpsiftFilter = new SnpSiftCmdFilter();
        String expression = "( countVariant() = 3 ) ";
        List<VcfEntry> list2 = snpsiftFilter.filter("test/test02.vcf", expression, true);
        if (verbose) {
            System.out.println("Expression: '" + expression + "'");
        }
        Assert.assertNotNull(list2);
        Assert.assertTrue(list2.size() > 0);
        for (VcfEntry vcfEntry : list2) {
            if (verbose) {
                System.out.println("\t" + vcfEntry);
            }
            int count2 = 0;
            for (VcfGenotype gen : vcfEntry) {
                if (!gen.isVariant()) continue;
                ++count2;
            }
            Assert.assertTrue(count2 == 3);
        }
    }

    public void test_32() {
        Gpr.debug("Test");
        SnpSiftCmdFilter snpsiftFilter = new SnpSiftCmdFilter();
        String expression = "EFF[*].CODING = 'CODING'";
        List<VcfEntry> list2 = snpsiftFilter.filter("test/test03.vcf", expression, true);
        if (verbose) {
            System.out.println("Expression: '" + expression + "'");
        }
        for (VcfEntry vcfEntry : list2) {
            if (verbose) {
                System.out.println("\t" + vcfEntry);
            }
            boolean any = false;
            String effStr = vcfEntry.getInfo("EFF");
            for (String eff : effStr.split(",")) {
                String e = eff.split("\\|")[6];
                any |= e.equals("CODING");
            }
            Assert.assertEquals(true, any);
        }
    }

    public void test_32_ann() {
        Gpr.debug("Test");
        SnpSiftCmdFilter snpsiftFilter = new SnpSiftCmdFilter();
        String expression = "ANN[*].BIOTYPE = 'protein_coding'";
        List<VcfEntry> list2 = snpsiftFilter.filter("test/test03.ann.vcf", expression, true);
        if (verbose) {
            System.out.println("Expression: '" + expression + "'");
        }
        int count2 = 0;
        for (VcfEntry vcfEntry : list2) {
            if (verbose) {
                System.out.println("\t" + vcfEntry);
            }
            boolean any = false;
            String effStr = vcfEntry.getInfo("ANN");
            for (String eff : effStr.split(",")) {
                String e = eff.split("\\|", -1)[7];
                if (!e.equals("protein_coding")) continue;
                ++count2;
                any = true;
            }
            Assert.assertEquals(true, any);
        }
        Assert.assertEquals(113, count2);
    }

    public void test_33() {
        Gpr.debug("Test");
        SnpSiftCmdFilter snpsiftFilter = new SnpSiftCmdFilter();
        String expression = "EFF[*].CODING = 'NON_CODING'";
        List<VcfEntry> list2 = snpsiftFilter.filter("test/test03.vcf", expression, true);
        if (verbose) {
            System.out.println("Expression: '" + expression + "'");
        }
        for (VcfEntry vcfEntry : list2) {
            if (verbose) {
                System.out.println("\t" + vcfEntry);
            }
            boolean any = false;
            String effStr = vcfEntry.getInfo("EFF");
            for (String eff : effStr.split(",")) {
                String e = eff.split("\\|")[6];
                any |= e.equals("NON_CODING");
            }
            Assert.assertEquals(true, any);
        }
    }

    public void test_33_ann() {
        Gpr.debug("Test");
        SnpSiftCmdFilter snpsiftFilter = new SnpSiftCmdFilter();
        String expression = "ANN[*].BIOTYPE = 'lincRNA'";
        List<VcfEntry> list2 = snpsiftFilter.filter("test/test03.ann.vcf", expression, true);
        if (verbose) {
            System.out.println("Expression: '" + expression + "'");
        }
        int count2 = 0;
        for (VcfEntry vcfEntry : list2) {
            if (verbose) {
                System.out.println("\t" + vcfEntry);
            }
            boolean any = false;
            String effStr = vcfEntry.getInfo("ANN");
            for (String eff : effStr.split(",")) {
                String e = eff.split("\\|", -1)[7];
                any |= e.equals("lincRNA");
            }
            if (any) {
                ++count2;
            }
            Assert.assertEquals(true, any);
        }
        Assert.assertEquals(727, count2);
    }

    public void test_34() {
        Gpr.debug("Test");
        SnpSiftCmdFilter snpsiftFilter = new SnpSiftCmdFilter();
        String expression = "(EFF[ALL].EFFECT = 'DOWNSTREAM')";
        List<VcfEntry> list2 = snpsiftFilter.filter("test/downstream.vcf", expression, true);
        if (verbose) {
            System.out.println("Expression: '" + expression + "'");
        }
        for (VcfEntry vcfEntry : list2) {
            boolean all = true;
            String effStr = vcfEntry.getInfo("EFF");
            for (String eff : effStr.split(",")) {
                String e = eff.split("\\(")[0];
                all &= e.equals("DOWNSTREAM");
            }
            if (!all) {
                Gpr.debug("Error: " + effStr);
            }
            Assert.assertEquals(true, all);
        }
    }

    public void test_34_ann() {
        Gpr.debug("Test");
        SnpSiftCmdFilter snpsiftFilter = new SnpSiftCmdFilter();
        String expression = "(ANN[ALL].EFFECT = 'downstream_gene_variant')";
        List<VcfEntry> list2 = snpsiftFilter.filter("test/downstream.ann.vcf", expression, true);
        if (verbose) {
            System.out.println("Expression: '" + expression + "'");
        }
        int count2 = 0;
        for (VcfEntry vcfEntry : list2) {
            if (verbose) {
                System.out.println("\t" + vcfEntry);
            }
            boolean all = true;
            String effStr = vcfEntry.getInfo("ANN");
            for (String eff : effStr.split(",")) {
                String e = eff.split("\\|")[1];
                all &= e.equals("downstream_gene_variant");
            }
            if (!all) {
                Gpr.debug("Error: " + effStr);
            }
            if (all) {
                ++count2;
            }
            Assert.assertEquals(true, all);
        }
        Assert.assertEquals(2, count2);
    }

    public void test_35() {
        Gpr.debug("Test");
        SnpSiftCmdFilter snpsiftFilter = new SnpSiftCmdFilter();
        String expression = "EFF[*].GENE = 'BICD1'";
        List<VcfEntry> list2 = snpsiftFilter.filter("test/test_gene.vcf", expression, true);
        if (verbose) {
            System.out.println("Expression: '" + expression + "'");
        }
        for (VcfEntry vcfEntry : list2) {
            if (verbose) {
                System.out.println("\t" + vcfEntry);
            }
            boolean any = false;
            for (VcfEffect eff : vcfEntry.getVcfEffects(null)) {
                Assert.assertEquals("BICD1", eff.getGeneName());
                any = true;
            }
            Assert.assertEquals(true, any);
        }
    }

    public void test_35_ann() {
        Gpr.debug("Test");
        SnpSiftCmdFilter snpsiftFilter = new SnpSiftCmdFilter();
        String expression = "ANN[*].GENE = 'BICD1'";
        List<VcfEntry> list2 = snpsiftFilter.filter("test/test_gene.ann.vcf", expression, true);
        if (verbose) {
            System.out.println("Expression: '" + expression + "'");
        }
        int count2 = 0;
        for (VcfEntry vcfEntry : list2) {
            if (verbose) {
                System.out.println("\t" + vcfEntry);
            }
            boolean any = false;
            for (VcfEffect eff : vcfEntry.getVcfEffects(null)) {
                Assert.assertEquals("BICD1", eff.getGeneName());
                any = true;
            }
            if (any) {
                ++count2;
            }
            Assert.assertEquals(true, any);
        }
        Assert.assertEquals(1, count2);
    }

    public void test_36() {
        Gpr.debug("Test");
        double minQ = 50.0;
        String expression = "QUAL >= " + minQ;
        String[] args = new String[]{"filter", "-f", "test/test01.vcf", "-n", expression};
        List<VcfEntry> list2 = this.snpSiftFilter(args);
        if (verbose) {
            System.out.println("Expression: '" + expression + "'");
        }
        Assert.assertNotNull(list2);
        Assert.assertTrue(list2.size() > 0);
        for (VcfEntry vcfEntry : list2) {
            if (verbose) {
                System.out.println("\t" + vcfEntry);
            }
            Assert.assertTrue(vcfEntry.getQuality() < minQ);
        }
    }

    public void test_37() {
        Gpr.debug("Test");
        double minQ = 50.0;
        String expression = "QUAL >= " + minQ;
        String[] args = new String[]{"filter", "-f", "test/test01.vcf", "-p", expression};
        List<VcfEntry> list2 = this.snpSiftFilter(args);
        if (verbose) {
            System.out.println("Expression: '" + expression + "'");
        }
        Assert.assertNotNull(list2);
        Assert.assertTrue(list2.size() > 0);
        for (VcfEntry vcfEntry : list2) {
            if (verbose) {
                System.out.println(vcfEntry.getFilter() + "\t" + vcfEntry);
            }
            if (vcfEntry.getFilter().equals("PASS")) {
                Assert.assertTrue(vcfEntry.getQuality() >= minQ);
                continue;
            }
            Assert.assertTrue(vcfEntry.getQuality() < minQ);
        }
    }

    public void test_38() {
        Gpr.debug("Test");
        double minQ = 50.0;
        String expression = "QUAL >= " + minQ;
        String[] args = new String[]{"filter", "-f", "test/test01.vcf", "-a", "ADD", expression};
        List<VcfEntry> list2 = this.snpSiftFilter(args);
        if (verbose) {
            System.out.println("Expression: '" + expression + "'");
        }
        Assert.assertNotNull(list2);
        Assert.assertTrue(list2.size() > 0);
        for (VcfEntry vcfEntry : list2) {
            if (verbose) {
                System.out.println(vcfEntry.getFilter() + "\t" + vcfEntry);
            }
            if (vcfEntry.getFilter().equals("ADD")) {
                Assert.assertTrue(vcfEntry.getQuality() >= minQ);
                continue;
            }
            Assert.assertTrue(vcfEntry.getQuality() < minQ);
        }
    }

    public void test_39() {
        Gpr.debug("Test");
        String expression = "REF = 'A'";
        String vcfFile = "test/downstream.vcf";
        String[] args = new String[]{"filter", "-f", vcfFile, "-r", "SVM", expression};
        List<VcfEntry> list2 = this.snpSiftFilter(args);
        if (verbose) {
            System.out.println("Expression: '" + expression + "'");
        }
        Assert.assertNotNull(list2);
        Assert.assertTrue(list2.size() > 0);
        for (VcfEntry vcfEntry : list2) {
            if (verbose) {
                System.out.println(vcfEntry.getFilter() + "\t" + vcfEntry);
            }
            if (!vcfEntry.getFilter().equals("SVM")) continue;
            Assert.assertTrue(!vcfEntry.getRef().equals("A"));
        }
    }

    public void test_40() {
        Gpr.debug("Test");
        String expression = "( EFF[*].EFFECT = 'SPLICE_SITE_ACCEPTOR' )";
        String vcfFile = "test/test_jim.vcf";
        String[] args = new String[]{"filter", "-f", vcfFile, "-n", expression};
        List<VcfEntry> list2 = this.snpSiftFilter(args);
        if (verbose) {
            System.out.println("Expression: '" + expression + "'");
        }
        Assert.assertNotNull(list2);
        Assert.assertTrue(list2.size() == 1);
        VcfEntry vcfEntry = list2.get(0);
        if (verbose) {
            System.out.println(vcfEntry.getFilter() + "\t" + vcfEntry);
        }
        Assert.assertEquals(219134272, vcfEntry.getStart());
    }

    public void test_41() {
        Gpr.debug("Test");
        String expression = "( DP < 5 )";
        String vcfFile = "test/test_rmfilter.vcf";
        String[] args = new String[]{"filter", "-f", vcfFile, "--rmFilter", "DP_OK", expression};
        List<VcfEntry> list2 = this.snpSiftFilter(args);
        if (verbose) {
            System.out.println("Expression: '" + expression + "'");
        }
        Assert.assertNotNull(list2);
        Assert.assertTrue(list2.size() == 3);
        int countOk = 0;
        for (VcfEntry vcfEntry : list2) {
            if (verbose) {
                System.out.println(vcfEntry.getFilter() + "\t" + vcfEntry);
            }
            if (vcfEntry.getStart() == 219134261) {
                Assert.assertEquals("OTHER", vcfEntry.getFilter());
                ++countOk;
            }
            if (vcfEntry.getStart() != 219134272) continue;
            Assert.assertEquals("DP_OK;OTHER", vcfEntry.getFilter());
            ++countOk;
        }
        Assert.assertEquals("Number of entries checkd does not match expected", countOk, 2);
    }

    public void test_42() {
        Gpr.debug("Test");
        SnpSiftCmdFilter snpsiftFilter = new SnpSiftCmdFilter();
        String expression = "( ZZZ = 3 ) ";
        List<VcfEntry> list2 = snpsiftFilter.filter("test/test42.vcf", expression, true);
        if (verbose) {
            System.out.println("Expression: '" + expression + "'");
        }
        Assert.assertNotNull(list2);
        Assert.assertTrue(list2.size() == 0);
    }

    public void test_43() {
        Gpr.debug("Test");
        SnpSiftCmdFilter snpsiftFilter = new SnpSiftCmdFilter();
        String expression = "( ZZZ < 0 ) ";
        List<VcfEntry> list2 = snpsiftFilter.filter("test/test42.vcf", expression, true);
        if (verbose) {
            System.out.println("Expression: '" + expression + "'");
        }
        Assert.assertNotNull(list2);
        Assert.assertEquals(0, list2.size());
    }

    public void test_44() {
        Gpr.debug("Test");
        SnpSiftCmdFilter snpsiftFilter = new SnpSiftCmdFilter();
        String expression = "( ZZZ > 0 ) ";
        List<VcfEntry> list2 = snpsiftFilter.filter("test/test42.vcf", expression, true);
        if (verbose) {
            System.out.println("Expression: '" + expression + "'");
        }
        Assert.assertNotNull(list2);
        Assert.assertEquals(0, list2.size());
    }

    public void test_45() {
        Gpr.debug("Test");
        SnpSiftCmdFilter snpSiftFilter = new SnpSiftCmdFilter();
        String expression = "LOF[*].PERC > 0.1";
        List<VcfEntry> list2 = snpSiftFilter.filter("test/test45.vcf", expression, true);
        if (verbose) {
            System.out.println("Expression: '" + expression + "'");
        }
        Assert.assertNotNull(list2);
        int count2 = 0;
        for (VcfEntry ve : list2) {
            if (verbose) {
                System.out.println(ve);
            }
            for (VcfLof lof : ve.parseLof()) {
                if (verbose) {
                    System.out.println("\t" + lof);
                }
                Assert.assertTrue(lof.getPercentAffected() >= 0.1);
                ++count2;
            }
        }
        Assert.assertEquals(2, count2);
    }

    public void test_46() {
        Gpr.debug("Test");
        String fileName = "./test/test46.vcf";
        String[] args = new String[]{"filter", "-f", fileName, "exists dbNSFP_SIFT_pred"};
        List<VcfEntry> ves = this.snpSiftFilter(args);
        Assert.assertEquals(1, ves.size());
    }

    public void test_47() {
        Gpr.debug("Test");
        String fileName = "./test/test46.vcf";
        String[] args = new String[]{"filter", "-f", fileName, "dbNSFP_SIFT_pred != 'D'"};
        List<VcfEntry> ves = this.snpSiftFilter(args);
        Assert.assertEquals(1, ves.size());
        String field2 = ves.get(0).getInfo("dbNSFP_SIFT_pred");
        Assert.assertEquals("T", field2);
    }

    public void test_48() {
        Gpr.debug("Test");
        SnpSiftCmdFilter snpsiftFilter = new SnpSiftCmdFilter();
        String expression = "( ZZZ = NaN ) ";
        List<VcfEntry> list2 = snpsiftFilter.filter("test/test48.vcf", expression, true);
        if (verbose) {
            System.out.println("Expression: '" + expression + "'");
        }
        Assert.assertNotNull(list2);
        Assert.assertTrue(list2.size() == 1);
        Assert.assertEquals(list2.get(0).getInfo("ZZZ"), "NaN");
    }

    public void test_49() {
        Gpr.debug("Test");
        SnpSiftCmdFilter snpsiftFilter = new SnpSiftCmdFilter();
        String expression = "( DP < (AC+4))";
        List<VcfEntry> list2 = snpsiftFilter.filter("test/test49.vcf", expression, true);
        if (verbose) {
            System.out.println("Expression: '" + expression + "'");
        }
        Assert.assertNotNull(list2);
        Assert.assertTrue(list2.size() == 1);
        Assert.assertEquals("4", list2.get(0).getInfo("AC"));
    }

    public void test_50() {
        Gpr.debug("Test");
        String effStr = "NON_SYNONYMOUS_CODING(MODERATE|MISSENSE|Cat/Tat|H52Y|AL669831.1|protein_coding|CODING|ENST00000358533|exon_1_721320_722513)";
        SnpSiftCmdFilter snpsiftFilter = new SnpSiftCmdFilter();
        String expression = "EFF[*] = '" + effStr + "'";
        List<VcfEntry> list2 = snpsiftFilter.filter("test/test03.vcf", expression, true);
        if (verbose) {
            System.out.println("Expression: '" + expression + "'");
        }
        for (VcfEntry vcfEntry : list2) {
            if (verbose) {
                System.out.println("\t" + vcfEntry);
            }
            boolean ok = false;
            if (verbose) {
                System.out.println(vcfEntry);
            }
            for (String eff : vcfEntry.getInfo("EFF").split(",")) {
                ok |= eff.equals(effStr);
                if (!verbose) continue;
                System.out.println("\t" + eff);
            }
            Assert.assertEquals(true, ok);
        }
        Assert.assertEquals(1, list2.size());
    }

    public void test_51() {
        Gpr.debug("Test");
        String lofStr = "(CAMTA1|ENSG00000171735|17|0.29)";
        SnpSiftCmdFilter snpSiftFilter = new SnpSiftCmdFilter();
        String expression = "LOF[*] = '" + lofStr + "'";
        List<VcfEntry> list2 = snpSiftFilter.filter("test/test45.vcf", expression, true);
        if (verbose) {
            System.out.println("Expression: '" + expression + "'");
        }
        Assert.assertNotNull(list2);
        for (VcfEntry ve : list2) {
            if (verbose) {
                System.out.println(ve);
            }
            boolean ok = false;
            for (String lof : ve.getInfo("LOF").split(",")) {
                if (verbose) {
                    System.out.println("\t" + lof);
                }
                ok |= lof.equals(lofStr);
            }
            Assert.assertTrue(ok);
        }
        Assert.assertEquals(1, list2.size());
    }

    public void test_52() {
        Gpr.debug("Test");
        SnpSiftCmdFilter snpsiftFilter = new SnpSiftCmdFilter();
        String expression = "(Cases[0] = 3) & (Controls[0] = 0)";
        List<VcfEntry> list2 = snpsiftFilter.filter("test/test52.vcf", expression, true);
        if (verbose) {
            System.out.println("Expression: '" + expression + "'");
            for (VcfEntry vcfEntry : list2) {
                System.out.println("\t" + vcfEntry);
            }
        }
        Assert.assertEquals(1, list2.size());
    }

    public void test_53() {
        Gpr.debug("Test");
        SnpSiftCmdFilter snpsiftFilter = new SnpSiftCmdFilter();
        String expression = "ANN[*].EFFECT has 'synonymous_variant'";
        List<VcfEntry> list2 = snpsiftFilter.filter("test/test_filter_has.vcf", expression, true);
        if (verbose) {
            System.out.println("Expression: '" + expression + "'");
            for (VcfEntry vcfEntry : list2) {
                if (!verbose) continue;
                System.out.println("VCF entry:\t" + vcfEntry);
            }
        }
        Assert.assertEquals(1, list2.size());
    }

    public void test_54() {
        Gpr.debug("Test");
        SnpSiftCmdFilter snpsiftFilter = new SnpSiftCmdFilter();
        String expression = "ANN[*].IMPACT = 'LOW' | ANN[*].IMPACT = 'MODERATE'";
        List<VcfEntry> list2 = snpsiftFilter.filter("test/test_precedence.vcf", expression, true);
        if (verbose) {
            System.out.println("Expression: '" + expression + "'");
            for (VcfEntry vcfEntry : list2) {
                if (!verbose) continue;
                System.out.println("VCF entry:\t" + vcfEntry);
            }
        }
        Assert.assertEquals(7, list2.size());
    }

    public void test_55() {
        Gpr.debug("Test");
        SnpSiftCmdFilter snpsiftFilter = new SnpSiftCmdFilter();
        String expression = "AC <= 1";
        List<VcfEntry> list2 = snpsiftFilter.filter("test/test55.vcf", expression, true);
        if (verbose) {
            System.out.println("Expression: '" + expression + "'");
        }
        Assert.assertNotNull(list2);
        Assert.assertEquals("Number of results expected does not match", 1, list2.size());
        if (verbose) {
            Gpr.debug("Result: " + list2.get(0));
        }
        Assert.assertEquals("Expected VCF entry does not match (checking POS)", 199, list2.get(0).getStart());
    }

    public void test_55_2() {
        Gpr.debug("Test");
        SnpSiftCmdFilter snpsiftFilter = new SnpSiftCmdFilter();
        String expression = "AC = 1";
        List<VcfEntry> list2 = snpsiftFilter.filter("test/test55.vcf", expression, true);
        if (verbose) {
            System.out.println("Expression: '" + expression + "'");
        }
        Assert.assertNotNull(list2);
        Assert.assertEquals("Number of results expected does not match", 1, list2.size());
        if (verbose) {
            Gpr.debug("Result: " + list2.get(0));
        }
        Assert.assertEquals("Expected VCF entry does not match (checking POS)", 199, list2.get(0).getStart());
    }

    public void test_55_3() {
        Gpr.debug("Test");
        SnpSiftCmdFilter snpsiftFilter = new SnpSiftCmdFilter();
        String expression = "AC == 1";
        List<VcfEntry> list2 = snpsiftFilter.filter("test/test55.vcf", expression, true);
        if (verbose) {
            System.out.println("Expression: '" + expression + "'");
        }
        Assert.assertNotNull(list2);
        Assert.assertEquals("Number of results expected does not match", 1, list2.size());
        if (verbose) {
            Gpr.debug("Result: " + list2.get(0));
        }
        Assert.assertEquals("Expected VCF entry does not match (checking POS)", 199, list2.get(0).getStart());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_56_empty_vcf() {
        Gpr.debug("Test");
        PrintStream oldOut = System.out;
        String standardOutput = "";
        ByteArrayOutputStream output2 = new ByteArrayOutputStream(0xA00000);
        try {
            System.setOut(new PrintStream(output2));
            SnpSiftCmdFilter snpsiftFilter = new SnpSiftCmdFilter();
            String expression = "TYPE = 'SNP'";
            snpsiftFilter.filter("test/empty_with_header.vcf", expression, false);
        }
        catch (Throwable t2) {
            t2.printStackTrace();
        }
        finally {
            standardOutput = output2.toString();
            System.setOut(oldOut);
        }
        if (verbose) {
            System.out.println("STDOUT:\n----------\n" + standardOutput + "\n----------");
        }
        Assert.assertNotNull(standardOutput);
        Assert.assertFalse(standardOutput.isEmpty());
        Assert.assertTrue(standardOutput.contains("#CHROM\tPOS\tID\tREF\tALT"));
    }

    public void test_57_short_circuit_AND_OR_operators() {
        Gpr.debug("Test");
        SnpSiftCmdFilter snpsiftFilter = new SnpSiftCmdFilter();
        String expression = "(GEN[0067_3_D58].DP > 0) && ((GEN[0067_3_D58].AD[0] / GEN[0067_3_D58].DP) > 0.1)";
        List<VcfEntry> list2 = snpsiftFilter.filter("test/test57.vcf", expression, true);
        if (verbose) {
            System.out.println("Expression: '" + expression + "'");
        }
        Assert.assertNotNull(list2);
        Assert.assertTrue(list2.size() > 0);
        for (VcfEntry vcfEntry : list2) {
            if (!verbose) continue;
            System.out.println("\t" + vcfEntry);
        }
        Assert.assertEquals("Filter results doesn't match the number of expected lines", 29, list2.size());
    }

    public void test_58_rmFilter_info_field() {
        Gpr.debug("Test");
        String expression = "( DP < 5 )";
        String vcfFile = "test/test_rmfilter_2.vcf";
        String[] args = new String[]{"filter", "-f", vcfFile, "--rmFilter", "DP_OK", expression};
        List<VcfEntry> list2 = this.snpSiftFilter(args);
        if (verbose) {
            System.out.println("Expression: '" + expression + "'");
        }
        Assert.assertNotNull(list2);
        Assert.assertTrue("List size does not matched expected", list2.size() == 4);
        int countOk = 0;
        for (VcfEntry vcfEntry : list2) {
            if (verbose) {
                System.out.println(vcfEntry.getFilter() + "\t" + vcfEntry);
            }
            if (vcfEntry.getStart() == 219134261) {
                Assert.assertEquals("OTHER", vcfEntry.getFilter());
                Assert.assertEquals("DP_OK", vcfEntry.getInfo("FILTER_DELETED"));
                ++countOk;
            }
            if (vcfEntry.getStart() == 219134272) {
                Assert.assertEquals("DP_OK;OTHER", vcfEntry.getFilter());
                Assert.assertEquals(null, vcfEntry.getInfo("FILTER_DELETED"));
                ++countOk;
            }
            if (vcfEntry.getStart() == 219134298) {
                Assert.assertEquals("OTHER", vcfEntry.getFilter());
                Assert.assertEquals("DELETED_BEFORE,DP_OK", vcfEntry.getInfo("FILTER_DELETED"));
                ++countOk;
            }
            if (vcfEntry.getStart() != 219134349) continue;
            Assert.assertEquals("OTHER", vcfEntry.getFilter());
            Assert.assertEquals("DELETED_BEFORE", vcfEntry.getInfo("FILTER_DELETED"));
            ++countOk;
        }
        Assert.assertEquals("Number of entries checkd does not match expected", countOk, 4);
    }
}

