/*
 * Decompiled with CFR 0.152.
 */
package org.snpsift.lang.expression;

import org.snpeff.vcf.VcfEntry;
import org.snpeff.vcf.VcfGenotype;
import org.snpsift.lang.expression.Expression;
import org.snpsift.lang.expression.FieldGenotype;
import org.snpsift.lang.expression.FieldIterator;

public class FieldGenotypeSub
extends FieldGenotype {
    Expression indexExpr2;

    public FieldGenotypeSub(String name, Expression indexExpr, Expression indexExpr2) {
        super(name, indexExpr);
        this.indexExpr2 = indexExpr2;
    }

    @Override
    public String getFieldString(VcfEntry vcfEntry) {
        int index2;
        VcfGenotype vcfGenotype = this.evalGenotype(vcfEntry);
        String value2 = vcfGenotype.get(this.name);
        if (value2 == null) {
            return (String)this.fieldNotFound(vcfEntry);
        }
        String[] sub = value2.split(",");
        int idx = index2 = this.evalIndex(vcfGenotype, this.indexExpr2);
        if (index2 < 0) {
            FieldIterator.get().setMax(FieldIterator.IteratorType.GENOTYPE_VAR, sub.length - 1);
            FieldIterator.get().setType(index2);
            idx = FieldIterator.get().get(FieldIterator.IteratorType.GENOTYPE_VAR);
        }
        if (sub.length <= idx) {
            return "";
        }
        return sub[idx];
    }

    @Override
    public String getFieldString(VcfGenotype vcfGenotype) {
        int index2;
        String value2 = super.getFieldString(vcfGenotype);
        if (value2 == null) {
            return (String)this.gtFieldNotFound(vcfGenotype);
        }
        String[] sub = value2.split(",");
        int idx = index2 = this.evalIndex(vcfGenotype, this.indexExpr2);
        if (index2 < 0) {
            FieldIterator.get().setMax(FieldIterator.IteratorType.GENOTYPE_VAR, sub.length - 1);
            FieldIterator.get().setType(index2);
            idx = FieldIterator.get().get(FieldIterator.IteratorType.GENOTYPE_VAR);
        }
        if (sub.length <= idx) {
            return "";
        }
        return sub[idx];
    }

    @Override
    protected boolean isSub() {
        return true;
    }

    @Override
    public String toString() {
        return "GEN[" + this.indexExpr + "]." + this.name + "[" + this.indexExpr2 + "]";
    }
}

