/*
 * Decompiled with CFR 0.152.
 */
package org.snpsift;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.snpeff.fileIterator.VcfFileIterator;
import org.snpeff.vcf.VcfEntry;
import org.snpsift.SnpSift;
import org.snpsift.lang.LangFactory;
import org.snpsift.lang.Value;
import org.snpsift.lang.expression.Expression;
import org.snpsift.lang.expression.FieldIterator;

public class SnpSiftCmdExtractFields
extends SnpSift {
    public static final int SHOW = 10000;
    String vcfFile;
    String sameFieldSeparator;
    String emptyFieldString;
    List<String> expressionStrs;
    List<Expression> expressions;

    public SnpSiftCmdExtractFields() {
    }

    public SnpSiftCmdExtractFields(String[] args) {
        super(args);
    }

    String evaluate(Expression expr, VcfEntry vcfEntry) {
        FieldIterator fieldIterator = FieldIterator.get();
        fieldIterator.reset();
        StringBuilder values2 = new StringBuilder();
        while (true) {
            String valStr;
            Value value2 = expr.eval(vcfEntry);
            if (values2.length() > 0) {
                values2.append(this.sameFieldSeparator);
            }
            if ((valStr = value2.asString()) == null || valStr.isEmpty()) {
                values2.append(this.emptyFieldString);
            } else {
                values2.append(value2);
            }
            if (!fieldIterator.hasNext()) break;
            fieldIterator.next();
        }
        return values2.toString();
    }

    @Override
    public void init() {
        super.init();
        this.sameFieldSeparator = "\t";
        this.emptyFieldString = "";
    }

    @Override
    public void parseArgs(String[] args) {
        if (args.length == 0) {
            this.usage(null);
        }
        this.expressionStrs = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (this.isOpt(arg)) {
                if (arg.equals("-s")) {
                    this.sameFieldSeparator = args[++i];
                    continue;
                }
                if (!arg.equals("-e")) continue;
                this.emptyFieldString = args[++i];
                continue;
            }
            if (this.vcfFile == null) {
                this.vcfFile = arg;
                continue;
            }
            this.expressionStrs.add(arg);
        }
        if (this.expressionStrs.isEmpty()) {
            this.usage("Missing field names");
        }
    }

    List<Expression> parseFields(List<String> expressionsStr) {
        ArrayList<Expression> fields = new ArrayList<Expression>();
        for (String exprStr : expressionsStr) {
            Expression field2;
            LangFactory lf = new LangFactory();
            try {
                field2 = lf.compile(exprStr);
            }
            catch (Exception e) {
                throw new RuntimeException("Error parsing expression '" + exprStr + "'", e);
            }
            fields.add(field2);
        }
        return fields;
    }

    @Override
    public boolean run() {
        this.run(false);
        return true;
    }

    public List<String> run(boolean createList) {
        LinkedList<String> list2 = new LinkedList<String>();
        this.expressions = this.parseFields(this.expressionStrs);
        if (!createList) {
            String sep = "";
            for (String fieldName : this.expressionStrs) {
                System.out.print(sep + fieldName);
                sep = "\t";
            }
            System.out.println("");
        }
        VcfFileIterator vcf = new VcfFileIterator(this.vcfFile);
        vcf.setDebug(this.debug);
        for (VcfEntry ve : vcf) {
            StringBuilder out = new StringBuilder();
            for (Expression f2 : this.expressions) {
                String val = this.evaluate(f2, ve);
                out.append(val + "\t");
            }
            out.deleteCharAt(out.length() - 1);
            if (createList) {
                list2.add(out.toString());
                continue;
            }
            System.out.println(out);
        }
        return list2;
    }

    @Override
    public void usage(String msg) {
        if (msg != null) {
            System.err.println("Error: " + msg);
            this.showCmd();
        }
        this.showVersion();
        System.err.println("Usage: java -jar " + SnpSift.class.getSimpleName() + ".jar extractFields [options] file.vcf fieldName1 fieldName2 ... fieldNameN > tabFile.txt\n\nOptions:\n\t-s     : Same field separator. Default: '" + this.sameFieldSeparator + "'\n\t-e     : Empty field. Default: '" + this.emptyFieldString + "'");
        System.exit(1);
    }
}

