/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.util;

import org.snpeff.util.Gpr;

public class Diff {
    boolean ignoreCase;
    boolean ignoreSpaces;
    boolean showOnlyDifferentLines;
    String s1;
    String s2;

    public Diff(String s1, String s2) {
        this.s1 = s1;
        this.s2 = s2;
        this.ignoreCase = false;
        this.ignoreSpaces = true;
        this.showOnlyDifferentLines = true;
    }

    String diff() {
        String[] lines1 = this.lines(this.s1);
        String[] lines2 = this.lines(this.s2);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < Math.max(lines1.length, lines2.length); ++i) {
            String l1 = i < lines1.length ? lines1[i] : "";
            String l2 = i < lines2.length ? lines2[i] : "";
            int lineNum = i + 1;
            if (l1.equals(l2)) {
                if (this.showOnlyDifferentLines) continue;
                sb.append(lineNum + "\tOK   : " + l1 + "\n");
                continue;
            }
            if (!this.showOnlyDifferentLines) {
                sb.append(lineNum + "\tDiff : " + l1 + "\n");
                sb.append(lineNum + "\t     : " + l2 + "\n");
                sb.append(lineNum + "\t     : " + this.diffLine(l1, l2) + "\n");
                continue;
            }
            sb.append(lineNum + "\t: " + l1 + "\n");
            sb.append(lineNum + "\t: " + l2 + "\n");
            sb.append(lineNum + "\t: " + this.diffLine(l1, l2) + "\n\n");
        }
        return sb.toString();
    }

    String diffLine(String s1, String s2) {
        char[] chars1 = s1.toCharArray();
        char[] chars2 = s2.toCharArray();
        int max2 = Math.max(chars1.length, chars2.length);
        char[] d = new char[max2];
        for (int i = 0; i < max2; ++i) {
            char c1 = i < chars1.length ? chars1[i] : (char)'\u0000';
            char c2 = i < chars2.length ? chars2[i] : (char)'\u0000';
            d[i] = c1 == c2 ? 32 : 94;
        }
        return new String(d);
    }

    public boolean equals() {
        String[] lines1 = this.lines(this.s1);
        String[] lines2 = this.lines(this.s2);
        for (int i = 0; i < Math.max(lines1.length, lines2.length); ++i) {
            String l2;
            String l1 = i < lines1.length ? lines1[i] : "";
            String string2 = l2 = i < lines2.length ? lines2[i] : "";
            if (l1.equals(l2)) continue;
            return false;
        }
        return true;
    }

    String[] lines(String str) {
        String[] l = str.split("\n");
        for (int i = 0; i < l.length; ++i) {
            if (this.ignoreCase) {
                l[i] = l[i].toLowerCase();
            }
            if (!this.ignoreSpaces) continue;
            l[i] = Gpr.noSpaces(l[i]);
        }
        return l;
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    public void setIgnoreSpaces(boolean ignoreSpaces) {
        this.ignoreSpaces = ignoreSpaces;
    }

    public void setShowOnlyDifferentLines(boolean showOnlyDifferentLines) {
        this.showOnlyDifferentLines = showOnlyDifferentLines;
    }

    public String toString() {
        return this.diff();
    }
}

