/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.stats;

import org.snpeff.interval.Gene;
import org.snpeff.interval.Transcript;
import org.snpeff.interval.VariantBnd;
import org.snpeff.vcf.VcfEffect;

public class TranslocationReport {
    Transcript tr1;
    Transcript tr2;
    VariantBnd var;
    VcfEffect veff;
    String svgPlot;

    public TranslocationReport(VariantBnd var, VcfEffect veff, Transcript tr1, Transcript tr2) {
        this.tr1 = tr1;
        this.tr2 = tr2;
        this.var = var;
        this.veff = veff;
    }

    public String getChr1() {
        return this.var.getChromosomeName();
    }

    public String getChr2() {
        return this.var.getEndPoint().getChromosomeName();
    }

    public String getGeneName1() {
        return ((Gene)this.tr1.getParent()).getGeneName();
    }

    public String getGeneName2() {
        return ((Gene)this.tr2.getParent()).getGeneName();
    }

    public String getHgvsC() {
        return this.veff.getHgvsC();
    }

    public String getHgvsP() {
        return this.veff.getHgvsP();
    }

    public String getImpact() {
        return this.veff.getImpact().toString();
    }

    public String getIndex() {
        return this.getChr1() + ":" + this.getPos1OneBased() + "-" + this.getChr2() + ":" + this.getPos2OneBased() + " " + this.getTrId1() + "-" + this.getTrId2();
    }

    public int getPos1OneBased() {
        return this.var.getStart() + 1;
    }

    public int getPos2OneBased() {
        return this.var.getEndPoint().getStart() + 1;
    }

    public String getSvgPlot() {
        return this.svgPlot;
    }

    public String getTrId1() {
        return this.tr1.getId();
    }

    public String getTrId2() {
        return this.tr2.getId();
    }

    public String getVariantEffect() {
        return this.veff.getEffString();
    }

    public String getVcfEffect() {
        return this.veff.toString();
    }

    public void setSvgPlot(String svgPlot) {
        this.svgPlot = svgPlot;
    }
}

