/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.snpEffect.testCases.unity;

import junit.framework.Assert;
import org.junit.Test;
import org.snpeff.interval.Marker;
import org.snpeff.interval.Variant;
import org.snpeff.snpEffect.HgvsDna;
import org.snpeff.snpEffect.VariantEffect;
import org.snpeff.snpEffect.VariantEffects;
import org.snpeff.snpEffect.testCases.unity.TestCasesBase;
import org.snpeff.util.Gpr;

public class TestCasesHgvsDnaDup
extends TestCasesBase {
    @Override
    protected void init() {
        super.init();
        this.shiftHgvs = true;
    }

    @Test
    public void test_01() {
        Gpr.debug("Test");
        if (this.verbose) {
            Gpr.debug(this.transcript);
        }
        Variant variant = new Variant((Marker)this.chromosome, 881, "", "T", "");
        if (this.verbose) {
            Gpr.debug("Variant: " + variant);
        }
        VariantEffects effs = this.snpEffectPredictor.variantEffect(variant);
        VariantEffect eff = effs.get();
        HgvsDna hgvsc = new HgvsDna(eff);
        String hgvsDna = hgvsc.toString();
        if (this.verbose) {
            Gpr.debug("HGVS (DNA): '" + hgvsDna + "'");
        }
        Assert.assertEquals("c.1dupT", hgvsDna);
    }

    @Test
    public void test_02() {
        Gpr.debug("Test");
        if (this.verbose) {
            Gpr.debug(this.transcript);
        }
        Variant variant = new Variant((Marker)this.chromosome, 883, "", "A", "");
        if (this.verbose) {
            Gpr.debug("Variant: " + variant);
        }
        VariantEffects effs = this.snpEffectPredictor.variantEffect(variant);
        VariantEffect eff = effs.get();
        HgvsDna hgvsc = new HgvsDna(eff);
        String hgvsDna = hgvsc.toString();
        if (this.verbose) {
            Gpr.debug("HGVS (DNA): '" + hgvsDna + "'");
        }
        Assert.assertEquals("c.3dupA", hgvsDna);
    }

    @Test
    public void test_03() {
        Gpr.debug("Test");
        String prepend = "ACTCTGTGCC";
        this.prependSequenceToFirstExon(prepend);
        if (this.verbose) {
            Gpr.debug(this.transcript);
        }
        Variant variant = new Variant((Marker)this.chromosome, 885, "", "T", "");
        if (this.verbose) {
            Gpr.debug("Variant: " + variant);
        }
        VariantEffects effs = this.snpEffectPredictor.variantEffect(variant);
        VariantEffect eff = effs.get();
        HgvsDna hgvsc = new HgvsDna(eff);
        String hgvsDna = hgvsc.toString();
        if (this.verbose) {
            Gpr.debug("HGVS (DNA): '" + hgvsDna + "'");
        }
        Assert.assertEquals("c.5dupT", hgvsDna);
    }

    @Test
    public void test_04() {
        Gpr.debug("Test");
        String prepend = "AGACTTTGTGCC";
        this.prependSequenceToFirstExon(prepend);
        if (this.verbose) {
            Gpr.debug(this.transcript);
        }
        Variant variant = new Variant((Marker)this.chromosome, 887, "", "T", "");
        if (this.verbose) {
            Gpr.debug("Variant: " + variant);
        }
        VariantEffects effs = this.snpEffectPredictor.variantEffect(variant);
        VariantEffect eff = effs.get();
        HgvsDna hgvsc = new HgvsDna(eff);
        String hgvsDna = hgvsc.toString();
        if (this.verbose) {
            Gpr.debug("HGVS (DNA): '" + hgvsDna + "'");
        }
        Assert.assertEquals("c.7dupT", hgvsDna);
    }

    @Test
    public void test_05() {
        Gpr.debug("Test");
        String prepend = "ACTTTGTGCC";
        this.prependSequenceToFirstExon(prepend);
        if (this.verbose) {
            Gpr.debug(this.transcript);
        }
        Variant variant = new Variant((Marker)this.chromosome, 888, "", "TG", "");
        if (this.verbose) {
            Gpr.debug("Variant: " + variant);
        }
        VariantEffects effs = this.snpEffectPredictor.variantEffect(variant);
        VariantEffect eff = effs.get();
        HgvsDna hgvsc = new HgvsDna(eff);
        String hgvsDna = hgvsc.toString();
        if (this.verbose) {
            Gpr.debug("HGVS (DNA): '" + hgvsDna + "'");
        }
        Assert.assertEquals("c.7_8dupTG", hgvsDna);
    }

    @Test
    public void test_06() {
        Gpr.debug("Test");
        String prepend = "ACTTTGTGCC";
        this.prependSequenceToFirstExon(prepend);
        if (this.verbose) {
            Gpr.debug(this.transcript);
        }
        Variant variant = new Variant((Marker)this.chromosome, 888, "", "GTG", "");
        if (this.verbose) {
            Gpr.debug("Variant: " + variant);
        }
        VariantEffects effs = this.snpEffectPredictor.variantEffect(variant);
        VariantEffect eff = effs.get();
        HgvsDna hgvsc = new HgvsDna(eff);
        String hgvsDna = hgvsc.toString();
        if (this.verbose) {
            Gpr.debug("HGVS (DNA): '" + hgvsDna + "'");
        }
        Assert.assertEquals("c.6_8dupGTG", hgvsDna);
    }

    @Test
    public void test_07() {
        Gpr.debug("Test");
        if (this.verbose) {
            Gpr.debug(this.transcript);
        }
        Variant variant = new Variant((Marker)this.chromosome, 882, "", "A", "");
        if (this.verbose) {
            Gpr.debug("Variant: " + variant);
        }
        VariantEffects effs = this.snpEffectPredictor.variantEffect(variant);
        VariantEffect eff = effs.get();
        HgvsDna hgvsc = new HgvsDna(eff);
        String hgvsDna = hgvsc.toString();
        if (this.verbose) {
            Gpr.debug("HGVS (DNA): '" + hgvsDna + "'");
        }
        Assert.assertEquals("c.3dupA", hgvsDna);
    }

    @Test
    public void test_08() {
        Gpr.debug("Test");
        if (this.verbose) {
            Gpr.debug(this.transcript);
        }
        Variant variant = new Variant((Marker)this.chromosome, 884, "", "C", "");
        if (this.verbose) {
            Gpr.debug("Variant: " + variant);
        }
        VariantEffects effs = this.snpEffectPredictor.variantEffect(variant);
        VariantEffect eff = effs.get();
        HgvsDna hgvsc = new HgvsDna(eff);
        String hgvsDna = hgvsc.toString();
        if (this.verbose) {
            Gpr.debug("HGVS (DNA): '" + hgvsDna + "'");
        }
        Assert.assertEquals("c.7dupC", hgvsDna);
    }

    @Test
    public void test_09() {
        Gpr.debug("Test");
        this.minExons = 2;
        this.initSnpEffPredictor();
        if (this.verbose) {
            Gpr.debug(this.transcript + "\nChromosome: " + this.chromoSequence);
        }
        Variant variant = new Variant((Marker)this.chromosome, 485, "", "TA", "");
        if (this.verbose) {
            Gpr.debug("Variant: " + variant);
        }
        VariantEffects effs = this.snpEffectPredictor.variantEffect(variant);
        VariantEffect eff = effs.get();
        HgvsDna hgvsc = new HgvsDna(eff);
        String hgvsDna = hgvsc.toString();
        if (this.verbose) {
            Gpr.debug("HGVS (DNA): '" + hgvsDna + "'");
        }
        Assert.assertEquals("c.49+3_49+4dupTA", hgvsDna);
    }

    @Test
    public void test_10() {
        Gpr.debug("Test");
        this.minExons = 2;
        this.shiftHgvs = false;
        this.initSnpEffPredictor();
        if (this.verbose) {
            Gpr.debug(this.transcript + "\nChromosome: " + this.chromoSequence);
        }
        Variant variant = new Variant((Marker)this.chromosome, 483, "", "TATA", "");
        if (this.verbose) {
            Gpr.debug("Variant: " + variant);
        }
        VariantEffects effs = this.snpEffectPredictor.variantEffect(variant);
        VariantEffect eff = effs.get();
        HgvsDna hgvsc = new HgvsDna(eff);
        String hgvsDna = hgvsc.toString();
        if (this.verbose) {
            Gpr.debug("HGVS (DNA): '" + hgvsDna + "'");
        }
        Assert.assertEquals("c.48_49+2dupTATA", hgvsDna);
    }

    @Test
    public void test_11() {
        Gpr.debug("Test");
        this.minExons = 2;
        this.initSnpEffPredictor();
        if (this.verbose) {
            Gpr.debug(this.transcript + "\nChromosome: " + this.chromoSequence);
        }
        Variant variant = new Variant((Marker)this.chromosome, 739, "", "AAAG", "");
        if (this.verbose) {
            Gpr.debug("Variant: " + variant);
        }
        VariantEffects effs = this.snpEffectPredictor.variantEffect(variant);
        VariantEffect eff = effs.get();
        HgvsDna hgvsc = new HgvsDna(eff);
        String hgvsDna = hgvsc.toString();
        if (this.verbose) {
            Gpr.debug("HGVS (DNA): '" + hgvsDna + "'\nEffects:" + effs);
        }
        Assert.assertEquals("c.50-2_51dupAAAG", hgvsDna);
    }
}

