/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.snpEffect.testCases.unity;

import junit.framework.Assert;
import org.junit.Test;
import org.snpeff.interval.Marker;
import org.snpeff.interval.Variant;
import org.snpeff.snpEffect.Config;
import org.snpeff.snpEffect.HgvsDna;
import org.snpeff.snpEffect.HgvsProtein;
import org.snpeff.snpEffect.VariantEffect;
import org.snpeff.snpEffect.VariantEffects;
import org.snpeff.snpEffect.testCases.unity.TestCasesBase;
import org.snpeff.util.Gpr;

public class TestCasesHgvs
extends TestCasesBase {
    void checkHgvsProt(Variant variant, String expectedHgvsC, String expectedHgvsP) {
        this.prependSequenceToFirstExon("atgaaaatgggccatcagcagcagtgctgc");
        if (this.verbose) {
            Gpr.debug("\nChromsome : " + this.chromoSequence + "\nTranscript:\n" + this.transcript + "\nVariant   : " + variant);
        }
        VariantEffects effs = this.snpEffectPredictor.variantEffect(variant);
        VariantEffect eff = effs.get();
        HgvsDna hgvsc = new HgvsDna(eff);
        String hgvsDna = hgvsc.toString();
        HgvsProtein hgvsp = new HgvsProtein(eff);
        String hgvsProt = hgvsp.toString();
        if (this.verbose) {
            Gpr.debug("Eff        : " + eff);
            Gpr.debug("HGVS (DNA) : '" + hgvsDna + "'");
            Gpr.debug("HGVS (Prot): '" + hgvsProt + "'");
        }
        if (expectedHgvsC != null) {
            Assert.assertEquals("HGVS.c notation does not match", expectedHgvsC, hgvsDna);
        }
        if (expectedHgvsP != null) {
            Assert.assertEquals("HGVS.p notation does not match", expectedHgvsP, hgvsProt);
        }
    }

    @Test
    public void test_01() {
        Gpr.debug("Test");
        Config.get().setHgvsOneLetterAA(true);
        Variant variant = new Variant((Marker)this.chromosome, 898, "C", "A", "");
        this.checkHgvsProt(variant, null, "p.Q7K");
        Config.get().setHgvsOneLetterAA(false);
    }

    @Test
    public void test_02() {
        Gpr.debug("Test");
        Config.get().setHgvsTrId(true);
        Variant variant = new Variant((Marker)this.chromosome, 898, "C", "A", "");
        this.checkHgvsProt(variant, "transcript_0:c.19C>A", "transcript_0:p.Gln7Lys");
        Config.get().setHgvsTrId(false);
    }

    @Test
    public void test_03() {
        Gpr.debug("Test");
        Config.get().setHgvsOld(true);
        Variant variant = new Variant((Marker)this.chromosome, 898, "C", "A", "");
        this.checkHgvsProt(variant, "c.C19A", null);
        Config.get().setHgvsOld(false);
    }
}

