/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.snpEffect.testCases.integration;

import java.util.List;
import junit.framework.Assert;
import org.junit.Test;
import org.snpeff.snpEffect.commandLine.SnpEffCmdEff;
import org.snpeff.snpEffect.testCases.integration.TestCasesIntegrationBase;
import org.snpeff.util.Gpr;
import org.snpeff.vcf.EffFormatVersion;
import org.snpeff.vcf.VcfEffect;
import org.snpeff.vcf.VcfEntry;

public class TestCasesIntegrationHgvsMnps
extends TestCasesIntegrationBase {
    public TestCasesIntegrationHgvsMnps() {
        this.shiftHgvs = true;
    }

    @Test
    public void test_01() {
        Gpr.debug("Test");
        String genome = "testHg19Chr17";
        String vcf = "tests/hgvs_mnps_01.vcf";
        this.compareHgvs(genome, vcf, false);
    }

    @Test
    public void test_02() {
        Gpr.debug("Test");
        String genome = "testHg19Chr17";
        String vcf = "tests/hgvs_mnps_02.vcf";
        String[] args = new String[]{genome, vcf};
        SnpEffCmdEff snpeff = new SnpEffCmdEff();
        snpeff.parseArgs(args);
        snpeff.setDebug(this.debug);
        snpeff.setVerbose(this.verbose);
        snpeff.setSupressOutput(!this.verbose);
        snpeff.setFormatVersion(EffFormatVersion.FORMAT_ANN_1);
        List<VcfEntry> results = snpeff.run(true);
        VcfEntry ve = results.get(0);
        boolean ok = false;
        for (VcfEffect veff : ve.getVcfEffects()) {
            if (this.verbose) {
                Gpr.debug("\t" + veff + "\n\t\ttranscript: " + veff.getTranscriptId() + "\n\t\tHgvs (DNA): " + veff.getHgvsDna());
            }
            if (!veff.getTranscriptId().equals("NM_001042492.2")) continue;
            Assert.assertEquals("HGVS p. notation does not match", "p.Gln1055*", veff.getHgvsProt());
            ok = true;
        }
        Assert.assertTrue("Transcript not found", ok);
    }
}

