/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.interval;

public enum FrameType {
    GFF,
    UCSC,
    PHASE,
    FRAME,
    UNKNOWN;


    public int convertFrame(int frame) {
        if (this == GFF) {
            return frame;
        }
        if (this == UCSC) {
            switch (frame) {
                case 0: {
                    return 0;
                }
                case 1: {
                    return 2;
                }
                case 2: {
                    return 1;
                }
            }
            return -1;
        }
        throw new RuntimeException("Unknown frame type '" + (Object)((Object)this) + "'");
    }

    public int frameFromLength(int length) {
        return this.frameFromLengthGff(length);
    }

    int frameFromLengthGff(int length) {
        return (3 - length % 3) % 3;
    }

    int frameFromLengthUcsc(int length) {
        return length % 3;
    }
}

