/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.binseq.comparator;

import org.snpeff.binseq.DnaAndQualitySequence;
import org.snpeff.binseq.comparator.SubsequenceComparator;

public class DnaQualSubsequenceComparator
extends SubsequenceComparator<DnaAndQualitySequence> {
    boolean differentLengthsAreEqual;
    int maxDifferentBases = 0;

    public DnaQualSubsequenceComparator(boolean differentLengthsAreEqual) {
        this.differentLengthsAreEqual = differentLengthsAreEqual;
    }

    public DnaQualSubsequenceComparator(boolean differentLengthsAreEqual, int maxDifferentBases) {
        this.differentLengthsAreEqual = differentLengthsAreEqual;
        this.maxDifferentBases = maxDifferentBases;
    }

    @Override
    public int compare(DnaAndQualitySequence seq1, int index1, DnaAndQualitySequence seq2, int index2) {
        int i2;
        if (index1 >= seq1.length()) {
            return -1;
        }
        if (index2 >= seq2.length()) {
            return 1;
        }
        byte[] s1 = seq1.getCodes();
        byte[] s2 = seq2.getCodes();
        int i1 = index1;
        for (i2 = index2; i1 < s1.length && i2 < s2.length; ++i1, ++i2) {
            int base1 = s1[i1] & 3;
            int base2 = s2[i2] & 3;
            int comp = base1 - base2;
            if (comp == 0) continue;
            return comp;
        }
        if (this.differentLengthsAreEqual) {
            return 0;
        }
        int comp = s1.length - i1 - (s2.length - i2);
        return comp;
    }

    @Override
    public int score(DnaAndQualitySequence seq1, int index1, DnaAndQualitySequence seq2, int index2) {
        int score = 0;
        if (index1 >= seq1.length()) {
            return 0;
        }
        if (index2 >= seq2.length()) {
            return 0;
        }
        byte[] s1 = seq1.getCodes();
        byte[] s2 = seq2.getCodes();
        int i1 = index1;
        int countDiff = 0;
        for (int i2 = index2; i1 < s1.length && i2 < s2.length; ++i1, ++i2) {
            int base1 = s1[i1] & 3;
            int base2 = s2[i2] & 3;
            int comp = base1 - base2;
            if (comp != 0 && ++countDiff > this.maxDifferentBases) {
                return 0;
            }
            ++score;
        }
        return score - countDiff;
    }
}

