/*
 * Decompiled with CFR 0.152.
 */
package org.junit.experimental.theories.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.experimental.theories.ParameterSignature;
import org.junit.experimental.theories.PotentialParameterValue;
import org.junit.experimental.theories.Theory;
import org.junit.experimental.theories.internal.ParameterizedAssertionError;
import org.junit.internal.runners.TestClass;
import org.junit.internal.runners.TestMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TheoryMethod
extends TestMethod {
    private final Method fMethod;
    private List<Assume.AssumptionViolatedException> fInvalidParameters = new ArrayList<Assume.AssumptionViolatedException>();

    public TheoryMethod(Method method, TestClass testClass) {
        super(method, testClass);
        this.fMethod = method;
    }

    @Override
    public void invoke(Object test2) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        int runCount = 0;
        try {
        }
        catch (Throwable e) {
            throw new InvocationTargetException(e);
        }
        if ((runCount += this.runWithDiscoveredParameterValues(test2, new PotentialMethodValues(), ParameterSignature.signatures(this.fMethod))) == 0) {
            Assert.fail("Never found parameters that satisfied method.  Violated assumptions: " + this.fInvalidParameters);
        }
    }

    public boolean nullsOk() {
        Theory annotation = this.fMethod.getAnnotation(Theory.class);
        if (annotation == null) {
            return false;
        }
        return annotation.nullsAccepted();
    }

    int invokeWithActualParameters(Object target, Object[] params) throws Throwable {
        try {
            try {
                this.fMethod.invoke(target, params);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }
        catch (Assume.AssumptionViolatedException e) {
            this.fInvalidParameters.add(e);
            return 0;
        }
        catch (Throwable e) {
            if (params.length == 0) {
                throw e;
            }
            throw new ParameterizedAssertionError(e, this.fMethod.getName(), params);
        }
        return 1;
    }

    int runWithDiscoveredParameterValues(Object target, PotentialMethodValues valueSources, List<ParameterSignature> sigs) throws Throwable {
        if (sigs.size() == 0) {
            try {
                return this.invokeWithActualParameters(target, valueSources.getValues(this.nullsOk()));
            }
            catch (PotentialParameterValue.CouldNotGenerateValueException e) {
                return 0;
            }
        }
        int count2 = 0;
        for (PotentialParameterValue source : sigs.get(0).getPotentialValues(target)) {
            count2 += this.runWithDiscoveredParameterValues(target, valueSources.concat(source), sigs.subList(1, sigs.size()));
        }
        return count2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PotentialMethodValues {
        public final List<PotentialParameterValue> fSources;

        public PotentialMethodValues() {
            this(new ArrayList<PotentialParameterValue>());
        }

        public PotentialMethodValues(List<PotentialParameterValue> concat2) {
            this.fSources = concat2;
        }

        Object[] getValues(boolean nullsOk) throws PotentialParameterValue.CouldNotGenerateValueException {
            Object[] values2 = new Object[this.fSources.size()];
            for (int i = 0; i < values2.length; ++i) {
                values2[i] = this.fSources.get(i).getValue();
                if (values2[i] != null || nullsOk) continue;
                throw new PotentialParameterValue.CouldNotGenerateValueException();
            }
            return values2;
        }

        PotentialMethodValues concat(PotentialParameterValue source) {
            ArrayList<PotentialParameterValue> list2 = new ArrayList<PotentialParameterValue>();
            list2.addAll(this.fSources);
            list2.add(source);
            return new PotentialMethodValues(list2);
        }
    }
}

