/*
 * Decompiled with CFR 0.152.
 */
package org.biojava3.core.sequence.io;

import java.util.List;
import org.biojava3.core.sequence.RNASequence;
import org.biojava3.core.sequence.compound.NucleotideCompound;
import org.biojava3.core.sequence.io.template.SequenceCreatorInterface;
import org.biojava3.core.sequence.loader.ArrayListProxySequenceReader;
import org.biojava3.core.sequence.template.AbstractSequence;
import org.biojava3.core.sequence.template.CompoundSet;
import org.biojava3.core.sequence.template.ProxySequenceReader;

public class RNASequenceCreator
implements SequenceCreatorInterface<NucleotideCompound> {
    private final CompoundSet<NucleotideCompound> compoundSet;

    public RNASequenceCreator(CompoundSet<NucleotideCompound> compoundSet) {
        this.compoundSet = compoundSet;
    }

    @Override
    public AbstractSequence<NucleotideCompound> getSequence(String sequence2, long index2) {
        return new RNASequence(sequence2, this.compoundSet);
    }

    @Override
    public AbstractSequence<NucleotideCompound> getSequence(ProxySequenceReader<NucleotideCompound> proxyLoader, long index2) {
        return new RNASequence(proxyLoader, this.compoundSet);
    }

    @Override
    public AbstractSequence<NucleotideCompound> getSequence(List<NucleotideCompound> list2) {
        ArrayListProxySequenceReader<NucleotideCompound> store = new ArrayListProxySequenceReader<NucleotideCompound>();
        store.setCompoundSet(this.compoundSet);
        store.setContents(list2);
        return new RNASequence(store);
    }
}

