/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure.io.mmcif.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.biojava.bio.structure.io.mmcif.chem.ChemCompTools;
import org.biojava.bio.structure.io.mmcif.chem.PolymerType;
import org.biojava.bio.structure.io.mmcif.chem.ResidueType;
import org.biojava.bio.structure.io.mmcif.model.ChemCompAtom;
import org.biojava.bio.structure.io.mmcif.model.ChemCompBond;
import org.biojava.bio.structure.io.mmcif.model.ChemCompDescriptor;

public class ChemComp
implements Serializable,
Comparable<ChemComp> {
    private static final long serialVersionUID = -4736341142030215915L;
    String id;
    String name;
    String type;
    String pdbx_type;
    String formula;
    String mon_nstd_parent_comp_id;
    String pdbx_synonyms;
    String pdbx_formal_charge;
    String pdbx_initial_date;
    String pdbx_modified_date;
    String pdbx_ambiguous_flag;
    String pdbx_release_status;
    String pdbx_replaced_by;
    String pdbx_replaces;
    String formula_weight;
    String one_letter_code;
    String three_letter_code;
    String pdbx_model_coordinates_details;
    String pdbx_model_coordinates_missing_flag;
    String pdbx_ideal_coordinates_details;
    String pdbx_ideal_coordinates_missing_flag;
    String pdbx_model_coordinates_db_code;
    String pdbx_subcomponent_list;
    String pdbx_processing_site;
    String mon_nstd_flag;
    List<ChemCompDescriptor> descriptors = new ArrayList<ChemCompDescriptor>();
    List<ChemCompBond> bonds = new ArrayList<ChemCompBond>();
    List<ChemCompAtom> atoms = new ArrayList<ChemCompAtom>();
    ResidueType residueType;
    PolymerType polymerType;
    boolean standard;

    public String toString() {
        StringBuffer buf = new StringBuffer("ChemComp ");
        buf.append(this.id);
        buf.append(" ");
        buf.append(this.one_letter_code);
        buf.append(" ");
        buf.append(this.three_letter_code);
        buf.append(" poly:");
        buf.append(this.getPolymerType());
        buf.append(" resi:");
        buf.append(this.getResidueType());
        if (this.isStandard()) {
            buf.append(" standard");
        } else {
            buf.append(" modified");
        }
        buf.append(" ");
        buf.append(this.name);
        buf.append(" ");
        buf.append(this.pdbx_type);
        buf.append(" ");
        buf.append(this.formula);
        buf.append(" parent:");
        buf.append(this.mon_nstd_parent_comp_id);
        return buf.toString();
    }

    public boolean hasParent() {
        String pid = this.mon_nstd_parent_comp_id;
        return pid != null && !pid.equals("?");
    }

    public boolean isStandard() {
        return this.standard;
    }

    private void setStandardFlag() {
        this.standard = ChemCompTools.isStandardChemComp(this);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
        this.residueType = ResidueType.getResidueTypeFromString(type);
        if (this.residueType != null) {
            this.polymerType = this.residueType.polymerType;
        }
    }

    public ResidueType getResidueType() {
        return this.residueType;
    }

    public void setResidueType(ResidueType residueType) {
        this.residueType = residueType;
    }

    public PolymerType getPolymerType() {
        return this.polymerType;
    }

    public void setPolymerType(PolymerType polymerType) {
        this.polymerType = polymerType;
    }

    public String getPdbx_type() {
        return this.pdbx_type;
    }

    public void setPdbx_type(String pdbx_type) {
        this.pdbx_type = pdbx_type;
    }

    public String getFormula() {
        return this.formula;
    }

    public void setFormula(String formula) {
        this.formula = formula;
    }

    public String getMon_nstd_parent_comp_id() {
        return this.mon_nstd_parent_comp_id;
    }

    public void setMon_nstd_parent_comp_id(String mon_nstd_parent_comp_id) {
        this.mon_nstd_parent_comp_id = mon_nstd_parent_comp_id;
        this.setStandardFlag();
    }

    public String getPdbx_synonyms() {
        return this.pdbx_synonyms;
    }

    public void setPdbx_synonyms(String pdbx_synonyms) {
        this.pdbx_synonyms = pdbx_synonyms;
    }

    public String getPdbx_formal_charge() {
        return this.pdbx_formal_charge;
    }

    public void setPdbx_formal_charge(String pdbx_formal_charge) {
        this.pdbx_formal_charge = pdbx_formal_charge;
    }

    public String getPdbx_initial_date() {
        return this.pdbx_initial_date;
    }

    public void setPdbx_initial_date(String pdbx_initial_date) {
        this.pdbx_initial_date = pdbx_initial_date;
    }

    public String getPdbx_modified_date() {
        return this.pdbx_modified_date;
    }

    public void setPdbx_modified_date(String pdbx_modified_date) {
        this.pdbx_modified_date = pdbx_modified_date;
    }

    public String getPdbx_ambiguous_flag() {
        return this.pdbx_ambiguous_flag;
    }

    public void setPdbx_ambiguous_flag(String pdbx_ambiguous_flag) {
        this.pdbx_ambiguous_flag = pdbx_ambiguous_flag;
    }

    public String getPdbx_release_status() {
        return this.pdbx_release_status;
    }

    public void setPdbx_release_status(String pdbx_release_status) {
        this.pdbx_release_status = pdbx_release_status;
    }

    public String getPdbx_replaced_by() {
        return this.pdbx_replaced_by;
    }

    public void setPdbx_replaced_by(String pdbx_replaced_by) {
        this.pdbx_replaced_by = pdbx_replaced_by;
    }

    public String getPdbx_replaces() {
        return this.pdbx_replaces;
    }

    public void setPdbx_replaces(String pdbx_replaces) {
        this.pdbx_replaces = pdbx_replaces;
    }

    public String getFormula_weight() {
        return this.formula_weight;
    }

    public void setFormula_weight(String formula_weight) {
        this.formula_weight = formula_weight;
    }

    public String getOne_letter_code() {
        return this.one_letter_code;
    }

    public void setOne_letter_code(String one_letter_code) {
        this.one_letter_code = one_letter_code;
        this.setStandardFlag();
    }

    public String getThree_letter_code() {
        return this.three_letter_code;
    }

    public void setThree_letter_code(String three_letter_code) {
        this.three_letter_code = three_letter_code;
    }

    public String getPdbx_model_coordinates_details() {
        return this.pdbx_model_coordinates_details;
    }

    public void setPdbx_model_coordinates_details(String pdbx_model_coordinates_details) {
        this.pdbx_model_coordinates_details = pdbx_model_coordinates_details;
    }

    public String getPdbx_model_coordinates_missing_flag() {
        return this.pdbx_model_coordinates_missing_flag;
    }

    public void setPdbx_model_coordinates_missing_flag(String pdbx_model_coordinates_missing_flag) {
        this.pdbx_model_coordinates_missing_flag = pdbx_model_coordinates_missing_flag;
    }

    public String getPdbx_ideal_coordinates_details() {
        return this.pdbx_ideal_coordinates_details;
    }

    public void setPdbx_ideal_coordinates_details(String pdbx_ideal_coordinates_details) {
        this.pdbx_ideal_coordinates_details = pdbx_ideal_coordinates_details;
    }

    public String getPdbx_ideal_coordinates_missing_flag() {
        return this.pdbx_ideal_coordinates_missing_flag;
    }

    public void setPdbx_ideal_coordinates_missing_flag(String pdbx_ideal_coordinates_missing_flag) {
        this.pdbx_ideal_coordinates_missing_flag = pdbx_ideal_coordinates_missing_flag;
    }

    public String getPdbx_model_coordinates_db_code() {
        return this.pdbx_model_coordinates_db_code;
    }

    public void setPdbx_model_coordinates_db_code(String pdbx_model_coordinates_db_code) {
        this.pdbx_model_coordinates_db_code = pdbx_model_coordinates_db_code;
    }

    public String getPdbx_subcomponent_list() {
        return this.pdbx_subcomponent_list;
    }

    public void setPdbx_subcomponent_list(String pdbx_subcomponent_list) {
        this.pdbx_subcomponent_list = pdbx_subcomponent_list;
    }

    public String getPdbx_processing_site() {
        return this.pdbx_processing_site;
    }

    public void setPdbx_processing_site(String pdbx_processing_site) {
        this.pdbx_processing_site = pdbx_processing_site;
    }

    public void setStandard(boolean standard) {
        this.standard = standard;
    }

    public String getMon_nstd_flag() {
        return this.mon_nstd_flag;
    }

    public void setMon_nstd_flag(String mon_nstd_flag) {
        this.mon_nstd_flag = mon_nstd_flag;
    }

    public List<ChemCompDescriptor> getDescriptors() {
        return this.descriptors;
    }

    public void setDescriptors(List<ChemCompDescriptor> descriptors) {
        this.descriptors = descriptors;
    }

    public List<ChemCompBond> getBonds() {
        return this.bonds;
    }

    public void setBonds(List<ChemCompBond> bonds) {
        this.bonds = bonds;
    }

    public List<ChemCompAtom> getAtoms() {
        return this.atoms;
    }

    public void setAtoms(List<ChemCompAtom> atoms) {
        this.atoms = atoms;
    }

    @Override
    public int compareTo(ChemComp arg0) {
        if (this.equals(arg0)) {
            return 0;
        }
        return this.getId().compareTo(arg0.getId());
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + (this.descriptors == null ? 0 : this.descriptors.hashCode());
        result2 = 31 * result2 + (this.formula == null ? 0 : this.formula.hashCode());
        result2 = 31 * result2 + (this.formula_weight == null ? 0 : this.formula_weight.hashCode());
        result2 = 31 * result2 + (this.id == null ? 0 : this.id.hashCode());
        result2 = 31 * result2 + (this.mon_nstd_flag == null ? 0 : this.mon_nstd_flag.hashCode());
        result2 = 31 * result2 + (this.mon_nstd_parent_comp_id == null ? 0 : this.mon_nstd_parent_comp_id.hashCode());
        result2 = 31 * result2 + (this.name == null ? 0 : this.name.hashCode());
        result2 = 31 * result2 + (this.one_letter_code == null ? 0 : this.one_letter_code.hashCode());
        result2 = 31 * result2 + (this.pdbx_ambiguous_flag == null ? 0 : this.pdbx_ambiguous_flag.hashCode());
        result2 = 31 * result2 + (this.pdbx_formal_charge == null ? 0 : this.pdbx_formal_charge.hashCode());
        result2 = 31 * result2 + (this.pdbx_ideal_coordinates_details == null ? 0 : this.pdbx_ideal_coordinates_details.hashCode());
        result2 = 31 * result2 + (this.pdbx_ideal_coordinates_missing_flag == null ? 0 : this.pdbx_ideal_coordinates_missing_flag.hashCode());
        result2 = 31 * result2 + (this.pdbx_initial_date == null ? 0 : this.pdbx_initial_date.hashCode());
        result2 = 31 * result2 + (this.pdbx_model_coordinates_db_code == null ? 0 : this.pdbx_model_coordinates_db_code.hashCode());
        result2 = 31 * result2 + (this.pdbx_model_coordinates_details == null ? 0 : this.pdbx_model_coordinates_details.hashCode());
        result2 = 31 * result2 + (this.pdbx_model_coordinates_missing_flag == null ? 0 : this.pdbx_model_coordinates_missing_flag.hashCode());
        result2 = 31 * result2 + (this.pdbx_modified_date == null ? 0 : this.pdbx_modified_date.hashCode());
        result2 = 31 * result2 + (this.pdbx_processing_site == null ? 0 : this.pdbx_processing_site.hashCode());
        result2 = 31 * result2 + (this.pdbx_release_status == null ? 0 : this.pdbx_release_status.hashCode());
        result2 = 31 * result2 + (this.pdbx_replaced_by == null ? 0 : this.pdbx_replaced_by.hashCode());
        result2 = 31 * result2 + (this.pdbx_replaces == null ? 0 : this.pdbx_replaces.hashCode());
        result2 = 31 * result2 + (this.pdbx_subcomponent_list == null ? 0 : this.pdbx_subcomponent_list.hashCode());
        result2 = 31 * result2 + (this.pdbx_synonyms == null ? 0 : this.pdbx_synonyms.hashCode());
        result2 = 31 * result2 + (this.pdbx_type == null ? 0 : this.pdbx_type.hashCode());
        result2 = 31 * result2 + (this.polymerType == null ? 0 : this.polymerType.hashCode());
        result2 = 31 * result2 + (this.residueType == null ? 0 : this.residueType.hashCode());
        result2 = 31 * result2 + (this.standard ? 1231 : 1237);
        result2 = 31 * result2 + (this.three_letter_code == null ? 0 : this.three_letter_code.hashCode());
        result2 = 31 * result2 + (this.type == null ? 0 : this.type.hashCode());
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChemComp other = (ChemComp)obj;
        if (this.descriptors == null ? other.descriptors != null : !this.descriptors.equals(other.descriptors)) {
            return false;
        }
        if (this.formula == null ? other.formula != null : !this.formula.equals(other.formula)) {
            return false;
        }
        if (this.formula_weight == null ? other.formula_weight != null : !this.formula_weight.equals(other.formula_weight)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.mon_nstd_flag == null ? other.mon_nstd_flag != null : !this.mon_nstd_flag.equals(other.mon_nstd_flag)) {
            return false;
        }
        if (this.mon_nstd_parent_comp_id == null ? other.mon_nstd_parent_comp_id != null : !this.mon_nstd_parent_comp_id.equals(other.mon_nstd_parent_comp_id)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.one_letter_code == null ? other.one_letter_code != null : !this.one_letter_code.equals(other.one_letter_code)) {
            return false;
        }
        if (this.pdbx_ambiguous_flag == null ? other.pdbx_ambiguous_flag != null : !this.pdbx_ambiguous_flag.equals(other.pdbx_ambiguous_flag)) {
            return false;
        }
        if (this.pdbx_formal_charge == null ? other.pdbx_formal_charge != null : !this.pdbx_formal_charge.equals(other.pdbx_formal_charge)) {
            return false;
        }
        if (this.pdbx_ideal_coordinates_details == null ? other.pdbx_ideal_coordinates_details != null : !this.pdbx_ideal_coordinates_details.equals(other.pdbx_ideal_coordinates_details)) {
            return false;
        }
        if (this.pdbx_ideal_coordinates_missing_flag == null ? other.pdbx_ideal_coordinates_missing_flag != null : !this.pdbx_ideal_coordinates_missing_flag.equals(other.pdbx_ideal_coordinates_missing_flag)) {
            return false;
        }
        if (this.pdbx_initial_date == null ? other.pdbx_initial_date != null : !this.pdbx_initial_date.equals(other.pdbx_initial_date)) {
            return false;
        }
        if (this.pdbx_model_coordinates_db_code == null ? other.pdbx_model_coordinates_db_code != null : !this.pdbx_model_coordinates_db_code.equals(other.pdbx_model_coordinates_db_code)) {
            return false;
        }
        if (this.pdbx_model_coordinates_details == null ? other.pdbx_model_coordinates_details != null : !this.pdbx_model_coordinates_details.equals(other.pdbx_model_coordinates_details)) {
            return false;
        }
        if (this.pdbx_model_coordinates_missing_flag == null ? other.pdbx_model_coordinates_missing_flag != null : !this.pdbx_model_coordinates_missing_flag.equals(other.pdbx_model_coordinates_missing_flag)) {
            return false;
        }
        if (this.pdbx_modified_date == null ? other.pdbx_modified_date != null : !this.pdbx_modified_date.equals(other.pdbx_modified_date)) {
            return false;
        }
        if (this.pdbx_processing_site == null ? other.pdbx_processing_site != null : !this.pdbx_processing_site.equals(other.pdbx_processing_site)) {
            return false;
        }
        if (this.pdbx_release_status == null ? other.pdbx_release_status != null : !this.pdbx_release_status.equals(other.pdbx_release_status)) {
            return false;
        }
        if (this.pdbx_replaced_by == null ? other.pdbx_replaced_by != null : !this.pdbx_replaced_by.equals(other.pdbx_replaced_by)) {
            return false;
        }
        if (this.pdbx_replaces == null ? other.pdbx_replaces != null : !this.pdbx_replaces.equals(other.pdbx_replaces)) {
            return false;
        }
        if (this.pdbx_subcomponent_list == null ? other.pdbx_subcomponent_list != null : !this.pdbx_subcomponent_list.equals(other.pdbx_subcomponent_list)) {
            return false;
        }
        if (this.pdbx_synonyms == null ? other.pdbx_synonyms != null : !this.pdbx_synonyms.equals(other.pdbx_synonyms)) {
            return false;
        }
        if (this.pdbx_type == null ? other.pdbx_type != null : !this.pdbx_type.equals(other.pdbx_type)) {
            return false;
        }
        if (this.polymerType != other.polymerType) {
            return false;
        }
        if (this.residueType != other.residueType) {
            return false;
        }
        if (this.standard != other.standard) {
            return false;
        }
        if (this.three_letter_code == null ? other.three_letter_code != null : !this.three_letter_code.equals(other.three_letter_code)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

