/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.biojava.bio.structure.Structure;
import org.biojava.bio.structure.StructureException;
import org.biojava.bio.structure.io.FileParsingParameters;
import org.biojava.bio.structure.io.PDBFileParser;
import org.biojava.bio.structure.io.StructureProvider;
import org.biojava3.core.util.InputStreamProvider;

public class SandboxStyleStructureProvider
implements StructureProvider {
    FileParsingParameters params = new FileParsingParameters();
    String path;
    public static final String fileSeparator = System.getProperty("file.separator");

    public SandboxStyleStructureProvider() {
        String defaultPath = System.getProperty("PDB_DIR");
        if (defaultPath == null) {
            String property = "java.io.tmpdir";
            defaultPath = System.getProperty(property);
        }
        this.setPath(defaultPath);
    }

    public void setPath(String p) {
        System.setProperty("PDB_DIR", p);
        this.path = p;
        if (!this.path.endsWith(fileSeparator)) {
            this.path = this.path + fileSeparator;
        }
    }

    @Override
    public Structure getStructureById(String pdbId) throws IOException, StructureException {
        if (pdbId == null || pdbId.length() < 4) {
            throw new StructureException("This does not look like a valid PDB ID! (" + pdbId + ")");
        }
        pdbId = pdbId.toLowerCase();
        String middle = pdbId.substring(1, 3).toLowerCase();
        File f2 = new File(this.path + fileSeparator + middle + fileSeparator + pdbId + fileSeparator + "pdb" + pdbId + ".ent.gz");
        if (!f2.exists()) {
            // empty if block
        }
        InputStreamProvider isp = new InputStreamProvider();
        try {
            InputStream inputStream = isp.getInputStream(f2);
            PDBFileParser pdbpars = new PDBFileParser();
            pdbpars.setFileParsingParameters(this.params);
            Structure struc = pdbpars.parsePDBFile(inputStream);
            return struc;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Structure getBiologicalUnit(String pdbId) throws StructureException, IOException {
        return null;
    }

    @Override
    public void setFileParsingParameters(FileParsingParameters params) {
        this.params = params;
    }

    @Override
    public FileParsingParameters getFileParsingParameters() {
        return this.params;
    }

    public List<String> getAllPDBIDs() throws IOException {
        File f2 = new File(this.path);
        if (!f2.isDirectory()) {
            throw new IOException("Path " + this.path + " is not a directory!");
        }
        String[] dirName = f2.list();
        ArrayList<String> pdbIds = new ArrayList<String>();
        for (String dir : dirName) {
            String[] pdbDirs;
            File d2 = new File(f2, dir);
            if (!d2.isDirectory()) continue;
            for (String pdbId : pdbDirs = d2.list()) {
                if (pdbIds.contains(pdbId)) continue;
                pdbIds.add(pdbId);
            }
        }
        return pdbIds;
    }
}

