/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.internal;

import org.apfloat.ApfloatContext;
import org.apfloat.ApfloatRuntimeException;
import org.apfloat.internal.ApfloatInternalException;
import org.apfloat.internal.FloatBaseMath;
import org.apfloat.spi.ConvolutionStrategy;
import org.apfloat.spi.DataStorage;
import org.apfloat.spi.DataStorageBuilder;

public class FloatMediumConvolutionStrategy
extends FloatBaseMath
implements ConvolutionStrategy {
    private static final long serialVersionUID = -6697305140738370764L;

    public FloatMediumConvolutionStrategy(int radix) {
        super(radix);
    }

    public DataStorage convolute(DataStorage x2, DataStorage y, long resultSize) throws ApfloatRuntimeException {
        DataStorage longStorage;
        DataStorage shortStorage;
        if (x2.getSize() > y.getSize()) {
            shortStorage = y;
            longStorage = x2;
        } else {
            shortStorage = x2;
            longStorage = y;
        }
        long shortSize = shortStorage.getSize();
        long longSize = longStorage.getSize();
        long size2 = shortSize + longSize;
        if (shortSize > Integer.MAX_VALUE) {
            throw new ApfloatInternalException("Too long shorter number, size = " + shortSize);
        }
        final int bufferSize = (int)shortSize;
        ApfloatContext ctx = ApfloatContext.getContext();
        DataStorageBuilder dataStorageBuilder = ctx.getBuilderFactory().getDataStorageBuilder();
        DataStorage resultStorage = dataStorageBuilder.createDataStorage(size2 * 4L);
        resultStorage.setSize(size2);
        DataStorage.Iterator src = longStorage.iterator(1, longSize, 0L);
        DataStorage.Iterator dst = resultStorage.iterator(2, size2, 0L);
        DataStorage.Iterator tmpDst = new DataStorage.Iterator(){
            private float[] buffer;
            private int position;
            {
                this.buffer = new float[bufferSize];
                this.position = 0;
            }

            public void next() {
                ++this.position;
                this.position = this.position == bufferSize ? 0 : this.position;
            }

            public float getFloat() {
                return this.buffer[this.position];
            }

            public void setFloat(float value2) {
                this.buffer[this.position] = value2;
            }
        };
        for (long i = 0L; i < longSize; ++i) {
            DataStorage.Iterator tmpSrc = shortStorage.iterator(1, shortSize, 0L);
            float factor = src.getFloat();
            float carry = this.baseMultiplyAdd(tmpSrc, tmpDst, factor, 0.0f, tmpDst, shortSize);
            float result2 = tmpDst.getFloat();
            dst.setFloat(result2);
            tmpDst.setFloat(carry);
            tmpDst.next();
            src.next();
            dst.next();
        }
        for (int i = 0; i < bufferSize; ++i) {
            float result3 = tmpDst.getFloat();
            dst.setFloat(result3);
            tmpDst.next();
            dst.next();
        }
        return resultStorage;
    }
}

