/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat;

import java.util.Arrays;
import java.util.Comparator;
import org.apfloat.ApfloatHelper;
import org.apfloat.ApfloatRuntimeException;
import org.apfloat.Apint;
import org.apfloat.ApintMath;
import org.apfloat.Aprational;

public class AprationalMath {
    private AprationalMath() {
    }

    public static Aprational pow(Aprational x2, long n) throws ArithmeticException, ApfloatRuntimeException {
        if (n == 0L) {
            if (x2.signum() == 0) {
                throw new ArithmeticException("Zero to power zero");
            }
            return new Apint(1L, x2.radix());
        }
        if (n < 0L) {
            x2 = Aprational.ONE.divide(x2);
            n = -n;
        }
        int b2pow = 0;
        while ((n & 1L) == 0L) {
            ++b2pow;
            n >>>= 1;
        }
        Aprational r = x2;
        while ((n >>>= 1) > 0L) {
            x2 = x2.multiply(x2);
            if ((n & 1L) == 0L) continue;
            r = r.multiply(x2);
        }
        while (b2pow-- > 0) {
            r = r.multiply(r);
        }
        return r;
    }

    @Deprecated
    public static Aprational negate(Aprational x2) throws ApfloatRuntimeException {
        return x2.negate();
    }

    public static Aprational abs(Aprational x2) throws ApfloatRuntimeException {
        if (x2.signum() >= 0) {
            return x2;
        }
        return x2.negate();
    }

    public static Aprational copySign(Aprational x2, Aprational y) throws ApfloatRuntimeException {
        if (y.signum() == 0) {
            return y;
        }
        if (x2.signum() != y.signum()) {
            return x2.negate();
        }
        return x2;
    }

    public static Aprational scale(Aprational x2, long scale) throws ApfloatRuntimeException {
        if (scale >= 0L) {
            return new Aprational(ApintMath.scale(x2.numerator(), scale), x2.denominator());
        }
        if (scale == Long.MIN_VALUE) {
            Apint scaler = ApintMath.pow(new Apint((long)x2.radix(), x2.radix()), 0x4000000000000000L);
            return new Aprational(x2.numerator(), x2.denominator().multiply(scaler).multiply(scaler));
        }
        return new Aprational(x2.numerator(), ApintMath.scale(x2.denominator(), -scale));
    }

    public static Aprational product(Aprational ... x2) throws ApfloatRuntimeException {
        if (x2.length == 0) {
            return Aprational.ONE;
        }
        Apint[] n = new Apint[x2.length];
        Apint[] m = new Apint[x2.length];
        for (int i = 0; i < x2.length; ++i) {
            if (x2[i].signum() == 0) {
                return Aprational.ZERO;
            }
            n[i] = x2[i].numerator();
            m[i] = x2[i].denominator();
        }
        return new Aprational(ApintMath.product(n), ApintMath.product(m));
    }

    public static Aprational sum(Aprational ... x2) throws ApfloatRuntimeException {
        if (x2.length == 0) {
            return Aprational.ZERO;
        }
        x2 = (Aprational[])x2.clone();
        Arrays.sort(x2, new Comparator<Aprational>(){

            @Override
            public int compare(Aprational x2, Aprational y) {
                long ySize;
                long xSize = ApfloatHelper.size(x2);
                return xSize < (ySize = ApfloatHelper.size(y)) ? -1 : (xSize > ySize ? 1 : 0);
            }
        });
        return AprationalMath.recursiveSum(x2, 0, x2.length - 1);
    }

    private static Aprational recursiveSum(Aprational[] x2, int n, int m) throws ApfloatRuntimeException {
        if (n == m) {
            return x2[n];
        }
        int k = n + m >>> 1;
        return AprationalMath.recursiveSum(x2, n, k).add(AprationalMath.recursiveSum(x2, k + 1, m));
    }
}

