/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.transform;

import java.io.Serializable;
import org.apache.commons.math3.analysis.FunctionUtils;
import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.complex.Complex;
import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.transform.DctNormalization;
import org.apache.commons.math3.transform.DftNormalization;
import org.apache.commons.math3.transform.FastFourierTransformer;
import org.apache.commons.math3.transform.RealTransformer;
import org.apache.commons.math3.transform.TransformType;
import org.apache.commons.math3.transform.TransformUtils;
import org.apache.commons.math3.util.ArithmeticUtils;
import org.apache.commons.math3.util.FastMath;

public class FastCosineTransformer
implements RealTransformer,
Serializable {
    static final long serialVersionUID = 20120212L;
    private final DctNormalization normalization;

    public FastCosineTransformer(DctNormalization normalization) {
        this.normalization = normalization;
    }

    public double[] transform(double[] f2, TransformType type) throws MathIllegalArgumentException {
        if (type == TransformType.FORWARD) {
            if (this.normalization == DctNormalization.ORTHOGONAL_DCT_I) {
                double s = FastMath.sqrt(2.0 / (double)(f2.length - 1));
                return TransformUtils.scaleArray(this.fct(f2), s);
            }
            return this.fct(f2);
        }
        double s2 = 2.0 / (double)(f2.length - 1);
        double s1 = this.normalization == DctNormalization.ORTHOGONAL_DCT_I ? FastMath.sqrt(s2) : s2;
        return TransformUtils.scaleArray(this.fct(f2), s1);
    }

    public double[] transform(UnivariateFunction f2, double min2, double max2, int n, TransformType type) throws MathIllegalArgumentException {
        double[] data2 = FunctionUtils.sample(f2, min2, max2, n);
        return this.transform(data2, type);
    }

    protected double[] fct(double[] f2) throws MathIllegalArgumentException {
        double[] transformed = new double[f2.length];
        int n = f2.length - 1;
        if (!ArithmeticUtils.isPowerOfTwo(n)) {
            throw new MathIllegalArgumentException(LocalizedFormats.NOT_POWER_OF_TWO_PLUS_ONE, f2.length);
        }
        if (n == 1) {
            transformed[0] = 0.5 * (f2[0] + f2[1]);
            transformed[1] = 0.5 * (f2[0] - f2[1]);
            return transformed;
        }
        double[] x2 = new double[n];
        x2[0] = 0.5 * (f2[0] + f2[n]);
        x2[n >> 1] = f2[n >> 1];
        double t1 = 0.5 * (f2[0] - f2[n]);
        for (int i = 1; i < n >> 1; ++i) {
            double a = 0.5 * (f2[i] + f2[n - i]);
            double b = FastMath.sin((double)i * Math.PI / (double)n) * (f2[i] - f2[n - i]);
            double c = FastMath.cos((double)i * Math.PI / (double)n) * (f2[i] - f2[n - i]);
            x2[i] = a - b;
            x2[n - i] = a + b;
            t1 += c;
        }
        FastFourierTransformer transformer = new FastFourierTransformer(DftNormalization.STANDARD);
        Complex[] y = transformer.transform(x2, TransformType.FORWARD);
        transformed[0] = y[0].getReal();
        transformed[1] = t1;
        for (int i = 1; i < n >> 1; ++i) {
            transformed[2 * i] = y[i].getReal();
            transformed[2 * i + 1] = transformed[2 * i - 1] - y[i].getImaginary();
        }
        transformed[n] = y[n >> 1].getReal();
        return transformed;
    }
}

