/*
 * Decompiled with CFR 0.152.
 */
package freemarker.debug.impl;

import freemarker.core.DebugBreak;
import freemarker.core.Environment;
import freemarker.core.TemplateElement;
import freemarker.debug.Breakpoint;
import freemarker.debug.DebuggerListener;
import freemarker.debug.EnvironmentSuspendedEvent;
import freemarker.debug.impl.DebuggerServer;
import freemarker.debug.impl.DebuggerService;
import freemarker.debug.impl.RmiDebuggedEnvironmentImpl;
import freemarker.debug.impl.RmiDebuggerImpl;
import freemarker.template.Template;
import freemarker.template.utility.UndeclaredThrowableException;
import java.io.Serializable;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.rmi.RemoteException;
import java.rmi.server.RemoteObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class RmiDebuggerService
extends DebuggerService {
    private final Map templateDebugInfos = new HashMap();
    private final HashSet suspendedEnvironments = new HashSet();
    private final Map listeners = new HashMap();
    private final ReferenceQueue refQueue = new ReferenceQueue();

    RmiDebuggerService() {
        try {
            new DebuggerServer((Serializable)((Object)RemoteObject.toStub(new RmiDebuggerImpl(this)))).start();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            throw new UndeclaredThrowableException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List getBreakpointsSpi(String templateName) {
        Map map2 = this.templateDebugInfos;
        synchronized (map2) {
            TemplateDebugInfo tdi = this.findTemplateDebugInfo(templateName);
            return tdi == null ? Collections.EMPTY_LIST : tdi.breakpoints;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List getBreakpointsSpi() {
        ArrayList sumlist = new ArrayList();
        Map map2 = this.templateDebugInfos;
        synchronized (map2) {
            Iterator iter2 = this.templateDebugInfos.values().iterator();
            while (iter2.hasNext()) {
                sumlist.addAll(((TemplateDebugInfo)iter2.next()).breakpoints);
            }
        }
        Collections.sort(sumlist);
        return sumlist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean suspendEnvironmentSpi(Environment env, int line) throws RemoteException {
        RmiDebuggedEnvironmentImpl denv = (RmiDebuggedEnvironmentImpl)RmiDebuggedEnvironmentImpl.getCachedWrapperFor(env);
        HashSet hashSet = this.suspendedEnvironments;
        synchronized (hashSet) {
            this.suspendedEnvironments.add(denv);
        }
        try {
            EnvironmentSuspendedEvent breakpointEvent = new EnvironmentSuspendedEvent(this, line, denv);
            Object object = this.listeners;
            synchronized (object) {
                Iterator iter2 = this.listeners.values().iterator();
                while (iter2.hasNext()) {
                    DebuggerListener listener = (DebuggerListener)iter2.next();
                    listener.environmentSuspended(breakpointEvent);
                }
            }
            object = denv;
            synchronized (object) {
                try {
                    denv.wait();
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            boolean bl = denv.isStopped();
            return bl;
        }
        finally {
            HashSet hashSet2 = this.suspendedEnvironments;
            synchronized (hashSet2) {
                this.suspendedEnvironments.remove(denv);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerTemplateSpi(Template template) {
        String templateName = template.getName();
        Map map2 = this.templateDebugInfos;
        synchronized (map2) {
            TemplateDebugInfo tdi = this.createTemplateDebugInfo(templateName);
            tdi.templates.add(new TemplateReference(templateName, template, this.refQueue));
            Iterator iter2 = tdi.breakpoints.iterator();
            while (iter2.hasNext()) {
                Breakpoint breakpoint = (Breakpoint)iter2.next();
                RmiDebuggerService.insertDebugBreak(template, breakpoint);
            }
        }
    }

    Collection getSuspendedEnvironments() {
        return (Collection)this.suspendedEnvironments.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object addDebuggerListener(DebuggerListener listener) {
        Long id;
        Map map2 = this.listeners;
        synchronized (map2) {
            id = new Long(System.currentTimeMillis());
            this.listeners.put(id, listener);
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeDebuggerListener(Object id) {
        Map map2 = this.listeners;
        synchronized (map2) {
            this.listeners.remove(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addBreakpoint(Breakpoint breakpoint) {
        String templateName = breakpoint.getTemplateName();
        Map map2 = this.templateDebugInfos;
        synchronized (map2) {
            TemplateDebugInfo tdi = this.createTemplateDebugInfo(templateName);
            List breakpoints = tdi.breakpoints;
            int pos = Collections.binarySearch(breakpoints, breakpoint);
            if (pos < 0) {
                breakpoints.add(-pos - 1, breakpoint);
                Iterator iter2 = tdi.templates.iterator();
                while (iter2.hasNext()) {
                    TemplateReference ref = (TemplateReference)iter2.next();
                    Template t2 = ref.getTemplate();
                    if (t2 == null) {
                        iter2.remove();
                        continue;
                    }
                    RmiDebuggerService.insertDebugBreak(t2, breakpoint);
                }
            }
        }
    }

    private static void insertDebugBreak(Template t2, Breakpoint breakpoint) {
        TemplateElement te = RmiDebuggerService.findTemplateElement(t2.getRootTreeNode(), breakpoint.getLine());
        if (te == null) {
            return;
        }
        TemplateElement parent = (TemplateElement)te.getParent();
        DebugBreak db = new DebugBreak(te);
        parent.setChildAt(parent.getIndex(te), db);
    }

    private static TemplateElement findTemplateElement(TemplateElement te, int line) {
        if (te.getBeginLine() > line || te.getEndLine() < line) {
            return null;
        }
        Enumeration children2 = te.children();
        while (children2.hasMoreElements()) {
            TemplateElement child = (TemplateElement)children2.nextElement();
            TemplateElement childmatch = RmiDebuggerService.findTemplateElement(child, line);
            if (childmatch == null) continue;
            return childmatch;
        }
        return te;
    }

    private TemplateDebugInfo findTemplateDebugInfo(String templateName) {
        this.processRefQueue();
        return (TemplateDebugInfo)this.templateDebugInfos.get(templateName);
    }

    private TemplateDebugInfo createTemplateDebugInfo(String templateName) {
        TemplateDebugInfo tdi = this.findTemplateDebugInfo(templateName);
        if (tdi == null) {
            tdi = new TemplateDebugInfo();
            this.templateDebugInfos.put(templateName, tdi);
        }
        return tdi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeBreakpoint(Breakpoint breakpoint) {
        String templateName = breakpoint.getTemplateName();
        Map map2 = this.templateDebugInfos;
        synchronized (map2) {
            TemplateDebugInfo tdi = this.findTemplateDebugInfo(templateName);
            if (tdi != null) {
                List breakpoints = tdi.breakpoints;
                int pos = Collections.binarySearch(breakpoints, breakpoint);
                if (pos >= 0) {
                    breakpoints.remove(pos);
                    Iterator iter2 = tdi.templates.iterator();
                    while (iter2.hasNext()) {
                        TemplateReference ref = (TemplateReference)iter2.next();
                        Template t2 = ref.getTemplate();
                        if (t2 == null) {
                            iter2.remove();
                            continue;
                        }
                        this.removeDebugBreak(t2, breakpoint);
                    }
                }
                if (tdi.isEmpty()) {
                    this.templateDebugInfos.remove(templateName);
                }
            }
        }
    }

    private void removeDebugBreak(Template t2, Breakpoint breakpoint) {
        TemplateElement te = RmiDebuggerService.findTemplateElement(t2.getRootTreeNode(), breakpoint.getLine());
        if (te == null) {
            return;
        }
        TemplateElement db = null;
        while (te != null) {
            if (te instanceof DebugBreak) {
                db = (DebugBreak)te;
                break;
            }
            te = (TemplateElement)te.getParent();
        }
        if (db == null) {
            return;
        }
        TemplateElement parent = (TemplateElement)db.getParent();
        parent.setChildAt(parent.getIndex(db), (TemplateElement)db.getChildAt(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeBreakpoints(String templateName) {
        Map map2 = this.templateDebugInfos;
        synchronized (map2) {
            TemplateDebugInfo tdi = this.findTemplateDebugInfo(templateName);
            if (tdi != null) {
                this.removeBreakpoints(tdi);
                if (tdi.isEmpty()) {
                    this.templateDebugInfos.remove(templateName);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeBreakpoints() {
        Map map2 = this.templateDebugInfos;
        synchronized (map2) {
            Iterator iter2 = this.templateDebugInfos.values().iterator();
            while (iter2.hasNext()) {
                TemplateDebugInfo tdi = (TemplateDebugInfo)iter2.next();
                this.removeBreakpoints(tdi);
                if (!tdi.isEmpty()) continue;
                iter2.remove();
            }
        }
    }

    private void removeBreakpoints(TemplateDebugInfo tdi) {
        tdi.breakpoints.clear();
        Iterator iter2 = tdi.templates.iterator();
        while (iter2.hasNext()) {
            TemplateReference ref = (TemplateReference)iter2.next();
            Template t2 = ref.getTemplate();
            if (t2 == null) {
                iter2.remove();
                continue;
            }
            this.removeDebugBreaks(t2.getRootTreeNode());
        }
    }

    private void removeDebugBreaks(TemplateElement te) {
        int count2 = te.getChildCount();
        for (int i = 0; i < count2; ++i) {
            TemplateElement child = (TemplateElement)te.getChildAt(i);
            while (child instanceof DebugBreak) {
                TemplateElement dbchild = (TemplateElement)child.getChildAt(0);
                te.setChildAt(i, dbchild);
                child = dbchild;
            }
            this.removeDebugBreaks(child);
        }
    }

    private void processRefQueue() {
        TemplateReference ref;
        while ((ref = (TemplateReference)this.refQueue.poll()) != null) {
            TemplateDebugInfo tdi = this.findTemplateDebugInfo(ref.templateName);
            if (tdi == null) continue;
            tdi.templates.remove(ref);
            if (!tdi.isEmpty()) continue;
            this.templateDebugInfos.remove(ref.templateName);
        }
    }

    private static final class TemplateReference
    extends WeakReference {
        final String templateName;

        TemplateReference(String templateName, Template template, ReferenceQueue queue) {
            super(template, queue);
            this.templateName = templateName;
        }

        Template getTemplate() {
            return (Template)this.get();
        }
    }

    private static final class TemplateDebugInfo {
        final List templates = new ArrayList();
        final List breakpoints = new ArrayList();

        private TemplateDebugInfo() {
        }

        boolean isEmpty() {
            return this.templates.isEmpty() && this.breakpoints.isEmpty();
        }
    }
}

