/*
 * Decompiled with CFR 0.152.
 */
package DistLib;

import DistLib.uniform;

public class normal {
    private static double SIXTEN = 1.6;
    static final double C1 = 0.398942280401433;
    static final double C2 = 0.180025191068563;
    static final double a = 2.216035867166471;

    public static double density(double x2, double mu, double sigma) {
        if (Double.isNaN(x2) || Double.isNaN(mu) || Double.isNaN(sigma)) {
            return x2 + mu + sigma;
        }
        if (sigma <= 0.0) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        x2 = (x2 - mu) / sigma;
        return 0.3989422804014327 * Math.exp(-0.5 * x2 * x2) / sigma;
    }

    public static double cumulative(double x2, double mu, double sigma) {
        double ccum;
        double result2;
        double[] c = new double[]{0.39894151208813466, 8.883149794388377, 93.50665613217785, 597.2702763948002, 2494.5375852903726, 6848.190450536283, 11602.65143764735, 9842.714838383978, 1.0765576773720192E-8};
        double[] d = new double[]{22.266688044328117, 235.387901782625, 1519.3775994075547, 6485.558298266761, 18615.571640885097, 34900.95272114598, 38912.00328609327, 19685.429676859992};
        double[] p = new double[]{0.215898534057957, 0.12740116116024736, 0.022235277870649807, 0.0014216191932278934, 2.9112874951168793E-5, 0.023073441764940174};
        double[] q = new double[]{1.284260096144911, 0.4682382124808651, 0.06598813786892856, 0.0037823963320275824, 7.297515550839662E-5};
        double[] a = new double[]{2.2352520354606837, 161.02823106855587, 1067.6894854603709, 18154.98125334356, 0.06568233791820745};
        double[] b = new double[]{47.202581904688245, 976.0985517377767, 10260.932208618979, 45507.78933502673};
        if (Double.isNaN(x2) || Double.isNaN(mu) || Double.isNaN(sigma)) {
            return x2 + mu + sigma;
        }
        if (sigma < 0.0) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        if (Double.isInfinite(x2 = (x2 - mu) / sigma)) {
            if (x2 < 0.0) {
                return 0.0;
            }
            return 1.0;
        }
        double eps = 1.110223E-16f;
        double min2 = Double.MIN_VALUE;
        double y = Math.abs(x2);
        if (y <= 0.66291) {
            double xsq = 0.0;
            if (y > eps) {
                xsq = x2 * x2;
            }
            double xnum = a[4] * xsq;
            double xden = xsq;
            int i = 1;
            while (i <= 3) {
                xnum = (xnum + a[i - 1]) * xsq;
                xden = (xden + b[i - 1]) * xsq;
                ++i;
            }
            double temp = result2 = x2 * (xnum + a[3]) / (xden + b[3]);
            result2 = 0.5 + temp;
            ccum = 0.5 - temp;
        } else if (y <= 5.656854249492381) {
            double xnum = c[8] * y;
            double xden = y;
            int i = 1;
            while (i <= 7) {
                xnum = (xnum + c[i - 1]) * y;
                xden = (xden + d[i - 1]) * y;
                ++i;
            }
            result2 = (xnum + c[7]) / (xden + d[7]);
            double xsq = Math.floor(y * SIXTEN) / SIXTEN;
            double del = (y - xsq) * (y + xsq);
            result2 = Math.exp(-xsq * xsq * 0.5) * Math.exp(-del * 0.5) * result2;
            ccum = 1.0 - result2;
            if (x2 > 0.0) {
                double temp = result2;
                result2 = ccum;
                ccum = temp;
            }
        } else if (y < 50.0) {
            result2 = 0.0;
            double xsq = 1.0 / (x2 * x2);
            double xnum = p[5] * xsq;
            double xden = xsq;
            int i = 1;
            while (i <= 4) {
                xnum = (xnum + p[i - 1]) * xsq;
                xden = (xden + q[i - 1]) * xsq;
                ++i;
            }
            result2 = xsq * (xnum + p[4]) / (xden + q[4]);
            result2 = (0.3989422804014327 - result2) / y;
            xsq = Math.floor(x2 * SIXTEN) / SIXTEN;
            double del = (x2 - xsq) * (x2 + xsq);
            result2 = Math.exp(-xsq * xsq * 0.5) * Math.exp(-del * 0.5) * result2;
            ccum = 1.0 - result2;
            if (x2 > 0.0) {
                double temp = result2;
                result2 = ccum;
                ccum = temp;
            }
        } else if (x2 > 0.0) {
            result2 = 1.0;
            ccum = 0.0;
        } else {
            result2 = 0.0;
            ccum = 1.0;
        }
        if (result2 < min2) {
            result2 = 0.0;
        }
        if (ccum < min2) {
            ccum = 0.0;
        }
        return result2;
    }

    public static double quantile(double p, double mu, double sigma) {
        double val;
        if (Double.isNaN(p) || Double.isNaN(mu) || Double.isNaN(sigma)) {
            return p + mu + sigma;
        }
        if (p < 0.0 || p > 1.0) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        double q = p - 0.5;
        if (Math.abs(q) <= 0.42) {
            double r = q * q;
            val = q * (((-25.44106049637 * r + 41.39119773534) * r - 18.61500062529) * r + 2.50662823884) / ((((3.13082909833 * r - 21.06224101826) * r + 23.08336743743) * r + -8.4735109309) * r + 1.0);
        } else {
            double r = p;
            if (q > 0.0) {
                r = 1.0 - p;
            }
            if (r > 2.220446049250313E-16) {
                r = Math.sqrt(-Math.log(r));
                val = (((2.32121276858 * r + 4.85014127135) * r - 2.29796479134) * r - 2.78718931138) / ((1.63706781897 * r + 3.54388924762) * r + 1.0);
                if (q < 0.0) {
                    val = -val;
                }
            } else {
                if (r > 1.0E-300) {
                    double val2 = -2.0 * Math.log(p);
                    r = Math.log(Math.PI * 2 * val2);
                    r = r / val2 + (2.0 - r) / (val2 * val2) + (-14.0 + 6.0 * r - r * r) / (2.0 * val2 * val2 * val2);
                    val2 = Math.sqrt(val2 * (1.0 - r));
                    if (q < 0.0) {
                        val2 = -val2;
                    }
                    return val2;
                }
                throw new ArithmeticException("Math Error: RANGE");
            }
        }
        val -= (normal.cumulative(val, 0.0, 1.0) - p) / normal.density(val, 0.0, 1.0);
        return mu + sigma * val;
    }

    public static double random(double mu, double sigma, uniform PRNG) {
        if (Double.isInfinite(mu) || Double.isInfinite(sigma) || sigma < 0.0) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        if (sigma == 0.0) {
            return mu;
        }
        return mu + sigma * normal.random(PRNG);
    }

    public static double random_AhrensDieter(uniform PRNG) {
        double w;
        double aa;
        double s;
        block11: {
            double[] a = new double[]{0.0, 0.03917609, 0.07841241, 0.1177699, 0.1573107, 0.1970991, 0.2372021, 0.2776904, 0.3186394, 0.3601299, 0.4022501, 0.4450965, 0.4887764, 0.5334097, 0.5791322, 0.626099, 0.6744898, 0.7245144, 0.7764218, 0.8305109, 0.8871466, 0.9467818, 1.00999, 1.077516, 1.150349, 1.229859, 1.318011, 1.417797, 1.534121, 1.67594, 1.862732, 2.153875};
            double[] d = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.2636843, 0.2425085, 0.2255674, 0.2116342, 0.1999243, 0.1899108, 0.1812252, 0.1736014, 0.1668419, 0.1607967, 0.1553497, 0.1504094, 0.1459026, 0.14177, 0.1379632, 0.1344418, 0.1311722, 0.128126, 0.1252791, 0.1226109, 0.1201036, 0.1177417, 0.1155119, 0.1134023, 0.1114027, 0.1095039};
            double[] t2 = new double[]{7.673828E-4, 0.00230687, 0.003860618, 0.005438454, 0.007050699, 0.008708396, 0.01042357, 0.01220953, 0.01408125, 0.01605579, 0.0181529, 0.02039573, 0.02281177, 0.02543407, 0.02830296, 0.03146822, 0.03499233, 0.03895483, 0.04345878, 0.04864035, 0.05468334, 0.06184222, 0.07047983, 0.08113195, 0.09462444, 0.1123001, 0.136498, 0.1716886, 0.2276241, 0.330498, 0.5847031};
            double[] h = new double[]{0.03920617, 0.03932705, 0.03950999, 0.03975703, 0.04007093, 0.04045533, 0.04091481, 0.04145507, 0.04208311, 0.04280748, 0.04363863, 0.04458932, 0.04567523, 0.04691571, 0.04833487, 0.04996298, 0.05183859, 0.05401138, 0.05654656, 0.0595313, 0.06308489, 0.06737503, 0.07264544, 0.07926471, 0.08781922, 0.09930398, 0.1155599, 0.1404344, 0.1836142, 0.2790016, 0.7010474};
            double u = uniform.random();
            s = 0.0;
            if (u > 0.5) {
                s = 1.0;
            }
            u = u + u - s;
            int i = (int)(u *= 32.0);
            if (i == 32) {
                i = 31;
            }
            if (i != 0) {
                double ustar = u - (double)i;
                aa = a[i - 1];
                block0: while (ustar <= t2[i - 1]) {
                    u = uniform.random();
                    w = u * (a[i] - aa);
                    double tt = (w * 0.5 + aa) * w;
                    while (!(ustar > tt)) {
                        u = uniform.random();
                        if (!(ustar < u)) {
                            tt = u;
                            ustar = uniform.random();
                            continue;
                        }
                        ustar = uniform.random();
                        continue block0;
                    }
                    break block11;
                }
                w = (ustar - t2[i - 1]) * h[i - 1];
            } else {
                i = 6;
                aa = a[31];
                while (!((u += u) >= 1.0)) {
                    aa += d[i - 1];
                    ++i;
                }
                u -= 1.0;
                block3: while (true) {
                    double ustar;
                    w = u * d[i - 1];
                    double tt = (w * 0.5 + aa) * w;
                    while (!((ustar = uniform.random()) > tt)) {
                        u = uniform.random();
                        if (!(ustar < u)) {
                            tt = u;
                            continue;
                        }
                        u = uniform.random();
                        continue block3;
                    }
                    break;
                }
            }
        }
        double y = aa + w;
        return s == 1.0 ? -y : y;
    }

    static final double g(double x2) {
        return 0.398942280401433 * Math.exp(-x2 * x2 / 2.0) - 0.180025191068563 * (2.216035867166471 - Math.abs(x2));
    }

    public static double random(uniform PRNG) {
        double t2;
        double u3;
        double u2;
        double u1 = uniform.random();
        if (u1 < 0.884070402298758) {
            double u22 = uniform.random();
            return 2.216035867166471 * (1.1311316354418 * u1 + u22 - 1.0);
        }
        if (u1 >= 0.973310954173898) {
            double u32;
            double t3;
            double u23;
            while (!((u23 = uniform.random()) * u23 < 4.910814964568252 / (t3 = 4.910814964568252 - 2.0 * Math.log(u32 = uniform.random())))) {
            }
            return u1 < 0.986655477086949 ? Math.sqrt(t3) : -Math.sqrt(t3);
        }
        if (u1 >= 0.958720824790463) {
            double t4;
            double u33;
            double u24;
            do {
                u24 = uniform.random();
                u33 = uniform.random();
                t4 = 2.216035867166471 - 0.63083480192196 * Math.min(u24, u33);
                if (!(Math.max(u24, u33) <= 0.755591531667601)) continue;
                return u24 < u33 ? t4 : -t4;
            } while (!(0.034240503750111 * Math.abs(u24 - u33) <= normal.g(t4)));
            return u24 < u33 ? t4 : -t4;
        }
        if (u1 >= 0.911312780288703) {
            u2 = uniform.random();
            u3 = uniform.random();
            t2 = 0.479727404222441 + 1.10547366102207 * Math.min(u2, u3);
            if (Math.max(u2, u3) <= 0.87283497667179) {
                return u2 < u3 ? t2 : -t2;
            }
            if (0.049264496373128 * Math.abs(u2 - u3) <= normal.g(t2)) {
                return u2 < u3 ? t2 : -t2;
            }
        }
        do {
            u2 = uniform.random();
            u3 = uniform.random();
            t2 = 0.479727404222441 - 0.59550713801594 * Math.min(u2, u3);
        } while (!(Math.max(u2, u3) <= 0.805577924423817));
        return u2 < u3 ? t2 : -t2;
    }
}

