/*
 * Decompiled with CFR 0.152.
 */
package org.junit.experimental.theories;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.junit.experimental.theories.DataPoint;
import org.junit.experimental.theories.ParameterSupplier;
import org.junit.experimental.theories.ParametersSuppliedBy;
import org.junit.experimental.theories.PotentialParameterValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterSignature {
    private final Class<?> type;
    private final Annotation[] annotations;

    public static ArrayList<ParameterSignature> signatures(Method method) {
        ArrayList<ParameterSignature> sigs = new ArrayList<ParameterSignature>();
        for (int i = 0; i < method.getParameterTypes().length; ++i) {
            sigs.add(new ParameterSignature(method.getParameterTypes()[i], method.getParameterAnnotations()[i]));
        }
        return sigs;
    }

    private ParameterSignature(Class<?> type, Annotation[] annotations) {
        this.type = type;
        this.annotations = annotations;
    }

    public Annotation getSupplierAnnotation() {
        for (Annotation annotation : this.annotations) {
            if (this.getSupplier(annotation) == null) continue;
            return annotation;
        }
        return null;
    }

    public ParametersSuppliedBy getSupplier(Annotation annotation) {
        return annotation.annotationType().getAnnotation(ParametersSuppliedBy.class);
    }

    public boolean canAcceptField(Field field2) {
        return this.type.isAssignableFrom(field2.getType());
    }

    public boolean canAcceptMethod(Method method) {
        return method.isAnnotationPresent(DataPoint.class) && this.type.isAssignableFrom(method.getReturnType());
    }

    public ParameterSupplier getAnnotatedSupplier() throws InstantiationException, IllegalAccessException {
        Annotation annotation = this.getSupplierAnnotation();
        if (annotation != null) {
            return this.getSupplier(annotation).value().newInstance();
        }
        return null;
    }

    public ParameterSupplier getSupplier(Class<?> targetClass) throws InstantiationException, IllegalAccessException {
        ParameterSupplier supplier = this.getAnnotatedSupplier();
        if (supplier != null) {
            return supplier;
        }
        return ParameterSignature.fieldParameterSupplier(targetClass);
    }

    public List<PotentialParameterValue> getPotentialValues(Object container) throws InstantiationException, IllegalAccessException {
        return this.getSupplier(container.getClass()).getValueSources(container, this);
    }

    public static ParameterSupplier fieldParameterSupplier(final Class<?> targetClass) {
        return new ParameterSupplier(){

            @Override
            public List<PotentialParameterValue> getValueSources(Object test2, ParameterSignature sig) {
                ArrayList<PotentialParameterValue> list2 = new ArrayList<PotentialParameterValue>();
                for (Field field2 : targetClass.getFields()) {
                    if (!sig.canAcceptField(field2)) continue;
                    try {
                        list2.add(PotentialParameterValue.forValue(field2.get(test2)));
                    }
                    catch (IllegalArgumentException e) {
                        throw new RuntimeException("unexpected: field from getClass doesn't exist on object");
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException("unexpected: getFields returned an inaccessible field");
                    }
                }
                for (AccessibleObject accessibleObject : targetClass.getMethods()) {
                    if (((Method)accessibleObject).getParameterTypes().length != 0 || !sig.canAcceptMethod((Method)accessibleObject)) continue;
                    list2.add(new PotentialParameterValue((Method)accessibleObject, test2){
                        final /* synthetic */ Method val$method;
                        final /* synthetic */ Object val$test;
                        {
                            this.val$method = method;
                            this.val$test = object;
                        }

                        public Object getValue() throws PotentialParameterValue.CouldNotGenerateValueException {
                            try {
                                return this.val$method.invoke(this.val$test, new Object[0]);
                            }
                            catch (IllegalArgumentException e) {
                                throw new RuntimeException("unexpected: argument length is checked");
                            }
                            catch (IllegalAccessException e) {
                                throw new RuntimeException("unexpected: getMethods returned an inaccessible method");
                            }
                            catch (InvocationTargetException e) {
                                throw new PotentialParameterValue.CouldNotGenerateValueException();
                            }
                        }
                    });
                }
                return list2;
            }
        };
    }
}

