/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.vcf;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.snpeff.align.VcfRefAltAlign;
import org.snpeff.fileIterator.VcfFileIterator;
import org.snpeff.interval.Cds;
import org.snpeff.interval.Chromosome;
import org.snpeff.interval.Marker;
import org.snpeff.interval.Variant;
import org.snpeff.interval.VariantBnd;
import org.snpeff.util.Gpr;
import org.snpeff.vcf.EffFormatVersion;
import org.snpeff.vcf.VcfEffect;
import org.snpeff.vcf.VcfGenotype;
import org.snpeff.vcf.VcfHeader;
import org.snpeff.vcf.VcfHeaderInfo;
import org.snpeff.vcf.VcfInfoType;
import org.snpeff.vcf.VcfLof;
import org.snpeff.vcf.VcfNmd;

public class VcfEntry
extends Marker
implements Iterable<VcfGenotype> {
    public static final String FILTER_PASS = "PASS";
    public static final char WITHIN_FIELD_SEP = ',';
    public static final String SUB_FIELD_SEP = ";";
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final double ALLELE_FEQUENCY_COMMON = 0.05;
    public static final double ALLELE_FEQUENCY_LOW = 0.01;
    public static final Pattern INFO_KEY_PATTERN = Pattern.compile("[\\p{Alpha}_][\\p{Alnum}._]*");
    public static final String VCF_INFO_END = "END";
    public static final String VCF_ALT_NON_REF = "<*>";
    public static final String VCF_ALT_NON_REF_gVCF = "<NON_REF>";
    public static final String VCF_ALT_MISSING_REF = "*";
    public static final String[] VCF_ALT_NON_REF_gVCF_ARRAY = new String[]{"<NON_REF>"};
    public static final String[] VCF_ALT_NON_REF_ARRAY = new String[]{"<*>"};
    public static final String[] VCF_ALT_MISSING_REF_ARRAY = new String[]{"*"};
    public static final String VCF_INFO_HOMS = "HO";
    public static final String VCF_INFO_HETS = "HE";
    public static final String VCF_INFO_NAS = "NA";
    public static final String VCF_INFO_PRIVATE = "Private";
    private static final Map<String, String> INFO_VALUE_ENCODE = new HashMap<String, String>();
    private static final long serialVersionUID = 4226374412681243433L;
    protected String[] alts;
    protected String altStr;
    protected String chromosomeName;
    protected String filter;
    protected String format;
    protected String[] formatFields;
    protected String[] genotypeFields;
    protected String genotypeFieldsStr;
    protected byte[] genotypeScores;
    protected HashMap<String, String> info;
    protected String infoStr = "";
    protected String line;
    protected int lineNum;
    protected Double quality;
    protected String ref;
    protected LinkedList<Variant> variants;
    protected List<VcfEffect> vcfEffects;
    protected VcfFileIterator vcfFileIterator;
    protected ArrayList<VcfGenotype> vcfGenotypes = null;

    public static boolean isEmpty(String value2) {
        if (value2 == null || value2.isEmpty() || value2.equals(".")) {
            return true;
        }
        if (value2.indexOf(44) >= 0) {
            String[] values2;
            for (String val : values2 = value2.split(",")) {
                if (val.isEmpty() || val.equals(".")) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isValidInfoKey(String key) {
        Matcher m = INFO_KEY_PATTERN.matcher(key);
        return m.matches();
    }

    public static boolean isValidInfoValue(String value2) {
        boolean invalid = value2 != null && (value2.indexOf(32) >= 0 || value2.indexOf(59) >= 0 || value2.indexOf(61) >= 0 || value2.indexOf(9) >= 0 || value2.indexOf(10) >= 0);
        return !invalid;
    }

    public static String vcfInfoDecode(String str) {
        if (str == null || str.isEmpty() || str.equals(".")) {
            return str;
        }
        for (String encoded : INFO_VALUE_ENCODE.keySet()) {
            str = str.replace(encoded, INFO_VALUE_ENCODE.get(encoded));
        }
        return str;
    }

    public static String vcfInfoEncode(String str) {
        if (str == null || str.isEmpty() || str.equals(".")) {
            return str;
        }
        for (String encoded : INFO_VALUE_ENCODE.keySet()) {
            str = str.replace(INFO_VALUE_ENCODE.get(encoded), encoded);
        }
        return str.replaceAll(" ", "_");
    }

    public static String vcfInfoKeySafe(String str) {
        if (str == null) {
            return str;
        }
        char c0 = (str = str.replaceAll("[^a-zA-Z0-9_.]", "_")).charAt(0);
        if (c0 != '_' && !Character.isAlphabetic(c0)) {
            str = '_' + str;
        }
        return str;
    }

    public static String vcfInfoValueSafe(String str) {
        if (str == null) {
            return str;
        }
        return str.replaceAll("[ ,;|=()\t]", "_");
    }

    public VcfEntry(VcfFileIterator vcfFileIterator, Marker parent, String chromosomeName, int start, String id, String ref, String altsStr, double quality, String filterPass, String infoStr, String format2) {
        super(parent, start, start + ref.length() - 1, false, id);
        this.chromosomeName = chromosomeName;
        this.ref = ref;
        this.parseAlts(altsStr);
        this.quality = quality;
        this.filter = filterPass;
        this.infoStr = infoStr;
        this.parseInfo();
        this.format = format2;
        this.parseEnd(altsStr);
    }

    public VcfEntry(VcfFileIterator vcfFileIterator, String line, int lineNum, boolean parseNow) {
        super(null, 0, 0, false, "");
        this.vcfFileIterator = vcfFileIterator;
        this.lineNum = lineNum;
        this.line = line;
        if (parseNow) {
            this.parse();
        }
    }

    public void addFilter(String filterStr) {
        if (this.filter.equals(".") || this.filter.equals(FILTER_PASS)) {
            this.filter = "";
        }
        this.filter = this.filter + (!this.filter.isEmpty() ? SUB_FIELD_SEP : "") + filterStr;
    }

    public void addFormat(String formatName) {
        if (this.format == null) {
            this.format = "";
        }
        if (this.format.indexOf(formatName) >= 0) {
            throw new RuntimeException("Format field '" + formatName + "' already exists!");
        }
        this.format = this.format + (this.format.endsWith(":") ? "" : ":") + formatName;
    }

    public void addGenotype(String vcfGenotypeStr) {
        if (this.vcfGenotypes == null) {
            this.vcfGenotypes = new ArrayList();
        }
        if (this.format == null) {
            this.format = "";
        }
        this.vcfGenotypes.add(new VcfGenotype(this, this.format, vcfGenotypeStr));
        this.genotypeScores = null;
    }

    public void addInfo(String key, String value2) {
        if (!VcfEntry.isValidInfoKey(key)) {
            throw new RuntimeException("Illegal INFO key / name. Key: \"" + key + "\" does not match regular expression ^[A-Za-z_][0-9A-Za-z_.]*$");
        }
        if (!VcfEntry.isValidInfoValue(value2)) {
            throw new RuntimeException("No white-space, semi-colons, or equals-signs are permitted in INFO field values. Name:\"" + key + "\" Value:\"" + value2 + "\"");
        }
        this.removeInfo(key);
        boolean isFlag = false;
        VcfHeader vcfHeader = this.vcfFileIterator.getVcfHeader();
        if (vcfHeader != null) {
            VcfHeaderInfo vcfHeaderInfo = this.vcfFileIterator.getVcfHeader().getVcfHeaderInfo(key);
            boolean bl = isFlag = vcfHeaderInfo != null && vcfHeaderInfo.getVcfInfoType() == VcfInfoType.Flag;
        }
        if (this.info != null) {
            this.info.put(key, value2);
        }
        String addInfoStr = key + (value2 != null && !isFlag ? "=" + value2 : "");
        if (this.infoStr == null || this.infoStr.isEmpty()) {
            this.infoStr = addInfoStr;
        } else {
            if (!this.infoStr.endsWith(SUB_FIELD_SEP)) {
                this.infoStr = this.infoStr + SUB_FIELD_SEP;
            }
            this.infoStr = this.infoStr + addInfoStr;
        }
    }

    public AlleleFrequencyType alleleFrequencyType() {
        double maf = this.maf();
        if (maf <= 0.01) {
            return AlleleFrequencyType.Rare;
        }
        if (maf <= 0.05) {
            return AlleleFrequencyType.LowFrequency;
        }
        return AlleleFrequencyType.Common;
    }

    public Boolean calcHetero() {
        if (this.genotypeFieldsStr == null) {
            return this.isMultiallelic();
        }
        Boolean isHetero = null;
        if (this.genotypeFields == null) {
            int countFields = 0;
            for (int fromIndex = 0; fromIndex >= 0 && countFields < 1; ++countFields, ++fromIndex) {
                fromIndex = this.genotypeFieldsStr.indexOf(9, fromIndex);
            }
            if (countFields == 1) {
                this.parseGenotypes();
            }
        }
        if (this.genotypeFields != null && this.genotypeFields.length == 1) {
            isHetero = this.getVcfGenotype(0).isHeterozygous();
        }
        return isHetero;
    }

    public String check() {
        StringBuilder sb = new StringBuilder();
        if (this.ref.indexOf(",") >= 0) {
            sb.append("REF field has multiple entries (this is not allowed)\n");
        }
        for (String infoName : this.getInfoKeys()) {
            String err2 = this.checkInfo(infoName);
            if (err2.isEmpty()) continue;
            sb.append(err2 + "\n");
        }
        sb.append(this.checkGenotypes());
        return sb.toString();
    }

    String checkGenotypes() {
        int numSamples;
        int numGt;
        StringBuilder err2 = new StringBuilder();
        if (this.getVcfFileIterator() != null && this.getVcfFileIterator().getVcfHeader() != null && (numGt = this.getVcfGenotypes().size()) != (numSamples = this.getVcfFileIterator().getVcfHeader().getNumberOfSamples())) {
            err2.append("Number of genotypes (" + numGt + ") differs form the number of samples (" + numSamples + ")\n");
        }
        int numAlts = this.getAlts().length;
        int gtNum = 1;
        for (VcfGenotype vgt : this.getVcfGenotypes()) {
            int[] gts = vgt.getGenotype();
            if (gts != null) {
                for (int i = 0; i < gts.length; ++i) {
                    if (gts[i] <= numAlts) continue;
                    err2.append("Genotype number " + gtNum + " has genotype number '" + gts[i] + "', but there are only '" + numAlts + "' ALTs.\n");
                }
            }
            ++gtNum;
        }
        return err2.toString();
    }

    String checkInfo(String infoName) {
        VcfInfoType type;
        String[] values2;
        if (infoName.isEmpty()) {
            return "";
        }
        VcfHeaderInfo vcfInfo = this.getVcfInfo(infoName);
        if (vcfInfo == null) {
            return "Cannot find header for INFO field '" + infoName + "'";
        }
        String valsStr = this.getInfo(infoName);
        if (valsStr == null) {
            return "";
        }
        for (String val : values2 = valsStr.split(",")) {
            if (VcfEntry.isValidInfoValue(val)) continue;
            return "INFO field '" + infoName + "' has an invalid value '" + val + "' (no spaces, tabs, '=' or ';' are allowed)";
        }
        if (vcfInfo.isNumberNumber() && vcfInfo.getNumber() != values2.length && ((type = vcfInfo.getVcfInfoType()) != VcfInfoType.Flag || values2.length != 1)) {
            return "INFO filed '" + infoName + "' has 'Number=" + vcfInfo.getNumber() + "' in header, but it contains '" + values2.length + "' elements.";
        }
        if (vcfInfo.isNumberAllAlleles() && values2.length != this.alts.length + 1) {
            return "INFO filed '" + infoName + "' has 'Number=R' in header, but it contains '" + values2.length + "' elements when there are '" + this.alts.length + "' alleles (it should have '" + (this.alts.length + 1) + "' elements).";
        }
        if (vcfInfo.isNumberAllAlleles() && values2.length != this.alts.length) {
            return "INFO filed '" + infoName + "' has 'Number=A' in header, but it contains '" + values2.length + "' elements when there are '" + this.alts.length + "' alleles.";
        }
        return "";
    }

    @Override
    public Cds cloneShallow() {
        throw new RuntimeException("Unimplemented!");
    }

    public boolean compressGenotypes() {
        if (this.getAlts().length > 1) {
            return false;
        }
        StringBuilder homs = new StringBuilder();
        StringBuilder hets = new StringBuilder();
        StringBuilder nas = new StringBuilder();
        int idx = 0;
        for (VcfGenotype gen : this.getVcfGenotypes()) {
            int score = gen.getGenotypeCode();
            if (score != 0) {
                if (score < 0) {
                    nas.append((nas.length() > 0 ? "," : "") + idx);
                } else if (score == 1) {
                    hets.append((hets.length() > 0 ? "," : "") + idx);
                } else if (score == 2) {
                    homs.append((homs.length() > 0 ? "," : "") + idx);
                } else {
                    return false;
                }
            }
            ++idx;
        }
        if (homs.length() > 0) {
            this.addInfo(VCF_INFO_HOMS, homs.toString());
        }
        if (hets.length() > 0) {
            this.addInfo(VCF_INFO_HETS, hets.toString());
        }
        if (nas.length() > 0) {
            this.addInfo(VCF_INFO_NAS, nas.toString());
        }
        if (homs.length() == 0 && hets.length() == 0 && nas.length() == 0) {
            this.addInfo(VCF_INFO_NAS, null);
        }
        return true;
    }

    public boolean delFilter(String filterStr) {
        StringBuilder sbFilter = new StringBuilder();
        boolean removed = false;
        for (String f2 : this.filter.split(SUB_FIELD_SEP)) {
            if (!f2.equals(filterStr)) {
                sbFilter.append((sbFilter.length() > 0 ? SUB_FIELD_SEP : "") + f2);
                continue;
            }
            removed = true;
        }
        if (removed) {
            this.filter = sbFilter.toString();
        }
        return removed;
    }

    public int getAltIndex(String alt) {
        for (int i = 0; i < this.alts.length; ++i) {
            if (!this.alts[i].equalsIgnoreCase(alt)) continue;
            return i;
        }
        return -1;
    }

    public String[] getAlts() {
        return this.alts;
    }

    public String getAltsStr() {
        if (this.altStr != null) {
            if (this.altStr.isEmpty()) {
                return ".";
            }
            return this.altStr;
        }
        if (this.alts == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String alt : this.alts) {
            sb.append(alt + " ");
        }
        this.altStr = sb.toString().trim().replace(' ', ',');
        return this.altStr;
    }

    @Override
    public String getChromosomeNameOri() {
        return this.chromosomeName;
    }

    public String getFilter() {
        return this.filter;
    }

    public String getFormat() {
        return this.format;
    }

    public String[] getFormatFields() {
        if (this.formatFields == null) {
            this.formatFields = this.format == null ? new String[0] : this.format.split(":");
        }
        return this.formatFields;
    }

    public synchronized byte[] getGenotypesScores() {
        if (this.genotypeScores != null) {
            return this.genotypeScores;
        }
        if (!this.isCompressedGenotypes()) {
            List<VcfGenotype> vcfGts = this.getVcfGenotypes();
            int numSamples = vcfGts.size();
            this.genotypeScores = new byte[numSamples];
            int idx = 0;
            for (VcfGenotype vcfGt : vcfGts) {
                this.genotypeScores[idx++] = (byte)vcfGt.getGenotypeCode();
            }
            return this.genotypeScores;
        }
        String hoStr = this.getInfo(VCF_INFO_HOMS);
        String heStr = this.getInfo(VCF_INFO_HETS);
        String naStr = this.getInfo(VCF_INFO_NAS);
        int numSamples = this.getNumberOfSamples();
        this.genotypeScores = new byte[numSamples];
        this.parseSparseGt(naStr, this.genotypeScores, -1);
        this.parseSparseGt(heStr, this.genotypeScores, 1);
        this.parseSparseGt(hoStr, this.genotypeScores, 2);
        return this.genotypeScores;
    }

    public String getInfo(String key) {
        if (this.info == null) {
            this.parseInfo();
        }
        return this.info.get(key);
    }

    public String getInfo(String key, String allele) {
        String infoStr;
        if (this.info == null) {
            this.parseInfo();
        }
        if ((infoStr = this.info.get(key)) == null) {
            return null;
        }
        String[] infos = infoStr.split(",");
        int firstAltIndex = 0;
        VcfHeaderInfo vcfInfo = this.getVcfInfo(key);
        if (vcfInfo != null && vcfInfo.isNumberAllAlleles()) {
            firstAltIndex = 1;
            if (this.ref.equalsIgnoreCase(allele)) {
                return infos[0];
            }
        }
        int i = 0;
        for (int j = firstAltIndex; i < this.alts.length && j < infos.length; ++i, ++j) {
            if (!this.alts[i].equalsIgnoreCase(allele)) continue;
            return infos[j];
        }
        return null;
    }

    public String getInfo(String key, Variant var) {
        String infoStr;
        if (this.info == null) {
            this.parseInfo();
        }
        if ((infoStr = this.info.get(key)) == null) {
            return null;
        }
        String[] infos = infoStr.split(",");
        int firstAltIndex = 0;
        VcfHeaderInfo vcfInfo = this.getVcfInfo(key);
        if (vcfInfo != null && vcfInfo.isNumberAllAlleles()) {
            firstAltIndex = 1;
            if (!var.isVariant()) {
                return infos[0];
            }
        }
        int i = firstAltIndex;
        String gtPrev = "";
        for (Variant v : this.variants()) {
            if (i >= infos.length) break;
            if (var.equals(v)) {
                return infos[i];
            }
            if (v.getGenotype().equals(gtPrev)) continue;
            ++i;
        }
        return null;
    }

    public boolean getInfoFlag(String key) {
        if (this.info == null) {
            this.parseInfo();
        }
        return this.info.containsKey(key);
    }

    public double getInfoFloat(String key) {
        String f2;
        if (this.info == null) {
            this.parseInfo();
        }
        if ((f2 = this.info.get(key)) == null) {
            return Double.NaN;
        }
        return Gpr.parseDoubleSafe(f2);
    }

    public long getInfoInt(String key) {
        String i;
        if (this.info == null) {
            this.parseInfo();
        }
        if ((i = this.info.get(key)) == null) {
            return 0L;
        }
        return Gpr.parseLongSafe(i);
    }

    public Set<String> getInfoKeys() {
        if (this.info == null) {
            this.parseInfo();
        }
        return this.info.keySet();
    }

    public String getInfoStr() {
        return this.infoStr;
    }

    public String getLine() {
        return this.line;
    }

    public int getLineNum() {
        return this.lineNum;
    }

    public int getNumberOfSamples() {
        if (this.vcfFileIterator == null) {
            return 0;
        }
        VcfHeader vh = this.vcfFileIterator.getVcfHeader();
        if (vh == null) {
            return 0;
        }
        return vh.getNumberOfSamples();
    }

    public double getQuality() {
        return this.quality != null ? this.quality : 0.0;
    }

    public String getRef() {
        return this.ref;
    }

    public String getStr() {
        return this.getChromosomeName() + ":" + (this.start + 1) + "_" + this.ref + "/" + this.getAltsStr();
    }

    public List<VcfEffect> getVcfEffects() {
        return this.getVcfEffects(null);
    }

    public synchronized List<VcfEffect> getVcfEffects(EffFormatVersion formatVersion) {
        String[] effs;
        if (this.vcfEffects != null) {
            return this.vcfEffects;
        }
        String effStr = null;
        if (formatVersion == null) {
            effStr = this.getInfo("ANN");
            if (effStr != null) {
                formatVersion = EffFormatVersion.FORMAT_ANN;
            } else {
                effStr = this.getInfo("EFF");
                if (effStr != null) {
                    formatVersion = EffFormatVersion.FORMAT_EFF;
                }
            }
        } else {
            String effFieldName = VcfEffect.infoFieldName(formatVersion);
            effStr = this.getInfo(effFieldName);
        }
        this.vcfEffects = new ArrayList<VcfEffect>();
        if (effStr == null || effStr.isEmpty() || effStr.equals("true")) {
            return this.vcfEffects;
        }
        for (String eff : effs = effStr.split(",")) {
            VcfEffect veff = new VcfEffect(eff, formatVersion);
            this.vcfEffects.add(veff);
        }
        return this.vcfEffects;
    }

    public VcfFileIterator getVcfFileIterator() {
        return this.vcfFileIterator;
    }

    public VcfGenotype getVcfGenotype(int index) {
        return this.getVcfGenotypes().get(index);
    }

    public List<VcfGenotype> getVcfGenotypes() {
        if (this.vcfGenotypes == null) {
            this.parseGenotypes();
        }
        return this.vcfGenotypes;
    }

    public VcfHeaderInfo getVcfInfo(String id) {
        return this.vcfFileIterator.getVcfHeader().getVcfHeaderInfo(id);
    }

    public VcfInfoType getVcfInfoNumber(String id) {
        VcfHeaderInfo vcfInfo = this.vcfFileIterator.getVcfHeader().getVcfHeaderInfo(id);
        if (vcfInfo == null) {
            return null;
        }
        return vcfInfo.getVcfInfoType();
    }

    public boolean hasField(String filedName) {
        return this.vcfFileIterator.getVcfHeader().getVcfHeaderInfo(filedName) != null;
    }

    public boolean hasGenotypes() {
        return this.vcfGenotypes != null && this.vcfGenotypes.size() > 0 || this.genotypeFieldsStr != null;
    }

    public boolean hasInfo(String infoFieldName) {
        if (this.info == null) {
            this.parseInfo();
        }
        return this.info.containsKey(infoFieldName);
    }

    public boolean hasQuality() {
        return this.quality != null;
    }

    public boolean isBiAllelic() {
        if (this.alts == null) {
            return false;
        }
        return this.alts.length == 1;
    }

    public boolean isCompressedGenotypes() {
        return !this.hasGenotypes() && this.getNumberOfSamples() > 0 && (this.hasInfo(VCF_INFO_HOMS) || this.hasInfo(VCF_INFO_HETS) || this.hasInfo(VCF_INFO_NAS));
    }

    public boolean isFilterPass() {
        return this.filter.equals(FILTER_PASS);
    }

    public boolean isMultiallelic() {
        if (this.alts == null) {
            return false;
        }
        return this.alts.length > 1;
    }

    @Override
    protected boolean isShowWarningIfParentDoesNotInclude() {
        return false;
    }

    public boolean isSingleSnp() {
        return this.ref != null && this.altStr != null && this.ref.length() == 1 && this.altStr.length() == 1 && !this.ref.equalsIgnoreCase(this.altStr);
    }

    public boolean isSingleton() {
        int count2 = 0;
        for (VcfGenotype gen : this) {
            if (gen.isVariant()) {
                ++count2;
            }
            if (count2 <= 1) continue;
            return false;
        }
        return count2 == 1;
    }

    public boolean isVariant() {
        if (this.alts == null || this.alts.length == 0) {
            return false;
        }
        for (String alt : this.alts) {
            if (!this.isVariant(alt)) continue;
            return true;
        }
        return false;
    }

    public boolean isVariant(String alt) {
        return alt != null && !alt.isEmpty() && !alt.equals(".") && !alt.equals(VCF_ALT_NON_REF) && !alt.equals(VCF_ALT_NON_REF_gVCF) && !alt.equals(VCF_ALT_MISSING_REF) && !alt.equals(this.ref);
    }

    @Override
    public Iterator<VcfGenotype> iterator() {
        return this.getVcfGenotypes().iterator();
    }

    public int mac() {
        long ac = -1L;
        if (this.hasField("MAC")) {
            return (int)this.getInfoInt("MAC");
        }
        if (this.hasField("AC")) {
            ac = this.getInfoInt("AC");
        }
        if (ac <= 0L) {
            ac = 0L;
            for (byte genCode : this.getGenotypesScores()) {
                if (genCode <= 0) continue;
                ac += (long)genCode;
            }
        }
        int numSamples = 0;
        List<String> sampleNames = this.vcfFileIterator.getVcfHeader().getSampleNames();
        numSamples = sampleNames != null ? sampleNames.size() : this.getVcfGenotypes().size();
        if (numSamples > 1 && ac > (long)numSamples) {
            ac = (long)(2 * numSamples) - ac;
        }
        return (int)ac;
    }

    public double maf() {
        double maf = -1.0;
        if (this.hasField("AF")) {
            maf = this.getInfoFloat("AF");
        } else if (this.hasField("MAF")) {
            maf = this.getInfoFloat("MAF");
        } else {
            int ac = 0;
            int count2 = 0;
            for (VcfGenotype gen : this) {
                count2 += 2;
                int genCode = gen.getGenotypeCode();
                if (genCode <= 0) continue;
                ac += genCode;
            }
            maf = (double)ac / (double)count2;
        }
        if (maf > 0.5) {
            maf = 1.0 - maf;
        }
        return maf;
    }

    public void parse() {
        String[] fields = this.line.split("\t", 10);
        if (fields.length >= 4) {
            this.chromosomeName = fields[0].trim();
            Chromosome chromo = this.vcfFileIterator.getChromosome(this.chromosomeName);
            this.parent = chromo;
            this.vcfFileIterator.sanityCheckChromo(this.chromosomeName, chromo);
            this.start = this.vcfFileIterator.parsePosition(this.vcfFileIterator.readField(fields, 1));
            this.id = this.vcfFileIterator.readField(fields, 2);
            this.ref = this.vcfFileIterator.readField(fields, 3).toUpperCase();
            this.strandMinus = false;
            this.altStr = this.vcfFileIterator.readField(fields, 4).toUpperCase();
            this.parseAlts(this.altStr);
            String qStr = this.vcfFileIterator.readField(fields, 5);
            this.quality = !qStr.isEmpty() ? Double.valueOf(Gpr.parseDoubleSafe(qStr)) : null;
            this.filter = this.vcfFileIterator.readField(fields, 6);
            this.infoStr = this.vcfFileIterator.readField(fields, 7);
            this.info = null;
            this.parseEnd(this.altStr);
            this.format = null;
            if (fields.length > 8) {
                this.format = this.vcfFileIterator.readField(fields, 8);
            }
            if (fields.length > 9) {
                this.genotypeFieldsStr = fields[9];
            }
        } else {
            throw new RuntimeException("Impropper VCF entry: Not enough fields (missing tab separators?).\n" + this.line);
        }
    }

    void parseAlts(String altsStr) {
        if (altsStr.length() == 1 || altsStr.indexOf(44) < 0) {
            this.alts = this.parseAltSingle(altsStr);
            if (this.alts == null) {
                this.alts = new String[0];
            }
        } else {
            String[] altsSplit;
            ArrayList<String> altsList = new ArrayList<String>();
            for (String altSingle : altsSplit = altsStr.split(",")) {
                String[] altsTmp = this.parseAltSingle(altSingle);
                if (altsTmp == null) continue;
                for (String alt : altsTmp) {
                    altsList.add(alt);
                }
            }
            this.alts = altsList.toArray(EMPTY_STRING_ARRAY);
        }
    }

    String[] parseAltSingle(String altsStr) {
        String[] alts;
        if (altsStr.length() != 1 || !this.isVariant(altsStr) || !this.vcfFileIterator.isExpandIub()) {
            String[] alts2 = new String[]{altsStr};
            return alts2;
        }
        if (altsStr.equals(VCF_ALT_NON_REF)) {
            return VCF_ALT_NON_REF_ARRAY;
        }
        if (altsStr.equals(VCF_ALT_MISSING_REF)) {
            return VCF_ALT_MISSING_REF_ARRAY;
        }
        if (altsStr.equals(VCF_ALT_NON_REF_gVCF)) {
            return VCF_ALT_NON_REF_gVCF_ARRAY;
        }
        switch (altsStr) {
            case "A": 
            case "C": 
            case "G": 
            case "T": 
            case "*": 
            case ".": {
                alts = new String[]{altsStr};
                break;
            }
            case "N": {
                alts = new String[]{"A", "C", "G", "T"};
                break;
            }
            case "B": {
                alts = new String[]{"C", "G", "T"};
                break;
            }
            case "D": {
                alts = new String[]{"A", "G", "T"};
                break;
            }
            case "H": {
                alts = new String[]{"A", "C", "T"};
                break;
            }
            case "V": {
                alts = new String[]{"A", "C", "G"};
                break;
            }
            case "M": {
                alts = new String[]{"A", "C"};
                break;
            }
            case "R": {
                alts = new String[]{"A", "G"};
                break;
            }
            case "W": {
                alts = new String[]{"A", "T"};
                break;
            }
            case "S": {
                alts = new String[]{"C", "G"};
                break;
            }
            case "Y": {
                alts = new String[]{"C", "T"};
                break;
            }
            case "K": {
                alts = new String[]{"G", "T"};
                break;
            }
            default: {
                throw new RuntimeException("WARNING: Unkown IUB code for SNP '" + altsStr + "'");
            }
        }
        return alts;
    }

    void parseEnd(String altStr) {
        this.end = this.start + this.ref.length() - 1;
        if (altStr.indexOf(60) >= 0 && this.getInfo(VCF_INFO_END) != null) {
            this.end = (int)this.getInfoInt(VCF_INFO_END) - 1;
            if (this.end < this.start) {
                throw new RuntimeException("INFO field 'END' is before varaint's 'POS'\n\tEND : " + this.end + "\n\tPOS : " + this.start);
            }
        }
    }

    void parseGenotypes() {
        if (this.isCompressedGenotypes()) {
            this.uncompressGenotypes();
        } else {
            this.vcfGenotypes = new ArrayList();
            if (this.genotypeFieldsStr == null) {
                return;
            }
            this.genotypeFields = this.genotypeFieldsStr.split("\t");
            for (int i = 0; i < this.genotypeFields.length; ++i) {
                String gen = this.genotypeFields[i];
                if (gen.equals(".")) {
                    gen = "";
                }
                this.addGenotype(gen);
            }
        }
    }

    void parseInfo() {
        this.info = new HashMap();
        for (String inf : this.infoStr.split(SUB_FIELD_SEP)) {
            String[] vp = inf.split("=", 2);
            if (vp.length > 1) {
                this.info.put(vp[0], vp[1]);
                continue;
            }
            this.info.put(vp[0], "true");
        }
    }

    public List<VcfLof> parseLof() {
        String[] lofs;
        String lofStr = this.getInfo("LOF");
        ArrayList<VcfLof> lofList = new ArrayList<VcfLof>();
        if (lofStr == null || lofStr.isEmpty()) {
            return lofList;
        }
        for (String lof : lofs = lofStr.split(",")) {
            lofList.add(new VcfLof(this, lof));
        }
        return lofList;
    }

    public List<VcfNmd> parseNmd() {
        String[] nmds;
        String nmdStr = this.getInfo("NMD");
        ArrayList<VcfNmd> nmdList = new ArrayList<VcfNmd>();
        if (nmdStr == null || nmdStr.isEmpty()) {
            return nmdList;
        }
        for (String nmd : nmds = nmdStr.split(",")) {
            nmdList.add(new VcfNmd(nmd));
        }
        return nmdList;
    }

    void parseSparseGt(String str, byte[] gt, int valueInt) {
        if (str == null || str.isEmpty() || str.equals("true")) {
            return;
        }
        String[] idxs = str.split(",");
        byte value2 = (byte)valueInt;
        for (String idx : idxs) {
            int i = Gpr.parseIntSafe(idx);
            gt[i] = value2;
        }
    }

    public void removeInfo(String key) {
        if (!this.infoStr.contains(key)) {
            return;
        }
        StringBuilder infoStrNew = new StringBuilder();
        for (String infoEntry : this.infoStr.split(SUB_FIELD_SEP)) {
            String[] keyValuePair = infoEntry.split("=", 2);
            if (keyValuePair[0].equals(key)) continue;
            if (infoStrNew.length() > 0) {
                infoStrNew.append(';');
            }
            infoStrNew.append(infoEntry);
        }
        this.infoStr = infoStrNew.toString();
        if (this.info != null) {
            this.info.remove(key);
        }
        if (EffFormatVersion.isEffectVcfInfoField(key)) {
            this.vcfEffects = null;
        }
    }

    public boolean rmInfo(String info) {
        boolean deleted = false;
        StringBuilder infoSb = new StringBuilder();
        for (String inf : this.infoStr.split(SUB_FIELD_SEP)) {
            String[] vp = inf.split("=");
            if (vp[0].equals(info)) {
                deleted = true;
                continue;
            }
            if (infoSb.length() > 0) {
                infoSb.append(SUB_FIELD_SEP);
            }
            infoSb.append(vp[0]);
            if (vp.length <= 1) continue;
            infoSb.append("=");
            infoSb.append(vp[1]);
        }
        if (deleted) {
            this.infoStr = infoSb.toString();
        }
        return deleted;
    }

    public void setFilter(String filter2) {
        this.filter = filter2;
    }

    public void setFormat(String format2) {
        this.format = format2;
    }

    public void setGenotypeStr(String genotypeFieldsStr) {
        this.genotypeFieldsStr = genotypeFieldsStr;
    }

    public void setLineNum(int lineNum) {
        this.lineNum = lineNum;
    }

    @Override
    public String toStr() {
        return this.getClass().getSimpleName() + "_" + this.getChromosomeName() + ":" + (this.start + 1) + "_" + this.ref + "/" + this.getAltsStr();
    }

    @Override
    public String toString() {
        boolean deleteLastTab = true;
        StringBuilder sb = new StringBuilder(this.toStringNoGt());
        sb.append("\t");
        if (this.format != null) {
            sb.append((this.format.isEmpty() ? "." : this.format) + "\t");
            if (this.vcfGenotypes != null && !this.vcfGenotypes.isEmpty()) {
                for (VcfGenotype vg : this.vcfGenotypes) {
                    sb.append(vg + "\t");
                }
            } else if (this.genotypeFieldsStr != null) {
                sb.append(this.genotypeFieldsStr);
                deleteLastTab = false;
            }
        }
        if (deleteLastTab) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public String toStringNoGt() {
        String chr = null;
        chr = this.chromosomeName != null ? this.chromosomeName : (this.parent != null && this.parent instanceof Chromosome ? this.parent.getId() : (this.parent != null ? this.getChromosomeName() : "."));
        StringBuilder sb = new StringBuilder(chr + "\t" + (this.start + 1) + "\t" + (this.id.isEmpty() ? "." : this.id));
        String refStr = this.ref == null || this.ref.isEmpty() ? "." : this.ref;
        sb.append("\t" + refStr);
        sb.append("\t" + this.getAltsStr());
        sb.append("\t" + (this.quality != null ? this.quality + "" : "."));
        sb.append("\t" + (this.filter == null || this.filter.isEmpty() ? "." : this.filter));
        sb.append("\t" + (this.infoStr == null || this.infoStr.isEmpty() ? "." : this.infoStr));
        return sb.toString();
    }

    public VcfEntry uncompressGenotypes() {
        if (!this.isCompressedGenotypes()) {
            return this;
        }
        String hoStr = this.getInfo(VCF_INFO_HOMS);
        String heStr = this.getInfo(VCF_INFO_HETS);
        String naStr = this.getInfo(VCF_INFO_NAS);
        List<String> sampleNames = this.getVcfFileIterator().getVcfHeader().getSampleNames();
        if (sampleNames == null) {
            throw new RuntimeException("Cannot find sample names in VCF header. Unable to uncompress genotypes.");
        }
        int numSamples = sampleNames.size();
        byte[] gt = new byte[numSamples];
        this.parseSparseGt(naStr, gt, -1);
        this.parseSparseGt(heStr, gt, 1);
        this.parseSparseGt(hoStr, gt, 2);
        if (hoStr != null) {
            this.rmInfo(VCF_INFO_HOMS);
        }
        if (heStr != null) {
            this.rmInfo(VCF_INFO_HETS);
        }
        if (naStr != null) {
            this.rmInfo(VCF_INFO_NAS);
        }
        this.setFormat("GT");
        for (int i = 0; i < gt.length; ++i) {
            String gtStr;
            switch (gt[i]) {
                case -1: {
                    gtStr = "./.";
                    break;
                }
                case 0: {
                    gtStr = "0/0";
                    break;
                }
                case 1: {
                    gtStr = "0/1";
                    break;
                }
                case 2: {
                    gtStr = "1/1";
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown code '" + gt[i] + "'");
                }
            }
            this.addGenotype(gtStr);
        }
        return this;
    }

    public List<Variant> variants() {
        if (this.variants != null) {
            return this.variants;
        }
        this.variants = new LinkedList();
        Chromosome chr = (Chromosome)this.parent;
        if (!this.isVariant()) {
            List<Variant> vars = this.variants(chr, this.start, this.ref, null, this.id);
            String alt = ".";
            for (Variant variant : vars) {
                variant.setGenotype(alt);
            }
            this.variants.addAll(vars);
        } else {
            for (String alt : this.alts) {
                if (!this.isVariant(alt)) {
                    alt = null;
                }
                List<Variant> vars = this.variants(chr, this.start, this.ref, alt, this.id);
                this.variants.addAll(vars);
            }
        }
        return this.variants;
    }

    List<Variant> variants(Chromosome chromo, int start, String reference, String alt, String id) {
        List<Variant> list2 = null;
        if (alt != null) {
            alt = alt.toUpperCase();
        }
        if (alt == null || alt.isEmpty() || alt.equals(reference)) {
            list2 = Variant.factory(chromo, start, reference, null, id, false);
        } else if (alt.charAt(0) == '<') {
            if (alt.startsWith("<DEL")) {
                String ch = this.ref;
                int startNew = start;
                if (this.end > start) {
                    startNew = start + reference.length();
                    int size2 = this.end - startNew + 1;
                    char[] change = new char[size2];
                    for (int i = 0; i < change.length; ++i) {
                        change[i] = reference.length() > i ? (int)reference.charAt(i) : 78;
                    }
                    ch = new String(change);
                }
                list2 = Variant.factory(chromo, startNew, ch, "", id, false);
            } else if (alt.startsWith("<INV")) {
                int startNew = start + reference.length();
                Variant var = new Variant((Marker)chromo, startNew, this.end, id);
                var.setVariantType(Variant.VariantType.INV);
                list2 = new LinkedList<Variant>();
                list2.add(var);
            } else if (alt.startsWith("<DUP")) {
                int startNew = start + reference.length();
                Variant var = new Variant((Marker)chromo, startNew, this.end, id);
                var.setVariantType(Variant.VariantType.DUP);
                list2 = new LinkedList<Variant>();
                list2.add(var);
            }
        } else if (alt.indexOf(91) >= 0 || alt.indexOf(93) >= 0) {
            boolean left = alt.indexOf(93) >= 0;
            String sep = left ? "\\]" : "\\[";
            String[] tpos = alt.split(sep);
            String pos = tpos[1];
            boolean before = alt.indexOf(93) == 0 || alt.indexOf(91) == 0;
            String altBases = before ? tpos[2] : tpos[0];
            String[] posSplit = pos.split(":");
            String trChrName = posSplit[0];
            Chromosome trChr = chromo.getGenome().getOrCreateChromosome(trChrName);
            int trStart = Gpr.parseIntSafe(posSplit[1]) - 1;
            VariantBnd var = new VariantBnd(chromo, start, this.ref, altBases, trChr, trStart, left, before);
            list2 = new LinkedList<Variant>();
            list2.add(var);
        } else if (reference.length() == alt.length()) {
            if (reference.length() == 1) {
                list2 = Variant.factory(chromo, start, reference, alt, id, this.vcfFileIterator.isExpandIub());
            } else {
                int startDiff = Integer.MAX_VALUE;
                for (int i = 0; i < reference.length(); ++i) {
                    if (reference.charAt(i) == alt.charAt(i)) continue;
                    startDiff = Math.min(startDiff, i);
                }
                int endDiff = 0;
                for (int i = reference.length() - 1; i >= 0; --i) {
                    if (reference.charAt(i) == alt.charAt(i)) continue;
                    endDiff = Math.max(endDiff, i);
                }
                String newRef = reference.substring(startDiff, endDiff + 1);
                String newAlt = alt.substring(startDiff, endDiff + 1);
                list2 = Variant.factory(chromo, start + startDiff, newRef, newAlt, id, this.vcfFileIterator.isExpandIub());
            }
        } else {
            VcfRefAltAlign align = new VcfRefAltAlign(alt, reference);
            align.align();
            int startDiff = align.getOffset();
            switch (align.getVariantType()) {
                case DEL: {
                    String ref = "";
                    String ch = align.getAlignment();
                    if (!ch.startsWith("-")) {
                        throw new RuntimeException("Deletion '" + ch + "' does not start with '-'. This should never happen!");
                    }
                    list2 = Variant.factory(chromo, start + startDiff, ref, ch, id, this.vcfFileIterator.isExpandIub());
                    break;
                }
                case INS: {
                    String ch = align.getAlignment();
                    String ref = "";
                    if (!ch.startsWith("+")) {
                        throw new RuntimeException("Insertion '" + ch + "' does not start with '+'. This should never happen!");
                    }
                    list2 = Variant.factory(chromo, start + startDiff, ref, ch, id, this.vcfFileIterator.isExpandIub());
                    break;
                }
                case MIXED: {
                    reference = reference.substring(startDiff);
                    alt = alt.substring(startDiff);
                    list2 = Variant.factory(chromo, start + startDiff, reference, alt, id, this.vcfFileIterator.isExpandIub());
                    break;
                }
                default: {
                    throw new RuntimeException("Unsupported VCF change type '" + (Object)((Object)align.getVariantType()) + "'\n\tRef: " + reference + "'\n\tAlt: '" + alt + "'\n\tVcfEntry: " + this);
                }
            }
        }
        if (list2 == null) {
            list2 = new LinkedList<Variant>();
        }
        for (Variant variant : list2) {
            variant.setGenotype(alt);
        }
        return list2;
    }

    static {
        INFO_VALUE_ENCODE.put("%3B", SUB_FIELD_SEP);
        INFO_VALUE_ENCODE.put("%3D", "=");
        INFO_VALUE_ENCODE.put("%2C", ",");
        INFO_VALUE_ENCODE.put("%0D", "\n");
        INFO_VALUE_ENCODE.put("%0A", "\r");
        INFO_VALUE_ENCODE.put("%09", "\t");
    }

    public static enum AlleleFrequencyType {
        Common,
        LowFrequency,
        Rare;

    }
}

