/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.snpEffect.testCases.unity;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Random;
import org.junit.Test;
import org.snpeff.binseq.coder.DnaCoder;
import org.snpeff.nmer.Nmer;
import org.snpeff.util.Gpr;

public class TestCasesNmers {
    public static boolean verbose = false;

    String randSeq(int len, Random rand) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            int r = rand.nextInt() & 3;
            sb.append(DnaCoder.get().toBase(r));
        }
        return sb.toString();
    }

    @Test
    public void test_03_Nmers() {
        Gpr.debug("Test");
        long seed = 20100615L;
        Random rand = new Random(seed);
        int numTests = 100;
        for (int len = 1; len <= 32; ++len) {
            for (int t2 = 0; t2 < numTests; ++t2) {
                Nmer nmer;
                String seq2 = this.randSeq(len, rand);
                if (verbose) {
                    System.out.println("Nmer test:" + t2 + "\tlen:" + len + "\t" + seq2);
                }
                if (seq2.equals((nmer = new Nmer(seq2)).toString())) continue;
                throw new RuntimeException("Sequences do not match:\n\tSeq    :\t" + seq2 + "\n\tBinSeq :\t" + nmer);
            }
        }
    }

    @Test
    public void test_20_Nmers_read_write() {
        Gpr.debug("Test");
        String testFile = "/tmp/nmer_test.bin";
        int nmerSize = 32;
        int numNmers = 100000;
        try {
            FileOutputStream os = new FileOutputStream(new File(testFile));
            Random rand = new Random(20100825L);
            ArrayList<Nmer> list2 = new ArrayList<Nmer>();
            for (int i = 0; i < numNmers; ++i) {
                Nmer nmer = new Nmer(nmerSize);
                nmer.setNmer(rand.nextLong());
                list2.add(nmer);
                nmer.write(os);
            }
            os.close();
            Nmer nmer = new Nmer(nmerSize);
            FileInputStream is = new FileInputStream(new File(testFile));
            int i = 0;
            while (nmer.read(is) >= 0) {
                Nmer nmerOri = (Nmer)list2.get(i);
                if (nmerOri.getNmer() != nmer.getNmer()) {
                    throw new RuntimeException("Nmers differ:\n\t" + nmerOri + "\t" + Long.toHexString(nmerOri.getNmer()) + "\n\t" + nmer + "\t" + Long.toHexString(nmer.getNmer()));
                }
                ++i;
            }
            is.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

