/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.interval;

import org.snpeff.interval.Marker;
import org.snpeff.interval.Transcript;
import org.snpeff.interval.Variant;
import org.snpeff.snpEffect.EffectType;
import org.snpeff.snpEffect.VariantEffect;
import org.snpeff.snpEffect.VariantEffects;

public class Upstream
extends Marker {
    private static final long serialVersionUID = 1636197649250882952L;

    public Upstream() {
        this.type = EffectType.UPSTREAM;
    }

    public Upstream(Transcript parent, int start, int end, boolean strandMinus, String id) {
        super(parent, start, end, strandMinus, id);
        this.type = EffectType.UPSTREAM;
    }

    public int distanceToTr(Variant variant) {
        int dist = (this.parent.isStrandPlus() ? this.end - variant.getStart() : variant.getStart() - this.start) + 1;
        return Math.max(0, dist);
    }

    @Override
    protected boolean isShowWarningIfParentDoesNotInclude() {
        return false;
    }

    @Override
    public boolean variantEffect(Variant variant, VariantEffects variantEffects) {
        if (!this.intersects(variant)) {
            return false;
        }
        int distance = this.distanceToTr(variant);
        VariantEffect variantEffect = new VariantEffect(variant);
        variantEffect.set(this, this.type, this.type.effectImpact(), distance + " bases");
        variantEffect.setDistance(distance);
        variantEffects.add(variantEffect);
        return true;
    }
}

