/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.binseq.coder;

import org.snpeff.binseq.coder.DnaCoder;

public class DnaQualityCoder
extends DnaCoder {
    public static final int MAX_QUALITY = 63;
    public static final int MIN_QUALITY = 0;
    private static DnaQualityCoder dnaQualityCoder = new DnaQualityCoder();

    public static DnaQualityCoder get() {
        return dnaQualityCoder;
    }

    private DnaQualityCoder() {
    }

    @Override
    public int basesPerWord() {
        return 1;
    }

    public int baseToBits(char c, int quality) {
        return this.qualityToBits(quality) | this.baseToBits(c, false);
    }

    @Override
    public int qualityToBits(int quality) {
        return 0xFF & Math.max(Math.min(quality, 63), 0) << 2;
    }

    public int replaceQuality(byte code, int newQuality) {
        return code & 3 | this.qualityToBits(newQuality);
    }

    @Override
    public char toBase(int code) {
        return TO_BASE[code & 3];
    }

    @Override
    public int toQuality(int code) {
        return (code & 0xFF) >> this.bitsPerBase();
    }
}

