/*
 * Decompiled with CFR 0.152.
 */
package org.junit.internal;

import java.io.PrintStream;
import java.text.NumberFormat;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

public class TextListener
extends RunListener {
    private final PrintStream fWriter;

    public TextListener() {
        this(System.out);
    }

    public TextListener(PrintStream writer) {
        this.fWriter = writer;
    }

    public void testRunFinished(Result result2) {
        this.printHeader(result2.getRunTime());
        this.printFailures(result2);
        this.printFooter(result2);
    }

    public void testStarted(Description description) {
        this.fWriter.append('.');
    }

    public void testFailure(Failure failure2) {
        this.fWriter.append('E');
    }

    public void testIgnored(Description description) {
        this.fWriter.append('I');
    }

    private PrintStream getWriter() {
        return this.fWriter;
    }

    protected void printHeader(long runTime) {
        this.getWriter().println();
        this.getWriter().println("Time: " + this.elapsedTimeAsString(runTime));
    }

    protected void printFailures(Result result2) {
        if (result2.getFailureCount() == 0) {
            return;
        }
        if (result2.getFailureCount() == 1) {
            this.getWriter().println("There was " + result2.getFailureCount() + " failure:");
        } else {
            this.getWriter().println("There were " + result2.getFailureCount() + " failures:");
        }
        int i = 1;
        for (Failure each : result2.getFailures()) {
            this.printFailure(each, i++);
        }
    }

    protected void printFailure(Failure failure2, int count2) {
        this.printFailureHeader(failure2, count2);
        this.printFailureTrace(failure2);
    }

    protected void printFailureHeader(Failure failure2, int count2) {
        this.getWriter().println(count2 + ") " + failure2.getTestHeader());
    }

    protected void printFailureTrace(Failure failure2) {
        this.getWriter().print(failure2.getTrace());
    }

    protected void printFooter(Result result2) {
        if (result2.wasSuccessful()) {
            this.getWriter().println();
            this.getWriter().print("OK");
            this.getWriter().println(" (" + result2.getRunCount() + " test" + (result2.getRunCount() == 1 ? "" : "s") + ")");
        } else {
            this.getWriter().println();
            this.getWriter().println("FAILURES!!!");
            this.getWriter().println("Tests run: " + result2.getRunCount() + ",  Failures: " + result2.getFailureCount());
        }
        this.getWriter().println();
    }

    protected String elapsedTimeAsString(long runTime) {
        return NumberFormat.getInstance().format((double)runTime / 1000.0);
    }
}

