/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.bbfile;

import org.apache.log4j.Logger;
import org.broad.igv.bbfile.BPTreeNode;
import org.broad.igv.bbfile.BPTreeNodeItem;

public class BPTreeChildNodeItem
implements BPTreeNodeItem {
    private static Logger log = Logger.getLogger(BPTreeChildNodeItem.class);
    private final boolean isLeafItem = false;
    private long itemIndex;
    private String chromKey;
    private BPTreeNode childNode;

    public BPTreeChildNodeItem(int itemIndex, String chromKey, BPTreeNode childNode) {
        this.itemIndex = itemIndex;
        this.chromKey = chromKey;
        this.childNode = childNode;
    }

    @Override
    public long getItemIndex() {
        return this.itemIndex;
    }

    @Override
    public boolean isLeafItem() {
        return false;
    }

    @Override
    public String getChromKey() {
        return this.chromKey;
    }

    @Override
    public boolean chromKeysMatch(String chromKey) {
        int thatKeyLength;
        String thisKey = this.chromKey;
        String thatKey = chromKey;
        int thisKeyLength = thisKey.length();
        if (thisKeyLength > (thatKeyLength = thatKey.length())) {
            thisKey = thisKey.substring(0, thatKeyLength);
        } else if (thatKeyLength > thisKeyLength) {
            thatKey = thatKey.substring(0, thisKeyLength);
        }
        return thisKey.compareTo(thatKey) == 0;
    }

    @Override
    public void print() {
        log.debug("B+ Tree child node " + this.itemIndex);
        log.debug("Key value = " + this.chromKey);
        this.childNode.printItems();
    }

    public BPTreeNode getChildNode() {
        return this.childNode;
    }
}

