/*
 * Decompiled with CFR 0.152.
 */
package org.biojava3.core.sequence.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.LinkedHashMap;
import org.biojava3.core.sequence.DNASequence;
import org.biojava3.core.sequence.ProteinSequence;
import org.biojava3.core.sequence.compound.AminoAcidCompoundSet;
import org.biojava3.core.sequence.compound.DNACompoundSet;
import org.biojava3.core.sequence.io.DNASequenceCreator;
import org.biojava3.core.sequence.io.FileProxyDNASequenceCreator;
import org.biojava3.core.sequence.io.FileProxyProteinSequenceCreator;
import org.biojava3.core.sequence.io.GenbankReader;
import org.biojava3.core.sequence.io.GenbankSequenceParser;
import org.biojava3.core.sequence.io.GenericGenbankHeaderParser;
import org.biojava3.core.sequence.io.ProteinSequenceCreator;

public class GenbankReaderHelper {
    public static LinkedHashMap<String, DNASequence> readGenbankDNASequence(File file, boolean lazySequenceLoad) throws Exception {
        if (!lazySequenceLoad) {
            return GenbankReaderHelper.readGenbankDNASequence(file);
        }
        GenbankReader GenbankProxyReader = new GenbankReader(file, new GenericGenbankHeaderParser(), new FileProxyDNASequenceCreator(file, DNACompoundSet.getDNACompoundSet(), new GenbankSequenceParser()));
        return GenbankProxyReader.process();
    }

    public static LinkedHashMap<String, ProteinSequence> readGenbankProteinSequence(File file, boolean lazySequenceLoad) throws Exception {
        if (!lazySequenceLoad) {
            return GenbankReaderHelper.readGenbankProteinSequence(file);
        }
        GenbankReader GenbankProxyReader = new GenbankReader(file, new GenericGenbankHeaderParser(), new FileProxyProteinSequenceCreator(file, AminoAcidCompoundSet.getAminoAcidCompoundSet(), new GenbankSequenceParser()));
        return GenbankProxyReader.process();
    }

    public static LinkedHashMap<String, ProteinSequence> readGenbankProteinSequence(File file) throws Exception {
        FileInputStream inStream = new FileInputStream(file);
        LinkedHashMap<String, ProteinSequence> proteinSequences = GenbankReaderHelper.readGenbankProteinSequence(inStream);
        inStream.close();
        return proteinSequences;
    }

    public static LinkedHashMap<String, ProteinSequence> readGenbankProteinSequence(InputStream inStream) throws Exception {
        GenbankReader GenbankReader2 = new GenbankReader(inStream, new GenericGenbankHeaderParser(), new ProteinSequenceCreator(AminoAcidCompoundSet.getAminoAcidCompoundSet()));
        return GenbankReader2.process();
    }

    public static LinkedHashMap<String, DNASequence> readGenbankDNASequence(InputStream inStream) throws Exception {
        GenbankReader GenbankReader2 = new GenbankReader(inStream, new GenericGenbankHeaderParser(), new DNASequenceCreator(DNACompoundSet.getDNACompoundSet()));
        return GenbankReader2.process();
    }

    public static LinkedHashMap<String, DNASequence> readGenbankDNASequence(File file) throws Exception {
        FileInputStream inStream = new FileInputStream(file);
        LinkedHashMap<String, DNASequence> dnaSequences = GenbankReaderHelper.readGenbankDNASequence(inStream);
        inStream.close();
        return dnaSequences;
    }

    public static void main(String[] args) throws Exception {
        LinkedHashMap<String, DNASequence> dnaSequences = GenbankReaderHelper.readGenbankDNASequence(new File("src/test/resources/NM_000266.gb"), true);
        for (DNASequence sequence2 : dnaSequences.values()) {
            System.out.println(sequence2.getRNASequence().getProteinSequence().getSequenceAsString());
        }
        LinkedHashMap<String, ProteinSequence> proteinSequences = GenbankReaderHelper.readGenbankProteinSequence(new File("src/test/resources/BondFeature.gb"), true);
        for (ProteinSequence sequence3 : proteinSequences.values()) {
            System.out.println(sequence3.getSequenceAsString());
        }
    }
}

