/*
 * Decompiled with CFR 0.152.
 */
package org.biojava3.core.sequence.io;

import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.LinkedHashMap;
import org.biojava3.core.sequence.compound.AminoAcidCompoundSet;
import org.biojava3.core.sequence.io.FastaReader;
import org.biojava3.core.sequence.io.GenericFastaHeaderFormat;
import org.biojava3.core.sequence.io.GenericFastaHeaderParser;
import org.biojava3.core.sequence.io.ProteinSequenceCreator;
import org.biojava3.core.sequence.io.template.FastaHeaderFormatInterface;
import org.biojava3.core.sequence.template.Compound;
import org.biojava3.core.sequence.template.Sequence;

public class FastaWriter<S extends Sequence<?>, C extends Compound> {
    OutputStream os;
    Collection<S> sequences;
    FastaHeaderFormatInterface<S, C> headerFormat;
    private int lineLength = 60;
    byte[] lineSep = System.getProperty("line.separator").getBytes();

    public FastaWriter(OutputStream os, Collection<S> sequences, FastaHeaderFormatInterface<S, C> headerFormat) {
        this.os = os;
        this.sequences = sequences;
        this.headerFormat = headerFormat;
    }

    public FastaWriter(OutputStream os, Collection<S> sequences, FastaHeaderFormatInterface<S, C> headerFormat, int lineLength) {
        this.os = os;
        this.sequences = sequences;
        this.headerFormat = headerFormat;
        this.lineLength = lineLength;
    }

    public void setLineSeparator(String lineSeparator) {
        this.lineSep = lineSeparator.getBytes();
    }

    public void process() throws Exception {
        for (Sequence sequence2 : this.sequences) {
            String header = this.headerFormat.getHeader(sequence2);
            this.os.write(62);
            this.os.write(header.getBytes());
            this.os.write(this.lineSep);
            int compoundCount = 0;
            String seq2 = "";
            seq2 = sequence2.getSequenceAsString();
            for (int i = 0; i < seq2.length(); ++i) {
                this.os.write(seq2.charAt(i));
                if (++compoundCount != this.lineLength) continue;
                this.os.write(this.lineSep);
                compoundCount = 0;
            }
            if (sequence2.getLength() % this.getLineLength() == 0) continue;
            this.os.write(this.lineSep);
        }
    }

    public static void main(String[] args) {
        try {
            FileInputStream is = new FileInputStream("/Users/Scooter/scripps/dyadic/c1-454Scaffolds.faa");
            FastaReader fastaReader = new FastaReader(is, new GenericFastaHeaderParser(), new ProteinSequenceCreator(AminoAcidCompoundSet.getAminoAcidCompoundSet()));
            LinkedHashMap proteinSequences = fastaReader.process();
            is.close();
            FileOutputStream fileOutputStream = new FileOutputStream("/Users/Scooter/scripps/dyadic/c1-454Scaffolds_temp.faa");
            BufferedOutputStream bo = new BufferedOutputStream(fileOutputStream);
            long start = System.currentTimeMillis();
            FastaWriter fastaWriter = new FastaWriter(bo, proteinSequences.values(), new GenericFastaHeaderFormat());
            fastaWriter.process();
            bo.close();
            long end = System.currentTimeMillis();
            System.out.println("Took " + (end - start) + " seconds");
            fileOutputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getLineLength() {
        return this.lineLength;
    }

    public void setLineLength(int lineLength) {
        this.lineLength = lineLength;
    }
}

