/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure.server;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.biojava.bio.structure.Structure;
import org.biojava.bio.structure.server.PDBInstallation;
import org.biojava.bio.structure.server.StructureEvent;
import org.biojava.bio.structure.server.StructureEventImpl;
import org.biojava.bio.structure.server.StructureFetcherRunnable;
import org.biojava.bio.structure.server.StructureListener;
import org.biojava.bio.structure.server.StructureServer;

public class SimpleStructureServer
implements StructureServer,
StructureListener {
    public static final Logger logger = Logger.getLogger("org.biojava.bio.structure");
    List<Structure> queue;
    List<StructureListener> listeners = new ArrayList<StructureListener>();
    PDBInstallation installation;
    int cacheSize = 1;
    int countLoading = 0;
    List<StructureListener> waitingList;

    public SimpleStructureServer() {
        this.queue = new ArrayList<Structure>();
        this.waitingList = new ArrayList<StructureListener>();
    }

    public void initCache() {
        this.checkStatus();
    }

    @Override
    public void addStructureListener(StructureListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void clearStructureListeners() {
        this.listeners.clear();
    }

    public int getNrCPUs() {
        return 0;
    }

    @Override
    public PDBInstallation getPDBInstallation() {
        return this.installation;
    }

    @Override
    public synchronized void requestNextStructure(StructureListener listener) {
        if (this.installation == null) {
            logger.warning("no PDB installation has been set, yet. Can not load next structure");
            this.triggerNextStructure(null, listener);
            return;
        }
        if (this.queue.size() > 0) {
            Structure s = this.getStructureFromQueue();
            this.checkStatus();
            this.triggerNextStructure(s, listener);
        }
        if (this.countLoading > 0) {
            this.waitingList.add(listener);
            this.checkStatus();
            return;
        }
        System.err.println("queue is empty on server!");
        this.addNextToQueue(listener);
        this.checkStatus();
    }

    private synchronized void checkStatus() {
        System.out.println("server check status " + this.queue.size() + "+" + this.countLoading + " == " + this.cacheSize + "?");
        while (this.queue.size() + this.countLoading <= this.cacheSize) {
            this.addNextToQueue(this);
            ++this.countLoading;
        }
    }

    private void addNextToQueue(StructureListener listener) {
        if (this.installation.hasNext()) {
            StructureFetcherRunnable r = new StructureFetcherRunnable(this.installation);
            r.addStructureListener(listener);
            Thread t2 = new Thread(r);
            t2.start();
        }
    }

    private synchronized Structure getStructureFromQueue() {
        if (this.queue.size() == 0) {
            return null;
        }
        Structure s = this.queue.get(0);
        this.queue.remove(0);
        return s;
    }

    @Override
    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    @Override
    public int getCacheSize() {
        return this.cacheSize;
    }

    @Override
    public void setPDBInstallation(PDBInstallation installation) {
        this.installation = installation;
    }

    @Override
    public boolean hasNextStructure() {
        if (this.queue.size() > 0) {
            return true;
        }
        if (this.countLoading > 0) {
            return true;
        }
        boolean hasNext = this.installation.hasNext();
        return hasNext;
    }

    private void triggerNextStructure(Structure s, StructureListener li) {
        StructureEventImpl event = new StructureEventImpl(s);
        li.newStructure(event);
    }

    @Override
    public void modifiedStructure(StructureEvent event) {
    }

    @Override
    public synchronized void newStructure(StructureEvent event) {
        --this.countLoading;
        Structure s = event.getStructure();
        if (s == null) {
            System.err.println("StructureServer: could not load structure for " + event.getPDBCode());
        } else {
            if (this.waitingList.size() > 0) {
                StructureListener listener = this.waitingList.get(0);
                this.waitingList.remove(0);
                this.triggerNextStructure(s, listener);
                return;
            }
            this.queue.add(s);
        }
    }

    @Override
    public void obsoleteStructure(StructureEvent event) {
    }
}

