/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure.server;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.biojava.bio.structure.PDBHeader;
import org.biojava.bio.structure.Structure;
import org.biojava.bio.structure.io.MMCIFFileReader;
import org.biojava.bio.structure.io.mmcif.SimpleMMcifConsumer;
import org.biojava.bio.structure.io.mmcif.SimpleMMcifParser;
import org.biojava.bio.structure.server.PDBFilter;
import org.biojava.bio.structure.server.PDBInstallation;
import org.biojava3.core.util.InputStreamProvider;

public class MMCIFFileInstallation
implements PDBInstallation {
    public static final Logger logger = Logger.getLogger("org.biojava.bio.structure");
    private File filePath;
    List<String> extensions;
    MMCIFFileReader reader;
    boolean autoFetch;

    public MMCIFFileInstallation(File filePath) {
        if (!filePath.isDirectory()) {
            throw new IllegalArgumentException("the provided path does not point to a directory!");
        }
        this.filePath = filePath;
        this.reader = new MMCIFFileReader();
        this.extensions = new ArrayList<String>();
        this.extensions.add(".cif");
        this.extensions.add(".mmcif");
        this.extensions.add(".cif.gz");
        this.extensions.add(".mmcif.gz");
        this.extensions.add(".cif.Z");
        this.extensions.add(".mmcif.Z");
        this.autoFetch = false;
    }

    public boolean isAutoFetch() {
        return this.autoFetch;
    }

    public void setAutoFetch(boolean autoFetch) {
        this.autoFetch = autoFetch;
    }

    private InputStream getInputStream(String pdbId) throws IOException {
        String[] paths;
        InputStream inputStream = null;
        String pdbFile = null;
        File f2 = null;
        String fpath = this.filePath + "/" + pdbId;
        String ppath = this.filePath + "/pdb" + pdbId;
        String split2 = pdbId.substring(1, 3);
        String fsplit = this.filePath + "/" + split2 + "/" + pdbId;
        block0: for (String testpath : paths = new String[]{fpath, ppath, fsplit}) {
            for (int i = 0; i < this.extensions.size(); ++i) {
                String ex = this.extensions.get(i);
                f2 = new File(testpath + ex);
                if (f2.exists()) {
                    pdbFile = testpath + ex;
                    InputStreamProvider isp = new InputStreamProvider();
                    inputStream = isp.getInputStream(pdbFile);
                    continue block0;
                }
                if (pdbFile != null) continue block0;
            }
        }
        if (pdbFile == null) {
            if (this.autoFetch) {
                return this.downloadAndGetInputStream(pdbId);
            }
            String message = "no structure with PDB code " + pdbId + " found!";
            throw new IOException(message);
        }
        return inputStream;
    }

    private InputStream downloadAndGetInputStream(String pdbId) throws IOException {
        File tmp = this.downloadCIF(pdbId);
        if (tmp != null) {
            InputStreamProvider prov = new InputStreamProvider();
            return prov.getInputStream(tmp);
        }
        throw new IOException("could not find PDB " + pdbId + " in file system and also could not download");
    }

    public File downloadCIF(String pdbId) {
        File tempFile = new File(this.filePath + "/" + pdbId + ".cif.gz");
        File pdbHome = new File(this.filePath.getAbsolutePath());
        if (!pdbHome.canWrite()) {
            System.err.println("can not write to " + pdbHome);
            return null;
        }
        String ftp = String.format("ftp://ftp.wwpdb.org/pub/pdb/data/structures/all/mmCIF/%s.cif.gz", pdbId.toLowerCase());
        System.out.println("Fetching " + ftp);
        try {
            String line;
            URL url = new URL(ftp);
            InputStream conn = url.openStream();
            System.out.println("writing to " + tempFile);
            FileOutputStream outPut = new FileOutputStream(tempFile);
            GZIPOutputStream gzOutPut = new GZIPOutputStream(outPut);
            PrintWriter pw = new PrintWriter(gzOutPut);
            BufferedReader fileBuffer = new BufferedReader(new InputStreamReader(new GZIPInputStream(conn)));
            while ((line = fileBuffer.readLine()) != null) {
                pw.println(line);
            }
            pw.flush();
            pw.close();
            outPut.close();
            conn.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return tempFile;
    }

    @Override
    public void addPDBFilter(PDBFilter filter2) {
    }

    @Override
    public void clearFilters() {
    }

    @Override
    public List<PDBHeader> getAll() {
        return null;
    }

    @Override
    public PDBHeader getPDBHeader(String pdbId) {
        return null;
    }

    @Override
    public Structure getStructure(String pdbId) {
        Structure struc = null;
        try {
            BufferedReader buf;
            InputStream inStream = this.getInputStream(pdbId);
            try {
                buf = this.getBufferedReader(inStream);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new IOException("error initializing BufferedReader");
            }
            SimpleMMcifParser pdbpars = new SimpleMMcifParser();
            SimpleMMcifConsumer consumer = new SimpleMMcifConsumer();
            pdbpars.addMMcifConsumer(consumer);
            pdbpars.parse(buf);
            struc = consumer.getStructure();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return struc;
    }

    private BufferedReader getBufferedReader(InputStream inStream) throws IOException {
        if (inStream == null) {
            throw new IOException("input stream is null!");
        }
        BufferedReader buf = new BufferedReader(new InputStreamReader(inStream));
        return buf;
    }

    @Override
    public boolean hasNext() {
        return false;
    }

    @Override
    public Structure next() {
        return null;
    }
}

