/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure.domain.pdp;

import java.util.Collections;
import java.util.List;
import org.biojava.bio.structure.Atom;
import org.biojava.bio.structure.domain.pdp.CutDomain;
import org.biojava.bio.structure.domain.pdp.CutValues;
import org.biojava.bio.structure.domain.pdp.Domain;
import org.biojava.bio.structure.domain.pdp.PDPDistanceMatrix;
import org.biojava.bio.structure.domain.pdp.Segment;
import org.biojava.bio.structure.domain.pdp.SegmentComparator;

public class Cut {
    static boolean verbose = CutDomain.verbose;

    public int cut(Atom[] ca, Domain dom, CutValues val, int[][] dist, PDPDistanceMatrix pdpMatrix) {
        int endst;
        int endsf;
        double y;
        double x2;
        int size2;
        int size1;
        int size22;
        int size11;
        int k;
        int to2;
        int from2;
        int j;
        int kseg;
        int i;
        int to1;
        int from1;
        int jseg;
        int iseg;
        int nclose = pdpMatrix.getNclose();
        int[] iclose = pdpMatrix.getIclose();
        int[] jclose = pdpMatrix.getJclose();
        int[] contacts = new int[3200];
        double[] max_contacts = new double[3200];
        double[] contact_density = new double[3200];
        int site_min = -1;
        List<Segment> segments = dom.getSegments();
        Collections.sort(segments, new SegmentComparator());
        if (verbose) {
            System.out.println("  ---  Cut.cut " + dom + " ");
        }
        double average_density = 0.0;
        int size0 = 0;
        for (iseg = 0; iseg < dom.nseg; ++iseg) {
            int to22;
            int from22;
            int contactsd = 1;
            int size1t = 0;
            int size2t = 0;
            for (jseg = 0; jseg < iseg; ++jseg) {
                size1t += dom.getSegmentAtPos(jseg).getFrom() - dom.getSegmentAtPos(jseg).getFrom() + 1;
            }
            for (jseg = iseg + 1; jseg < dom.nseg; ++jseg) {
                size2t += dom.getSegmentAtPos(jseg).getTo() - dom.getSegmentAtPos(jseg).getFrom() + 1;
            }
            for (jseg = 0; jseg < iseg; ++jseg) {
                from1 = dom.getSegmentAtPos(jseg).getFrom();
                to1 = dom.getSegmentAtPos(jseg).getTo();
                for (i = from1; i < to1; ++i) {
                    for (kseg = iseg + 1; kseg < dom.nseg; ++kseg) {
                        from22 = dom.getSegmentAtPos(kseg).getFrom();
                        to22 = dom.getSegmentAtPos(kseg).getFrom();
                        for (j = from22; j < to22; ++j) {
                            if (Math.abs(i - j) <= 4) continue;
                            contactsd += dist[i][j];
                        }
                    }
                }
            }
            from2 = dom.getSegmentAtPos(iseg).getFrom();
            to2 = dom.getSegmentAtPos(iseg).getTo();
            for (k = from2; k < to2; ++k) {
                contacts[k] = contactsd;
                size11 = size1t + (k - from2 + 1);
                size22 = size2t + (to2 - k);
                for (i = from2; i <= k; ++i) {
                    for (kseg = iseg + 1; kseg < dom.nseg; ++kseg) {
                        from22 = dom.getSegmentAtPos(kseg).getFrom();
                        to22 = dom.getSegmentAtPos(kseg).getTo();
                        for (j = from22; j <= to22; ++j) {
                            if (Math.abs(i - j) <= 4) continue;
                            int n = k;
                            contacts[n] = contacts[n] + dist[i][j];
                        }
                    }
                }
                for (i = from2; i <= k; ++i) {
                    for (j = k + 1; j <= to2; ++j) {
                        if (Math.abs(i - j) <= 4) continue;
                        int n = k;
                        contacts[n] = contacts[n] + dist[i][j];
                    }
                }
                for (i = k + 1; i <= to2; ++i) {
                    for (kseg = 0; kseg < iseg; ++kseg) {
                        from22 = dom.getSegmentAtPos(kseg).getFrom();
                        to22 = dom.getSegmentAtPos(kseg).getTo();
                        for (j = from22; j < to22; ++j) {
                            if (Math.abs(i - j) <= 4) continue;
                            int n = k;
                            contacts[n] = contacts[n] + dist[j][i];
                        }
                    }
                }
                size1 = Math.min(size11, size22);
                size2 = Math.max(size11, size22);
                x2 = Math.min(350, size1);
                y = Math.min(350, size2);
                if (x2 > 150.0 && y > 1.5 * x2) {
                    y = 1.5 * x2;
                } else if (y > 2.0 * x2) {
                    y = 2.0 * x2;
                }
                x2 = Math.min(Math.pow(x2, 0.43333333333333335) + 0.0, Math.pow(x2, 0.3666666666666667) + Math.pow(25.0, 0.43333333333333335) + 0.0);
                y = Math.min(Math.pow(y, 0.43333333333333335) + 0.0, Math.pow(y, 0.3666666666666667) + Math.pow(25.0, 0.43333333333333335) + 0.0);
                max_contacts[k] = 10.0 * x2 * y;
                if (size1 > 150) {
                    max_contacts[k] = 9.0 * x2 * y;
                }
                contact_density[k] = (double)contacts[k] / max_contacts[k];
                endsf = from2 == 0 ? 9 : 12;
                endst = to2 == ca.length - 1 ? 9 : 12;
                if (contact_density[k] < val.s_min && k > from2 + endsf && k < to2 - endst) {
                    val.s_min = contact_density[k];
                    site_min = k + 1;
                }
                if (k <= from2 + endsf || k >= to2 - endst) continue;
                average_density += contact_density[k];
                ++size0;
            }
        }
        average_density /= (double)size0;
        if (verbose) {
            System.out.println(String.format("  --- Trying to cut domain of size %d having %d segments and  average cont_density %f\n", dom.size, dom.nseg, average_density));
        }
        if (verbose) {
            for (kseg = 0; kseg < dom.nseg; ++kseg) {
                System.out.println(String.format("\t--- segment %d from %d to %d", kseg, dom.getSegmentAtPos(kseg).getFrom(), dom.getSegmentAtPos(kseg).getTo()) + " av density: " + average_density);
            }
        }
        if (val.first_cut) {
            val.AD = average_density;
            if (verbose) {
                System.out.println(String.format("  --- AD=%f", average_density));
            }
        }
        val.AD = average_density;
        val.s_min /= val.AD;
        if (verbose) {
            System.out.println(String.format("  --- after single cut: s_min = %f site_min = %d", val.s_min, site_min));
        }
        k = 0;
        if (verbose) {
            System.out.println("  --- checking double cuts up to: " + nclose);
        }
        int nc = 0;
        for (int l = 0; l < nclose; ++l) {
            int lseg;
            jseg = -1;
            iseg = -1;
            for (kseg = 0; kseg < dom.nseg; ++kseg) {
                from2 = dom.getSegmentAtPos(kseg).getFrom();
                to2 = dom.getSegmentAtPos(kseg).getTo();
                endsf = from2 == 0 ? 9 : 12;
                endst = to2 == ca.length - 1 ? 9 : 12;
                if (iclose[l] > from2 + endsf && iclose[l] < to2 - endst) {
                    iseg = kseg;
                }
                if (jclose[l] <= from2 + endsf || jclose[l] >= to2 - endst) continue;
                jseg = kseg;
            }
            if (iseg < 0 || jseg < 0) continue;
            from2 = dom.getSegmentAtPos(iseg).getFrom();
            to2 = dom.getSegmentAtPos(iseg).getTo();
            from1 = dom.getSegmentAtPos(jseg).getFrom();
            to1 = dom.getSegmentAtPos(jseg).getTo();
            contacts[nc] = 1;
            for (kseg = 0; kseg < iseg; ++kseg) {
                for (lseg = iseg + 1; lseg < jseg; ++lseg) {
                    for (i = dom.getSegmentAtPos(kseg).getFrom().intValue(); i < dom.getSegmentAtPos(kseg).getTo(); ++i) {
                        for (j = dom.getSegmentAtPos(lseg).getFrom().intValue(); j < dom.getSegmentAtPos(lseg).getTo(); ++j) {
                            int n = nc;
                            contacts[n] = contacts[n] + dist[i][j];
                        }
                    }
                }
            }
            for (kseg = jseg + 1; kseg < dom.nseg; ++kseg) {
                for (lseg = iseg + 1; lseg < jseg; ++lseg) {
                    for (i = dom.getSegmentAtPos(kseg).getFrom().intValue(); i < dom.getSegmentAtPos(kseg).getTo(); ++i) {
                        for (j = dom.getSegmentAtPos(lseg).getFrom().intValue(); j < dom.getSegmentAtPos(lseg).getTo(); ++j) {
                            int n = nc;
                            contacts[n] = contacts[n] + dist[j][i];
                        }
                    }
                }
            }
            if (iseg == jseg) {
                for (i = from2; i <= iclose[l]; ++i) {
                    for (j = iclose[l] + 1; j <= jclose[l]; ++j) {
                        int n = nc;
                        contacts[n] = contacts[n] + dist[i][j];
                    }
                }
                for (int j2 = iclose[l] + 1; j2 < jclose[l]; ++j2) {
                    int i2;
                    for (kseg = 0; kseg < iseg; ++kseg) {
                        for (i2 = dom.getSegmentAtPos(kseg).getFrom().intValue(); i2 < dom.getSegmentAtPos(kseg).getTo(); ++i2) {
                            int n = nc;
                            contacts[n] = contacts[n] + dist[i2][j2];
                        }
                    }
                    for (i2 = jclose[l]; i2 < to2; ++i2) {
                        int n = nc;
                        contacts[n] = contacts[n] + dist[j2][i2];
                    }
                    for (kseg = iseg + 1; kseg < dom.nseg; ++kseg) {
                        for (i2 = dom.getSegmentAtPos(kseg).getFrom().intValue(); i2 < dom.getSegmentAtPos(kseg).getTo(); ++i2) {
                            int n = nc;
                            contacts[n] = contacts[n] + dist[j2][i2];
                        }
                    }
                }
            } else {
                for (i = from2; i <= iclose[l]; ++i) {
                    for (kseg = iseg + 1; kseg < jseg; ++kseg) {
                        for (j = dom.getSegmentAtPos(kseg).getFrom().intValue(); j < dom.getSegmentAtPos(kseg).getTo(); ++j) {
                            int n = nc;
                            contacts[n] = contacts[n] + dist[i][j];
                        }
                    }
                    for (j = from1; j < jclose[l]; ++j) {
                        int n = nc;
                        contacts[n] = contacts[n] + dist[i][j];
                    }
                    for (j = iclose[l] + 1; j < to2; ++j) {
                        int n = nc;
                        contacts[n] = contacts[n] + dist[i][j];
                    }
                }
                for (i = iclose[l] + 1; i < to2; ++i) {
                    for (kseg = 0; kseg < iseg; ++kseg) {
                        for (j = dom.getSegmentAtPos(kseg).getFrom().intValue(); j < dom.getSegmentAtPos(kseg).getTo(); ++j) {
                            int n = nc;
                            contacts[n] = contacts[n] + dist[j][i];
                        }
                    }
                    for (kseg = jseg + 1; kseg < dom.nseg; ++kseg) {
                        for (j = dom.getSegmentAtPos(kseg).getFrom().intValue(); j < dom.getSegmentAtPos(kseg).getTo(); ++j) {
                            int n = nc;
                            contacts[n] = contacts[n] + dist[i][j];
                        }
                    }
                    for (j = jclose[l]; j <= to1; ++j) {
                        int n = nc;
                        contacts[n] = contacts[n] + dist[i][j];
                    }
                }
                for (i = from1; i < jclose[l]; ++i) {
                    for (kseg = 0; kseg < iseg; ++kseg) {
                        for (j = dom.getSegmentAtPos(kseg).getFrom().intValue(); j < dom.getSegmentAtPos(kseg).getTo(); ++j) {
                            int n = nc;
                            contacts[n] = contacts[n] + dist[j][i];
                        }
                    }
                    for (kseg = jseg + 1; kseg < dom.nseg; ++kseg) {
                        for (j = dom.getSegmentAtPos(kseg).getFrom().intValue(); j < dom.getSegmentAtPos(kseg).getTo(); ++j) {
                            int n = nc;
                            contacts[n] = contacts[n] + dist[i][j];
                        }
                    }
                    for (j = jclose[l]; j < to1; ++j) {
                        int n = nc;
                        contacts[n] = contacts[n] + dist[i][j];
                    }
                }
                for (i = jclose[l]; i < to1; ++i) {
                    for (kseg = iseg + 1; kseg < jseg; ++kseg) {
                        for (j = dom.getSegmentAtPos(kseg).getFrom().intValue(); j < dom.getSegmentAtPos(kseg).getTo(); ++j) {
                            int n = nc;
                            contacts[n] = contacts[n] + dist[j][i];
                        }
                    }
                }
            }
            size11 = 0;
            size22 = 0;
            for (kseg = 0; kseg < iseg; ++kseg) {
                size11 += dom.getSegmentAtPos(kseg).getTo() - dom.getSegmentAtPos(kseg).getFrom() + 1;
            }
            for (kseg = jseg + 1; kseg < dom.nseg; ++kseg) {
                size11 += dom.getSegmentAtPos(kseg).getTo() - dom.getSegmentAtPos(kseg).getFrom() + 1;
            }
            size11 += iclose[l] - from2 + 1;
            size11 += to1 - jclose[l] + 1;
            for (kseg = iseg + 1; kseg < jseg; ++kseg) {
                size22 += dom.getSegmentAtPos(kseg).getTo() - dom.getSegmentAtPos(kseg).getFrom() + 1;
            }
            if (iseg == jseg) {
                size22 += jclose[l] - iclose[l];
            } else {
                size22 += jclose[l] - from1;
                size22 += to2 - iclose[l];
            }
            size1 = Math.min(size11, size22);
            size2 = Math.max(size11, size22);
            x2 = Math.min(350, size1);
            y = Math.max(350, size2);
            if (y > 2.0 * x2) {
                y = 2.0 * x2;
            }
            x2 = Math.min(Math.pow(x2, 0.43333333333333335) + 0.0, Math.pow(x2, 0.3666666666666667) + Math.pow(25.0, 0.43333333333333335) + 0.0);
            y = Math.min(Math.pow(y, 0.43333333333333335) + 0.0, Math.pow(y, 0.3666666666666667) + Math.pow(25.0, 0.43333333333333335) + 0.0);
            max_contacts[nc] = x2 * y * 10.0;
            if (size1 > 150) {
                max_contacts[k] = 9.0 * x2 * y;
            }
            contact_density[nc] = (double)contacts[nc] / max_contacts[nc];
            if (contact_density[nc] / val.AD + (double)0.05f < val.s_min && contact_density[nc] / val.AD + (double)0.05f < (double)0.44f) {
                val.s_min = contact_density[nc] / val.AD + (double)0.05f;
                site_min = iclose[l];
                val.site2 = jclose[l];
            }
            if (++nc < 350) continue;
            nc = 349;
        }
        val.first_cut = false;
        if (verbose) {
            System.out.println(String.format("  --- E ... at the end of cut: s_min %f CUTOFF %f site_min %d *site2 %d", val.s_min, Float.valueOf(0.5f), site_min, val.site2));
        }
        if (val.s_min > 0.5) {
            return -1;
        }
        return site_min;
    }
}

