/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.internal;

import java.math.BigInteger;
import java.util.RandomAccess;
import org.apfloat.ApfloatContext;
import org.apfloat.ApfloatRuntimeException;
import org.apfloat.internal.LongCRTMath;
import org.apfloat.internal.LongModConstants;
import org.apfloat.internal.LongModMath;
import org.apfloat.internal.MessagePasser;
import org.apfloat.internal.ParallelRunnable;
import org.apfloat.internal.ParallelRunner;
import org.apfloat.spi.DataStorage;
import org.apfloat.spi.DataStorageBuilder;

public class LongCarryCRT
extends LongCRTMath {
    private static final long serialVersionUID = -3954870352092656433L;
    private static final LongModMath MATH_MOD_0 = new LongModMath();
    private static final LongModMath MATH_MOD_1 = new LongModMath();
    private static final LongModMath MATH_MOD_2 = new LongModMath();
    private static final long T0;
    private static final long T1;
    private static final long T2;
    private static final long[] M01;
    private static final long[] M02;
    private static final long[] M12;
    private static final long[] M012;
    private ParallelRunner parallelRunner;

    public LongCarryCRT(int radix) {
        super(radix);
    }

    public DataStorage carryCRT(final DataStorage resultMod0, final DataStorage resultMod1, final DataStorage resultMod2, final long resultSize) throws ApfloatRuntimeException {
        final long size2 = Math.min(resultSize + 2L, resultMod0.getSize());
        ApfloatContext ctx = ApfloatContext.getContext();
        DataStorageBuilder dataStorageBuilder = ctx.getBuilderFactory().getDataStorageBuilder();
        final DataStorage dataStorage = dataStorageBuilder.createDataStorage(resultSize * 8L);
        dataStorage.setSize(resultSize);
        final MessagePasser<Long, long[]> messagePasser = new MessagePasser<Long, long[]>();
        if (size2 <= Integer.MAX_VALUE && this.parallelRunner != null && resultMod0 instanceof RandomAccess && resultMod1 instanceof RandomAccess && resultMod2 instanceof RandomAccess && dataStorage instanceof RandomAccess) {
            ParallelRunnable parallelRunnable = new ParallelRunnable(){

                public int getLength() {
                    return (int)size2;
                }

                public Runnable getRunnable(int offset, int length) {
                    return new CarryCRTRunnable(resultMod0, resultMod1, resultMod2, dataStorage, size2, resultSize, offset, length, messagePasser);
                }
            };
            this.parallelRunner.runParallel(parallelRunnable);
        } else {
            new CarryCRTRunnable(resultMod0, resultMod1, resultMod2, dataStorage, size2, resultSize, 0L, size2, messagePasser).run();
        }
        long[] carries = null;
        assert ((carries = messagePasser.getMessage(size2)) != null);
        assert (carries.length == 2);
        assert (carries[0] == 0L);
        assert (carries[1] == 0L);
        return dataStorage;
    }

    public void setParallelRunner(ParallelRunner parallelRunner) {
        this.parallelRunner = parallelRunner;
    }

    private static DataStorage.Iterator arrayIterator(final long[] data2) {
        return new DataStorage.Iterator(){
            private int position;
            {
                this.position = data2.length - 1;
            }

            public boolean hasNext() {
                return true;
            }

            public void next() {
                --this.position;
            }

            public long getLong() {
                assert (this.position >= 0);
                return data2[this.position];
            }

            public void setLong(long value2) {
                assert (this.position >= 0);
                data2[this.position] = value2;
            }
        };
    }

    private static DataStorage.Iterator compositeIterator(final DataStorage.Iterator iterator1, final long size2, final DataStorage.Iterator iterator2) {
        return new DataStorage.Iterator(){
            private long position;

            public boolean hasNext() {
                return this.position < size2 ? iterator1.hasNext() : iterator2.hasNext();
            }

            public void next() {
                (this.position < size2 ? iterator1 : iterator2).next();
                ++this.position;
            }

            public long getLong() {
                return (this.position < size2 ? iterator1 : iterator2).getLong();
            }

            public void setLong(long value2) {
                (this.position < size2 ? iterator1 : iterator2).setLong(value2);
            }

            public void close() throws ApfloatRuntimeException {
                (this.position < size2 ? iterator1 : iterator2).close();
            }
        };
    }

    static {
        MATH_MOD_0.setModulus(LongModConstants.MODULUS[0]);
        MATH_MOD_1.setModulus(LongModConstants.MODULUS[1]);
        MATH_MOD_2.setModulus(LongModConstants.MODULUS[2]);
        BigInteger base = BigInteger.valueOf(Math.abs(0x200000000000000L));
        BigInteger m0 = BigInteger.valueOf(LongModConstants.MODULUS[0]);
        BigInteger m1 = BigInteger.valueOf(LongModConstants.MODULUS[1]);
        BigInteger m2 = BigInteger.valueOf(LongModConstants.MODULUS[2]);
        BigInteger m01 = m0.multiply(m1);
        BigInteger m02 = m0.multiply(m2);
        BigInteger m12 = m1.multiply(m2);
        T0 = m12.modInverse(m0).longValue();
        T1 = m02.modInverse(m1).longValue();
        T2 = m01.modInverse(m2).longValue();
        M01 = new long[2];
        M02 = new long[2];
        M12 = new long[2];
        M012 = new long[3];
        BigInteger[] qr = m01.divideAndRemainder(base);
        LongCarryCRT.M01[0] = qr[0].longValue();
        LongCarryCRT.M01[1] = qr[1].longValue();
        qr = m02.divideAndRemainder(base);
        LongCarryCRT.M02[0] = qr[0].longValue();
        LongCarryCRT.M02[1] = qr[1].longValue();
        qr = m12.divideAndRemainder(base);
        LongCarryCRT.M12[0] = qr[0].longValue();
        LongCarryCRT.M12[1] = qr[1].longValue();
        qr = m0.multiply(m12).divideAndRemainder(base);
        LongCarryCRT.M012[2] = qr[1].longValue();
        qr = qr[0].divideAndRemainder(base);
        LongCarryCRT.M012[0] = qr[0].longValue();
        LongCarryCRT.M012[1] = qr[1].longValue();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CarryCRTRunnable
    implements Runnable {
        private DataStorage resultMod0;
        private DataStorage resultMod1;
        private DataStorage resultMod2;
        private DataStorage dataStorage;
        private long size;
        private long resultSize;
        private long offset;
        private long length;
        private MessagePasser<Long, long[]> messagePasser;

        public CarryCRTRunnable(DataStorage resultMod0, DataStorage resultMod1, DataStorage resultMod2, DataStorage dataStorage, long size2, long resultSize, long offset, long length, MessagePasser<Long, long[]> messagePasser) {
            this.resultMod0 = resultMod0;
            this.resultMod1 = resultMod1;
            this.resultMod2 = resultMod2;
            this.dataStorage = dataStorage;
            this.size = size2;
            this.resultSize = resultSize;
            this.offset = offset;
            this.length = length;
            this.messagePasser = messagePasser;
        }

        @Override
        public void run() {
            long skipSize = this.offset == 0L ? this.size - this.resultSize + 1L : 0L;
            long lastSize = this.offset + this.length == this.size ? 1 : 0;
            long nonLastSize = 1L - lastSize;
            long subResultSize = this.length - skipSize + lastSize;
            long subStart = this.size - this.offset;
            long subEnd = subStart - this.length;
            long subResultStart = this.size - this.offset - this.length + nonLastSize + subResultSize;
            long subResultEnd = subResultStart - subResultSize;
            DataStorage.Iterator src0 = this.resultMod0.iterator(1, subStart, subEnd);
            DataStorage.Iterator src1 = this.resultMod1.iterator(1, subStart, subEnd);
            DataStorage.Iterator src2 = this.resultMod2.iterator(1, subStart, subEnd);
            DataStorage.Iterator dst = this.dataStorage.iterator(2, subResultStart, subResultEnd);
            long[] carryResult = new long[3];
            long[] sum2 = new long[3];
            long[] tmp = new long[3];
            for (long i = 0L; i < this.length; ++i) {
                long y0 = MATH_MOD_0.modMultiply(T0, src0.getLong());
                long y1 = MATH_MOD_1.modMultiply(T1, src1.getLong());
                long y2 = MATH_MOD_2.modMultiply(T2, src2.getLong());
                LongCarryCRT.this.multiply(M12, y0, sum2);
                LongCarryCRT.this.multiply(M02, y1, tmp);
                if (LongCarryCRT.this.add(tmp, sum2) != 0L || LongCarryCRT.this.compare(sum2, M012) >= 0L) {
                    LongCarryCRT.this.subtract(M012, sum2);
                }
                LongCarryCRT.this.multiply(M01, y2, tmp);
                if (LongCarryCRT.this.add(tmp, sum2) != 0L || LongCarryCRT.this.compare(sum2, M012) >= 0L) {
                    LongCarryCRT.this.subtract(M012, sum2);
                }
                LongCarryCRT.this.add(sum2, carryResult);
                long result2 = LongCarryCRT.this.divide(carryResult);
                if (i >= skipSize) {
                    dst.setLong(result2);
                    dst.next();
                }
                src0.next();
                src1.next();
                src2.next();
            }
            long result0 = LongCarryCRT.this.divide(carryResult);
            long result1 = carryResult[2];
            assert (carryResult[0] == 0L);
            assert (carryResult[1] == 0L);
            if (subResultSize == this.length - skipSize + 1L) {
                dst.setLong(result0);
                dst.close();
                result0 = result1;
                assert (result1 == 0L);
            }
            long[] results = new long[]{result1, result0};
            if (this.offset > 0L) {
                long[] previousResults = this.messagePasser.receiveMessage(this.offset);
                DataStorage.Iterator src = LongCarryCRT.arrayIterator(previousResults);
                dst = LongCarryCRT.compositeIterator(this.dataStorage.iterator(3, subResultStart, subResultEnd), subResultSize, LongCarryCRT.arrayIterator(results));
                long carry = LongCarryCRT.this.baseAdd(dst, src, 0L, dst, previousResults.length);
                carry = this.baseCarry(dst, carry, subResultSize);
                dst.close();
                assert (carry == 0L);
            }
            this.messagePasser.sendMessage(this.offset + this.length, results);
        }

        private long baseCarry(DataStorage.Iterator srcDst, long carry, long size2) {
            for (long i = 0L; i < size2 && carry > 0L; ++i) {
                carry = LongCarryCRT.this.baseAdd(srcDst, null, carry, srcDst, 1L);
            }
            return carry;
        }
    }
}

