/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.internal;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PushbackReader;
import java.io.StringWriter;
import java.io.Writer;
import org.apfloat.ApfloatContext;
import org.apfloat.ApfloatRuntimeException;
import org.apfloat.InfiniteExpansionException;
import org.apfloat.OverflowException;
import org.apfloat.internal.ApfloatInternalException;
import org.apfloat.internal.FloatBaseMath;
import org.apfloat.internal.FloatRadixConstants;
import org.apfloat.internal.ImplementationMismatchException;
import org.apfloat.internal.RadixMismatchException;
import org.apfloat.spi.ApfloatImpl;
import org.apfloat.spi.ArrayAccess;
import org.apfloat.spi.ConvolutionBuilder;
import org.apfloat.spi.ConvolutionStrategy;
import org.apfloat.spi.DataStorage;
import org.apfloat.spi.DataStorageBuilder;
import org.apfloat.spi.RadixConstants;
import org.apfloat.spi.Util;

public class FloatApfloatImpl
extends FloatBaseMath
implements ApfloatImpl {
    private static final DataStorage.Iterator ZERO_ITERATOR = new DataStorage.Iterator(){

        public float getFloat() {
            return 0.0f;
        }

        public void next() {
        }
    };
    private static final long serialVersionUID = 4198839366471670758L;
    private static final int UNDEFINED = Integer.MIN_VALUE;
    private static final int MAX_LONG_SIZE = 4;
    private static final int MAX_DOUBLE_SIZE = 4;
    private int sign;
    private long precision;
    private long exponent;
    private DataStorage dataStorage;
    private int radix;
    private int hashCode = 0;
    private int initialDigits = Integer.MIN_VALUE;
    private long leastZeros = Integer.MIN_VALUE;

    private FloatApfloatImpl(int sign2, long precision, long exponent2, DataStorage dataStorage, int radix) {
        super(radix);
        assert (sign2 == 0 || sign2 == -1 || sign2 == 1);
        assert (precision > 0L);
        assert (sign2 != 0 || precision == Long.MAX_VALUE);
        assert (sign2 != 0 || exponent2 == 0L);
        assert (sign2 != 0 || dataStorage == null);
        assert (sign2 == 0 || dataStorage != null);
        assert (exponent2 <= FloatRadixConstants.MAX_EXPONENT[radix] && exponent2 >= -FloatRadixConstants.MAX_EXPONENT[radix]);
        assert (dataStorage == null || dataStorage.isReadOnly());
        this.sign = sign2;
        this.precision = precision;
        this.exponent = exponent2;
        this.dataStorage = dataStorage;
        this.radix = radix;
    }

    public FloatApfloatImpl(String value2, long precision, int radix, boolean isInteger) throws NumberFormatException, ApfloatRuntimeException {
        super(FloatApfloatImpl.checkRadix(radix));
        int slack;
        assert (precision == Long.MIN_VALUE || precision > 0L);
        this.radix = radix;
        this.sign = 1;
        int startIndex = -1;
        int pointIndex = -1;
        int expIndex = -1;
        int leadingZeros = 0;
        int trailingZeros = 0;
        int digitSize = 0;
        for (int i = 0; i < value2.length(); ++i) {
            char c = value2.charAt(i);
            int digit2 = Character.digit(c, radix);
            if (digit2 == -1) {
                if (i == 0 && (c == '-' || c == '+')) {
                    this.sign = c == '-' ? -1 : 1;
                    continue;
                }
                if (!isInteger && c == '.' && pointIndex == -1) {
                    pointIndex = digitSize;
                    continue;
                }
                if (!(isInteger || c != 'e' && c != 'E' || expIndex != -1)) {
                    expIndex = i;
                    break;
                }
                throw new NumberFormatException("Invalid character: " + c + " at position " + i);
            }
            if (leadingZeros == digitSize && digit2 == 0) {
                ++leadingZeros;
            } else if (startIndex == -1) {
                startIndex = i;
            }
            ++digitSize;
            if (digit2 == 0) {
                ++trailingZeros;
                continue;
            }
            trailingZeros = 0;
        }
        if (digitSize == 0) {
            throw new NumberFormatException("No digits");
        }
        if (startIndex == -1) {
            this.sign = 0;
            this.precision = Long.MAX_VALUE;
            this.exponent = 0L;
            this.dataStorage = null;
            return;
        }
        if (precision == Long.MIN_VALUE) {
            assert (!isInteger);
            precision = digitSize - leadingZeros;
        }
        this.precision = precision;
        int integerSize = (pointIndex >= 0 ? pointIndex : digitSize) - leadingZeros;
        if (expIndex >= 0) {
            String expString = value2.substring(expIndex + 1);
            if (expString.startsWith("+")) {
                expString = expString.substring(1);
            }
            try {
                this.exponent = Long.parseLong(expString);
            }
            catch (NumberFormatException nfe) {
                throw new NumberFormatException("Invalid exponent: " + expString);
            }
        } else {
            this.exponent = 0L;
        }
        if (integerSize >= -(slack = FloatRadixConstants.BASE_DIGITS[radix]) && this.exponent >= Long.MAX_VALUE - (long)integerSize - (long)slack) {
            throw new NumberFormatException("Exponent overflow");
        }
        if (integerSize <= slack && this.exponent <= Long.MIN_VALUE - (long)integerSize + (long)slack) {
            this.sign = 0;
            this.precision = Long.MAX_VALUE;
            this.exponent = 0L;
            this.dataStorage = null;
            return;
        }
        this.exponent += (long)integerSize;
        long baseExp = (this.exponent + (long)(this.exponent > 0L ? FloatRadixConstants.BASE_DIGITS[radix] - 1 : 0)) / (long)FloatRadixConstants.BASE_DIGITS[radix];
        int digitsInBase = (int)(baseExp * (long)FloatRadixConstants.BASE_DIGITS[radix] - this.exponent);
        this.exponent = baseExp;
        digitSize -= leadingZeros + trailingZeros;
        digitSize = (int)Math.min((long)digitSize, precision);
        int size2 = (int)this.getBasePrecision(digitSize, FloatRadixConstants.BASE_DIGITS[radix] - digitsInBase);
        this.dataStorage = FloatApfloatImpl.createDataStorage(size2);
        this.dataStorage.setSize(size2);
        float word = 0.0f;
        DataStorage.Iterator iterator2 = this.dataStorage.iterator(2, 0L, size2);
        int i = startIndex;
        while (digitSize > 0) {
            char c = value2.charAt(i);
            if (c != '.') {
                int digit3 = Character.digit(c, radix);
                word *= (float)radix;
                word += (float)digit3;
                if (digitSize == 1) {
                    while (digitsInBase < FloatRadixConstants.BASE_DIGITS[radix] - 1) {
                        word *= (float)radix;
                        ++digitsInBase;
                    }
                }
                if (++digitsInBase == FloatRadixConstants.BASE_DIGITS[radix]) {
                    digitsInBase = 0;
                    iterator2.setFloat(word);
                    iterator2.next();
                    word = 0.0f;
                }
                --digitSize;
            }
            ++i;
        }
        assert (!iterator2.hasNext());
        this.dataStorage.setReadOnly();
    }

    public FloatApfloatImpl(long value2, long precision, int radix) throws NumberFormatException, ApfloatRuntimeException {
        super(FloatApfloatImpl.checkRadix(radix));
        int size2;
        assert (precision > 0L);
        this.radix = radix;
        if (value2 > 0L) {
            this.sign = 1;
            value2 = -value2;
        } else if (value2 < 0L) {
            this.sign = -1;
        } else {
            this.sign = 0;
            this.precision = Long.MAX_VALUE;
            this.exponent = 0L;
            this.dataStorage = null;
            return;
        }
        this.precision = precision;
        float[] data2 = new float[4];
        long longBase = (long)FloatRadixConstants.BASE[radix];
        if (-longBase < value2) {
            size2 = 1;
            data2[3] = -value2;
        } else {
            size2 = 0;
            while (value2 != 0L) {
                long newValue = value2 / longBase;
                data2[3 - size2] = newValue * longBase - value2;
                value2 = newValue;
                ++size2;
            }
        }
        this.exponent = size2;
        long basePrecision = this.getBasePrecision(precision, this.getDigits(data2[4 - size2]));
        if (basePrecision < (long)size2) {
            size2 = (int)basePrecision;
        }
        while (data2[3 - (int)this.exponent + size2] == 0.0f) {
            --size2;
        }
        this.dataStorage = FloatApfloatImpl.createDataStorage(size2);
        this.dataStorage.setSize(size2);
        ArrayAccess arrayAccess = this.dataStorage.getArray(2, 0L, size2);
        System.arraycopy(data2, 4 - (int)this.exponent, arrayAccess.getData(), arrayAccess.getOffset(), size2);
        arrayAccess.close();
        this.dataStorage.setReadOnly();
    }

    public FloatApfloatImpl(double value2, long precision, int radix) throws NumberFormatException, ApfloatRuntimeException {
        super(FloatApfloatImpl.checkRadix(radix));
        int size2;
        if (Double.isInfinite(value2) || Double.isNaN(value2)) {
            throw new NumberFormatException(value2 + " is not a valid number");
        }
        this.radix = radix;
        if (value2 > 0.0) {
            this.sign = 1;
        } else if (value2 < 0.0) {
            this.sign = -1;
            value2 = -value2;
        } else {
            this.sign = 0;
            this.precision = Long.MAX_VALUE;
            this.exponent = 0L;
            this.dataStorage = null;
            return;
        }
        this.precision = precision;
        float[] data2 = new float[4];
        double doubleBase = FloatRadixConstants.BASE[radix];
        this.exponent = (long)Math.floor(Math.log(value2) / Math.log(doubleBase));
        if (this.exponent > 0L) {
            value2 *= Math.pow(doubleBase, -this.exponent);
        } else if (this.exponent < 0L) {
            value2 *= Math.pow(doubleBase, -this.exponent - 4L);
            value2 *= Math.pow(doubleBase, 4.0);
        }
        ++this.exponent;
        if (value2 < 1.0) {
            value2 = 1.0;
        }
        for (size2 = 0; size2 < 4 && value2 > 0.0; value2 *= doubleBase, ++size2) {
            double tmp = Math.floor(value2);
            assert (tmp <= doubleBase);
            if (tmp == doubleBase) {
                tmp -= 1.0;
            }
            data2[size2] = (float)tmp;
            value2 -= tmp;
        }
        long basePrecision = this.getBasePrecision(precision, this.getDigits(data2[0]));
        if (basePrecision < (long)size2) {
            size2 = (int)basePrecision;
        }
        while (data2[size2 - 1] == 0.0f) {
            --size2;
        }
        this.dataStorage = FloatApfloatImpl.createDataStorage(size2);
        this.dataStorage.setSize(size2);
        ArrayAccess arrayAccess = this.dataStorage.getArray(2, 0L, size2);
        System.arraycopy(data2, 0, arrayAccess.getData(), arrayAccess.getOffset(), size2);
        arrayAccess.close();
        this.dataStorage.setReadOnly();
    }

    private static long readExponent(PushbackReader in) throws IOException, NumberFormatException {
        int input2;
        StringBuilder buffer = new StringBuilder(20);
        long i = 0L;
        while ((input2 = in.read()) != -1) {
            char c = (char)input2;
            int digit2 = Character.digit(c, 10);
            if ((i != 0L || c != '-') && digit2 == -1) {
                in.unread(input2);
                break;
            }
            buffer.append(c);
            ++i;
        }
        return Long.parseLong(buffer.toString());
    }

    /*
     * Enabled aggressive block sorting
     */
    public FloatApfloatImpl(PushbackReader in, long precision, int radix, boolean isInteger) throws IOException, NumberFormatException, ApfloatRuntimeException {
        super(FloatApfloatImpl.checkRadix(radix));
        int slack;
        int input2;
        assert (precision == Long.MIN_VALUE || precision > 0L);
        this.radix = radix;
        this.sign = 1;
        ApfloatContext ctx = ApfloatContext.getContext();
        long initialSize = ctx.getMemoryTreshold() / 4;
        long previousAllocatedSize = 0L;
        long allocatedSize = initialSize;
        this.dataStorage = FloatApfloatImpl.createDataStorage(initialSize);
        this.dataStorage.setSize(initialSize);
        float word = 0.0f;
        int digitsInBase = 0;
        DataStorage.Iterator iterator2 = this.dataStorage.iterator(2, previousAllocatedSize, allocatedSize);
        long actualSize = 0L;
        long startIndex = -1L;
        long pointIndex = -1L;
        long leadingZeros = 0L;
        long trailingZeros = 0L;
        long digitSize = 0L;
        long i = 0L;
        while ((input2 = in.read()) != -1) {
            block23: {
                int digit2;
                block24: {
                    char c = (char)input2;
                    digit2 = Character.digit(c, radix);
                    if (digit2 != -1) break block24;
                    if (i == 0L && (c == '-' || c == '+')) {
                        this.sign = c == '-' ? -1 : 1;
                        break block23;
                    } else if (!isInteger && c == '.' && pointIndex == -1L) {
                        pointIndex = digitSize;
                        break block23;
                    } else {
                        if (!(isInteger || digitSize <= 0L || c != 'e' && c != 'E')) {
                            this.exponent = FloatApfloatImpl.readExponent(in);
                            break;
                        }
                        in.unread(input2);
                        break;
                    }
                }
                if (leadingZeros == digitSize && digit2 == 0) {
                    ++leadingZeros;
                } else {
                    if (startIndex == -1L) {
                        startIndex = i;
                    }
                    word *= (float)radix;
                    word += (float)digit2;
                    if (actualSize == allocatedSize) {
                        if (actualSize == initialSize) {
                            DataStorage dataStorage = FloatApfloatImpl.createDataStorage(0x1FFFFFFFFFFFFFFFL);
                            dataStorage.copyFrom(this.dataStorage, actualSize);
                            this.dataStorage = dataStorage;
                        }
                        previousAllocatedSize = allocatedSize;
                        this.dataStorage.setSize(allocatedSize += (long)FloatApfloatImpl.getBlockSize());
                        iterator2.close();
                        iterator2 = this.dataStorage.iterator(2, previousAllocatedSize, allocatedSize);
                    }
                    if (++digitsInBase == FloatRadixConstants.BASE_DIGITS[radix]) {
                        digitsInBase = 0;
                        iterator2.setFloat(word);
                        iterator2.next();
                        word = 0.0f;
                        ++actualSize;
                    }
                }
                ++digitSize;
                trailingZeros = digit2 == 0 ? ++trailingZeros : 0L;
            }
            ++i;
        }
        if (digitSize == 0L) {
            throw new NumberFormatException("No digits");
        }
        if (startIndex == -1L) {
            this.sign = 0;
            this.precision = Long.MAX_VALUE;
            this.exponent = 0L;
            this.dataStorage = null;
            return;
        }
        if (digitsInBase > 0 && word != 0.0f) {
            while (digitsInBase < FloatRadixConstants.BASE_DIGITS[radix]) {
                word *= (float)radix;
                ++digitsInBase;
            }
            iterator2.setFloat(word);
            ++actualSize;
        }
        iterator2.close();
        if (precision == Long.MIN_VALUE) {
            assert (!isInteger);
            precision = digitSize - leadingZeros;
        }
        this.precision = precision;
        long integerSize = (pointIndex >= 0L ? pointIndex : digitSize) - leadingZeros;
        if (integerSize >= (long)(-(slack = FloatRadixConstants.BASE_DIGITS[radix])) && this.exponent >= Long.MAX_VALUE - integerSize - (long)slack) {
            throw new NumberFormatException("Exponent overflow");
        }
        if (integerSize <= (long)slack && this.exponent <= Long.MIN_VALUE - integerSize + (long)slack) {
            this.sign = 0;
            this.precision = Long.MAX_VALUE;
            this.exponent = 0L;
            this.dataStorage = null;
            return;
        }
        this.exponent += integerSize;
        long baseExp = (this.exponent - (long)(this.exponent < 0L ? FloatRadixConstants.BASE_DIGITS[radix] - 1 : 0)) / (long)FloatRadixConstants.BASE_DIGITS[radix];
        int bias = (int)(this.exponent - baseExp * (long)FloatRadixConstants.BASE_DIGITS[radix]);
        this.exponent = baseExp;
        digitSize -= leadingZeros + trailingZeros;
        digitSize = Math.min(digitSize, precision);
        actualSize = (digitSize + (long)FloatRadixConstants.BASE_DIGITS[radix] - 1L) / (long)FloatRadixConstants.BASE_DIGITS[radix];
        this.dataStorage.setSize(actualSize);
        this.dataStorage.setReadOnly();
        if (bias != 0) {
            long factor = 1L;
            for (int i2 = 0; i2 < bias; factor *= (long)radix, ++i2) {
            }
            FloatApfloatImpl tmp = (FloatApfloatImpl)this.multiply(new FloatApfloatImpl(factor, Long.MAX_VALUE, radix));
            this.exponent = tmp.exponent;
            this.dataStorage = tmp.dataStorage;
            this.initialDigits = Integer.MIN_VALUE;
        }
    }

    private static long getTrailingZeros(DataStorage dataStorage, long index) throws ApfloatRuntimeException {
        long count2 = 0L;
        DataStorage.Iterator iterator2 = dataStorage.iterator(1, index, 0L);
        while (iterator2.hasNext()) {
            if (iterator2.getFloat() != 0.0f) {
                iterator2.close();
                break;
            }
            iterator2.next();
            ++count2;
        }
        return count2;
    }

    private static long getLeadingZeros(DataStorage dataStorage) throws ApfloatRuntimeException {
        long count2 = 0L;
        DataStorage.Iterator iterator2 = dataStorage.iterator(1, 0L, dataStorage.getSize());
        while (iterator2.hasNext()) {
            if (iterator2.getFloat() != 0.0f) {
                iterator2.close();
                break;
            }
            iterator2.next();
            ++count2;
        }
        return count2;
    }

    public ApfloatImpl addOrSubtract(ApfloatImpl x2, boolean subtract) throws ApfloatRuntimeException {
        DataStorage dataStorage;
        long precision;
        long exponent2;
        int sign2;
        boolean reallySubtract;
        if (!(x2 instanceof FloatApfloatImpl)) {
            throw new ImplementationMismatchException("Wrong operand type: " + x2.getClass().getName());
        }
        FloatApfloatImpl that = (FloatApfloatImpl)x2;
        if (this.radix != that.radix) {
            throw new RadixMismatchException("Cannot use numbers with different radixes: " + this.radix + " and " + that.radix);
        }
        assert (this.sign != 0);
        assert (that.sign != 0);
        int realThatSign = subtract ? -that.sign : that.sign;
        boolean bl = reallySubtract = this.sign != realThatSign;
        if (this == that) {
            if (reallySubtract) {
                return this.zero();
            }
            sign2 = this.sign;
            exponent2 = this.exponent;
            precision = this.precision;
            long size2 = this.getSize() + 1L;
            dataStorage = FloatApfloatImpl.createDataStorage(size2);
            dataStorage.setSize(size2);
            DataStorage.Iterator src1 = this.dataStorage.iterator(1, size2 - 1L, 0L);
            DataStorage.Iterator src2 = this.dataStorage.iterator(1, size2 - 1L, 0L);
            DataStorage.Iterator dst = dataStorage.iterator(2, size2, 0L);
            float carry = this.baseAdd(src1, src2, 0.0f, dst, size2 - 1L);
            dst.setFloat(carry);
            dst.close();
            size2 -= FloatApfloatImpl.getTrailingZeros(dataStorage, size2);
            int carrySize = (int)carry;
            int leadingZeros = 1 - carrySize;
            dataStorage = dataStorage.subsequence(leadingZeros, size2 - (long)leadingZeros);
            exponent2 += (long)carrySize;
            if (this.exponent == FloatRadixConstants.MAX_EXPONENT[this.radix] && carrySize > 0) {
                throw new OverflowException("Overflow");
            }
            if (precision != Long.MAX_VALUE && (carrySize > 0 || this.getInitialDigits(dataStorage) > this.getInitialDigits())) {
                ++precision;
            }
        } else {
            long leadingZeros;
            long blockSize;
            long exponentDifference;
            long size3;
            long smallSize;
            long bigSize;
            FloatApfloatImpl small;
            FloatApfloatImpl big;
            int comparison = this.scale() > that.scale() ? 1 : (this.scale() < that.scale() ? -1 : (reallySubtract ? this.compareMantissaTo(that) : 1));
            if (comparison > 0) {
                big = this;
                small = that;
                sign2 = this.sign;
            } else if (comparison < 0) {
                big = that;
                small = this;
                sign2 = realThatSign;
            } else {
                return this.zero();
            }
            long scaleDifference = big.scale() - small.scale();
            if (scaleDifference < 0L) {
                precision = big.precision;
                exponent2 = big.exponent;
                bigSize = big.getSize();
                smallSize = 0L;
                size3 = bigSize;
                exponentDifference = bigSize;
            } else {
                precision = Math.min(big.precision, Util.ifFinite(small.precision, scaleDifference + small.precision));
                long basePrecision = Math.min(FloatRadixConstants.MAX_EXPONENT[this.radix], this.getBasePrecision(precision, big.getInitialDigits()));
                exponent2 = big.exponent;
                exponentDifference = big.exponent - small.exponent;
                size3 = Math.min(basePrecision, Math.max(big.getSize(), exponentDifference + small.getSize()));
                bigSize = Math.min(size3, big.getSize());
                smallSize = Math.max(0L, Math.min(size3 - exponentDifference, small.getSize()));
            }
            long dstSize = size3 + 1L;
            dataStorage = FloatApfloatImpl.createDataStorage(dstSize);
            dataStorage.setSize(dstSize);
            DataStorage.Iterator src1 = big.dataStorage.iterator(1, bigSize, 0L);
            DataStorage.Iterator src2 = small.dataStorage.iterator(1, smallSize, 0L);
            DataStorage.Iterator dst = dataStorage.iterator(2, dstSize, 0L);
            float carry = 0.0f;
            if (size3 > bigSize) {
                blockSize = Math.min(size3 - bigSize, smallSize);
                carry = reallySubtract ? this.baseSubtract(null, src2, carry, dst, blockSize) : this.baseAdd(null, src2, carry, dst, blockSize);
            } else if (size3 > exponentDifference + smallSize) {
                blockSize = size3 - exponentDifference - smallSize;
                carry = reallySubtract ? this.baseSubtract(src1, null, carry, dst, blockSize) : this.baseAdd(src1, null, carry, dst, blockSize);
            }
            if (exponentDifference > bigSize) {
                blockSize = exponentDifference - bigSize;
                carry = reallySubtract ? this.baseSubtract(null, null, carry, dst, blockSize) : this.baseAdd(null, null, carry, dst, blockSize);
            } else if (bigSize > exponentDifference) {
                blockSize = Math.min(bigSize - exponentDifference, smallSize);
                carry = reallySubtract ? this.baseSubtract(src1, src2, carry, dst, blockSize) : this.baseAdd(src1, src2, carry, dst, blockSize);
            }
            if (exponentDifference > 0L) {
                blockSize = Math.min(bigSize, exponentDifference);
                carry = reallySubtract ? this.baseSubtract(src1, null, carry, dst, blockSize) : this.baseAdd(src1, null, carry, dst, blockSize);
            }
            dst.setFloat(carry);
            dst.close();
            if (reallySubtract) {
                leadingZeros = FloatApfloatImpl.getLeadingZeros(dataStorage);
                assert (leadingZeros <= size3);
            } else {
                leadingZeros = carry == 0.0f ? 1 : 0;
                if (this.exponent == FloatRadixConstants.MAX_EXPONENT[this.radix] && leadingZeros == 0L) {
                    throw new OverflowException("Overflow");
                }
            }
            dstSize -= FloatApfloatImpl.getTrailingZeros(dataStorage, dstSize);
            dataStorage = dataStorage.subsequence(leadingZeros, dstSize - leadingZeros);
            if ((exponent2 += 1L - leadingZeros) < -FloatRadixConstants.MAX_EXPONENT[this.radix]) {
                return this.zero();
            }
            if (precision != Long.MAX_VALUE) {
                long scaleChange = (1L - leadingZeros) * (long)FloatRadixConstants.BASE_DIGITS[this.radix] + (long)this.getInitialDigits(dataStorage) - (long)big.getInitialDigits();
                if (-scaleChange >= precision) {
                    return this.zero();
                }
                precision = (precision += scaleChange) <= 0L ? Long.MAX_VALUE : precision;
            }
        }
        dataStorage.setReadOnly();
        return new FloatApfloatImpl(sign2, precision, exponent2, dataStorage, this.radix);
    }

    public ApfloatImpl multiply(ApfloatImpl x2) throws ApfloatRuntimeException {
        int leadingZeros;
        if (!(x2 instanceof FloatApfloatImpl)) {
            throw new ImplementationMismatchException("Wrong operand type: " + x2.getClass().getName());
        }
        FloatApfloatImpl that = (FloatApfloatImpl)x2;
        if (this.radix != that.radix) {
            throw new RadixMismatchException("Cannot multiply numbers with different radixes: " + this.radix + " and " + that.radix);
        }
        int sign2 = this.sign * that.sign;
        if (sign2 == 0) {
            return this.zero();
        }
        long exponent2 = this.exponent + that.exponent;
        if (exponent2 > FloatRadixConstants.MAX_EXPONENT[this.radix]) {
            throw new OverflowException("Overflow");
        }
        if (exponent2 < -FloatRadixConstants.MAX_EXPONENT[this.radix]) {
            return this.zero();
        }
        long precision = Math.min(this.precision, that.precision);
        long basePrecision = this.getBasePrecision(precision, 0);
        long thisSize = this.getSize();
        long thatSize = that.getSize();
        long size2 = Math.min(Util.ifFinite(basePrecision, basePrecision + 1L), thisSize + thatSize);
        long thisDataSize = Math.min(thisSize, basePrecision);
        long thatDataSize = Math.min(thatSize, basePrecision);
        DataStorage thisDataStorage = this.dataStorage.subsequence(0L, thisDataSize);
        DataStorage thatDataStorage = this.dataStorage == that.dataStorage ? thisDataStorage : that.dataStorage.subsequence(0L, thatDataSize);
        ApfloatContext ctx = ApfloatContext.getContext();
        ConvolutionBuilder convolutionBuilder = ctx.getBuilderFactory().getConvolutionBuilder();
        ConvolutionStrategy convolutionStrategy = convolutionBuilder.createConvolution(this.radix, thisDataSize, thatDataSize, size2);
        DataStorage dataStorage = convolutionStrategy.convolute(thisDataStorage, thatDataStorage, size2);
        int n = leadingZeros = FloatApfloatImpl.getMostSignificantWord(dataStorage) == 0.0f ? 1 : 0;
        if ((exponent2 -= (long)leadingZeros) < -FloatRadixConstants.MAX_EXPONENT[this.radix]) {
            return this.zero();
        }
        dataStorage = dataStorage.subsequence(leadingZeros, size2 -= (long)leadingZeros);
        size2 = Math.min(size2, this.getBasePrecision(precision, this.getInitialDigits(dataStorage)));
        size2 -= FloatApfloatImpl.getTrailingZeros(dataStorage, size2);
        dataStorage = dataStorage.subsequence(0L, size2);
        dataStorage.setReadOnly();
        return new FloatApfloatImpl(sign2, precision, exponent2, dataStorage, this.radix);
    }

    public boolean isShort() throws ApfloatRuntimeException {
        return this.sign == 0 || this.getSize() == 1L;
    }

    public ApfloatImpl divideShort(ApfloatImpl x2) throws ApfloatRuntimeException {
        DataStorage dataStorage;
        if (!(x2 instanceof FloatApfloatImpl)) {
            throw new ImplementationMismatchException("Wrong operand type: " + x2.getClass().getName());
        }
        FloatApfloatImpl that = (FloatApfloatImpl)x2;
        if (this.radix != that.radix) {
            throw new RadixMismatchException("Cannot divide numbers with different radixes: " + this.radix + " and " + that.radix);
        }
        assert (this.sign != 0);
        assert (that.sign != 0);
        int sign2 = this.sign * that.sign;
        long exponent2 = this.exponent - that.exponent + 1L;
        if (exponent2 > FloatRadixConstants.MAX_EXPONENT[this.radix]) {
            throw new OverflowException("Overflow");
        }
        if (exponent2 < -FloatRadixConstants.MAX_EXPONENT[this.radix]) {
            return this.zero();
        }
        long precision = Math.min(this.precision, that.precision);
        long basePrecision = this.getBasePrecision();
        long thisDataSize = Math.min(this.getSize(), basePrecision);
        float divisor = FloatApfloatImpl.getMostSignificantWord(that.dataStorage);
        if (divisor == 1.0f) {
            long size2 = thisDataSize - FloatApfloatImpl.getTrailingZeros(this.dataStorage, thisDataSize);
            dataStorage = this.dataStorage.subsequence(0L, size2);
        } else {
            float carry;
            long size3;
            float dividend = divisor;
            for (int i = 0; i < RadixConstants.RADIX_FACTORS[this.radix].length; ++i) {
                float quotient;
                float factor = RadixConstants.RADIX_FACTORS[this.radix][i];
                while (dividend - factor * (quotient = (float)((long)(dividend / factor))) == 0.0f) {
                    dividend = quotient;
                }
            }
            if (dividend != 1.0f) {
                if (basePrecision == Long.MAX_VALUE) {
                    throw new InfiniteExpansionException("Cannot perform inexact division to infinite precision");
                }
                size3 = basePrecision;
            } else {
                carry = 1.0f;
                DataStorage.Iterator dummy = new DataStorage.Iterator(){

                    public void setFloat(float value2) {
                    }

                    public void next() {
                    }
                };
                long sequenceSize = 0L;
                while (carry != 0.0f) {
                    carry = this.baseDivide(null, divisor, carry, dummy, 1L);
                    ++sequenceSize;
                }
                size3 = Math.min(basePrecision, thisDataSize + sequenceSize);
            }
            dataStorage = FloatApfloatImpl.createDataStorage(++size3);
            dataStorage.setSize(size3);
            DataStorage.Iterator src = this.dataStorage.iterator(1, 0L, thisDataSize);
            DataStorage.Iterator dst = dataStorage.iterator(2, 0L, size3);
            carry = this.baseDivide(src, divisor, 0.0f, dst, thisDataSize);
            carry = this.baseDivide(null, divisor, carry, dst, size3 - thisDataSize);
            size3 -= FloatApfloatImpl.getTrailingZeros(dataStorage, size3);
            int leadingZeros = this.getMostSignificantWord() < divisor ? 1 : 0;
            dataStorage = dataStorage.subsequence(leadingZeros, size3 - (long)leadingZeros);
            if ((exponent2 -= (long)leadingZeros) < -FloatRadixConstants.MAX_EXPONENT[this.radix]) {
                return this.zero();
            }
            dataStorage.setReadOnly();
        }
        return new FloatApfloatImpl(sign2, precision, exponent2, dataStorage, this.radix);
    }

    public ApfloatImpl absFloor() throws ApfloatRuntimeException {
        if (this.sign == 0 || this.exponent >= this.dataStorage.getSize()) {
            return this.precision(Long.MAX_VALUE);
        }
        if (this.exponent <= 0L) {
            return this.zero();
        }
        long size2 = this.exponent;
        size2 -= FloatApfloatImpl.getTrailingZeros(this.dataStorage, size2);
        DataStorage dataStorage = this.dataStorage.subsequence(0L, size2);
        FloatApfloatImpl apfloatImpl = new FloatApfloatImpl(this.sign, Long.MAX_VALUE, this.exponent, dataStorage, this.radix);
        return apfloatImpl;
    }

    public ApfloatImpl absCeil() throws ApfloatRuntimeException {
        long exponent2;
        DataStorage dataStorage;
        if (this.sign == 0) {
            return this;
        }
        DataStorage.Iterator iterator2 = null;
        if (this.exponent <= 0L) {
            int size2 = 1;
            dataStorage = FloatApfloatImpl.createDataStorage(size2);
            dataStorage.setSize(size2);
            ArrayAccess arrayAccess = dataStorage.getArray(2, 0L, size2);
            arrayAccess.getFloatData()[arrayAccess.getOffset()] = 1.0f;
            arrayAccess.close();
            exponent2 = 1L;
        } else if (this.getSize() <= this.exponent || this.findMismatch(iterator2 = this.getZeroPaddedIterator(this.exponent, this.getSize()), ZERO_ITERATOR, this.getSize() - this.exponent) < 0L) {
            long size3 = Math.min(this.getSize(), this.exponent);
            size3 -= FloatApfloatImpl.getTrailingZeros(this.dataStorage, size3);
            dataStorage = this.dataStorage.subsequence(0L, size3);
            exponent2 = this.exponent;
        } else {
            long size4 = this.exponent;
            dataStorage = FloatApfloatImpl.createDataStorage(size4 + 1L);
            dataStorage.setSize(size4 + 1L);
            DataStorage.Iterator src = this.dataStorage.iterator(1, size4, 0L);
            DataStorage.Iterator dst = dataStorage.iterator(2, size4 + 1L, 0L);
            float carry = this.baseAdd(src, null, 1.0f, dst, size4);
            dst.setFloat(carry);
            src.close();
            dst.close();
            int carrySize = (int)carry;
            size4 -= FloatApfloatImpl.getTrailingZeros(dataStorage, size4 + 1L);
            dataStorage = dataStorage.subsequence(1 - carrySize, size4 + (long)carrySize);
            exponent2 = this.exponent + (long)carrySize;
        }
        if (iterator2 != null) {
            iterator2.close();
        }
        dataStorage.setReadOnly();
        FloatApfloatImpl apfloatImpl = new FloatApfloatImpl(this.sign, Long.MAX_VALUE, exponent2, dataStorage, this.radix);
        return apfloatImpl;
    }

    private ApfloatImpl zero() {
        return new FloatApfloatImpl(0, Long.MAX_VALUE, 0L, null, this.radix);
    }

    public int radix() {
        return this.radix;
    }

    public long precision() {
        return this.precision;
    }

    public long size() throws ApfloatRuntimeException {
        assert (this.dataStorage != null);
        return (long)this.getInitialDigits() + (this.getSize() - 1L) * (long)FloatRadixConstants.BASE_DIGITS[this.radix] - this.getLeastZeros();
    }

    private long getLeastZeros() throws ApfloatRuntimeException {
        if (this.leastZeros == Integer.MIN_VALUE) {
            long index = this.getSize() - 1L;
            float word = this.getWord(index);
            word = this.getLeastSignificantWord(index, word);
            long leastZeros = 0L;
            if (word == 0.0f) {
                long trailingZeros = FloatApfloatImpl.getTrailingZeros(this.dataStorage, index) + 1L;
                word = this.getWord(index -= trailingZeros);
                word = this.getLeastSignificantWord(index, word);
                leastZeros += trailingZeros * (long)FloatRadixConstants.BASE_DIGITS[this.radix];
            }
            assert (word != 0.0f);
            while (word % (float)this.radix == 0.0f) {
                ++leastZeros;
                word /= (float)this.radix;
            }
            this.leastZeros = leastZeros;
        }
        return this.leastZeros;
    }

    public ApfloatImpl precision(long precision) {
        if (this.sign == 0 || precision == this.precision) {
            return this;
        }
        return new FloatApfloatImpl(this.sign, precision, this.exponent, this.dataStorage, this.radix);
    }

    public long scale() throws ApfloatRuntimeException {
        assert (this.dataStorage != null);
        return (this.exponent - 1L) * (long)FloatRadixConstants.BASE_DIGITS[this.radix] + (long)this.getInitialDigits();
    }

    public int signum() {
        return this.sign;
    }

    public ApfloatImpl negate() throws ApfloatRuntimeException {
        return new FloatApfloatImpl(-this.sign, this.precision, this.exponent, this.dataStorage, this.radix);
    }

    public double doubleValue() {
        if (this.sign == 0) {
            return 0.0;
        }
        double value2 = 0.0;
        double doubleBase = FloatRadixConstants.BASE[this.radix];
        int size2 = (int)Math.min(4L, this.getSize());
        DataStorage.Iterator iterator2 = this.dataStorage.iterator(1, size2, 0L);
        while (iterator2.hasNext()) {
            value2 += (double)iterator2.getFloat();
            value2 /= doubleBase;
            iterator2.next();
        }
        if (this.exponent > 0L) {
            return (double)this.sign * value2 * Math.pow(FloatRadixConstants.BASE[this.radix], this.exponent - 1L) * (double)FloatRadixConstants.BASE[this.radix];
        }
        return (double)this.sign * value2 * Math.pow(FloatRadixConstants.BASE[this.radix], this.exponent);
    }

    public long longValue() {
        if (this.sign == 0 || this.exponent <= 0L) {
            return 0L;
        }
        if (this.exponent > 4L) {
            return this.sign > 0 ? Long.MAX_VALUE : Long.MIN_VALUE;
        }
        long value2 = 0L;
        long longBase = (long)FloatRadixConstants.BASE[this.radix];
        long maxPrevious = Long.MIN_VALUE / longBase;
        int size2 = (int)Math.min(this.exponent, this.getSize());
        DataStorage.Iterator iterator2 = this.dataStorage.iterator(1, 0L, size2);
        for (int i = 0; i < (int)this.exponent; ++i) {
            if (value2 < maxPrevious) {
                value2 = 0L;
                iterator2.close();
                break;
            }
            value2 *= longBase;
            if (i >= size2) continue;
            value2 -= (long)iterator2.getFloat();
            iterator2.next();
        }
        if (value2 == Long.MIN_VALUE || value2 >= 0L) {
            return this.sign > 0 ? Long.MAX_VALUE : Long.MIN_VALUE;
        }
        return (long)(-this.sign) * value2;
    }

    public boolean isOne() throws ApfloatRuntimeException {
        return this.sign == 1 && this.exponent == 1L && this.getSize() == 1L && this.getMostSignificantWord() == 1.0f;
    }

    public long equalDigits(ApfloatImpl x2) throws ApfloatRuntimeException {
        long index;
        float carry;
        float value2;
        if (!(x2 instanceof FloatApfloatImpl)) {
            throw new ImplementationMismatchException("Wrong operand type: " + x2.getClass().getName());
        }
        FloatApfloatImpl that = (FloatApfloatImpl)x2;
        if (this.radix != that.radix) {
            throw new RadixMismatchException("Cannot compare values with different radixes: " + this.radix + " and " + that.radix);
        }
        if (this.sign == 0 && that.sign == 0) {
            return Long.MAX_VALUE;
        }
        if (this.sign != that.sign) {
            return 0L;
        }
        long thisScale = this.scale();
        long thatScale = that.scale();
        long minScale = Math.min(thisScale, thatScale);
        long maxScale = Math.max(thisScale, thatScale);
        if (maxScale - 1L > minScale) {
            return 0L;
        }
        long thisSize = this.getSize();
        long thatSize = that.getSize();
        long size2 = Math.max(thisSize, thatSize);
        DataStorage.Iterator thisIterator = this.getZeroPaddedIterator(0L, thisSize);
        DataStorage.Iterator thatIterator = that.getZeroPaddedIterator(0L, thatSize);
        long result2 = Math.min(this.precision, that.precision);
        int lastMatchingDigits = -1;
        float base = FloatRadixConstants.BASE[this.radix];
        if (this.exponent > that.exponent) {
            value2 = thisIterator.getFloat();
            if (value2 != 1.0f) {
                thisIterator.close();
                thatIterator.close();
                return 0L;
            }
            carry = base;
            thisIterator.next();
        } else if (this.exponent < that.exponent) {
            value2 = thatIterator.getFloat();
            if (value2 != 1.0f) {
                thisIterator.close();
                thatIterator.close();
                return 0L;
            }
            carry = -base;
            thatIterator.next();
        } else {
            carry = 0.0f;
        }
        for (index = 0L; index < size2; ++index) {
            value2 = thisIterator.getFloat() - thatIterator.getFloat() + carry;
            if (value2 == 0.0f) {
                carry = 0.0f;
            } else {
                if (Math.abs(value2) > 1.0f) {
                    if (Math.abs(value2) >= base) {
                        lastMatchingDigits = -1;
                        break;
                    }
                    lastMatchingDigits = FloatRadixConstants.BASE_DIGITS[this.radix] - this.getDigits(Math.abs(value2));
                    break;
                }
                if (value2 == 1.0f) {
                    carry = base;
                } else if (value2 == -1.0f) {
                    carry = -base;
                }
            }
            thisIterator.next();
            thatIterator.next();
        }
        if (index < size2 || carry != 0.0f) {
            long initialMatchingDigits = this.exponent == that.exponent ? Math.min(this.getInitialDigits(), that.getInitialDigits()) : FloatRadixConstants.BASE_DIGITS[this.radix];
            long middleMatchingDigits = (index - 1L) * (long)FloatRadixConstants.BASE_DIGITS[this.radix];
            result2 = Math.min(result2, initialMatchingDigits + middleMatchingDigits + (long)lastMatchingDigits);
            result2 = Math.max(result2, 0L);
        }
        thisIterator.close();
        thatIterator.close();
        return result2;
    }

    public int compareTo(ApfloatImpl x2) throws ApfloatRuntimeException {
        if (!(x2 instanceof FloatApfloatImpl)) {
            throw new ImplementationMismatchException("Wrong operand type: " + x2.getClass().getName());
        }
        FloatApfloatImpl that = (FloatApfloatImpl)x2;
        if (this.sign == 0 && that.sign == 0) {
            return 0;
        }
        if (this.sign < that.sign) {
            return -1;
        }
        if (this.sign > that.sign) {
            return 1;
        }
        if (this.radix != that.radix) {
            throw new RadixMismatchException("Cannot compare values with different radixes: " + this.radix + " and " + that.radix);
        }
        if (this.scale() < that.scale()) {
            return -this.sign;
        }
        if (this.scale() > that.scale()) {
            return this.sign;
        }
        return this.sign * this.compareMantissaTo(that);
    }

    private DataStorage.Iterator getZeroPaddedIterator(final long start, final long end) throws ApfloatRuntimeException {
        final DataStorage.Iterator iterator2 = this.dataStorage.iterator(1, start, end);
        return new DataStorage.Iterator(){
            private long index;
            {
                this.index = start;
            }

            public float getFloat() throws ApfloatRuntimeException {
                float value2;
                if (this.index < end) {
                    value2 = iterator2.getFloat();
                    if (this.index == end - 1L) {
                        value2 = FloatApfloatImpl.this.getLeastSignificantWord(this.index, value2);
                    }
                } else {
                    value2 = 0.0f;
                }
                return value2;
            }

            public void next() throws ApfloatRuntimeException {
                if (this.index < end) {
                    iterator2.next();
                    ++this.index;
                }
            }

            public void close() throws ApfloatRuntimeException {
                iterator2.close();
            }
        };
    }

    private int compareMantissaTo(FloatApfloatImpl that) throws ApfloatRuntimeException {
        long thisSize = this.getSize();
        long thatSize = that.getSize();
        long size2 = Math.max(thisSize, thatSize);
        DataStorage.Iterator thisIterator = this.getZeroPaddedIterator(0L, thisSize);
        DataStorage.Iterator thatIterator = that.getZeroPaddedIterator(0L, thatSize);
        int result2 = 0;
        long index = this.findMismatch(thisIterator, thatIterator, size2);
        if (index >= 0L) {
            float thatValue;
            float thisValue = thisIterator.getFloat();
            if (thisValue < (thatValue = thatIterator.getFloat())) {
                result2 = -1;
            } else if (thisValue > thatValue) {
                result2 = 1;
            }
        }
        thisIterator.close();
        thatIterator.close();
        return result2;
    }

    private long findMismatch(DataStorage.Iterator thisIterator, DataStorage.Iterator thatIterator, long size2) throws ApfloatRuntimeException {
        for (long index = 0L; index < size2; ++index) {
            float thatValue;
            float thisValue = thisIterator.getFloat();
            if (thisValue != (thatValue = thatIterator.getFloat())) {
                return index;
            }
            thisIterator.next();
            thatIterator.next();
        }
        return -1L;
    }

    private float getLeastSignificantWord(long index, float word) throws ApfloatRuntimeException {
        if (this.precision == Long.MAX_VALUE) {
            return word;
        }
        long digits = (long)this.getInitialDigits() + index * (long)FloatRadixConstants.BASE_DIGITS[this.radix];
        if (this.precision >= digits) {
            return word;
        }
        float divisor = FloatRadixConstants.MINIMUM_FOR_DIGITS[this.radix][(int)(digits - this.precision)];
        return (float)((long)(word / divisor)) * divisor;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ApfloatImpl)) {
            return false;
        }
        ApfloatImpl thatImpl = (ApfloatImpl)obj;
        if (this.signum() == 0 && thatImpl.signum() == 0) {
            return true;
        }
        if (this.isOne() && thatImpl.isOne()) {
            return true;
        }
        if (!(obj instanceof FloatApfloatImpl)) {
            return false;
        }
        FloatApfloatImpl that = (FloatApfloatImpl)obj;
        if (this.radix != that.radix) {
            return false;
        }
        if (this.sign != that.sign || this.scale() != that.scale()) {
            return false;
        }
        return this.compareMantissaTo(that) == 0;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int hashCode = 1 + this.sign + (int)this.exponent + (int)(this.exponent >>> 32);
            if (this.dataStorage != null) {
                long size2 = this.getSize();
                long i = 0L;
                while (i < size2) {
                    float word = this.getWord(i);
                    if (i == size2 - 1L) {
                        word = this.getLeastSignificantWord(i, word);
                    }
                    long element = (long)word;
                    hashCode += (int)element + (int)(element >>> 32);
                    i = i + i + 1L;
                }
            }
            this.hashCode = hashCode;
        }
        return this.hashCode;
    }

    public String toString(boolean pretty) throws ApfloatRuntimeException {
        long length;
        if (this.sign == 0) {
            return "0";
        }
        long size2 = this.getSize() * (long)FloatRadixConstants.BASE_DIGITS[this.radix];
        if (pretty) {
            long scale = this.scale();
            length = scale <= 0L ? 2L - scale + size2 : (size2 > scale ? 1L + size2 : scale);
            length += (long)(this.sign < 0 ? 1 : 0);
        } else {
            length = size2 + 24L;
        }
        if (length > Integer.MAX_VALUE || length < 0L) {
            throw new ApfloatInternalException("Number is too large to fit in a String");
        }
        StringWriter writer = new StringWriter((int)length);
        try {
            this.writeTo(writer, pretty);
        }
        catch (IOException ioe) {
            throw new ApfloatInternalException("Unexpected I/O error writing to StringWriter", ioe);
        }
        String value2 = writer.toString();
        assert ((long)value2.length() <= length);
        return value2;
    }

    private static void writeZeros(Writer out, long count2) throws IOException {
        for (long i = 0L; i < count2; ++i) {
            out.write(48);
        }
    }

    public void writeTo(Writer out, boolean pretty) throws IOException, ApfloatRuntimeException {
        long size2;
        long exponent2;
        long integerDigits;
        if (this.sign == 0) {
            out.write(48);
            return;
        }
        if (this.sign < 0) {
            out.write(45);
        }
        if (pretty) {
            if (this.exponent <= 0L) {
                out.write("0.");
                FloatApfloatImpl.writeZeros(out, -this.scale());
                integerDigits = -1L;
            } else {
                integerDigits = this.scale();
            }
            exponent2 = 0L;
        } else {
            integerDigits = 1L;
            exponent2 = this.scale() - 1L;
        }
        boolean leftPadZeros = false;
        long digitsToWrite = Math.min(this.precision, (long)this.getInitialDigits() + (size2 - 1L) * (long)FloatRadixConstants.BASE_DIGITS[this.radix]);
        long digitsWritten = 0L;
        long trailingZeros = 0L;
        DataStorage.Iterator iterator2 = this.dataStorage.iterator(1, 0L, size2);
        char[] buffer = new char[FloatRadixConstants.BASE_DIGITS[this.radix]];
        for (size2 = this.getSize(); size2 > 0L; --size2) {
            int start = leftPadZeros ? 0 : FloatRadixConstants.BASE_DIGITS[this.radix] - this.getInitialDigits();
            int digits = (int)Math.min(digitsToWrite, (long)(FloatRadixConstants.BASE_DIGITS[this.radix] - start));
            this.formatWord(buffer, iterator2.getFloat());
            for (int i = 0; i < digits; ++i) {
                char c = buffer[start + i];
                if (c == '0') {
                    ++trailingZeros;
                    --digitsToWrite;
                    continue;
                }
                while (trailingZeros > 0L) {
                    if (digitsWritten == integerDigits) {
                        out.write(46);
                    }
                    out.write(48);
                    ++digitsWritten;
                    --trailingZeros;
                }
                if (digitsWritten == integerDigits) {
                    out.write(46);
                }
                out.write(c);
                ++digitsWritten;
                --digitsToWrite;
            }
            leftPadZeros = true;
            iterator2.next();
        }
        if (!pretty && exponent2 != 0L) {
            out.write("e" + exponent2);
        }
        FloatApfloatImpl.writeZeros(out, integerDigits - digitsWritten);
    }

    private void formatWord(char[] buffer, float word) {
        int position = FloatRadixConstants.BASE_DIGITS[this.radix];
        while (position > 0 && word > 0.0f) {
            float newWord = (long)(word / (float)this.radix);
            int digit2 = (int)(word - newWord * (float)this.radix);
            word = newWord;
            buffer[--position] = Character.forDigit(digit2, this.radix);
        }
        while (position > 0) {
            buffer[--position] = 48;
        }
    }

    private long getSize() throws ApfloatRuntimeException {
        assert (this.dataStorage != null);
        return Math.min(this.getBasePrecision(), this.dataStorage.getSize());
    }

    private static int checkRadix(int radix) throws NumberFormatException {
        if (radix < 2 || radix > 36) {
            throw new NumberFormatException("Invalid radix " + radix + "; radix must be between " + 2 + " and " + 36);
        }
        return radix;
    }

    private float getMostSignificantWord() throws ApfloatRuntimeException {
        return FloatApfloatImpl.getMostSignificantWord(this.dataStorage);
    }

    private static float getMostSignificantWord(DataStorage dataStorage) throws ApfloatRuntimeException {
        ArrayAccess arrayAccess = dataStorage.getArray(1, 0L, 1);
        float msw = arrayAccess.getFloatData()[arrayAccess.getOffset()];
        arrayAccess.close();
        return msw;
    }

    private int getInitialDigits() throws ApfloatRuntimeException {
        if (this.initialDigits == Integer.MIN_VALUE) {
            this.initialDigits = this.getDigits(this.getMostSignificantWord());
        }
        return this.initialDigits;
    }

    private int getInitialDigits(DataStorage dataStorage) throws ApfloatRuntimeException {
        return this.getDigits(FloatApfloatImpl.getMostSignificantWord(dataStorage));
    }

    private int getDigits(float x2) {
        assert (x2 > 0.0f);
        float[] minimums = FloatRadixConstants.MINIMUM_FOR_DIGITS[this.radix];
        int i = minimums.length;
        while (x2 < minimums[--i]) {
        }
        return i + 1;
    }

    private long getBasePrecision() throws ApfloatRuntimeException {
        return this.getBasePrecision(this.precision, this.getInitialDigits());
    }

    private long getBasePrecision(long precision, int mswDigits) {
        if (precision == Long.MAX_VALUE) {
            return Long.MAX_VALUE;
        }
        return (precision + (long)FloatRadixConstants.BASE_DIGITS[this.radix] - (long)mswDigits - 1L) / (long)FloatRadixConstants.BASE_DIGITS[this.radix] + 1L;
    }

    private float getWord(long index) {
        ArrayAccess arrayAccess = this.dataStorage.getArray(1, index, 1);
        float word = arrayAccess.getFloatData()[arrayAccess.getOffset()];
        arrayAccess.close();
        return word;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.leastZeros = Integer.MIN_VALUE;
        in.defaultReadObject();
    }

    private static DataStorage createDataStorage(long size2) throws ApfloatRuntimeException {
        ApfloatContext ctx = ApfloatContext.getContext();
        DataStorageBuilder dataStorageBuilder = ctx.getBuilderFactory().getDataStorageBuilder();
        return dataStorageBuilder.createDataStorage(size2 * 4L);
    }

    private static int getBlockSize() {
        ApfloatContext ctx = ApfloatContext.getContext();
        return ctx.getBlockSize() / 4;
    }
}

