/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.internal;

import org.apfloat.ApfloatContext;
import org.apfloat.ApfloatRuntimeException;
import org.apfloat.internal.DoubleDiskDataStorage;
import org.apfloat.internal.DoubleMemoryDataStorage;
import org.apfloat.spi.DataStorage;
import org.apfloat.spi.DataStorageBuilder;

public class DoubleDataStorageBuilder
implements DataStorageBuilder {
    public DataStorage createDataStorage(long size2) throws ApfloatRuntimeException {
        ApfloatContext ctx = ApfloatContext.getContext();
        if (size2 <= (long)ctx.getMemoryTreshold()) {
            return new DoubleMemoryDataStorage();
        }
        return new DoubleDiskDataStorage();
    }

    public DataStorage createCachedDataStorage(long size2) throws ApfloatRuntimeException {
        ApfloatContext ctx = ApfloatContext.getContext();
        if (size2 <= ctx.getMaxMemoryBlockSize()) {
            return new DoubleMemoryDataStorage();
        }
        return new DoubleDiskDataStorage();
    }

    public DataStorage createDataStorage(DataStorage dataStorage) throws ApfloatRuntimeException {
        ApfloatContext ctx;
        long size2;
        if (dataStorage instanceof DoubleMemoryDataStorage && (size2 = dataStorage.getSize()) > (long)(ctx = ApfloatContext.getContext()).getMemoryTreshold()) {
            DoubleDiskDataStorage tmp = new DoubleDiskDataStorage();
            tmp.copyFrom(dataStorage);
            dataStorage = tmp;
        }
        return dataStorage;
    }
}

