/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sf.samtools.util.BlockCompressedFilePointerUtil;

class Chunk
implements Cloneable,
Serializable,
Comparable<Chunk> {
    private static final long serialVersionUID = 1L;
    private long mChunkStart;
    private long mChunkEnd;

    public Chunk(long start, long end) {
        this.mChunkStart = start;
        this.mChunkEnd = end;
    }

    public Chunk clone() {
        return new Chunk(this.mChunkStart, this.mChunkEnd);
    }

    protected long getChunkStart() {
        return this.mChunkStart;
    }

    protected void setChunkStart(long value2) {
        this.mChunkStart = value2;
    }

    protected long getChunkEnd() {
        return this.mChunkEnd;
    }

    protected void setChunkEnd(long value2) {
        this.mChunkEnd = value2;
    }

    @Override
    public int compareTo(Chunk chunk) {
        int result2 = Long.signum(this.mChunkStart - chunk.mChunkStart);
        if (result2 == 0) {
            result2 = Long.signum(this.mChunkEnd - chunk.mChunkEnd);
        }
        return result2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Chunk chunk = (Chunk)o;
        if (this.mChunkEnd != chunk.mChunkEnd) {
            return false;
        }
        return this.mChunkStart == chunk.mChunkStart;
    }

    public boolean overlaps(Chunk other) {
        long rightMostBlockAddress;
        int comparison = this.compareTo(other);
        if (comparison == 0) {
            return true;
        }
        Chunk leftMost = comparison == -1 ? this : other;
        Chunk rightMost = comparison == 1 ? this : other;
        long leftMostBlockAddress = BlockCompressedFilePointerUtil.getBlockAddress(leftMost.getChunkEnd());
        if (leftMostBlockAddress > (rightMostBlockAddress = BlockCompressedFilePointerUtil.getBlockAddress(rightMost.getChunkStart()))) {
            return true;
        }
        if (leftMostBlockAddress == rightMostBlockAddress) {
            int rightMostOffset;
            int leftMostOffset = BlockCompressedFilePointerUtil.getBlockOffset(leftMost.getChunkEnd());
            return leftMostOffset > (rightMostOffset = BlockCompressedFilePointerUtil.getBlockOffset(rightMost.getChunkStart()));
        }
        return false;
    }

    public boolean isAdjacentTo(Chunk other) {
        return BlockCompressedFilePointerUtil.getBlockAddress(this.getChunkEnd()) == BlockCompressedFilePointerUtil.getBlockAddress(other.getChunkStart()) && BlockCompressedFilePointerUtil.getBlockOffset(this.getChunkEnd()) == BlockCompressedFilePointerUtil.getBlockOffset(other.getChunkStart()) || BlockCompressedFilePointerUtil.getBlockAddress(this.getChunkStart()) == BlockCompressedFilePointerUtil.getBlockAddress(other.getChunkEnd()) && BlockCompressedFilePointerUtil.getBlockOffset(this.getChunkStart()) == BlockCompressedFilePointerUtil.getBlockOffset(other.getChunkEnd());
    }

    public int hashCode() {
        int result2 = (int)(this.mChunkStart ^ this.mChunkStart >>> 32);
        result2 = 31 * result2 + (int)(this.mChunkEnd ^ this.mChunkEnd >>> 32);
        return result2;
    }

    public String toString() {
        return String.format("%d:%d-%d:%d", this.mChunkStart >> 16, this.mChunkStart & 0xFFFFL, this.mChunkEnd >> 16, this.mChunkEnd & 0xFFFFL);
    }

    public static List<Chunk> optimizeChunkList(List<Chunk> chunks, long minimumOffset) {
        Chunk lastChunk = null;
        Collections.sort(chunks);
        ArrayList<Chunk> result2 = new ArrayList<Chunk>();
        for (Chunk chunk : chunks) {
            if (chunk.getChunkEnd() <= minimumOffset) continue;
            if (result2.isEmpty()) {
                result2.add(chunk);
                lastChunk = chunk;
                continue;
            }
            if (!lastChunk.overlaps(chunk) && !lastChunk.isAdjacentTo(chunk)) {
                result2.add(chunk);
                lastChunk = chunk;
                continue;
            }
            if (chunk.getChunkEnd() <= lastChunk.getChunkEnd()) continue;
            lastChunk.setChunkEnd(chunk.getChunkEnd());
        }
        return result2;
    }
}

