/*
 * Decompiled with CFR 0.152.
 */
package DistLib.rng;

import DistLib.StdUniformRng;

public class WichmannHill
implements StdUniformRng {
    int i1_seed = 123;
    int[] i_seed = new int[2];
    static final int c0 = 30269;
    static final int c1 = 30307;
    static final int c2 = 30323;

    public WichmannHill() {
        this.fixupSeeds();
    }

    public void fixupSeeds() {
        if (this.i1_seed == 0) {
            ++this.i1_seed;
        }
        int j = 0;
        while (j < this.i_seed.length) {
            if (this.i_seed[j] == 0) {
                int n = j;
                this.i_seed[n] = this.i_seed[n] + 1;
            }
            ++j;
        }
        if (this.i1_seed >= 30269 || this.i_seed[0] >= 30307 || this.i_seed[1] >= 30323) {
            this.random();
        }
    }

    public double random() {
        this.i1_seed = this.i1_seed * 171 % 30269;
        this.i_seed[0] = this.i_seed[0] * 172 % 30307;
        this.i_seed[1] = this.i_seed[1] * 170 % 30323;
        double value2 = (double)this.i1_seed / 30269.0 + (double)this.i_seed[0] / 30307.0 + (double)this.i_seed[1] / 30323.0;
        return value2 - (double)((int)value2);
    }
}

