/*
 * Decompiled with CFR 0.152.
 */
package DistLib;

import DistLib.uniform;

public class cauchy {
    public static double density(double x2, double location, double scale) {
        if (Double.isNaN(x2) || Double.isNaN(location) || Double.isNaN(scale)) {
            return x2 + location + scale;
        }
        if (scale <= 0.0) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        double y = (x2 - location) / scale;
        return 1.0 / (Math.PI * scale * (1.0 + y * y));
    }

    public static double cumulative(double x2, double location, double scale) {
        if (Double.isNaN(x2) || Double.isNaN(location) || Double.isNaN(scale)) {
            return x2 + location + scale;
        }
        if (scale <= 0.0) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        if (Double.isInfinite(x2 = (x2 - location) / scale)) {
            if (x2 < 0.0) {
                return 0.0;
            }
            return 1.0;
        }
        return 0.5 + Math.atan(x2) / Math.PI;
    }

    public static double quantile(double x2, double location, double scale) {
        if (Double.isNaN(x2) || Double.isNaN(location) || Double.isNaN(scale)) {
            return x2 + location + scale;
        }
        if (Double.isInfinite(x2) || Double.isInfinite(location) || Double.isInfinite(scale)) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        if (scale <= 0.0) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        return location + scale * Math.tan(Math.PI * (x2 - 0.5));
    }

    public static double random(double location, double scale, uniform PRNG) {
        if (Double.isInfinite(location) || Double.isInfinite(scale) || scale < 0.0) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        return location + scale * Math.tan(Math.PI * uniform.random());
    }
}

