/*
 * Decompiled with CFR 0.152.
 */
package com.informagen.giv;

import com.informagen.giv.MapGlyph;
import com.informagen.giv.MosaicLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.Hashtable;

public class MapTile
extends Container {
    String name = null;
    Color bkgColor = null;
    private int hGap = 0;
    private int vGap = 0;
    boolean selected = false;
    private int tileWidth;
    private Hashtable properties = null;

    public MapTile() {
        this(2);
    }

    public MapTile(String string) {
        this(2);
        this.setName(string);
    }

    public MapTile(int n) {
        this("Floating", n, n);
    }

    public MapTile(String string, int n, int n2) {
        this.setBuoyancy(string, n, n2);
    }

    public Insets getInsets() {
        Insets insets = (Insets)super.getInsets().clone();
        insets.top += this.vGap;
        insets.bottom += this.vGap;
        insets.left += this.hGap;
        insets.right += this.hGap;
        return insets;
    }

    public MapTile(MapGlyph mapGlyph) {
        this(mapGlyph, 2);
    }

    public MapTile(MapGlyph mapGlyph, int n) {
        this("Floating", n, n);
        this.add(mapGlyph);
    }

    public void addMouseListener(MouseListener mouseListener) {
        super.addMouseListener(mouseListener);
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            componentArray[i].addMouseListener(mouseListener);
        }
    }

    void setBuoyancy(int n, int n2, int n3) {
        this.setLayout(new MosaicLayout(n, n2, n3));
    }

    public void setBuoyancy(String string) {
        this.setBuoyancy(string, this.hGap, this.vGap);
    }

    void setBuoyancy(String string, int n, int n2) {
        this.hGap = n;
        this.vGap = n2;
        int n3 = 0;
        if (string.equals("Floating")) {
            n3 = 0;
        } else if (string.equals("Sinking")) {
            n3 = 1;
        } else if (string.equals("TopDown")) {
            n3 = 2;
        } else if (string.equals("BottomUp")) {
            n3 = 3;
        } else if (string.equals("StackUp")) {
            n3 = 4;
        } else if (string.equals("StackDown")) {
            n3 = 5;
        } else if (string.equals("Collapsed")) {
            n3 = 6;
        }
        this.setLayout(new MosaicLayout(n3, n, n2));
    }

    public void setLabel(String string) {
        this.name = string;
    }

    public String getLabel() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setBkgColor(Color color) {
        this.bkgColor = color;
    }

    public Color getBkgColor() {
        return this.bkgColor;
    }

    public boolean hasPropertyPair(String string, String string2) {
        if (this.properties == null) {
            return false;
        }
        String string3 = (String)this.properties.get(string);
        return string2.equalsIgnoreCase(string3);
    }

    public void putStringProperty(String string, String string2) {
        if (this.properties == null) {
            this.properties = new Hashtable();
        }
        this.properties.put(string, string2);
    }

    public String getStringProperty(String string) {
        if (this.properties == null) {
            return null;
        }
        return (String)this.properties.get(string);
    }

    public void adjustSize(double d, double d2) {
        Serializable serializable;
        Component component;
        int n;
        int n2 = Integer.MAX_VALUE;
        int n3 = Integer.MIN_VALUE;
        Component[] componentArray = this.getComponents();
        for (n = 0; n < componentArray.length; ++n) {
            int n4;
            int n5;
            component = componentArray[n];
            if (component instanceof MapGlyph) {
                serializable = (MapGlyph)component;
                n5 = (int)Math.floor(((double)((MapGlyph)serializable).mStart - d) * d2);
                n4 = (int)Math.ceil(((double)((MapGlyph)serializable).mStop - d) * d2);
                ((MapGlyph)serializable).setBarWidth(n4 - n5 + 1);
                int n6 = n5 - ((MapGlyph)serializable).mBarInset;
                int n7 = n6 + ((Component)serializable).getSize().width;
                if (n6 < n2) {
                    n2 = n6;
                }
                if (n7 > n3) {
                    n3 = n7;
                }
                ((Component)serializable).setLocation(n6, 0);
                continue;
            }
            if (!(component instanceof MapTile)) continue;
            serializable = (MapTile)component;
            ((MapTile)serializable).adjustSize(d, d2);
            n5 = ((Component)serializable).getLocation().x;
            n4 = n5 + ((Component)serializable).getSize().width;
            if (n5 < n2) {
                n2 = n5;
            }
            if (n4 <= n3) continue;
            n3 = n4;
        }
        this.tileWidth = this.hGap + (n3 - n2) + this.hGap;
        for (n = 0; n < componentArray.length; ++n) {
            component = componentArray[n];
            serializable = component.getLocation();
            ((Point)serializable).x -= n2;
            ((Point)serializable).x += this.hGap;
            ((Point)serializable).y = 0;
            component.setLocation((Point)serializable);
        }
        this.setLocation(n2, 0);
        this.setSize(this.getPreferredSize());
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this.getLayout().preferredLayoutSize(this);
        dimension.width = this.tileWidth;
        return dimension;
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        if (this.bkgColor != null) {
            graphics.setColor(this.bkgColor);
            graphics.fillRect(0, 0, dimension.width, dimension.height);
        }
        if (this.selected) {
            graphics.setColor(Color.black);
            graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
        }
        super.paint(graphics);
    }
}

