/*
 * Decompiled with CFR 0.152.
 */
package edsim51sh;

import edsim51sh.Memory;
import edsim51sh.instructions.ExecutedInstructionInfo;
import edsim51sh.instructions.Instruction;
import edsim51sh.instructions.InstructionInfo;
import edsim51sh.instructions.InstructionSetArray;
import java.util.Vector;

public class Cpu {
    public static final int P0 = 128;
    public static final int P1 = 144;
    public static final int P2 = 160;
    public static final int P3 = 176;
    public static final int PSW = 208;
    public static final int ACC = 224;
    public static final int B = 240;
    public static final int SP = 129;
    public static final int DPL = 130;
    public static final int DPH = 131;
    public static final int PCON = 135;
    public static final int TCON = 136;
    public static final int TMOD = 137;
    public static final int TL0 = 138;
    public static final int TL1 = 139;
    public static final int TH0 = 140;
    public static final int TH1 = 141;
    public static final int IE = 168;
    public static final int IP = 184;
    public static final int SCON = 152;
    public static final int SBUF = 153;
    public static final int CY = 215;
    public static final int AC = 214;
    public static final int F0 = 213;
    public static final int RS1 = 212;
    public static final int RS0 = 211;
    public static final int OV = 210;
    public static final int P = 208;
    public static final int TF1 = 143;
    public static final int TR1 = 142;
    public static final int TF0 = 141;
    public static final int TR0 = 140;
    public static final int IE1 = 139;
    public static final int IT1 = 138;
    public static final int IE0 = 137;
    public static final int IT0 = 136;
    public static final int EA = 175;
    public static final int ES = 172;
    public static final int ET1 = 171;
    public static final int EX1 = 170;
    public static final int ET0 = 169;
    public static final int EX0 = 168;
    public static final int PS = 188;
    public static final int PT1 = 187;
    public static final int PX1 = 186;
    public static final int PT0 = 185;
    public static final int PX0 = 184;
    public static final int RD = 183;
    public static final int WR = 182;
    public static final int T1 = 181;
    public static final int T0 = 180;
    public static final int INT1 = 179;
    public static final int INT0 = 178;
    public static final int TXD = 177;
    public static final int RXD = 176;
    public static final int SM0 = 159;
    public static final int SM1 = 158;
    public static final int SM2 = 157;
    public static final int REN = 156;
    public static final int TB8 = 155;
    public static final int RB8 = 154;
    public static final int TI = 153;
    public static final int RI = 152;
    public static final int[] vectorTable = new int[]{0, 3, 11, 19, 27, 35};
    public boolean running = false;
    public Memory memory = new Memory();
    public boolean codeLoaded = false;
    private InstructionSetArray allInstructions = new InstructionSetArray();
    private int pc = 0;
    private boolean previousInt0 = true;
    private boolean previousInt1 = true;
    private int instructionCycles;
    private int batchCycles;
    private long programCycles = 0L;
    private int numberOfExecutedInstructions = 0;
    private double machineCycleLength = 1.0;

    public int getPc() {
        return this.pc;
    }

    public void setPc(int pc) {
        this.pc = pc & 0xFFFF;
    }

    public boolean setMachineCycleLength(double machineCycleLength) {
        if (this.machineCycleLength == machineCycleLength) {
            return false;
        }
        this.machineCycleLength = machineCycleLength;
        return true;
    }

    public double getMachineCycleLength() {
        return this.machineCycleLength;
    }

    private boolean isFlagSet(int interruptSource) {
        try {
            if (interruptSource == 0) {
                return this.memory.getBit(137) == 1;
            }
            if (interruptSource == 1) {
                return this.memory.getBit(141) == 1;
            }
            if (interruptSource == 2) {
                return this.memory.getBit(139) == 1;
            }
            if (interruptSource == 3) {
                return this.memory.getBit(143) == 1;
            }
            if (interruptSource == 4) {
                return this.memory.getBit(152) == 1 || this.memory.getBit(153) == 1;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private void clearFlag(int interruptSource) {
        try {
            if (interruptSource == 1) {
                this.memory.clearBit(141);
            } else if (interruptSource == 3) {
                this.memory.clearBit(143);
            } else if (interruptSource == 0 && this.memory.getBit(136) == 1) {
                this.memory.clearBit(137);
            } else if (interruptSource == 2 && this.memory.getBit(138) == 1) {
                this.memory.clearBit(139);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean isHighPriority(int interruptSource) {
        if (interruptSource >= 0 && interruptSource <= 4) {
            try {
                int ip = this.memory.readByte(184);
                return ((ip >>= interruptSource) & 1) == 1;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private boolean isEnabled(int interruptSource) {
        if (interruptSource == 7 || interruptSource >= 0 && interruptSource <= 4) {
            try {
                int ip = this.memory.readByte(168);
                return ((ip >>= interruptSource) & 1) == 1;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private boolean isEnableAllSet() {
        return this.isEnabled(7);
    }

    private int getVector(int interruptSource) {
        if (interruptSource >= 0 && interruptSource <= 4) {
            return vectorTable[interruptSource + 1];
        }
        return 0;
    }

    private void pollExternalInterrupt0() {
        try {
            boolean edgeTriggered;
            boolean bl = edgeTriggered = this.memory.getBit(136) == 1;
            if (edgeTriggered) {
                if (this.previousInt0 && !this.memory.port3.isPortPinHigh(2)) {
                    this.memory.setBit(137);
                }
            } else if (!this.memory.port3.isPortPinHigh(2)) {
                this.memory.setBit(137);
            }
            this.previousInt0 = this.memory.port3.isPortPinHigh(2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void pollExternalInterrupt1() {
        try {
            boolean edgeTriggered;
            boolean bl = edgeTriggered = this.memory.getBit(138) == 1;
            if (edgeTriggered) {
                if (this.previousInt1 && !this.memory.port3.isPortPinHigh(3)) {
                    this.memory.setBit(139);
                }
            } else if (!this.memory.port3.isPortPinHigh(3)) {
                this.memory.setBit(139);
            }
            this.previousInt1 = this.memory.port3.isPortPinHigh(3);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private int vectorToIsr(int currentPc) {
        int i;
        if (!this.isEnableAllSet() || this.memory.getInterruptLevel() == 1) {
            return currentPc;
        }
        for (i = 0; i <= 4; ++i) {
            if (!this.isEnabled(i) || !this.isHighPriority(i) || !this.isFlagSet(i)) continue;
            if (this.memory.getInterruptLevel() == 0) {
                this.memory.setIsrNested(true);
            }
            this.memory.setInterruptLevel(1);
            this.clearFlag(i);
            this.pushReturnAddress(this.pc);
            return this.getVector(i);
        }
        if (this.memory.getInterruptLevel() == 0) {
            return currentPc;
        }
        for (i = 0; i <= 4; ++i) {
            if (!this.isEnabled(i) || !this.isFlagSet(i)) continue;
            this.memory.setInterruptLevel(0);
            this.clearFlag(i);
            this.pushReturnAddress(this.pc);
            return this.getVector(i);
        }
        return currentPc;
    }

    private void pushReturnAddress(int returnAddress) {
        try {
            int sp = this.memory.readByte(129) + 1;
            if (sp == 256) {
                sp = 0;
            }
            this.memory.writeByte(sp, this.pc & 0xFF);
            if (++sp == 256) {
                sp = 0;
            }
            this.memory.writeByte(129, sp);
            this.memory.writeByte(sp, this.pc >> 8);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void reset() {
        this.codeLoaded = false;
        this.pc = 0;
        this.previousInt0 = false;
        this.previousInt1 = false;
        this.batchCycles = 0;
        this.programCycles = 0L;
        this.numberOfExecutedInstructions = 0;
        this.memory.reset();
    }

    public void loadCode(InstructionInfo[] codeMemory) {
        if (codeMemory != null) {
            this.memory.codeMemory = codeMemory;
            this.codeLoaded = true;
            this.pc = 0;
        }
    }

    private void setPortGuiUpdateFlags(boolean b) {
        this.memory.port0.setTimeToUpdateGui(b);
        this.memory.port1.setTimeToUpdateGui(b);
        this.memory.port2.setTimeToUpdateGui(b);
        this.memory.port3.setTimeToUpdateGui(b);
    }

    int getInstructionCycles() {
        return this.instructionCycles;
    }

    long getInstructionElapsedTimeInNanos() {
        return Math.round((double)this.instructionCycles * this.machineCycleLength * 1000.0);
    }

    int getInstructionElapsedTime() {
        return Math.round((float)this.instructionCycles * (float)this.machineCycleLength);
    }

    int getBatchElapsedTime() {
        return Math.round((float)this.batchCycles * (float)this.machineCycleLength);
    }

    long getProgramElapsedTime() {
        return Math.round((double)this.programCycles * this.machineCycleLength);
    }

    String getProgramElapsedTimeString() {
        long temp = Math.round((double)this.programCycles * this.machineCycleLength);
        long min = temp / 60000000L;
        long sec = (temp %= 60000000L) / 1000000L;
        long milli = (temp %= 1000000L) / 1000L;
        long micro = temp % 1000L;
        String s = "";
        if (micro != 0L) {
            s = s + micro + "us";
        }
        if (milli != 0L) {
            s = milli + "ms " + s;
        }
        if (sec != 0L) {
            s = sec + "s " + s;
        }
        if (min != 0L) {
            s = min + "m " + s;
        }
        return s;
    }

    public int getNumberOfExecutedInstructions() {
        return this.numberOfExecutedInstructions;
    }

    private boolean isBreakpoint(Vector breakpoints, int pc) {
        if (breakpoints == null) {
            return false;
        }
        for (int i = 0; i < breakpoints.size(); ++i) {
            if ((Integer)breakpoints.elementAt(i) != pc) continue;
            return true;
        }
        return false;
    }

    public ExecutedInstructionInfo executeInstructions(int instructionBatchSize, Vector breakpoints, boolean stopAtMovx) throws Exception {
        this.setPortGuiUpdateFlags(false);
        ExecutedInstructionInfo info = new ExecutedInstructionInfo();
        this.batchCycles = 0;
        for (int instructionNumber = 0; instructionNumber < instructionBatchSize; ++instructionNumber) {
            ++this.numberOfExecutedInstructions;
            Instruction instruction = this.allInstructions.array[this.memory.codeMemory[this.pc].getCode()];
            this.instructionCycles = instruction.cycles;
            for (int i = 0; i < instruction.cycles; ++i) {
                ++this.batchCycles;
                ++this.programCycles;
                this.memory.timer0.step();
                this.memory.timer1.step();
                this.memory.serial.poll();
                this.pollExternalInterrupt0();
                this.pollExternalInterrupt1();
            }
            if (instructionNumber == instructionBatchSize - 1) {
                this.setPortGuiUpdateFlags(true);
            }
            if (instruction.size > 1) {
                int operand0Position = this.pc + 1;
                if (operand0Position == 65536) {
                    operand0Position = 0;
                }
                instruction.operand0 = this.memory.codeMemory[operand0Position].getCode();
            }
            if (instruction.size > 2) {
                int operand1Position = this.pc + 2;
                if (operand1Position >= 65536) {
                    operand1Position -= 65536;
                }
                instruction.operand1 = this.memory.codeMemory[operand1Position].getCode();
            }
            if (instructionBatchSize == 1) {
                info.pc = this.pc;
                info.preAssembledLine = this.memory.codeMemory[this.pc].getText();
            }
            this.pc = instruction.execute(this.memory, this.pc);
            if (instructionNumber == instructionBatchSize - 1) {
                info.mneumonic = instruction.toString();
            }
            if (this.memory.hasRetiJustBeenExecuted()) {
                this.memory.setRetiJustExecuted(false);
            } else {
                this.pc = this.vectorToIsr(this.pc);
            }
            if (this.pc > 65535) {
                this.pc = 0;
            }
            this.memory.updatePortPins();
            if (stopAtMovx && instruction.mneumonic.startsWith("MOVX")) {
                info.isMovx = true;
                return info;
            }
            if (!this.isBreakpoint(breakpoints, this.pc)) continue;
            info.isBreakpoint = true;
            return info;
        }
        return info;
    }
}

