/*
 * Decompiled with CFR 0.152.
 */
package org.forester.surfacing;

import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.forester.species.Species;
import org.forester.util.BasicDescriptiveStatistics;
import org.forester.util.DescriptiveStatistics;

public class DomainLengths {
    final String _domain_id;
    final SortedMap<Species, DescriptiveStatistics> _length_statistics;

    public DomainLengths(String string) {
        this._domain_id = string;
        this._length_statistics = new TreeMap<Species, DescriptiveStatistics>();
    }

    public void addLength(Species species, int n) {
        if (!this.getLengthStatistics().containsKey(species)) {
            this.addLengthStatistics(species, new BasicDescriptiveStatistics());
        }
        this.getLengthStatistic(species).addValue(n);
    }

    public DescriptiveStatistics calculateMeanBasedStatistics() {
        BasicDescriptiveStatistics basicDescriptiveStatistics = new BasicDescriptiveStatistics();
        for (DescriptiveStatistics descriptiveStatistics : this.getLengthStatisticsList()) {
            basicDescriptiveStatistics.addValue(descriptiveStatistics.arithmeticMean());
        }
        return basicDescriptiveStatistics;
    }

    public double calculateZScoreForSpecies(Species species) {
        double d = this.getLengthStatistic(species).arithmeticMean();
        DescriptiveStatistics descriptiveStatistics = this.calculateMeanBasedStatistics();
        double d2 = descriptiveStatistics.sampleStandardDeviation();
        double d3 = descriptiveStatistics.arithmeticMean();
        return (d - d3) / d2;
    }

    public String getDomainId() {
        return this._domain_id;
    }

    public DescriptiveStatistics getLengthStatistic(Species species) {
        return (DescriptiveStatistics)this.getLengthStatistics().get(species);
    }

    public List<DescriptiveStatistics> getLengthStatisticsList() {
        ArrayList<DescriptiveStatistics> arrayList = new ArrayList<DescriptiveStatistics>();
        for (DescriptiveStatistics descriptiveStatistics : this._length_statistics.values()) {
            arrayList.add(descriptiveStatistics);
        }
        return arrayList;
    }

    public List<Species> getMeanBasedOutlierSpecies(double d) {
        ArrayList<Species> arrayList = new ArrayList<Species>();
        if (this.getSpeciesList().size() > 1) {
            for (Species species : this.getSpeciesList()) {
                double d2 = this.calculateZScoreForSpecies(species);
                if (d < 0.0) {
                    if (!(d2 <= d)) continue;
                    arrayList.add(species);
                    continue;
                }
                if (!(d > 0.0) || !(d2 >= d)) continue;
                arrayList.add(species);
            }
        }
        return arrayList;
    }

    public List<Species> getSpeciesList() {
        ArrayList<Species> arrayList = new ArrayList<Species>();
        for (Species species : this._length_statistics.keySet()) {
            arrayList.add(species);
        }
        return arrayList;
    }

    public boolean isHasLengthStatistic(Species species) {
        return this.getLengthStatistics().containsKey(species);
    }

    private void addLengthStatistics(Species species, DescriptiveStatistics descriptiveStatistics) {
        if (this.getLengthStatistics().containsKey(species)) {
            throw new IllegalArgumentException("length statistics for [" + species.getSpeciesId() + "] already added");
        }
        this.getLengthStatistics().put(species, descriptiveStatistics);
    }

    private SortedMap<Species, DescriptiveStatistics> getLengthStatistics() {
        return this._length_statistics;
    }
}

