/*
 * Decompiled with CFR 0.152.
 */
package org.forester.surfacing;

import java.util.HashMap;
import java.util.Map;
import org.forester.protein.BasicDomain;
import org.forester.protein.BinaryDomainCombination;
import org.forester.util.ForesterUtil;

public class BasicBinaryDomainCombination
implements BinaryDomainCombination {
    static final boolean VERBOSE = false;
    private static final Map<Integer, BasicBinaryDomainCombination> DC_POOL = new HashMap<Integer, BasicBinaryDomainCombination>();
    private static final Map<Integer, String> S_POOL = new HashMap<Integer, String>();
    short _id0;
    short _id1;

    BasicBinaryDomainCombination() {
        this._id0 = (short)-1;
        this._id1 = (short)-1;
    }

    private BasicBinaryDomainCombination(String string, String string2) {
        if (string == null || string2 == null) {
            throw new IllegalArgumentException("attempt to create binary domain combination using null");
        }
        if (string.indexOf("=") != -1 || string2.indexOf("=") != -1) {
            throw new IllegalArgumentException("ill formatted domain id: " + string + ", " + string2);
        }
        if (string.toLowerCase().compareTo(string2.toLowerCase()) < 0) {
            this._id0 = BasicDomain.obtainIdAsShort(string);
            this._id1 = BasicDomain.obtainIdAsShort(string2);
        } else {
            this._id0 = BasicDomain.obtainIdAsShort(string2);
            this._id1 = BasicDomain.obtainIdAsShort(string);
        }
    }

    @Override
    public final int compareTo(BinaryDomainCombination binaryDomainCombination) {
        if (binaryDomainCombination.getClass() != this.getClass()) {
            throw new IllegalArgumentException("attempt to compare [" + binaryDomainCombination.getClass() + "] to [" + this.getClass() + "]");
        }
        if (this.equals(binaryDomainCombination)) {
            return 0;
        }
        int n = this.getId0().compareTo(binaryDomainCombination.getId0());
        if (n != 0) {
            return n;
        }
        return this.getId1().compareTo(binaryDomainCombination.getId1());
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            throw new IllegalArgumentException("attempt to check [" + this.getClass() + "] equality to null");
        }
        if (object.getClass() != this.getClass()) {
            throw new IllegalArgumentException("attempt to check [" + this.getClass() + "] equality to [" + object.getClass() + "]");
        }
        return this.getId0Code() == ((BinaryDomainCombination)object).getId0Code() && this.getId1Code() == ((BinaryDomainCombination)object).getId1Code();
    }

    @Override
    public final String getId0() {
        return BasicDomain.obtainIdFromShort(this._id0);
    }

    @Override
    public final short getId0Code() {
        return this._id0;
    }

    @Override
    public final String getId1() {
        return BasicDomain.obtainIdFromShort(this._id1);
    }

    @Override
    public final short getId1Code() {
        return this._id1;
    }

    public final int hashCode() {
        return BasicBinaryDomainCombination.calcCode(this._id0, this._id1);
    }

    @Override
    public final StringBuffer toGraphDescribingLanguage(BinaryDomainCombination.OutputFormat outputFormat, String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        switch (outputFormat) {
            case DOT: {
                if (ForesterUtil.isEmpty(string)) {
                    stringBuffer.append(this.getId0());
                    stringBuffer.append(" -- ");
                    stringBuffer.append(this.getId1());
                    if (!ForesterUtil.isEmpty(string2)) {
                        stringBuffer.append(" ");
                        stringBuffer.append(string2);
                    }
                    stringBuffer.append(";");
                    break;
                }
                stringBuffer.append(this.getId0());
                stringBuffer.append(" ");
                stringBuffer.append(string);
                stringBuffer.append(";");
                stringBuffer.append(ForesterUtil.LINE_SEPARATOR);
                stringBuffer.append(this.getId1());
                stringBuffer.append(" ");
                stringBuffer.append(string);
                stringBuffer.append(";");
                stringBuffer.append(ForesterUtil.LINE_SEPARATOR);
                stringBuffer.append(this.getId0());
                stringBuffer.append(" -- ");
                stringBuffer.append(this.getId1());
                if (!ForesterUtil.isEmpty(string2)) {
                    stringBuffer.append(" ");
                    stringBuffer.append(string2);
                }
                stringBuffer.append(";");
                break;
            }
            default: {
                throw new AssertionError((Object)("unknown format:" + (Object)((Object)outputFormat)));
            }
        }
        return stringBuffer;
    }

    public final String toString() {
        int n = BasicBinaryDomainCombination.calcCode(this._id0, this._id1);
        if (S_POOL.containsKey(n)) {
            return S_POOL.get(n);
        }
        String string = this.getId0() + "=" + this.getId1();
        S_POOL.put(n, string);
        return string;
    }

    public static BinaryDomainCombination obtainInstance(String string) {
        if (string.indexOf("=") < 1) {
            throw new IllegalArgumentException("Unexpected format for binary domain combination [" + string + "]");
        }
        String[] stringArray = string.split("=");
        if (stringArray.length != 2) {
            throw new IllegalArgumentException("Unexpected format for binary domain combination [" + string + "]");
        }
        return BasicBinaryDomainCombination.obtainInstance(stringArray[0], stringArray[1]);
    }

    public static BasicBinaryDomainCombination obtainInstance(String string, String string2) {
        int n = string.toLowerCase().compareTo(string2.toLowerCase()) < 0 ? BasicBinaryDomainCombination.calcCode(BasicDomain.obtainIdAsShort(string), BasicDomain.obtainIdAsShort(string2)) : BasicBinaryDomainCombination.calcCode(BasicDomain.obtainIdAsShort(string2), BasicDomain.obtainIdAsShort(string));
        if (DC_POOL.containsKey(n)) {
            return DC_POOL.get(n);
        }
        BasicBinaryDomainCombination basicBinaryDomainCombination = new BasicBinaryDomainCombination(string, string2);
        DC_POOL.put(n, basicBinaryDomainCombination);
        return basicBinaryDomainCombination;
    }

    static final int calcCode(int n, int n2) {
        return n * 32768 + n2;
    }
}

