/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogeny.data;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.forester.phylogeny.data.BinaryCharacters;
import org.forester.phylogeny.data.Date;
import org.forester.phylogeny.data.Distribution;
import org.forester.phylogeny.data.Event;
import org.forester.phylogeny.data.NodeVisualData;
import org.forester.phylogeny.data.PhylogenyData;
import org.forester.phylogeny.data.PropertiesList;
import org.forester.phylogeny.data.Property;
import org.forester.phylogeny.data.Reference;
import org.forester.phylogeny.data.Sequence;
import org.forester.phylogeny.data.Taxonomy;
import org.forester.util.ForesterUtil;

public class NodeData
implements PhylogenyData {
    private String _node_name;
    private Event _event;
    private List<Sequence> _sequences;
    private List<Taxonomy> _taxonomies;
    private List<Distribution> _distributions;
    private Date _date;
    private BinaryCharacters _binary_characters;
    private PropertiesList _properties;
    private List<Reference> _references;
    private List<Double> _vector;
    private NodeVisualData _node_visual_data;

    public NodeData() {
        this.init();
    }

    private void init() {
        this._node_name = "";
        this._event = null;
        this._sequences = null;
        this._taxonomies = null;
        this._distributions = null;
        this._date = null;
        this._binary_characters = null;
        this._properties = null;
        this._references = null;
        this._vector = null;
        this._node_visual_data = null;
    }

    public void addDistribution(Distribution distribution) {
        if (this._distributions == null) {
            this._distributions = new ArrayList<Distribution>();
        }
        this._distributions.add(distribution);
    }

    public void addReference(Reference reference) {
        if (this._references == null) {
            this._references = new ArrayList<Reference>();
        }
        this._references.add(reference);
    }

    public void addSequence(Sequence sequence) {
        if (this._sequences == null) {
            this._sequences = new ArrayList<Sequence>();
        }
        this._sequences.add(sequence);
    }

    public void addTaxonomy(Taxonomy taxonomy) {
        if (this._taxonomies == null) {
            this._taxonomies = new ArrayList<Taxonomy>();
        }
        this._taxonomies.add(taxonomy);
    }

    @Override
    public StringBuffer asSimpleText() {
        throw new UnsupportedOperationException();
    }

    @Override
    public StringBuffer asText() {
        throw new UnsupportedOperationException();
    }

    @Override
    public PhylogenyData copy() {
        NodeData nodeData = new NodeData();
        nodeData.setNodeName(this.getNodeName());
        if (this.getSequences() != null && this.getSequences().size() > 0) {
            nodeData.setSequences(new ArrayList<Sequence>());
            for (Sequence phylogenyData : this.getSequences()) {
                if (phylogenyData == null) continue;
                nodeData.addSequence((Sequence)phylogenyData.copy());
            }
        }
        if (this.isHasEvent()) {
            nodeData.setEvent((Event)this.getEvent().copy());
        }
        if (this.getTaxonomies() != null && this.getTaxonomies().size() > 0) {
            nodeData.setTaxonomies(new ArrayList<Taxonomy>());
            for (Taxonomy taxonomy : this.getTaxonomies()) {
                if (taxonomy == null) continue;
                nodeData.addTaxonomy((Taxonomy)taxonomy.copy());
            }
        }
        if (this.isHasBinaryCharacters()) {
            nodeData.setBinaryCharacters((BinaryCharacters)this.getBinaryCharacters().copy());
        }
        if (this.getReferences() != null && this.getReferences().size() > 0) {
            nodeData.setReferences(new ArrayList<Reference>());
            for (Reference reference : this.getReferences()) {
                if (reference == null) continue;
                nodeData.addReference((Reference)reference.copy());
            }
        }
        if (this.getDistributions() != null && this.getDistributions().size() > 0) {
            nodeData.setDistributions(new ArrayList<Distribution>());
            for (Distribution distribution : this.getDistributions()) {
                if (distribution == null) continue;
                nodeData.addDistribution((Distribution)distribution.copy());
            }
        }
        if (this.getNodeVisualData() != null && !this.getNodeVisualData().isEmpty()) {
            nodeData.setNodeVisualData((NodeVisualData)this.getNodeVisualData().copy());
        }
        if (this.isHasDate()) {
            nodeData.setDate((Date)this.getDate().copy());
        }
        if (this.isHasProperties()) {
            nodeData.setProperties((PropertiesList)this.getProperties().copy());
        }
        return nodeData;
    }

    public BinaryCharacters getBinaryCharacters() {
        return this._binary_characters;
    }

    public Date getDate() {
        return this._date;
    }

    public Distribution getDistribution() {
        return this.getDistribution(0);
    }

    public Distribution getDistribution(int n) {
        if (this._distributions == null) {
            return null;
        }
        return this._distributions.get(n);
    }

    public List<Distribution> getDistributions() {
        return this._distributions;
    }

    public Event getEvent() {
        return this._event;
    }

    public PropertiesList getProperties() {
        return this._properties;
    }

    public Reference getReference() {
        return this.getReference(0);
    }

    public Reference getReference(int n) {
        if (this._references == null) {
            return null;
        }
        return this._references.get(n);
    }

    public List<Reference> getReferences() {
        return this._references;
    }

    public Sequence getSequence() {
        return this.getSequence(0);
    }

    public Sequence getSequence(int n) {
        if (this._sequences == null) {
            return null;
        }
        return this._sequences.get(n);
    }

    public List<Sequence> getSequences() {
        return this._sequences;
    }

    public List<Taxonomy> getTaxonomies() {
        return this._taxonomies;
    }

    public Taxonomy getTaxonomy() {
        return this.getTaxonomy(0);
    }

    public Taxonomy getTaxonomy(int n) {
        if (this._taxonomies == null) {
            return null;
        }
        return this._taxonomies.get(n);
    }

    @Override
    public boolean isEqual(PhylogenyData phylogenyData) {
        throw new NoSuchMethodError();
    }

    public boolean isHasBinaryCharacters() {
        return this.getBinaryCharacters() != null;
    }

    public boolean isEmpty() {
        return ForesterUtil.isEmpty(this._node_name) && !this.isHasSequence() && !this.isHasTaxonomy() && !this.isHasBinaryCharacters() && !this.isHasDate() && !this.isHasDistribution() && !this.isHasEvent() && !this.isHasProperties() && !this.isHasReference() && (this._vector == null || this._vector.isEmpty());
    }

    public boolean isHasDate() {
        return this.getDate() != null && (!ForesterUtil.isEmpty(this.getDate().getDesc()) || !ForesterUtil.isNull(this.getDate().getMax()) || !ForesterUtil.isNull(this.getDate().getMin()) || !ForesterUtil.isNull(this.getDate().getValue()) || !ForesterUtil.isEmpty(this.getDate().getUnit()));
    }

    public boolean isHasDistribution() {
        return this.getDistributions() != null && this.getDistributions().size() > 0 && (!ForesterUtil.isEmpty(this.getDistribution().getDesc()) || this.getDistribution().getPoints() != null && this.getDistribution().getPoints().size() > 0 || this.getDistribution().getPolygons() != null && this.getDistribution().getPolygons().size() > 0);
    }

    public boolean isHasEvent() {
        return this.getEvent() != null;
    }

    public boolean isHasProperties() {
        return this.getProperties() != null && this.getProperties().size() > 0;
    }

    public boolean isHasReference() {
        return this.getReferences() != null && this.getReferences().size() > 0 && (!ForesterUtil.isEmpty(this.getReference().getDoi()) || !ForesterUtil.isEmpty(this.getReference().getDescription()));
    }

    public boolean isHasSequence() {
        return this.getSequences() != null && this.getSequences().size() > 0 && this.getSequences().get(0) != null;
    }

    public boolean isHasTaxonomy() {
        return this.getTaxonomies() != null && this.getTaxonomies().size() > 0 && this.getTaxonomies().get(0) != null;
    }

    public void setBinaryCharacters(BinaryCharacters binaryCharacters) {
        this._binary_characters = binaryCharacters;
    }

    public void setDate(Date date) {
        this._date = date;
    }

    public void setDistribution(Distribution distribution) {
        if (this._distributions == null) {
            this._distributions = new ArrayList<Distribution>();
        }
        if (this._distributions.size() == 0) {
            this._distributions.add(distribution);
        } else {
            this._distributions.set(0, distribution);
        }
    }

    public void setDistribution(int n, Distribution distribution) {
        if (this._distributions == null) {
            this._distributions = new ArrayList<Distribution>();
        }
        this._distributions.set(n, distribution);
    }

    private void setDistributions(List<Distribution> list) {
        this._distributions = list;
    }

    public void setEvent(Event event) {
        this._event = event;
    }

    public void setProperties(PropertiesList propertiesList) {
        this._properties = propertiesList;
    }

    public void setReference(int n, Reference reference) {
        if (this._references == null) {
            this._references = new ArrayList<Reference>();
        }
        this._references.set(n, reference);
    }

    public void setReference(Reference reference) {
        if (this._references == null) {
            this._references = new ArrayList<Reference>();
        }
        if (this._references.size() == 0) {
            this._references.add(reference);
        } else {
            this._references.set(0, reference);
        }
    }

    private void setReferences(List<Reference> list) {
        this._references = list;
    }

    public void setSequence(int n, Sequence sequence) {
        if (this._sequences == null) {
            this._sequences = new ArrayList<Sequence>();
        }
        this._sequences.set(n, sequence);
    }

    public void setSequence(Sequence sequence) {
        if (this._sequences == null) {
            this._sequences = new ArrayList<Sequence>();
        }
        if (this._sequences.size() == 0) {
            this._sequences.add(sequence);
        } else {
            this._sequences.set(0, sequence);
        }
    }

    private void setSequences(List<Sequence> list) {
        this._sequences = list;
    }

    private void setTaxonomies(List<Taxonomy> list) {
        this._taxonomies = list;
    }

    public void setTaxonomy(int n, Taxonomy taxonomy) {
        if (this._taxonomies == null) {
            this._taxonomies = new ArrayList<Taxonomy>();
        }
        this._taxonomies.set(n, taxonomy);
    }

    public void setTaxonomy(Taxonomy taxonomy) {
        if (this._taxonomies == null) {
            this._taxonomies = new ArrayList<Taxonomy>();
        }
        if (this._taxonomies.size() == 0) {
            this._taxonomies.add(taxonomy);
        } else {
            this._taxonomies.set(0, taxonomy);
        }
    }

    @Override
    public StringBuffer toNHX() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isHasTaxonomy()) {
            stringBuffer.append(this.getTaxonomy().toNHX());
        }
        if (this.isHasSequence()) {
            stringBuffer.append(this.getSequence().toNHX());
        }
        if (this.isHasEvent()) {
            stringBuffer.append(this.getEvent().toNHX());
        }
        return stringBuffer;
    }

    @Override
    public void toPhyloXML(Writer writer, int n, String string) throws IOException {
        if (this.isHasTaxonomy()) {
            for (Taxonomy object : this.getTaxonomies()) {
                if (object.isEmpty()) continue;
                object.toPhyloXML(writer, n, string);
            }
        }
        if (this.isHasSequence()) {
            for (Sequence sequence : this.getSequences()) {
                if (sequence.isEmpty()) continue;
                sequence.toPhyloXML(writer, n, string);
            }
        }
        if (this.isHasEvent()) {
            this.getEvent().toPhyloXML(writer, n, string);
        }
        if (this.isHasBinaryCharacters()) {
            this.getBinaryCharacters().toPhyloXML(writer, n, string);
        }
        if (this.isHasDistribution()) {
            for (Distribution distribution : this.getDistributions()) {
                distribution.toPhyloXML(writer, n, string);
            }
        }
        if (this.isHasDate()) {
            this.getDate().toPhyloXML(writer, n, string);
        }
        if (this.isHasReference()) {
            for (Reference reference : this.getReferences()) {
                reference.toPhyloXML(writer, n, string);
            }
        }
        if (this.isHasProperties()) {
            this.getProperties().toPhyloXML(writer, n, string.substring(0, string.length() - 2));
        }
        if (n == 0 && this.getNodeVisualData() != null && !this.getNodeVisualData().isEmpty()) {
            this.getNodeVisualData().toPhyloXML(writer, n, string.substring(0, string.length() - 2));
        }
        if (this.getVector() != null && !this.getVector().isEmpty() && (this.getProperties() == null || this.getProperties().getPropertiesWithGivenReferencePrefix("vector:index=").isEmpty())) {
            List<Property> list = this.vectorToProperties(this.getVector());
            String string2 = string.substring(0, string.length() - 2);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Property property = (Property)iterator.next();
                property.toPhyloXML(writer, n, string2);
            }
        }
    }

    private List<Property> vectorToProperties(List<Double> list) {
        ArrayList<Property> arrayList = new ArrayList<Property>();
        for (int i = 0; i < list.size(); ++i) {
            arrayList.add(new Property("vector:index=" + i, String.valueOf(list.get(i)), "", "xsd:decimal", Property.AppliesTo.NODE));
        }
        return arrayList;
    }

    public void setVector(List<Double> list) {
        this._vector = list;
    }

    public List<Double> getVector() {
        return this._vector;
    }

    public String getNodeName() {
        return this._node_name;
    }

    public void setNodeName(String string) {
        this._node_name = string;
    }

    public void setNodeVisualData(NodeVisualData nodeVisualData) {
        this._node_visual_data = nodeVisualData;
    }

    public NodeVisualData getNodeVisualData() {
        return this._node_visual_data;
    }
}

