/*
 * Decompiled with CFR 0.152.
 */
package org.forester.msa;

import org.forester.msa.BasicMsa;
import org.forester.sequence.BasicSequence;
import org.forester.sequence.MolecularSequence;

public final class ResampleableMsa
extends BasicMsa {
    private int[] _resampled_column_positions = null;

    public ResampleableMsa(BasicMsa basicMsa) {
        super(basicMsa);
    }

    @Override
    public final char getResidueAt(int n, int n2) {
        if (this._resampled_column_positions != null) {
            return super.getResidueAt(n, this._resampled_column_positions[n2]);
        }
        return super.getResidueAt(n, n2);
    }

    public final void resample(int[] nArray) {
        if (nArray.length != this.getLength()) {
            throw new IllegalArgumentException("illegal attempt to use " + nArray.length + " resampled column positions on msa of length " + this.getLength());
        }
        this._resampled_column_positions = nArray;
    }

    @Override
    public final void setResidueAt(int n, int n2, char c) {
        throw new NoSuchMethodError("illegal attempt to set residue in resampleable msa");
    }

    @Override
    public MolecularSequence getSequence(int n) {
        return new BasicSequence(this.getIdentifier(n), this.getSequenceAsString(n).toString(), this.getType());
    }
}

