/*
 * Decompiled with CFR 0.152.
 */
package org.forester.evoinference.distance;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.forester.evoinference.distance.Sarray;
import org.forester.evoinference.matrix.distance.BasicSymmetricalDistanceMatrix;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.util.ForesterUtil;

public final class NeighborJoiningR {
    private static final DecimalFormat DF = new DecimalFormat("0.00000");
    private BasicSymmetricalDistanceMatrix _d;
    private double[][] _d_values;
    private final DecimalFormat _df;
    private PhylogenyNode[] _external_nodes;
    private int[] _mappings;
    private int _n;
    private double[] _r;
    private final boolean _verbose;
    private int _min_i;
    private int _min_j;
    private Sarray _s;
    private double _d_min;
    private int[] _rev_mappings;
    private double _umax;
    private double _rmax;

    private NeighborJoiningR() {
        this._verbose = false;
        this._df = null;
    }

    private NeighborJoiningR(boolean bl, int n) {
        if (n < 1 || n > 9) {
            throw new IllegalArgumentException("maximum fraction digits for distances is out of range: " + n);
        }
        this._verbose = bl;
        this._df = new DecimalFormat();
        this._df.setMaximumFractionDigits(n);
        this._df.setRoundingMode(RoundingMode.HALF_UP);
    }

    public final Phylogeny execute(BasicSymmetricalDistanceMatrix basicSymmetricalDistanceMatrix) {
        this.reset(basicSymmetricalDistanceMatrix);
        Phylogeny phylogeny = new Phylogeny();
        while (this._n > 2) {
            if (this._verbose) {
                System.out.println("N=" + this._n);
                System.out.println();
            }
            this.updateM();
            int n = this._min_i;
            int n2 = this._min_j;
            PhylogenyNode phylogenyNode = new PhylogenyNode();
            double d = this._d_values[n][this._mappings[n2]];
            double d2 = d / 2.0 + (this._r[this._rev_mappings[n]] - this._r[n2]) / (double)(2 * (this._n - 2));
            double d3 = d - d2;
            if (this._df == null) {
                this._external_nodes[n].setDistanceToParent(d2);
                this.getExternalPhylogenyNode(n2).setDistanceToParent(d3);
            } else {
                this._external_nodes[n].setDistanceToParent(Double.parseDouble(this._df.format(d2)));
                this.getExternalPhylogenyNode(n2).setDistanceToParent(Double.parseDouble(this._df.format(d3)));
            }
            phylogenyNode.addAsChild(this._external_nodes[n]);
            phylogenyNode.addAsChild(this.getExternalPhylogenyNode(n2));
            if (this._verbose) {
                this.printProgress(n, n2, phylogenyNode);
            }
            if (this._verbose) {
                System.out.println("otu1=" + n);
                System.out.println("otu2=" + n2);
            }
            this.calculateDistancesFromNewNode(n, n2, d);
            this._external_nodes[n] = phylogenyNode;
            this.updateMappings(n2);
            --this._n;
            if (!this._verbose) continue;
            System.out.println("");
            System.out.println("----------------------------------------------------------------------------------");
            System.out.println("");
        }
        double d = this.getDvalue(0, 1) / 2.0;
        if (this._df == null) {
            this.getExternalPhylogenyNode(0).setDistanceToParent(d);
            this.getExternalPhylogenyNode(1).setDistanceToParent(d);
        } else {
            double d4 = Double.parseDouble(this._df.format(d));
            this.getExternalPhylogenyNode(0).setDistanceToParent(d4);
            this.getExternalPhylogenyNode(1).setDistanceToParent(d4);
        }
        PhylogenyNode phylogenyNode = new PhylogenyNode();
        phylogenyNode.addAsChild(this.getExternalPhylogenyNode(0));
        phylogenyNode.addAsChild(this.getExternalPhylogenyNode(1));
        if (this._verbose) {
            this.printProgress(0, 1, phylogenyNode);
        }
        phylogeny.setRoot(phylogenyNode);
        phylogeny.setRooted(false);
        return phylogeny;
    }

    public final List<Phylogeny> execute(List<BasicSymmetricalDistanceMatrix> list) {
        ArrayList<Phylogeny> arrayList = new ArrayList<Phylogeny>();
        for (BasicSymmetricalDistanceMatrix basicSymmetricalDistanceMatrix : list) {
            arrayList.add(this.execute(basicSymmetricalDistanceMatrix));
        }
        return arrayList;
    }

    private final void calculateDistancesFromNewNode(int n, int n2, double d) {
        for (int i = 0; i < this._n; ++i) {
            if (i == n2 || i == this._rev_mappings[n]) continue;
            this.updateDvalue(n, n2, i, d);
        }
        if (this._verbose) {
            System.out.println();
        }
    }

    private final void updateDvalue(int n, int n2, int n3, double d) {
        int n4 = this._mappings[n3];
        if (n < n4) {
            this._s.removePairing(this._d_values[n][n4], n, n4);
        } else {
            this._s.removePairing(this._d_values[n4][n], n4, n);
        }
        if (this._mappings[n2] < n4) {
            this._s.removePairing(this.getDvalue(n3, n2), this._mappings[n2], n4);
        } else {
            this._s.removePairing(this.getDvalue(n3, n2), n4, this._mappings[n2]);
        }
        if (n < n4) {
            double d2 = (this._d_values[n][n4] + this.getDvalue(n3, n2) - d) / 2.0;
            this._s.addPairing(d2, n, n4);
            this._d_values[n][n4] = d2;
        } else {
            double d3 = (this._d_values[n4][n] + this.getDvalue(n3, n2) - d) / 2.0;
            this._s.addPairing(d3, n4, n);
            this._d_values[n4][n] = d3;
        }
    }

    private double getDvalue(int n, int n2) {
        if (n < n2) {
            return this._d_values[this._mappings[n]][this._mappings[n2]];
        }
        return this._d_values[this._mappings[n2]][this._mappings[n]];
    }

    private final void calculateNetDivergences() {
        this._rmax = -1.7976931348623157E308;
        for (int i = 0; i < this._n; ++i) {
            this._r[i] = this.calculateNetDivergence(i);
            if (!(this._r[i] > this._rmax)) continue;
            this._rmax = this._r[i];
        }
    }

    private double calculateNetDivergence(int n) {
        float f = 0.0f;
        for (int i = 0; i < this._n; ++i) {
            if (n == i) continue;
            f = (float)((double)f + this.getDvalue(i, n));
        }
        return f;
    }

    private final PhylogenyNode getExternalPhylogenyNode(int n) {
        return this._external_nodes[this._mappings[n]];
    }

    private final void initExternalNodes() {
        this._external_nodes = new PhylogenyNode[this._n];
        for (int i = 0; i < this._n; ++i) {
            this._external_nodes[i] = new PhylogenyNode();
            String string = this._d.getIdentifier(i);
            if (string != null) {
                this._external_nodes[i].setName(string);
            } else {
                this._external_nodes[i].setName(Integer.toString(i));
            }
            this._mappings[i] = i;
            this._rev_mappings[i] = i;
        }
    }

    private final void printProgress(int n, int n2, PhylogenyNode phylogenyNode) {
        System.out.println("Node " + this.printProgressNodeToString(this._external_nodes[n]) + " joins " + this.printProgressNodeToString(this.getExternalPhylogenyNode(n2)) + " [resulting in node " + this.printProgressNodeToString(phylogenyNode) + "]");
    }

    private final String printProgressNodeToString(PhylogenyNode phylogenyNode) {
        if (phylogenyNode.isExternal()) {
            if (ForesterUtil.isEmpty(phylogenyNode.getName())) {
                return Long.toString(phylogenyNode.getId());
            }
            return phylogenyNode.getName();
        }
        return phylogenyNode.getId() + " (" + (ForesterUtil.isEmpty(phylogenyNode.getChildNode1().getName()) ? Long.valueOf(phylogenyNode.getChildNode1().getId()) : phylogenyNode.getChildNode1().getName()) + "+" + (ForesterUtil.isEmpty(phylogenyNode.getChildNode2().getName()) ? Long.valueOf(phylogenyNode.getChildNode2().getId()) : phylogenyNode.getChildNode2().getName()) + ")";
    }

    private final void reset(BasicSymmetricalDistanceMatrix basicSymmetricalDistanceMatrix) {
        this._n = basicSymmetricalDistanceMatrix.getSize();
        this._d = basicSymmetricalDistanceMatrix;
        this._r = new double[this._n];
        this._mappings = new int[this._n];
        this._rev_mappings = new int[this._n];
        this._d_values = basicSymmetricalDistanceMatrix.getValues();
        this._s = new Sarray();
        this._s.initialize(basicSymmetricalDistanceMatrix);
        this.initExternalNodes();
        if (this._verbose) {
            System.out.println();
            this.printM();
            System.out.println("----------------------------------------------------------------------------------");
            System.out.println();
            System.out.println();
        }
    }

    private final void printM() {
        int n;
        for (n = 0; n < this._d_values.length; ++n) {
            System.out.print(this._external_nodes[n]);
            System.out.print("\t\t");
            for (int i = 0; i < this._d_values[n].length; ++i) {
                System.out.print(DF.format(this._d_values[i][n]));
                System.out.print(" ");
            }
            System.out.println();
        }
        for (n = 0; n < this._n; ++n) {
            System.out.print(this.getExternalPhylogenyNode(n));
            System.out.print("\t\t");
            for (int i = 0; i < this._n; ++i) {
                System.out.print(DF.format(this._d_values[this._mappings[i]][this._mappings[n]]));
                System.out.print(" ");
            }
            System.out.print("\t\t");
            for (Map.Entry<Integer, int[]> entry : this._s.getSentrySet(this._mappings[n])) {
                System.out.print(DF.format((double)entry.getKey().intValue() / 1000000.0) + "=");
                boolean bl = true;
                for (int n2 : entry.getValue()) {
                    if (!bl) {
                        System.out.print(",");
                    }
                    bl = false;
                    System.out.print(n2);
                }
                System.out.print("  ");
            }
            System.out.println();
        }
    }

    private final void updateM() {
        int n;
        double d;
        int n2;
        this.calculateNetDivergences();
        Double d2 = Double.MAX_VALUE;
        this._min_i = -1;
        this._min_j = -1;
        int n3 = this._n - 2;
        if (this._verbose) {
            this.printM();
        }
        for (n2 = 1; n2 < this._n; ++n2) {
            d = this._r[n2];
            n = this._mappings[n2];
            Iterator<Map.Entry<Integer, int[]>> iterator2 = this._s.getSentrySet(n).iterator();
            if (!iterator2.hasNext()) continue;
            Iterator<Map.Entry<Integer, int[]>> iterator = iterator2.next();
            for (int n4 : iterator.getValue()) {
                double d3 = this._d_values[n4][n] - (this._r[this._rev_mappings[n4]] + d) / (double)n3;
                if (!(d3 < d2)) continue;
                d2 = d3;
                this._min_i = n4;
                this._min_j = n2;
            }
        }
        block2: for (n2 = 1; n2 < this._n; ++n2) {
            d = this._r[n2];
            n = this._mappings[n2];
            boolean bl = true;
            for (Map.Entry entry : this._s.getSentrySet(n)) {
                if (bl) {
                    bl = false;
                    continue;
                }
                for (int n5 : (int[])entry.getValue()) {
                    double d4 = this._d_values[n5][n];
                    if (d4 - (this._umax + d) / (double)n3 > d2) continue block2;
                    double d5 = d4 - (this._r[this._rev_mappings[n5]] + d) / (double)n3;
                    if (!(d5 < d2)) continue;
                    d2 = d5;
                    this._min_i = n5;
                    this._min_j = n2;
                }
            }
            if (!this._verbose) continue;
            System.out.println();
            for (Map.Entry<Integer, int[]> entry : this._s.getSentrySet(n)) {
                for (int n6 : entry.getValue()) {
                    System.out.print(n6);
                    System.out.print("->");
                    System.out.print(DF.format(this._r[n6]));
                    System.out.print("  ");
                }
            }
            System.out.println();
        }
        if (this._verbose) {
            System.out.println();
        }
    }

    private final void updateMappings(int n) {
        int n2;
        for (n2 = n; n2 < this._mappings.length - 1; ++n2) {
            this._mappings[n2] = this._mappings[n2 + 1];
        }
        for (n2 = 0; n2 < this._n; ++n2) {
            this._rev_mappings[this._mappings[n2]] = n2;
        }
    }

    public static final NeighborJoiningR createInstance() {
        return new NeighborJoiningR();
    }

    public static final NeighborJoiningR createInstance(boolean bl, int n) {
        return new NeighborJoiningR(bl, n);
    }
}

